/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.plugins;

import java.beans.PropertyChangeEvent;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.plugins.EditorPlugin;

public class AutomaticEndTagProvider
implements CharacterTypedListener,
EditorPlugin {
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR"));

    public void install(BasicEditorPane editor) {
        editor.addCharacterTypedListener((CharacterTypedListener)this);
    }

    public void deinstall(BasicEditorPane editor) {
        editor.removeCharacterTypedListener((CharacterTypedListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
        if (typedChar == '>') {
            this._checkForEndTagInsertion(editorPane, offset, typedChar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkForEndTagInsertion(BasicEditorPane editorPane, int offset, char typedChar) {
        boolean insertEndTags = false;
        try {
            insertEndTags = EditorProperties.getProperties().getBooleanProperty("XMLLanguageModule.END_TAG");
        }
        catch (Exception e) {
            insertEndTags = false;
        }
        if (insertEndTags) {
            BasicDocument document = (BasicDocument)editorPane.getDocument();
            TextBuffer textBuffer = document.getTextBuffer();
            String endTagText = null;
            try {
                if (offset > 0) {
                    String text;
                    int start;
                    int lookback = 80;
                    if (offset < lookback) {
                        lookback = offset;
                    }
                    if ((start = (text = document.getText(offset - lookback, lookback)).lastIndexOf(60)) != -1 && (text = text.substring(start + 1)).charAt(0) != '-' && text.charAt(0) != '!' && text.charAt(0) != '?' && text.indexOf(62) == -1 && text.indexOf(47) == -1) {
                        int end = text.indexOf(32);
                        if (end == -1) {
                            end = text.length();
                        }
                        if ((text = text.substring(0, end)) != null && text.length() > 0) {
                            endTagText = "</" + text + ">";
                        }
                    }
                }
            }
            catch (Exception e) {
                endTagText = null;
            }
            if (endTagText != null) {
                editorPane.beginEdit(EDIT_DESCRIPTOR);
                try {
                    document.insertString(offset + 1, endTagText, null);
                    editorPane.setCaretPosition(offset + 1);
                }
                catch (BadLocationException e) {
                    System.err.println("Exception occurred in completion: " + e);
                    e.printStackTrace();
                }
                finally {
                    editorPane.endEdit();
                }
            }
        }
    }
}

