/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.netbeans.progress.module.LoggingUtils;
import org.netbeans.progress.module.ProgressApiAccessor;
import org.openide.modules.PatchedPublic;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public class InternalHandle {
    private static final Logger LOG = Logger.getLogger(InternalHandle.class.getName());
    private String displayName;
    private int state;
    private int totalUnits;
    private int currentUnit;
    private long initialEstimate;
    private long timeStarted;
    private long timeLastProgress;
    private long timeSleepy = 0L;
    private String lastMessage;
    private final Cancellable cancelable;
    private final boolean userInitiated;
    private int initialDelay = 500;
    private Controller controller;
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_FINISHED = 2;
    public static final int STATE_REQUEST_STOP = 3;
    public static final int NO_INCREASE = -2;
    InternalHandle del;
    static final Method compatInit;

    @PatchedPublic
    protected InternalHandle(String displayName, Cancellable cancel, boolean userInitiated) {
        this.displayName = displayName;
        this.userInitiated = userInitiated;
        this.state = 0;
        this.totalUnits = 0;
        this.lastMessage = null;
        this.cancelable = cancel;
        this.compatInit();
    }

    public final ProgressHandle createProgressHandle() {
        if (this.del != null) {
            return ProgressApiAccessor.getInstance().create(this.del);
        }
        return ProgressApiAccessor.getInstance().create(this);
    }

    public String getDisplayName() {
        if (this.del != null) {
            return this.del.getDisplayName();
        }
        return this.displayName;
    }

    public synchronized int getState() {
        if (this.del != null) {
            return this.del.getState();
        }
        return this.state;
    }

    public boolean isAllowCancel() {
        if (this.del != null) {
            return this.del.isAllowCancel();
        }
        return this.cancelable != null;
    }

    public boolean isAllowView() {
        if (this.del != null) {
            return this.del.isAllowView();
        }
        return false;
    }

    public boolean isCustomPlaced() {
        if (this.del != null) {
            return this.del.isCustomPlaced();
        }
        return false;
    }

    public final boolean isUserInitialized() {
        return this.userInitiated;
    }

    private int getCurrentUnit() {
        return this.currentUnit;
    }

    public int getTotalUnits() {
        if (this.del != null) {
            return this.del.getTotalUnits();
        }
        return this.totalUnits;
    }

    public void setInitialDelay(int millis) {
        if (this.del != null) {
            this.del.setInitialDelay(millis);
            return;
        }
        if (this.state != 0) {
            LOG.log(Level.WARNING, "Setting ProgressHandle.setInitialDelay() after the task is started has no effect at {0}", LoggingUtils.findCaller());
            return;
        }
        this.initialDelay = millis;
    }

    public int getInitialDelay() {
        if (this.del != null) {
            return this.del.getInitialDelay();
        }
        return this.initialDelay;
    }

    public synchronized void toSilent(String message) {
        if (this.del != null) {
            this.del.toSilent(message);
            return;
        }
        if (this.state != 1 && this.state != 3) {
            LOG.log(Level.WARNING, "Cannot switch to silent mode when not running at {0}", LoggingUtils.findCaller());
            return;
        }
        this.timeSleepy = this.timeLastProgress = System.currentTimeMillis();
        if (message != null) {
            this.lastMessage = message;
        }
        this.controller.toSilent(this, message);
    }

    public boolean isInSleepMode() {
        if (this.del != null) {
            return this.isInSleepMode();
        }
        return this.timeSleepy == this.timeLastProgress;
    }

    public synchronized void toIndeterminate() {
        if (this.del != null) {
            this.del.toIndeterminate();
            return;
        }
        if (this.state != 1 && this.state != 3) {
            LOG.log(Level.WARNING, "Cannot switch to indeterminate mode when not running at {0}", LoggingUtils.findCaller());
            return;
        }
        this.totalUnits = 0;
        this.currentUnit = 0;
        this.initialEstimate = -1L;
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.toIndeterminate(this);
    }

    public synchronized void toDeterminate(int workunits, long estimate) {
        if (this.del != null) {
            this.del.toDeterminate(workunits, estimate);
        }
        if (this.state != 1 && this.state != 3) {
            LOG.log(Level.WARNING, "Cannot switch to determinate mode when not running at {0}", LoggingUtils.findCaller());
            return;
        }
        if (workunits < 0) {
            throw new IllegalArgumentException("number of workunits cannot be negative");
        }
        this.totalUnits = workunits;
        this.currentUnit = 0;
        this.initialEstimate = estimate;
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.toDeterminate(this);
    }

    protected final void setController(Controller ctrl) {
        assert (this.controller == null) : "Controller can be set just once";
        this.controller = ctrl;
    }

    public synchronized void start(String message, int workunits, long estimate) {
        if (this.del != null) {
            this.del.start(message, workunits, estimate);
            return;
        }
        if (this.state != 0) {
            LOG.log(Level.WARNING, "Cannot call start twice on a handle at {0}", LoggingUtils.findCaller());
            return;
        }
        if (workunits < 0) {
            throw new IllegalArgumentException("number of workunits cannot be negative");
        }
        this.totalUnits = workunits;
        this.currentUnit = 0;
        if (message != null) {
            this.lastMessage = message;
        }
        if (this.controller == null) {
            this.controller = Controller.getDefault();
        }
        this.state = 1;
        this.initialEstimate = estimate;
        this.timeLastProgress = this.timeStarted = System.currentTimeMillis();
        this.controller.start(this);
    }

    public synchronized void finish() {
        if (this.del != null) {
            this.del.finish();
            return;
        }
        if (this.state == 0) {
            LOG.log(Level.WARNING, "Cannot finish a task that was never started at {0}", LoggingUtils.findCaller());
            return;
        }
        if (this.state == 2) {
            return;
        }
        this.state = 2;
        this.currentUnit = this.totalUnits;
        this.controller.finish(this);
    }

    public synchronized void progress(String message, int workunit) {
        if (this.del != null) {
            this.del.progress(message, workunit);
            return;
        }
        if (this.state != 1 && this.state != 3) {
            LOG.log(Level.WARNING, "Cannot call progress on a task that was never started at {0}", LoggingUtils.findCaller());
            return;
        }
        if (workunit != -2) {
            if (workunit < this.currentUnit) {
                throw new IllegalArgumentException("Cannot decrease processed workunit count (" + workunit + ") to lower value than before (" + this.currentUnit + ")");
            }
            if (workunit > this.totalUnits) {
                LOG.log(Level.INFO, "Cannot process more work than scheduled. Progress handle with name \"" + this.getDisplayName() + "\" has requested progress to workunit no." + workunit + " but the total number of workunits is " + this.totalUnits + ". That means the progress bar UI will not display real progress and will stay at 100%.", new IllegalArgumentException());
                workunit = this.totalUnits;
            }
            this.currentUnit = workunit;
        }
        if (message != null) {
            this.lastMessage = message;
        }
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.progress(this, message, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1.0, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCancel() {
        if (this.del != null) {
            this.del.requestCancel();
            return;
        }
        if (!this.isAllowCancel()) {
            return;
        }
        InternalHandle internalHandle = this;
        synchronized (internalHandle) {
            this.state = 3;
        }
        this.cancelable.cancel();
        internalHandle = this;
        synchronized (internalHandle) {
            this.requestStateSnapshot();
        }
    }

    public void requestView() {
        if (this.del != null) {
            this.del.requestView();
        }
    }

    public synchronized void requestExplicitSelection() {
        if (this.del != null) {
            this.del.requestExplicitSelection();
            return;
        }
        if (!this.isInSleepMode()) {
            this.timeLastProgress = System.currentTimeMillis();
        }
        this.controller.explicitSelection(this);
    }

    public synchronized void requestDisplayNameChange(String newDisplayName) {
        if (this.del != null) {
            this.del.requestDisplayNameChange(newDisplayName);
            return;
        }
        this.displayName = newDisplayName;
        if (this.state == 0) {
            return;
        }
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.displayNameChange(this, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1.0, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate(), newDisplayName);
    }

    public synchronized ProgressEvent requestStateSnapshot() {
        if (this.del != null) {
            return this.del.requestStateSnapshot();
        }
        if (!this.isInSleepMode()) {
            this.timeLastProgress = System.currentTimeMillis();
        }
        return this.controller.snapshot(this, this.lastMessage, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1.0, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate());
    }

    long calculateFinishEstimate() {
        double durationSoFar = (double)(System.currentTimeMillis() - this.timeStarted) / 1000.0;
        if (this.initialEstimate == -1L) {
            return (long)(durationSoFar * (double)(this.totalUnits - this.currentUnit) / (double)this.totalUnits);
        }
        long remainingUnits = this.totalUnits - this.currentUnit;
        double remainingPortion = (double)remainingUnits / (double)this.totalUnits;
        double currentEstimate = durationSoFar / (double)this.currentUnit * (double)this.totalUnits;
        long retValue = (long)(((double)(this.initialEstimate * remainingUnits) * remainingPortion + currentEstimate * (double)remainingUnits * (1.0 - remainingPortion)) / (double)this.totalUnits);
        return retValue;
    }

    public double getPercentageDone() {
        if (this.del != null) {
            return this.del.getPercentageDone();
        }
        return (double)this.currentUnit * 100.0 / (double)this.totalUnits;
    }

    public long getTimeStampStarted() {
        if (this.del != null) {
            return this.del.getTimeStampStarted();
        }
        return this.timeStarted;
    }

    private void compatInit() {
        if (compatInit == null) {
            return;
        }
        try {
            compatInit.invoke((Object)this, this.displayName, this.cancelable, this.userInitiated);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static {
        Method m = null;
        try {
            m = InternalHandle.class.getSuperclass().getDeclaredMethod("compatInit", String.class, Cancellable.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        compatInit = m;
    }
}

