/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.net.URL;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Node;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard;
import oracle.jdevimpl.vcs.svn.nav.ui.SetupConnectionPanel;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryImportExportWizard;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.WorkingCopyURLFilter;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNOperationCreateConnection
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.create-connection";

    public SVNOperationCreateConnection() {
        super(COMMAND_ID);
    }

    @Override
    protected int doitImpl() throws Exception {
        SetupConnectionPanel scPanel = new SetupConnectionPanel();
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)VCSWindowUtils.getCurrentWindow(), (Component)((Object)scPanel), (Component)((Object)scPanel), (String)Resource.get("UI_SETUPCONNECTIONS_TITLE"), (int)3);
        dialog.setResizable(false);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("ACTION_CREATE_DIALOG_HEADER"));
        dialog.setDialogHeader((Component)header);
        WizardLauncher.runDialog((JDialog)dialog);
        if (dialog.isCancelled()) {
            return 1;
        }
        if (scPanel.isManualCreationSelected()) {
            Context wcContext;
            Wizard connectionWizard = WizardManager.getInstance().getWizard(SVNRepositoryWizard.class);
            boolean success = connectionWizard.invoke(wcContext = this.prepareContextForWoringCopy(this.getContext()));
            return success ? 0 : 1;
        }
        boolean success = new SVNRepositoryImportExportWizard().invokeImportWizard(this.getContext(), new String[0]);
        return success ? 0 : 1;
    }

    private Context prepareContextForWoringCopy(Context context) {
        Node node = context.getNode();
        if (node == null || node.getURL() == null) {
            return context;
        }
        WorkingCopyURLFilter wcFilter = new WorkingCopyURLFilter();
        if (!wcFilter.accept(node.getURL())) {
            return context;
        }
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            URL wcRoot = SVNUtil.resolveWorkingCopy(node.getURL());
            ISVNInfo info = client.getInfoFromWorkingCopy(SVNUtil.toFile(wcRoot));
            if (info == null) {
                return context;
            }
            Context wcContext = new Context(context);
            wcContext.setProperty("PRESET_REPO_URL", (Object)info.getRepository().toString());
            wcContext.setProperty("PRESET_REPO_USERNAME", (Object)info.getLastCommitAuthor());
            return wcContext;
        }
        catch (SVNClientException e) {
            return context;
        }
    }
}

