/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCacheSimpleStrategy;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCacheStrategy;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public final class SVNURLInfoCache {
    private static final SVNURLInfoCache _instance = new SVNURLInfoCache();
    private static final SVNURLInfoCacheStrategy _strategy = new SVNURLInfoCacheSimpleStrategy();

    private SVNURLInfoCache() {
    }

    public static SVNURLInfoCache getInstance() {
        return _instance;
    }

    public SVNStatusType getTextStatus(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return null;
        }
        return info.getTextStatus();
    }

    public SVNStatusType getNodeStatus(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return null;
        }
        return info.getNodeStatus();
    }

    public SVNStatusType getPropStatus(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return null;
        }
        return info.getPropStatus();
    }

    public boolean getTreeStatus(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return false;
        }
        return info.getTreeStatus();
    }

    public long getRevision(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return -1L;
        }
        return info.getRevision();
    }

    public long getLastChangedRevision(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return -1L;
        }
        return info.getLastChangedRevision();
    }

    public String getLastCommitAuthor(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return null;
        }
        return info.getLastCommitAuthor();
    }

    public SVNUrl getURL(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return null;
        }
        return info.getURL();
    }

    public boolean isAddMoved(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return false;
        }
        return info.addMoved() != null;
    }

    public boolean isDeleteMoved(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return false;
        }
        return info.deleteMoved() != null;
    }

    public String relativePath(URL url) throws SVNException, IOException {
        SVNURLInfo info = _strategy.getURLInfo(url);
        if (info == null) {
            return null;
        }
        return info.deleteMoved() != null ? info.deleteMoved() : info.addMoved();
    }

    public void clear() {
        _strategy.clear();
    }

    public void clear(URL[] urls) {
        _strategy.clear(urls);
    }

    public void clear(URLFilter filter) {
        _strategy.clear(filter);
    }

    public void clear(URL[] urls, Depth depth) {
        _strategy.clear(urls, depth);
    }

    public SVNURLInfo getURLInfo(URL url) throws SVNException, IOException {
        return _strategy.getURLInfo(url);
    }

    public Map<VCSHashURL, SVNURLInfo> getDirectoryURLInfo(URL url, boolean descend) throws UnsupportedOperationException, SVNException {
        return _strategy.getDirectoryURLInfo(url, descend);
    }

    public Collection<URL> getUrls(URLFilter filter) {
        return _strategy.getUrls(filter);
    }
}

