/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSQuickDiffReferenceProvider;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.history.SVNHistoricalContentCache;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class SVNQuickDiffReferenceProvider
extends VCSQuickDiffReferenceProvider {
    private static final String ID = "PristineSVNCopy";

    SVNQuickDiffReferenceProvider() {
        super((VCSExtension)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion"));
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return Resource.get("PRISTINE_SVN_COPY");
    }

    public InputStream openInputStream(URL url) throws IOException {
        try {
            long previousRevision = SVNURLInfoCache.getInstance().getRevision(url);
            if (previousRevision < 0L) {
                return null;
            }
            SVNUrl reposUrl = SVNURLInfoCache.getInstance().getURL(url);
            if (reposUrl == null) {
                return null;
            }
            SVNRevision.Number revision = new SVNRevision.Number(previousRevision);
            SVNHistoricalContentCache contentCache = SVNHistoricalContentCache.getInstance();
            return contentCache.getRevisionContentStream(reposUrl, (SVNRevision)revision, AbstractSVNOperation.CLIENT_CONTEXT);
        }
        catch (Exception ex) {
            if (ex instanceof SVNClientException) {
                SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(ex.getMessage());
            }
            throw new IOException(ex);
        }
    }
}

