/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.xml.parser.v2.XMLNode;

public class ApplyOneDiffResult {
    public static final int DIFF_NONE = 0;
    public static final int DIFF_REMOVE = 1;
    public static final int DIFF_ADD = 2;
    public static final int DIFF_MODIFY = 3;
    public static final int CONFLICT_NONE = 0;
    public static final int CONFLICT_NOT_EXIST = 1;
    public static final int CONFLICT_EXISTS_SAME = 2;
    public static final int CONFLICT_EXISTS_DIFFERENT = 3;
    public static final int CONFLICT_MODIFIED_SAME = 4;
    public static final int CONFLICT_MODIFIED_DIFFERENT = 5;
    public static final int CONFLICT_MODIFIED_PREVIOUSLY = 6;
    private int m_diffType = 0;
    private int m_conflictType = 0;
    private String m_xpath = null;
    private XMLNode m_diffNode = null;
    private XMLNode m_tgtNode = null;
    private boolean m_doTheChange;

    public ApplyOneDiffResult(int diffType, int conflictType) {
        this.m_diffType = diffType;
        this.setConflictType(conflictType);
    }

    public ApplyOneDiffResult(int diffType) {
        this(diffType, 0);
    }

    public int getDiffType() {
        return this.m_diffType;
    }

    public void setConflictType(int conflictType) {
        this.m_conflictType = conflictType;
        this.m_doTheChange = conflictType == 3 ? true : (conflictType == 5 ? true : (conflictType == 6 ? true : conflictType == 0));
    }

    public int getConflictType() {
        return this.m_conflictType;
    }

    public void setXpath(String xpath) {
        this.m_xpath = xpath;
    }

    public String getXpath() {
        return this.m_xpath;
    }

    public void setDiffNode(XMLNode node) {
        this.m_diffNode = node;
    }

    public XMLNode getDiffNode() {
        return this.m_diffNode;
    }

    public void setTargetNode(XMLNode node) {
        this.m_tgtNode = node;
    }

    public XMLNode getTargetNode() {
        return this.m_tgtNode;
    }

    public void setDoChange(boolean doIt) {
        this.m_doTheChange = doIt;
    }

    public boolean getDoChange() {
        return this.m_doTheChange;
    }

    public String toString() {
        String diffType = null;
        switch (this.m_diffType) {
            case 0: {
                diffType = "No difference type";
                break;
            }
            case 1: {
                diffType = "Remove";
                break;
            }
            case 2: {
                diffType = "Add";
                break;
            }
            case 3: {
                diffType = "Modify";
                break;
            }
            default: {
                diffType = "Unknown type: " + this.m_diffType;
            }
        }
        String conflictType = null;
        switch (this.m_conflictType) {
            case 0: {
                conflictType = "CONFLICT_NONE: No conflict.";
                break;
            }
            case 1: {
                conflictType = "CONFLICT_NOT_EXIST: The item to be removed or modified does not exist.";
                break;
            }
            case 2: {
                conflictType = "CONFLICT_EXISTS_SAME: The item to be added already exists and is the same.";
                break;
            }
            case 3: {
                conflictType = "CONFLICT_EXISTS_DIFFERENT: " + (this.m_diffType != 1 ? "The item to be added already exists and is different." : "The item to be removed is different.");
                break;
            }
            case 4: {
                conflictType = "CONFLICT_MODIFIED_SAME: The item to be modified has already been modified to the same value.";
                break;
            }
            case 5: {
                conflictType = "CONFLICT_MODIFIED_DIFFERENT: The item to be modified has already been modified to a different value.";
                break;
            }
            case 6: {
                conflictType = "CONFLICT_MODIFIED_PREVIOUSLY: The item to be modified has already been modified to the old value recorded in the difference.";
                break;
            }
            default: {
                conflictType = "Unknown conflict type: " + this.m_conflictType;
            }
        }
        String s = "Difference type: " + diffType + "\nConflict type: " + conflictType + "\nXpath: " + (this.m_xpath == null ? "(none)" : this.m_xpath);
        if ((this.m_diffType == 2 || this.m_diffType == 1) && this.m_conflictType == 3) {
            ByteArrayOutputStream bos;
            String def;
            if (this.m_diffNode != null) {
                def = null;
                try {
                    bos = new ByteArrayOutputStream();
                    this.m_diffNode.print((OutputStream)bos);
                    def = bos.toString();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                s = s + "\nDifference node:\n" + def;
            }
            if (this.m_tgtNode != null) {
                def = null;
                try {
                    bos = new ByteArrayOutputStream();
                    this.m_tgtNode.print((OutputStream)bos);
                    def = bos.toString();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                s = s + "\nTarget node:\n" + def;
            }
        }
        return s;
    }
}

