/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.Capturer;
import oracle.dbtools.migration.capture.OfflineCaptureWorker;
import oracle.dbtools.migration.capture.offline.MultiDatabaseOfflineCapturer;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.ide.util.Assert;

public class TeradataOfflineCaptureWorker
extends OfflineCaptureWorker {
    public TeradataOfflineCaptureWorker(OfflineCapturer offlineCapturer, String string, String string2) {
        this((MultiDatabaseOfflineCapturer)offlineCapturer, string, string2, null);
    }

    public TeradataOfflineCaptureWorker(MultiDatabaseOfflineCapturer multiDatabaseOfflineCapturer, String string, String string2, MigrationObjectFilterList migrationObjectFilterList) {
        super(multiDatabaseOfflineCapturer, string, string2, migrationObjectFilterList);
    }

    protected void captureType(String string) throws PersistenceException, SQLException, CaptureException {
        System.out.println("captureType: " + string);
        if (this.m_filters != null && this.m_filters.getFilterForType(string) == null) {
            return;
        }
        if (string.equals("MD_CATALOGS")) {
            this.captureCatalog();
        } else if (string.equals("MD_SCHEMAS")) {
            this.captureSchema();
        } else if (string.equals("MD_TABLES")) {
            this.captureTables();
        } else if (string.equals("MD_VIEWS")) {
            this.captureViews();
        } else if (string.equals("MD_STORED_PROGRAMS")) {
            this.captureStoredProcs();
        }
    }

    protected void captureCatalogImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_CATALOGS", this.m_context, migrationObjectFilter);
    }

    protected void capturePerCatalogImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(string, this.m_context, migrationObjectFilter);
    }

    protected void capturePerSchemaImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(string, this.m_context, migrationObjectFilter);
    }

    protected void capturePerTableImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(string, this.m_context, migrationObjectFilter);
    }

    protected void capturePerViewImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(string, this.m_context, migrationObjectFilter);
    }

    protected void captureSchemaImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_SCHEMAS", this.m_context, migrationObjectFilter);
    }

    protected void captureTableImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_TABLES", this.m_context, migrationObjectFilter);
    }

    protected Capturer getCapturer() {
        return this.m_capturer;
    }

    protected void captureSynonymImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_SYNONYMS", this.m_context, migrationObjectFilter);
    }

    protected void captureCatalog() throws PersistenceException, CaptureException {
        super.captureCatalog();
        boolean bl = false;
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator closeableIterator = persistenceUtility.getCatalogsForConnectionId(dBObjectId);
        while (closeableIterator.hasNext()) {
            MgvAllCatalogsRec mgvAllCatalogsRec;
            bl = true;
            if (this.shouldCancel()) {
                closeableIterator.close();
                mgvAllCatalogsRec = new CaptureEvent(-1, "SCHEMA", "");
                this.fireListeners((CaptureEvent)mgvAllCatalogsRec);
                return;
            }
            mgvAllCatalogsRec = (MgvAllCatalogsRec)closeableIterator.next();
            DBObjectId dBObjectId2 = mgvAllCatalogsRec.getCatalogId();
            if (this.m_capturedCatalogs.contains(dBObjectId2)) continue;
            this.checkNewCatalog(dBObjectId2);
            this.m_capturedCatalogs.add(dBObjectId2);
            return;
        }
        if (!bl) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.NO_VALID_CATALOGS");
        }
    }

    protected void captureSchema() throws PersistenceException, SQLException, CaptureException {
        DBObjectId dBObjectId;
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_SCHEMAS");
        }
        if ((dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID")) != null) {
            this.captureSchemaImpl(migrationObjectFilter);
        } else {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.NO_VALID_CATALOGS");
        }
    }

    protected void capturePerSchema(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        this.m_context.setContextVariable("PER_CONTEXT", (Object)"MD_SCHEMAS");
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId(dBObjectId);
        while (closeableIterator.hasNext()) {
            MdSchema mdSchema;
            if (this.shouldCancel()) {
                mdSchema = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)mdSchema);
                this.m_context.resetContextVariable("PER_CONTEXT");
                return;
            }
            mdSchema = (MdSchema)closeableIterator.next();
            this.checkNewSchema(mdSchema.getKey());
            this.capturePerSchemaImpl(string, migrationObjectFilter);
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    protected void captureTables() throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_TABLES");
        }
        if (this.shouldCancel()) {
            CaptureEvent captureEvent = new CaptureEvent(-1, "TABLE", "");
            this.fireListeners(captureEvent);
            return;
        }
        this.captureTableImpl(migrationObjectFilter);
    }

    protected void captureViews() throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_VIEWS");
        }
        if (this.shouldCancel()) {
            CaptureEvent captureEvent = new CaptureEvent(-1, "VIEW", "");
            this.fireListeners(captureEvent);
            return;
        }
        this.capturePerTableImpl("MD_VIEWS", migrationObjectFilter);
    }

    protected void captureStoredProcs() throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_STORED_PROGRAMS");
        }
        if (this.shouldCancel()) {
            CaptureEvent captureEvent = new CaptureEvent(-1, "STOREDPROCEDURES", "");
            this.fireListeners(captureEvent);
            return;
        }
        this.capturePerTableImpl("MD_STORED_PROGRAMS", migrationObjectFilter);
    }

    protected void capturePerTable(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID");
        this.m_context.setContextVariable("PER_CONTEXT", (Object)"MD_TABLES");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId(dBObjectId);
        while (closeableIterator.hasNext()) {
            MdSchema mdSchema;
            if (this.shouldCancel()) {
                mdSchema = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)mdSchema);
                return;
            }
            mdSchema = (MdSchema)closeableIterator.next();
            CloseableIterator closeableIterator2 = persistenceUtility.getTablesForSchemaId(mdSchema.getKey());
            while (closeableIterator2.hasNext()) {
                MdTable mdTable;
                if (this.shouldCancel()) {
                    mdTable = new CaptureEvent(-1, "CATALOG", "");
                    this.fireListeners((CaptureEvent)mdTable);
                    this.m_context.resetContextVariable("PER_CONTEXT");
                    return;
                }
                mdTable = (MdTable)closeableIterator2.next();
                this.checkNewSchema(mdTable.getSchemaId());
                this.checkNewTable(mdTable.getKey());
                this.capturePerTableImpl(string, migrationObjectFilter);
            }
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    protected void capturePerView(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID");
        this.m_context.setContextVariable("PER_CONTEXT", (Object)"MD_VIEWS");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId(dBObjectId);
        while (closeableIterator.hasNext()) {
            MdSchema mdSchema;
            if (this.shouldCancel()) {
                mdSchema = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)mdSchema);
                return;
            }
            mdSchema = (MdSchema)closeableIterator.next();
            CloseableIterator closeableIterator2 = persistenceUtility.getViewsForSchemaId(mdSchema.getKey());
            while (closeableIterator2.hasNext()) {
                MdView mdView;
                if (this.shouldCancel()) {
                    mdView = new CaptureEvent(-1, "CATALOG", "");
                    this.fireListeners((CaptureEvent)mdView);
                    this.m_context.resetContextVariable("PER_CONTEXT");
                    return;
                }
                mdView = (MdView)closeableIterator2.next();
                this.checkNewSchema(mdView.getSchemaId());
                this.checkNewView(mdView.getKey());
                this.capturePerViewImpl(string, migrationObjectFilter);
            }
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    protected void captureSynonyms() throws PersistenceException, CaptureException, SQLException {
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_SYNONYMS");
        }
        if (this.shouldCancel()) {
            CaptureEvent captureEvent = new CaptureEvent(-1, "CATALOG", "");
            this.fireListeners(captureEvent);
            return;
        }
        this.captureSynonymImpl(migrationObjectFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCapture() throws PersistenceException, CaptureException {
        boolean bl = true;
        Object var2_2 = null;
        while (this.m_capturer.hasMoreDatabase()) {
            try {
                bl &= this.runCaptureImpl();
            }
            finally {
                try {
                    this.m_capturer.cleanUp();
                }
                catch (OfflineCaptureException offlineCaptureException) {}
            }
        }
        bl = this.afterCapture();
        this.m_capturedCatalogs.clear();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCaptureImpl() throws PersistenceException, CaptureException {
        CaptureEvent captureEvent = new CaptureEvent(6, "", MigrationAddinArb.getString((String)"START_CAPTURE"));
        this.fireListeners(captureEvent);
        if (this.m_capturedConnection == null) {
            this.storeConnection();
        }
        for (String string : CAPTURE_ORDER) {
            try {
                if (this.shouldCancel()) {
                    CaptureEvent captureEvent2 = new CaptureEvent(-1, string, "");
                    this.fireListeners(captureEvent2);
                    try {
                        this.getStorer().rollback();
                    }
                    catch (SQLException sQLException) {
                        return false;
                    }
                    return false;
                }
                this.captureType(string);
            }
            catch (SQLException sQLException) {
                throw new CaptureException((Throwable)sQLException);
            }
        }
        try {
            long l = System.currentTimeMillis();
            this.getStorer().commit();
            long l2 = System.currentTimeMillis();
            this.updateStatistics();
            long l3 = System.currentTimeMillis();
            System.out.println("Commit = " + (l2 - l) + ", UpdateStats = " + (l3 - l2));
            captureEvent.setEventId(7);
            this.fireListeners(captureEvent);
        }
        catch (SQLException sQLException) {
            MigrationLogUtil.logThrowable((String)"MigrationLog.DB_COMMIT_ERROR", (String)Messages.getString((String)"CaptureWorker.3"), (Throwable)sQLException);
            Assert.printStackTrace((Throwable)sQLException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.clearPersitenceCache();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean afterCapture() throws PersistenceException, CaptureException {
        try {
            long l = System.currentTimeMillis();
            this.populateIdentifiers();
            long l2 = System.currentTimeMillis();
            this.getStorer().commit();
            long l3 = System.currentTimeMillis();
            this.updateStatistics();
            long l4 = System.currentTimeMillis();
            System.out.println("Populate = " + (l2 - l) + ", Commit = " + (l3 - l2) + ", UpdateStats = " + (l4 - l3));
        }
        catch (SQLException sQLException) {
            MigrationLogUtil.logThrowable((String)"MigrationLog.DB_COMMIT_ERROR", (String)Messages.getString((String)"CaptureWorker.3"), (Throwable)sQLException);
            Assert.printStackTrace((Throwable)sQLException);
            boolean bl = false;
            return bl;
        }
        finally {
            this.clearPersitenceCache();
        }
        return true;
    }
}

