/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.teradata.offline.AbstractTeradataOfflineStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.plugin.TeradataMachine;
import oracle.dbtools.migration.workbench.plugin.TeradataPreferencePanel;
import oracle.dbtools.migration.workbench.plugin.TeradataState;
import oracle.dbtools.migration.workbench.plugin.teradata.Teradata12Offline3rdPartyPrintStream;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

class Teradata12FEXPState
extends TeradataState {
    Logger LOGGER = Logger.getLogger(MigrationUtils.class.getName());
    protected StringTemplateGroup m_templateGroup = null;

    public Teradata12FEXPState(TeradataMachine teradataMachine) {
        super(teradataMachine);
    }

    @Override
    public String generateCSV(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray) {
        String string2 = "";
        return string2;
    }

    @Override
    public String getDataExportCommmand(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2, boolean bl) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        try {
            this.loadTemplates();
            string2 = string2.replaceAll("\"", "");
            string2 = string2.replaceAll("[ \\\\/$]", "_");
            String string3 = string2.toLowerCase().endsWith(".dat") ? "data/" + string2.substring(0, string2.length() - 4) + ".dat" : "data/" + string2 + ".dat";
            String string4 = migrationConfig.getEndColumnDelimiter();
            String string5 = "'" + string4 + "'";
            String string6 = migrationConfig.getEndRowDelimiter();
            String string7 = "'" + string6 + "'";
            stringTemplate = this.m_templateGroup.getTemplateDefinition("FexpConvert");
            stringTemplate.reset();
            stringTemplate.setAttribute("maxsessions", TeradataPreferencePanel.getFexpMaxSessions());
            stringTemplate.setAttribute("minsessions", TeradataPreferencePanel.getFexpMaxSessions());
            stringTemplate.setAttribute("logtable", (Object)teradataMachine.quote(string + "_L"));
            stringTemplate.setAttribute("outfile", (Object)string3);
            stringTemplate.setAttribute("table", (Object)AbstractTeradataOfflineStream.makeFileName(string));
            stringTemplate.setAttribute("eofd", (Object)string5);
            stringTemplate.setAttribute("eord", (Object)string7);
            stringTemplate.setAttribute("platformWindows", (Object)bl);
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return stringTemplate.toString();
    }

    @Override
    public String getDataExportScript(TeradataMachine teradataMachine, String string, MdColumn[] mdColumnArray, String string2) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringTemplate stringTemplate = null;
        String string3 = null;
        try {
            this.loadTemplates();
            String string4 = string2.toLowerCase().endsWith(".dat") ? "data/" + string2.substring(0, string2.length() - 4) + ".fexp.dat" : "data/" + string2 + ".fexp.dat";
            String string5 = migrationConfig.getEndColumnDelimiter();
            String string6 = "'" + string5 + "'";
            String string7 = migrationConfig.getEndRowDelimiter();
            String string8 = "'" + string7 + "'";
            String string9 = string.substring(0, string.indexOf("."));
            String[] stringArray = new String[mdColumnArray.length];
            for (int i = 0; i < mdColumnArray.length; ++i) {
                MdColumn mdColumn = mdColumnArray[i];
                String string10 = mdColumn.getColumnType();
                String string11 = mdColumn.getColumnName();
                Integer n = mdColumn.getPrecision();
                Integer n2 = mdColumn.getScale();
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = 0;
                }
                stringArray[i] = this.getColumnPattern(string11, string10, n, n2, string6, mdColumn.getNullableFlag(), i == mdColumnArray.length - 1);
            }
            stringTemplate = this.m_templateGroup.getTemplateDefinition("FexpUnload");
            stringTemplate.reset();
            stringTemplate.setAttribute("maxsessions", TeradataPreferencePanel.getFexpMaxSessions());
            stringTemplate.setAttribute("minsessions", TeradataPreferencePanel.getFexpMinSessions());
            stringTemplate.setAttribute("logtable", (Object)(string9 + ".LogTable"));
            stringTemplate.setAttribute("outfile", (Object)string4);
            stringTemplate.setAttribute("collist", (Object)stringArray);
            stringTemplate.setAttribute("table", (Object)teradataMachine.quote(string));
            stringTemplate.setAttribute("eofd", (Object)string6);
            stringTemplate.setAttribute("eord", (Object)string8);
            string3 = stringTemplate.toString();
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return string3;
    }

    public static String makeNumericFormat(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('-');
        for (int i = 0; i < n; ++i) {
            if (i == n - n2) {
                stringBuffer.append('.');
            }
            stringBuffer.append('9');
        }
        return stringBuffer.toString();
    }

    public String getColumnPattern(String string, String string2, int n, int n2, String string3, boolean bl, boolean bl2) {
        String string4;
        String string5 = "";
        String string6 = "''";
        String string7 = string4 = bl2 ? "" : " || " + string3;
        if (string2.equals("DECIMAL")) {
            String string8 = Teradata12FEXPState.makeNumericFormat(n, n2);
            string5 = "CAST(CAST(\"" + string + "\" AS FORMAT '" + string8 + "') AS CHAR(" + string8.length() + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + string8.length() + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("DATE")) {
            string5 = "(\"" + string + "\"(FORMAT 'Y4-MM-DD') (CHAR(10)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || '          ' )";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("ANSITIME")) {
            string5 = "(\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)') (CHAR(15)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(15))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("ANSITIMEWITHTIMEZONE")) {
            string5 = "(\"" + string + "\"(FORMAT 'HH:MI:SS.S(6)Z') (CHAR(21)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(21))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string5 = "(\"" + string + "\"(FORMAT 'Y4-MM-DDbHH:MI:SS.S(6)') (CHAR(26)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(26))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("TIMESTAMPWITHTIMEZONE")) {
            string5 = "(\"" + string + "\"(FORMAT 'Y4-MM-DD HH:MI:SS.S(6)Z') (CHAR(31)))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(31))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("DAY") || string2.equals("DAYHOUR") || string2.equals("DAYMINUTE") || string2.equals("DAYSECOND")) {
            int n3 = n + 10 + (n2 > 0 ? n2 + 1 : 0);
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + ")) AS CHAR(" + n3 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n3 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("HOUR") || string2.equals("HOURMINUTE") || string2.equals("HOURSECOND")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            int n4 = n + 10 + (n2 > 0 ? n2 + 1 : 0);
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(" + n + ") TO SECOND(" + n2 + ")) AS CHAR(" + n4 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n4 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("MINUTE") || string2.equals("MINUTETOSECOND") || string2.equals("SECOND")) {
            int n5 = 11 + (n2 > 0 ? n2 + 1 : 0);
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL DAY(1) TO SECOND(" + n2 + ")) AS CHAR(" + n5 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n5 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("YEAR") || string2.equals("YEARMONTH")) {
            int n6 = n + 4;
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) AS CHAR(" + n6 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n6 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("MONTH")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            int n7 = n + 4;
            string5 = "CAST(CAST(\"" + string + "\" AS INTERVAL YEAR(" + n + ") TO MONTH) AS CHAR(" + n7 + "))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(" + n7 + "))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("CHARVARYINGLATIN") || string2.equals("CHARVARYINGGRAPHIC") || string2.equals("CHARVARYINGUNICODE") || string2.equals("CHARVARYINGKANJI1") || string2.equals("CHARVARYINGKANJISJIS")) {
            string5 = n > 4000 ? "'000009Too Large'" : "((CAST(CAST(CHARACTER_LENGTH(\"" + string + "\") AS FORMAT'-9(6)') AS CHAR(6))) || \"" + string + "\")";
            string6 = "'000000'";
            string4 = "";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
        } else if (string2.equals("BYTEFIXED")) {
            string5 = "'" + Teradata12FEXPState.makeHexVARCHARC(6, "BYTEFIXED not allowed in fexp migration", n) + "'";
            string6 = "'000000'";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("BYTELARGEOBJECT")) {
            string5 = "'" + Teradata12FEXPState.makeHexVARCHARC(6, "BYTELARGEOBJECT not allowed in fexp migration", -1) + "'";
            string6 = "'000000'";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("BYTEVARYING")) {
            string5 = "'" + Teradata12FEXPState.makeHexVARCHARC(6, "BYTEVARYING not allowed in fexp migration", n) + "'";
            string6 = "'000000'";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("CHARLARGEOBJECTLATIN") || string2.equals("CHARLARGEOBJECTGRAPHIC") || string2.equals("CHARLARGEOBJECTUNICODE") || string2.equals("CHARLARGEOBJECTKANJI1") || string2.equals("CHARLARGEOBJECTKANJISJIS")) {
            string5 = "'" + Teradata12FEXPState.makeVARCHARC(6, string2 + " not allowed in fexp migration", -1) + "'";
            string6 = "'000000'";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || " + string6 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("REAL")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9.9999999999999999E+999'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || '+9.9999999999999999E+999')";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("BIGINTEGER")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9(20)'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(21))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("INTEGER")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9(11)'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(12))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("SMALLINT")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9(5)'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(6))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("BYTEINT")) {
            string5 = "(CAST(\"" + string + "\" AS FORMAT '+9(3)'))";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + " || (CAST ('' as char(4))))";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
            string4 = "";
        } else if (string2.equals("CHARFIXEDLATIN")) {
            string5 = "\"" + string + "\"";
            if (bl) {
                String string9 = "('N' || " + string3 + ")";
                string6 = "('Y' || " + string3 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string9 + " end, " + "case when \"" + string + "\" is null then (CAST ('' as char(" + n + "))) else (" + string5 + ") end, ''";
            } else {
                string5 = "'', " + string5 + ", ''";
            }
        } else if (string2.equals("CHARFIXEDGRAPHIC")) {
            string5 = "(TRANSLATE(\"" + string + "\" USING GRAPHIC_TO_UNICODE))";
            if (bl) {
                String string10 = "('N' || " + string3 + ")";
                string6 = "('Y' || " + string3 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string10 + " end, " + "case when \"" + string + "\" is null then (CAST ('' as char(" + n + ")) else (" + string5 + ") end, ''";
            } else {
                string5 = "'', " + string5 + ", ''";
            }
        } else {
            string5 = "\"" + string + "\"";
            if (bl) {
                string5 = "('N' || " + string3 + " || " + string5 + ")";
                string6 = "('Y' || " + string3 + ")";
                string5 = "case when \"" + string + "\" is null then " + string6 + " else " + string5 + " end";
            }
        }
        return string5 + string4;
    }

    @Override
    public Object[] generateExternalTableColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        return mdColumnArray2;
    }

    @Override
    public String generateExternalColumnDefinitions(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < mdColumnArray2.length; ++i) {
            MdColumn mdColumn = mdColumnArray2[i];
            MdColumn mdColumn2 = mdColumnArray[i];
            stringBuffer.append(this.maybeQuoteExternalFieldReference(teradataMachine, mdColumn2, mdColumn));
            stringBuffer.append(' ');
            stringBuffer.append(this.formatSQLLoaderColumn(teradataMachine, mdColumn2, mdColumn, i + 1 >= mdColumnArray2.length));
            if (i >= mdColumnArray2.length - 1) continue;
            stringBuffer.append(", \n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public String generateExternalSelectColumnList(TeradataMachine teradataMachine, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2) {
        return null;
    }

    @Override
    public String maybeQuoteSqlldrFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = mdColumn.getColumnType();
        String string2 = mdColumn2.getColumnName();
        if (mdColumn2.getNullableFlag()) {
            stringBuffer.append(teradataMachine.trunk30("NL_" + mdColumn2.getColumnName()));
            stringBuffer.append(" FILLER CHAR(1) TERMINATED BY '" + teradataMachine.getDataMoveColumnDelimiter() + "',\n");
        }
        stringBuffer.append(mdColumn2.getColumnName());
        return stringBuffer.toString();
    }

    @Override
    public String maybeQuoteExternalFieldReference(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = mdColumn.getColumnType();
        String string2 = mdColumn2.getColumnName();
        if (mdColumn2.getNullableFlag()) {
            stringBuffer.append(teradataMachine.trunk30("NL_" + string2));
            stringBuffer.append(" FILLER CHAR(1) TERMINATED BY '<EOFD>',\n");
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    @Override
    public String formatSQLLoaderColumn(TeradataMachine teradataMachine, MdColumn mdColumn, MdColumn mdColumn2, boolean bl) {
        String string = "";
        String string2 = mdColumn2.getColumnName();
        boolean bl2 = mdColumn.getNullableFlag();
        String string3 = mdColumn.getColumnType();
        Integer n = mdColumn.getPrecision() == null ? 0 : mdColumn.getPrecision();
        Integer n2 = mdColumn.getScale() == null ? 0 : mdColumn.getScale();
        String string4 = "";
        String string5 = "";
        String string6 = " TERMINATED BY '" + teradataMachine.getDataMoveColumnDelimiter() + "'";
        Integer n3 = mdColumn2.getPrecision();
        int n4 = 0;
        if (bl2) {
            string4 = " NULLIF " + teradataMachine.trunk30("NL_" + string2) + "='Y'";
        }
        n4 = n3 == null ? 0 : n3;
        if (string3.equals("DECIMAL")) {
            string = "DECIMAL EXTERNAL(" + Teradata12FEXPState.makeNumericFormat(n, n2).length() + ")";
            string6 = "";
        } else if (string3.equals("BYTEINT")) {
            string = "INTEGER EXTERNAL(4)";
            string6 = "";
        } else if (string3.equals("SMALLINT")) {
            string = "INTEGER EXTERNAL(6)";
            string6 = "";
        } else if (string3.equals("INTEGER")) {
            string = "INTEGER EXTERNAL(12)";
            string6 = "";
        } else if (string3.equals("BIGINTEGER")) {
            string = "DECIMAL EXTERNAL(21)";
            string6 = "";
        } else if (string3.equals("REAL")) {
            string = "FLOAT EXTERNAL(24)";
            string6 = "";
        } else if (string3.equals("DATE")) {
            string = "CHAR(10)";
            string5 = " \"TO_DATE(:" + string2 + ",  'YYYY-MM-DD')\"";
            string6 = "";
        } else if (string3.equals("ANSITIME")) {
            string = "CHAR(15)";
            string5 = " \"TO_TIMESTAMP(:" + string2 + ",  'HH24:MI:SS.FF6')\"";
            string6 = "";
        } else if (string3.equals("ANSITIMEWITHTIMEZONE")) {
            string = "CHAR(21)";
            string5 = " \"TO_TIMESTAMP_TZ(:" + string2 + ",  'HH24:MI:SS.FF6TZH:TZM')\"";
            string6 = "";
        } else if (string3.equals("TIMESTAMPWITHOUTTIMEZONE")) {
            string = "CHAR(26)";
            string5 = " \"TO_TIMESTAMP(:" + string2 + ",  'YYYY-MM-DD HH24:MI:SS.FF6')\"";
            string6 = "";
        } else if (string3.equals("TIMESTAMPWITHTIMEZONE")) {
            string = "CHAR(31)";
            string5 = " \"TO_TIMESTAMP_TZ(:" + string2 + ",  'YYYY-MM-DD HH24:MI:SS.FF6TZH:TZM')\"";
            string6 = "";
        } else if (string3.equals("DAY") || string3.equals("DAYHOUR") || string3.equals("DAYMINUTE") || string3.equals("DAYSECOND")) {
            string = "CHAR(" + (n + 10 + (n2 > 0 ? n2 + 1 : 0)) + ")";
            string6 = "";
        } else if (string3.equals("HOUR") || string3.equals("HOURMINUTE") || string3.equals("HOURSECOND")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string = "CHAR(" + (n + 10 + (n2 > 0 ? n2 + 1 : 0)) + ")";
            string6 = "";
        } else if (string3.equals("MINUTE") || string3.equals("MINUTETOSECOND") || string3.equals("SECOND")) {
            string = "CHAR(" + (11 + (n2 > 0 ? n2 + 1 : 0)) + ")";
            string6 = "";
        } else if (string3.equals("YEAR") || string3.equals("YEARMONTH")) {
            string = "CHAR(" + (n + 4) + ")";
            string6 = "";
        } else if (string3.equals("MONTH")) {
            switch (n) {
                case 4: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    n = 1;
                }
            }
            string = "CHAR(" + (n + 4) + ")";
        } else if (string3.equals("BYTELARGEOBJECT") || string3.equals("CHARLARGEOBJECTLATIN") || string3.equals("CHARLARGEOBJECTGRAPHIC") || string3.equals("CHARLARGEOBJECTUNICODE") || string3.equals("CHARLARGEOBJECTKANJI1") || string3.equals("CHARLARGEOBJECTKANJISJIS") || string3.equals("BYTEFIXED") || string3.equals("BYTEVARYING")) {
            string = "VARCHARC(6)";
            string6 = "";
        } else if (string3.equals("CHARFIXEDLATIN")) {
            string = "CHAR(" + n + ")";
            string6 = "";
            string5 = ",\nF2_" + string2 + " FILLER RAW(8)";
        } else if (string3.equals("CHARFIXEDGRAPHIC") || string3.equals("CHARFIXEDUNICODE")) {
            string = "CHAR(" + n / 2 + ")";
        } else if (string3.equals("CHARFIXEDKANJI1") || string3.equals("CHARFIXEDKANJISJIS")) {
            string = "CHAR(" + n + ")";
        } else if (string3.equals("CHARVARYINGLATIN")) {
            string = "VARCHARC(6)";
            string6 = "";
        } else if (string3.equals("CHARVARYINGGRAPHIC") || string3.equals("CHARVARYINGUNICODE") || string3.equals("CHARVARYINGKANJI1") || string3.equals("CHARVARYINGKANJISJIS")) {
            string = "VARCHARC(6)";
            string6 = "";
        } else {
            string = "XXX(" + string3 + ")XXX";
            System.out.println("UNHANDLED TYPE " + string + (bl ? "" : string6) + string4 + string5);
        }
        return string + (bl ? "" : string6) + string4 + string5;
    }

    protected void loadTemplates() {
        if (this.m_templateGroup == null) {
            RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", this.getClass().getClassLoader());
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
    }

    @Override
    public void postProcessTableData(Teradata12Offline3rdPartyPrintStream teradata12Offline3rdPartyPrintStream, String string) throws Exception {
        if (!TeradataPreferencePanel.isUseFExp()) {
            String string2 = string.endsWith(".dat") ? string.substring(0, string.length() - 4).replaceAll("[ \\\\/$]", "_") : string.replaceAll("[ \\\\/$]", "_");
            teradata12Offline3rdPartyPrintStream.println(null, ":#:SCRIPT:java -jar convertdata.jar data" + File.separator + string2 + ".csv " + "data" + File.separator + string2 + ".exp " + "data" + File.separator + string2 + ".dat", true);
        }
    }

    @Override
    public String getSQLLoaderCommand(TeradataMachine teradataMachine, String string, String string2, boolean bl) {
        this.loadTemplates();
        StringTemplate stringTemplate = null;
        stringTemplate = this.m_templateGroup.getInstanceOf("FexpSQLLoaderCommand");
        stringTemplate.setAttribute("fileName", (Object)string2);
        stringTemplate.setAttribute("platformWindows", (Object)bl);
        String string3 = stringTemplate.toString();
        return string3;
    }

    @Override
    public String getColumnPattern(String string, String string2, int n, int n2) {
        return string;
    }

    protected static String makeHexVARCHARC(int n, CharSequence charSequence, int n2) {
        if (charSequence == null || charSequence.length() == 0) {
            return Teradata12FEXPState.makeVARCHARC(n, charSequence, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            int n3 = Character.getNumericValue(c);
            String string = Integer.toHexString(n3 & 0xFF);
            stringBuffer.append(string);
        }
        return Teradata12FEXPState.makeVARCHARC(n, stringBuffer.toString(), n2 * 2);
    }

    protected static String makeVARCHARC(int n, CharSequence charSequence, int n2) {
        int n3;
        int n4;
        int n5 = n4 = charSequence == null ? 0 : charSequence.length();
        if (n2 >= 0 && n4 > n2) {
            n4 = n2;
        }
        String string = Integer.toString(n4);
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n - string.length(); ++n3) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append(charSequence.charAt(n3));
        }
        return stringBuffer.toString();
    }
}

