/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.util.LinkedList;
import java.util.Map;
import java.util.logging.LogRecord;

class QuickTraceBuffer {
    long maxSize_;
    int logRecordOverhead_;
    String name_;
    long size_;
    int numOfFixArray_;
    boolean containsThreadNames_;
    int refOverhead_;
    LogRecord[] recArr_;
    int[] recSizes_;
    String[] recThreadNames_;
    Map[] recSupplAttrs_;
    int arrLen_;
    int currPos_;
    int headPos_;
    byte[] bufferLock_;
    private static final int BUFFER_OVERFLOW_SIZE = 1024;
    byte[] buffer_;
    LinkedList<LockRegion> regions_;
    LinkedList<Integer> recPosList_;

    QuickTraceBuffer(String name, long size, int logRecordOverhead, int refOverhead, boolean containsThreadNames) {
        this.name_ = name;
        this.maxSize_ = size;
        this.bufferLock_ = new byte[0];
        this.logRecordOverhead_ = logRecordOverhead;
        this.refOverhead_ = refOverhead;
        this.containsThreadNames_ = containsThreadNames;
        this.numOfFixArray_ = this.containsThreadNames_ ? 3 : 4;
        this.initialize();
    }

    QuickTraceBuffer(String name, long size) {
        this.name_ = name;
        this.maxSize_ = size;
        this.bufferLock_ = new byte[0];
        this.buffer_ = new byte[(int)size + 1024];
        this.currPos_ = 0;
        this.recPosList_ = new LinkedList();
        this.regions_ = new LinkedList();
    }

    void initialize() {
        this.arrLen_ = (int)(this.maxSize_ / (long)this.numOfFixArray_ / (long)this.logRecordOverhead_);
        this.recArr_ = new LogRecord[this.arrLen_];
        this.recSizes_ = new int[this.recArr_.length];
        if (this.containsThreadNames_) {
            this.recThreadNames_ = new String[this.recArr_.length];
        }
        this.recSupplAttrs_ = new Map[this.recArr_.length];
        this.currPos_ = 0;
        this.headPos_ = 0;
        this.maxSize_ -= (long)(this.refOverhead_ * this.arrLen_ * this.numOfFixArray_);
        if (this.maxSize_ < 0L) {
            this.maxSize_ = 0L;
        }
    }

    void enableThreadNameBuffer(boolean enable) {
        if (enable && !this.containsThreadNames_) {
            this.containsThreadNames_ = true;
            this.recThreadNames_ = new String[this.recArr_.length];
        } else if (!enable && this.containsThreadNames_) {
            this.containsThreadNames_ = false;
            this.recThreadNames_ = null;
        }
    }

    String getName() {
        return this.name_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LockRegion lockRegion(int pos, int size) {
        int end = pos + size - 1;
        if (end > this.buffer_.length - 1) {
            end -= this.buffer_.length;
        }
        LockRegion r = new LockRegion(pos, end);
        boolean overlap = true;
        LinkedList<LockRegion> linkedList = this.regions_;
        synchronized (linkedList) {
            if (this.regions_.size() > 0) {
                block5: while (overlap) {
                    for (LockRegion lr : this.regions_) {
                        overlap = r.isOverlappedWith(lr);
                        if (!overlap) continue;
                        try {
                            this.regions_.wait(100L);
                        }
                        catch (InterruptedException inex) {
                            overlap = false;
                        }
                        continue block5;
                    }
                }
            }
            this.regions_.add(r);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockRegion(LockRegion r) {
        LinkedList<LockRegion> linkedList = this.regions_;
        synchronized (linkedList) {
            this.regions_.remove(r);
            this.regions_.notifyAll();
        }
    }

    static class LockRegion {
        int x1_;
        int x2_;
        boolean wrap_;

        LockRegion(int start, int end) {
            this.x1_ = start;
            this.x2_ = end;
            this.wrap_ = this.x1_ > this.x2_;
        }

        boolean isOverlappedWith(LockRegion r) {
            boolean status = false;
            if (this.wrap_ && r.wrap_) {
                status = true;
            } else if (this.wrap_ || r.wrap_) {
                status = this.x1_ <= r.x2_ | this.x2_ >= r.x1_;
            }
            return status;
        }
    }
}

