/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.core.ojdl.logging.ODLLoggerProxy;
import oracle.core.ojdl.logging.QuickTraceHandlerMarker;
import oracle.core.ojdl.logging.context.LoggingContext;
import oracle.core.ojdl.logging.context.LoggingContextManager;
import oracle.core.ojdl.logging.context.LoggingContextProvider;
import oracle.core.ojdl.logging.impl.LoggingNotificationHandler;
import sun.reflect.Reflection;

public class ODLLogger
extends Logger {
    private String m_resourceBundleName;
    private WeakReference m_cachedBundle;
    private String m_cachedBundleName;
    private boolean m_contextLevelEnabled = true;
    private static boolean s_globalContextLevelEnabled = true;
    private LoggingContextProvider m_ctxProvider;
    private LoggingNotificationHandler m_notificationHandler = LoggingNotificationHandler.getInstance();
    public static final String CONTEXT_LEVEL_KEY = "LOGGING_LEVEL";
    private static final boolean s_useProxy;

    protected ODLLogger(String name, String resourceBundleName) throws MissingResourceException {
        super(name, null);
        this.m_resourceBundleName = resourceBundleName;
        this.getResourceBundle(resourceBundleName);
        this.m_ctxProvider = LoggingContextManager.getEffectiveLoggingContextProvider(name);
    }

    public static Logger getLogger(String name) {
        return ODLLogger.getLogger(name, null);
    }

    public static ODLLogger getODLLogger(String name) throws ClassCastException {
        return ODLLogger.getODLLogger(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name, String resourceBundleName) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ODLLogger._getODLLogger(name, resourceBundleName);
        }
    }

    static Logger _getODLLogger(String name, String resourceBundleName) {
        LogManager lm = LogManager.getLogManager();
        Logger logger = lm.getLogger(name);
        if (logger != null) {
            if (resourceBundleName == null) {
                return logger;
            }
            if (logger instanceof ODLLogger) {
                ODLLogger ologger = (ODLLogger)logger;
                String rbName = ologger.getResourceBundleName();
                if (rbName != null && !rbName.equals(resourceBundleName)) {
                    throw new IllegalArgumentException("resourceBundleName");
                }
                ologger.m_resourceBundleName = resourceBundleName;
                ologger.getResourceBundle(resourceBundleName);
                return logger;
            }
            return Logger.getLogger(name, resourceBundleName);
        }
        logger = new ODLLogger(name, resourceBundleName);
        lm.addLogger(logger);
        return lm.getLogger(name);
    }

    public static ODLLogger getODLLogger(String name, String resourceBundleName) throws ClassCastException {
        Logger logger = ODLLogger.getLogger(name, resourceBundleName);
        if (!(logger instanceof ODLLogger) && s_useProxy) {
            return new ODLLoggerProxy(logger);
        }
        return (ODLLogger)logger;
    }

    public void setLoggingContextProvider(LoggingContextProvider provider) {
        if (provider != LoggingContextManager.getEffectiveLoggingContextProvider(this.getName())) {
            throw new IllegalArgumentException();
        }
        this.m_ctxProvider = provider;
    }

    @Override
    public boolean isLoggable(Level level) {
        Level ctxLevel;
        if (s_globalContextLevelEnabled && this.m_contextLevelEnabled && this.m_ctxProvider != null && this.m_ctxProvider.isContextLevelEnabled() && (ctxLevel = this.m_ctxProvider.getLoggingContext().getLevel()) != null && level.intValue() >= ctxLevel.intValue()) {
            return true;
        }
        return super.isLoggable(level);
    }

    final boolean isLoggableByContext(Level level) {
        Level ctxLevel;
        return s_globalContextLevelEnabled && this.m_contextLevelEnabled && this.m_ctxProvider != null && this.m_ctxProvider.isContextLevelEnabled() && (ctxLevel = this.m_ctxProvider.getLoggingContext().getLevel()) != null && level.intValue() >= ctxLevel.intValue();
    }

    public static Level getContextLevel() {
        return LoggingContextManager.getLoggingContext(null).getLevel();
    }

    public static void setContextLevel(Level level) {
        LoggingContext ctx = LoggingContextManager.getLoggingContext(null);
        if (ctx.getClass().getName().equals("oracle.core.ojdl.logging.impl.DMSLoggingContext")) {
            try {
                ctx.getClass().getMethod("setLevel", Level.class).invoke((Object)ctx, level);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to set context level: " + e);
            }
        }
    }

    public static boolean isGlobalContextLevelEnabled() {
        return s_globalContextLevelEnabled;
    }

    public static void setGlobalContextLevelEnabled(boolean enabled) {
        s_globalContextLevelEnabled = enabled;
    }

    public boolean isContextLevelEnabled() {
        return this.m_contextLevelEnabled;
    }

    public void setContextLevelEnabled(boolean enabled) {
        this.m_contextLevelEnabled = enabled;
    }

    @Override
    public String getResourceBundleName() {
        if (this.m_resourceBundleName == null) {
            this.m_resourceBundleName = super.getResourceBundleName();
        }
        return this.m_resourceBundleName;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        try {
            return this.getResourceBundle(this.getResourceBundleName());
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private String getInheritedResourceBundleName() {
        Logger logger = this;
        do {
            String rbName;
            if ((rbName = ((Logger)logger).getResourceBundleName()) == null) continue;
            return rbName;
        } while ((logger = logger.getParent()) != null);
        return null;
    }

    private ResourceBundle getResourceBundle(String resourceBundleName) throws MissingResourceException {
        ResourceBundle rb;
        block12: {
            if (resourceBundleName == null) {
                return null;
            }
            Locale loc = Locale.getDefault();
            rb = null;
            if (this.m_cachedBundle != null && this.m_cachedBundleName == resourceBundleName && (rb = (ResourceBundle)this.m_cachedBundle.get()) != null && loc.equals(rb.getLocale())) {
                return rb;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                rb = ResourceBundle.getBundle(resourceBundleName, loc, cl);
            }
            catch (MissingResourceException e) {
                try {
                    Class clz;
                    int i = 0;
                    while ((clz = Reflection.getCallerClass((int)i)) != null) {
                        ClassLoader cl2 = clz.getClassLoader();
                        if (cl2 != null && cl2 != cl) {
                            cl = cl2;
                            try {
                                rb = ResourceBundle.getBundle(resourceBundleName, loc, cl);
                                break;
                            }
                            catch (MissingResourceException e2) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (rb != null) break block12;
                throw e;
            }
        }
        this.m_cachedBundle = new WeakReference<ResourceBundle>(rb);
        this.m_cachedBundleName = resourceBundleName;
        return rb;
    }

    public void log(Level level, String msgId, String msg, Object[] args, Map supplAttributes, Object supplDetail) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        rec.setMessageId(msgId);
        rec.setParameters(args);
        rec.setSupplAttributes(supplAttributes);
        if (supplDetail instanceof Throwable) {
            rec.setThrown((Throwable)supplDetail);
        } else if (supplDetail != null) {
            rec.setSupplDetail(supplDetail.toString());
        }
        this.logRec(rec);
    }

    public void log(Level level, String msgId, String msg, Object[] args, Map supplAttributes, String[] supplAttrKeys, String[] supplAttrValues, Object supplDetail) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        rec.setMessageId(msgId);
        rec.setParameters(args);
        rec.setSupplAttributes(supplAttributes);
        rec.setSupplAttributeKeys(supplAttrKeys);
        rec.setSupplAttributeValues(supplAttrValues);
        if (supplDetail != null) {
            if (supplDetail instanceof Throwable) {
                rec.setThrown((Throwable)supplDetail);
            } else {
                rec.setSupplDetail(supplDetail.toString());
            }
        }
        this.logRec(rec);
    }

    public void log(Level level, String msg, Object[] args, Map supplAttributes) {
        this.log(level, null, msg, args, supplAttributes, null);
    }

    public void log(Level level, String msg, Object[] args, Object supplDetail) {
        this.log(level, null, msg, args, null, supplDetail);
    }

    public void log(Level level, String msgId, String msg, Object[] args) {
        this.log(level, msgId, msg, args, null, null);
    }

    public void log(Level level, String msg, Object[] args, Throwable t) {
        this.log(level, null, msg, args, null, t);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] args, Throwable t) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(args);
        rec.setThrown(t);
        this.logRec(rec);
    }

    public void logp(Level level, String msgId, String sourceClass, String sourceMethod, String msg, Object[] args, Map supplAttributes, Object supplDetail) {
        this.logrb(level, msgId, sourceClass, sourceMethod, null, msg, args, supplAttributes, supplDetail);
    }

    public void logrb(Level level, String msgId, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] args, Map supplAttributes, Object supplDetail) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        rec.setMessageId(msgId);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(args);
        rec.setSupplAttributes(supplAttributes);
        if (supplDetail instanceof Throwable) {
            rec.setThrown((Throwable)supplDetail);
        } else if (supplDetail != null) {
            rec.setSupplDetail(supplDetail.toString());
        }
        this.logRec(rec, bundleName);
    }

    @Override
    public void log(LogRecord rec) {
        if (!this.isLoggable(rec.getLevel())) {
            return;
        }
        this.doLog(rec);
    }

    @Override
    public void log(Level level, String msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        this.logRec(rec);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        this.log(level, msg, new Object[]{param1});
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        rec.setParameters(params);
        this.logRec(rec);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        rec.setThrown(thrown);
        this.logRec(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        ((LogRecord)rec).setSourceClassName(sourceClass);
        ((LogRecord)rec).setSourceMethodName(sourceMethod);
        this.logRec(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        Object[] params = new Object[]{param1};
        this.logp(level, sourceClass, sourceMethod, msg, params);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        ((LogRecord)rec).setSourceClassName(sourceClass);
        ((LogRecord)rec).setSourceMethodName(sourceMethod);
        rec.setParameters(params);
        this.logRec(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        ((LogRecord)rec).setSourceClassName(sourceClass);
        ((LogRecord)rec).setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        this.logRec(rec);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        ((LogRecord)rec).setSourceClassName(sourceClass);
        ((LogRecord)rec).setSourceMethodName(sourceMethod);
        this.logRec(rec, bundleName);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        Object[] params = new Object[]{param1};
        this.logrb(level, sourceClass, sourceMethod, bundleName, msg, params);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        ((LogRecord)rec).setSourceClassName(sourceClass);
        ((LogRecord)rec).setSourceMethodName(sourceMethod);
        rec.setParameters(params);
        this.logRec(rec, bundleName);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (!this.isLoggable(level)) {
            return;
        }
        ODLLogRecord rec = new ODLLogRecord(level, msg);
        ((LogRecord)rec).setSourceClassName(sourceClass);
        ((LogRecord)rec).setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        this.logRec(rec, bundleName);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", params);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        StringBuffer sb = new StringBuffer("ENTRY");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                sb.append(" {");
                sb.append(i);
                sb.append("}");
            }
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, sb.toString(), params);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        Object[] params = new Object[]{result};
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", params);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logp(Level.FINER, sourceClass, sourceMethod, "THROW", thrown);
    }

    @Override
    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    @Override
    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    @Override
    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    @Override
    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    @Override
    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    @Override
    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog(LogRecord rec) {
        ODLLogger oDLLogger = this;
        synchronized (oDLLogger) {
            Filter filter = this.getFilter();
            if (filter != null && !filter.isLoggable(rec)) {
                return;
            }
        }
        boolean useQuickTrace = false;
        Logger logger = this;
        do {
            Handler[] handlers;
            if ((handlers = logger.getHandlers()) == null) continue;
            for (int i = 0; i < handlers.length; ++i) {
                if (!useQuickTrace && handlers[i] instanceof QuickTraceHandlerMarker) {
                    useQuickTrace |= true;
                }
                handlers[i].publish(rec);
            }
        } while (logger.getUseParentHandlers() && (logger = logger.getParent()) != null);
        if (useQuickTrace && rec != null && rec instanceof ODLLogRecord) {
            this.disposeRecordMembers((ODLLogRecord)rec);
        }
        this.m_notificationHandler.recordLogged(rec);
    }

    private void disposeRecordMembers(ODLLogRecord rec) {
        rec.setSupplAttributes(null);
        rec.setLoggingContext(null);
    }

    private void logRec(LogRecord rec) {
        this.logRec(rec, null);
    }

    private void logRec(LogRecord rec, String resourceBundleName) {
        rec.setLoggerName(this.getName());
        String rbName = resourceBundleName == null ? this.getInheritedResourceBundleName() : resourceBundleName;
        rec.setResourceBundleName(rbName);
        try {
            rec.setResourceBundle(this.getResourceBundle(rbName));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        this.doLog(rec);
    }

    private static String getSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    static {
        String useProxyProp = ODLLogger.getSystemProperty("oracle.core.ojdl.logging.ODLLogger.useProxy");
        s_useProxy = useProxyProp != null ? "true".equalsIgnoreCase(useProxyProp) : true;
    }
}

