/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing.impl;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.as.management.logging.LogMetaData;
import oracle.as.management.tracing.TraceInfo;
import oracle.as.management.tracing.TraceProvider;
import oracle.as.management.tracing.TraceProviderInfo;
import oracle.as.management.tracing.TraceProviderParameterInfo;
import oracle.as.management.tracing.TraceProviderParameterType;
import oracle.as.management.tracing.impl.TraceDump;
import oracle.core.ojdl.reader.ODLTextLogReaderFactory;
import oracle.dfw.framework.DiagnosticsFramework;
import oracle.dfw.incident.Incident;
import oracle.dms.context.ExecutionContext;
import oracle.dms.event.Destination;
import oracle.dms.event.Event;
import oracle.dms.event.EventConfigManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.event.EventType;
import oracle.dms.event.Filter;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.trace.TraceResourceBundle;
import oracle.dms.trace2.runtime.LoggerDestination;

public class DMSTraceProvider
implements TraceProvider {
    private static final String EVENT_TYPES_PARAMETER_NAME = "_eventTypes";
    private static final String NOUN_TYPES_PARAMETER_NAME = "_nounTypes";
    private AtomicBoolean m_enabled = new AtomicBoolean(false);
    private DiagnosticsFramework m_dfw;
    private Logger mDiagnosticLogger = Logger.getLogger("oracle.dms.trace");
    private TraceDump m_traceDump = new DMSTraceDump();
    private Map<String, DMSTraceFilter> mTraceStateMap = new ConcurrentHashMap<String, DMSTraceFilter>();
    private LoggerDestination mDestination;
    private int mInstanceNumber = sInstanceCounter.incrementAndGet();
    private static final String NAME = "DMS";
    private static final AtomicInteger sInstanceCounter = new AtomicInteger();
    private static final AtomicInteger sFilterCounter = new AtomicInteger();
    private static final String TRACE_OUTPUT_LOGGER_NAME = "oracle.dms.strace";
    private static EventType[] sAllEventTypes = EventType.getAllEventTypes();

    public DMSTraceProvider() {
        this.mDestination = new LoggerDestination();
        this.mDestination.setName("<traceDestination" + this.mInstanceNumber + ">");
        this.mDestination.setId("<traceDestination" + this.mInstanceNumber + ">");
        try {
            this.mDestination.setLoggerName(TRACE_OUTPUT_LOGGER_NAME);
        }
        catch (Exception e) {
            this.mDiagnosticLogger.log(Level.WARNING, "DMS-58073", e);
            throw new RuntimeException(e);
        }
        try {
            this.m_dfw = new DiagnosticsFramework();
        }
        catch (Exception e) {
            this.mDiagnosticLogger.log(Level.WARNING, "DMS-58072", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public int startTracing(String traceId, String attrName, String attrValue, Level level, Map<String, String> params) {
        DMSTraceFilter filter = null;
        filter = params == null ? new DMSTraceFilter(traceId, Collections.EMPTY_MAP) : new DMSTraceFilter(traceId, params);
        if (this.isEnabled() && filter != null) {
            this.mTraceStateMap.put(traceId, filter);
            this.activateTraceConfguration(filter);
        }
        return 0;
    }

    @Override
    public int stopTracing(String traceId) {
        DMSTraceFilter filter;
        if (this.isEnabled() && (filter = this.mTraceStateMap.remove(traceId)) != null) {
            this.deactivateTraceConfguration(filter);
        }
        return 0;
    }

    @Override
    public int stopTracing(TraceInfo traceInfo, Incident incident) throws Exception {
        this.addTraceDataToIncident(traceInfo, incident);
        this.stopTracing(traceInfo.getTraceId());
        return 0;
    }

    @Override
    public boolean hasTraceData(String traceId) {
        boolean retVal = false;
        DMSTraceFilter filter = this.mTraceStateMap.get(traceId);
        if (filter != null) {
            retVal = filter.mEventCount.get() > 0;
        }
        return retVal;
    }

    @Override
    public boolean isEnabled() {
        boolean retVal = this.m_enabled.get();
        return retVal;
    }

    @Override
    public void setEnabled(boolean enabled) throws Exception {
        boolean previousEnabled = this.m_enabled.getAndSet(enabled);
        if (previousEnabled && !enabled) {
            for (DMSTraceFilter filter : this.mTraceStateMap.values()) {
                this.deactivateTraceConfguration(filter);
            }
            this.mTraceStateMap.clear();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public TraceProviderInfo getTraceProviderInfo(Locale loc) {
        ResourceBundle rb = ResourceBundle.getBundle(TraceResourceBundle.class.getName(), loc);
        TraceProviderInfo tpi = new TraceProviderInfo();
        tpi.setName(NAME);
        tpi.setUserVisibleName(NAME);
        tpi.setDescription(rb.getString("DMSTraceProdiver.description"));
        TraceProviderParameterInfo p1 = new TraceProviderParameterInfo();
        p1.setName(EVENT_TYPES_PARAMETER_NAME);
        p1.setUserVisibleName(rb.getString("DMSTraceProdiver._eventTypes.userVisibleName"));
        p1.setDescription(rb.getString("DMSTraceProdiver._eventTypes.description"));
        p1.setType(TraceProviderParameterType.STRING);
        TraceProviderParameterInfo p2 = new TraceProviderParameterInfo();
        p2.setName(NOUN_TYPES_PARAMETER_NAME);
        p2.setUserVisibleName(rb.getString("DMSTraceProdiver._nounTypes.userVisibleName"));
        p2.setDescription(rb.getString("DMSTraceProdiver._nounTypes.description"));
        p2.setType(TraceProviderParameterType.STRING);
        tpi.setParameterInfo(Arrays.asList(p1, p2));
        return tpi;
    }

    private synchronized void activateTraceConfguration(DMSTraceFilter filter) {
        if (filter != null && this.mDestination != null) {
            EventConfigManager eventConfigManager = EventSystem.getEventConfigManager();
            eventConfigManager.associateFilterWithDestination((Filter)filter, (Destination)this.mDestination);
        }
    }

    private synchronized void deactivateTraceConfguration(DMSTraceFilter filter) {
        if (filter != null && this.mDestination != null) {
            EventConfigManager eventConfigManager = EventSystem.getEventConfigManager();
            eventConfigManager.disassociateFilterAndDestination(filter.getId(), this.mDestination.getId());
        }
    }

    private void addTraceDataToIncident(TraceInfo traceInfo, Incident incident) throws Exception {
        String incidentDir = incident.getIncidentDirectory();
        File f = new File(incidentDir, "dms_trace.dmp");
        int index = 0;
        while (f.exists()) {
            f = new File(incidentDir, "dms_trace_" + ++index + ".dmp");
        }
        String path = f.getPath();
        this.m_traceDump.writeDump(path, traceInfo.getTraceId(), traceInfo.getStartTime(), traceInfo.getStopTime());
        this.m_dfw.getIncidentManager().addIncidentFile(incident.getIncidentId(), new String[]{f.getName()});
    }

    static class DMSTraceDump
    extends TraceDump {
        DMSTraceDump() {
        }

        @Override
        protected List<LogMetaData> getLogMetaData() throws Exception {
            String serverName = System.getProperty("weblogic.Name");
            String domainHome = System.getProperty("domain.home");
            String path = domainHome + File.separator + "servers" + File.separator + serverName + File.separator + "logs" + File.separator + DMSTraceProvider.TRACE_OUTPUT_LOGGER_NAME + "-event.log";
            LogMetaData lmd = new LogMetaData();
            lmd.setPath(path);
            lmd.setLogReaderClassName(ODLTextLogReaderFactory.class.getName());
            return Arrays.asList(lmd);
        }
    }

    class DMSTraceFilter
    implements Filter {
        String mTraceId;
        String mName;
        String mId;
        EventType[] mEventTypes;
        Set<String> mNounTypes;
        AtomicInteger mEventCount = new AtomicInteger(0);

        public DMSTraceFilter(String traceId, Map<String, String> params) {
            String filterIdAndName;
            if (traceId == null) {
                throw new IllegalArgumentException("Can not create a DMSTraceFilter with a null traceId.");
            }
            this.mTraceId = traceId;
            this.mName = filterIdAndName = "<dmsTraceFilter-" + traceId + ">";
            this.mId = filterIdAndName;
            String eventTypesListAsString = params.get(DMSTraceProvider.EVENT_TYPES_PARAMETER_NAME);
            String nounTypeListAsString = params.get(DMSTraceProvider.NOUN_TYPES_PARAMETER_NAME);
            boolean eventsIncludeSensorsOrNouns = false;
            if (eventTypesListAsString == null) {
                this.mEventTypes = sAllEventTypes;
                eventsIncludeSensorsOrNouns = true;
            } else {
                for (EventType et : this.mEventTypes = EventType.parseList((String)eventTypesListAsString, (boolean)true)) {
                    if (!et.getSourceType().isTypeOf(EventSourceType.INSTRUMENTATION_NODE)) continue;
                    eventsIncludeSensorsOrNouns = true;
                    break;
                }
            }
            if (nounTypeListAsString != null && eventsIncludeSensorsOrNouns) {
                this.mNounTypes = new HashSet<String>();
                StringTokenizer st = new StringTokenizer(nounTypeListAsString, ",");
                while (st.hasMoreTokens()) {
                    String t = st.nextToken().trim();
                    this.mNounTypes.add(t);
                }
            }
        }

        public boolean applyFilter(Event event) {
            boolean passEvent = false;
            ExecutionContext ctx = event.getExecutionContext();
            String traceId = null;
            if (ctx != null) {
                traceId = ctx.getValue("ODL_TRACE_ID");
            }
            if (this.mTraceId.equals(traceId)) {
                passEvent = true;
            }
            if (passEvent && this.mNounTypes != null) {
                Noun noun = null;
                if (event.getSourceType().isTypeOf(EventSourceType.SENSOR)) {
                    Sensor sensor = (Sensor)event.getSource();
                    noun = sensor.getParent();
                } else if (event.getSourceType() == EventSourceType.NOUN) {
                    noun = (Noun)event.getSource();
                }
                if (noun != null) {
                    passEvent = this.mNounTypes.contains(noun.getType());
                }
            }
            if (passEvent) {
                int numEvents = this.mEventCount.incrementAndGet();
            }
            return passEvent;
        }

        public boolean needsContext() {
            return true;
        }

        public String getId() {
            return this.mId;
        }

        public String getName() {
            return this.mName;
        }

        public EventType[] getEventTypesOfInterest() {
            return this.mEventTypes;
        }

        public boolean willDiscriminateAgainstNounType(String nounType) {
            boolean retVal = false;
            if (this.mNounTypes != null) {
                retVal = !this.mNounTypes.contains(nounType);
            }
            return retVal;
        }
    }
}

