/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.BuildSpecification;
import oracle.olapi.syntax.Buildable;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class BuildItem
extends SyntaxObject {
    private BaseMetadataObjectReference m_BuildObject = null;
    private String m_BuildSpecName = null;
    private BuildSpecification m_InlineBuildSpec = null;
    private long m_AsOfSCN = 0L;

    private BuildItem(Buildable buildable, String string, BuildSpecification buildSpecification, long l) {
        BuildItem.validateValue(buildable);
        this.m_BuildObject = new MetadataObjectReference((BaseMetadataObject)((Object)buildable), Buildable.class);
        this.m_BuildSpecName = string;
        this.m_InlineBuildSpec = buildSpecification;
        this.m_AsOfSCN = l;
        this.initialize();
    }

    private BuildItem(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, String string, BuildSpecification buildSpecification, long l) {
        BuildItem.validateValue(baseMetadataObjectReference);
        this.m_BuildObject = baseMetadataObjectReference;
        this.m_BuildSpecName = string;
        this.m_InlineBuildSpec = buildSpecification;
        this.m_AsOfSCN = l;
        this.initialize();
    }

    private BaseMetadataObjectReference getBuildObjectReference() {
        return this.m_BuildObject;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null != this.getInlineBuildSpecification() && !this.getInlineBuildSpecification().isDefinitionComplete()) {
            return false;
        }
        if (!this.getBuildObjectReference().isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        this.getBuildObjectReference().toSyntax(syntaxPrintingContext);
        if (null != this.getBuildSpecName()) {
            syntaxPrintingContext.append(" USING ");
            syntaxPrintingContext.append(this.getBuildSpecName());
        } else if (null != this.getInlineBuildSpecification()) {
            syntaxPrintingContext.append(" USING ");
            this.getInlineBuildSpecification().printCommands(syntaxPrintingContext);
        }
        if (this.getAsOfSCN() > 0L) {
            syntaxPrintingContext.append(" AS OF SCN ");
            syntaxPrintingContext.append(Long.toString(this.getAsOfSCN()));
        }
    }

    public BuildItem(Buildable buildable) {
        this(buildable, null, null, 0L);
    }

    public BuildItem(Buildable buildable, long l) {
        this(buildable, null, null, l);
    }

    public BuildItem(Buildable buildable, String string) {
        this(buildable, string, null, 0L);
    }

    public BuildItem(Buildable buildable, String string, long l) {
        this(buildable, string, null, l);
    }

    public BuildItem(Buildable buildable, BuildSpecification buildSpecification) {
        this(buildable, null, buildSpecification, 0L);
    }

    public BuildItem(Buildable buildable, BuildSpecification buildSpecification, long l) {
        this(buildable, null, buildSpecification, l);
    }

    public BuildItem(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, long l) {
        this(expParser, baseMetadataObjectReference, null, null, l);
    }

    public BuildItem(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, String string, long l) {
        this(expParser, baseMetadataObjectReference, string, null, l);
    }

    public BuildItem(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, BuildSpecification buildSpecification, long l) {
        this(expParser, baseMetadataObjectReference, null, buildSpecification, l);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBuildItem(this, object);
    }

    public String getBuildSpecName() {
        return this.m_BuildSpecName;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        this.m_BuildObject = (BaseMetadataObjectReference)validationContext.validate(this.m_BuildObject);
        if (null != this.m_InlineBuildSpec) {
            this.m_InlineBuildSpec = (BuildSpecification)this.m_InlineBuildSpec.validate(validationContext);
        }
        return this;
    }

    public Buildable getBuildObject() {
        return (Buildable)((Object)this.getBuildObjectReference().getBaseMetadataObject());
    }

    public String getBuildObjectID() {
        return this.getBuildObjectReference().getIdentifier().toString();
    }

    public BuildSpecification getInlineBuildSpecification() {
        return this.m_InlineBuildSpec;
    }

    public long getAsOfSCN() {
        return this.m_AsOfSCN;
    }
}

