/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.Condition;
import oracle.olapi.syntax.SyntaxException;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

public final class BinaryOperatorCondition
extends Condition {
    public static final String OP_AND = "AND";
    public static final String OP_OR = "OR";
    static final String[] ALL_OPERATORS = new String[]{"AND", "OR"};
    private String m_Operator;
    private Condition[] m_Arguments;

    private Condition[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        for (int i = 0; i < this.getArgumentsInternal().length; ++i) {
            if (0 != i) {
                syntaxPrintingContext.append(" ");
                syntaxPrintingContext.append(this.getOperator());
                syntaxPrintingContext.append(" ");
            }
            syntaxPrintingContext.print(this.getArgumentsInternal()[i]);
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.validateComponents(this, this.getArgumentsInternal());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getArgumentsInternal());
    }

    public BinaryOperatorCondition(Condition[] conditionArray, String string) {
        this.m_Operator = BinaryOperatorCondition.validateEnum(string, ALL_OPERATORS);
        BinaryOperatorCondition.validateValues(conditionArray);
        if (conditionArray.length < 2) {
            throw new SyntaxException("TwoElementsExpected");
        }
        this.m_Arguments = (Condition[])conditionArray.clone();
        this.initialize();
    }

    public BinaryOperatorCondition(List<Condition> list, String string) {
        this.m_Operator = BinaryOperatorCondition.validateEnum(string, ALL_OPERATORS);
        BinaryOperatorCondition.validateValues(list);
        if (list.size() < 2) {
            throw new SyntaxException("TwoElementsExpected");
        }
        this.m_Arguments = new Condition[list.size()];
        list.toArray(this.m_Arguments);
        this.initialize();
    }

    public BinaryOperatorCondition(Condition condition, String string, Condition condition2) {
        this.m_Operator = BinaryOperatorCondition.validateEnum(string, ALL_OPERATORS);
        BinaryOperatorCondition.validateValue(condition);
        BinaryOperatorCondition.validateValue(condition2);
        this.m_Arguments = new Condition[]{condition, condition2};
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBinaryOperatorCondition(this, object);
    }

    @Override
    public String getOperator() {
        return this.m_Operator;
    }

    public Condition[] getArguments() {
        return (Condition[])this.getArgumentsInternal().clone();
    }
}

