/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi;

public class XMLWriter {
    private StringBuffer m_StringBuffer = null;
    private int m_IndentLevel = 0;

    private void append(String string) {
        this.getStringBuffer().append(string);
    }

    private void append(char c) {
        this.getStringBuffer().append(c);
    }

    public void appendAttribute(String string, String string2) {
        if (null == string2) {
            return;
        }
        this.newLine();
        this.append(string);
        this.append("=");
        this.quote(string2);
    }

    public void beginElement(String string) {
        this.newLine();
        this.openTag();
        this.append(string);
        this.incrementIndentLevel();
    }

    public void closeTag() {
        this.append(">");
    }

    private void decrementIndentLevel() {
        --this.m_IndentLevel;
    }

    public void endElement() {
        this.slash();
        this.closeTag();
        this.decrementIndentLevel();
    }

    public void endElement(String string) {
        this.decrementIndentLevel();
        this.newLine();
        this.openTag();
        this.slash();
        this.append(string);
        this.closeTag();
    }

    private int getIndentLevel() {
        return this.m_IndentLevel;
    }

    public StringBuffer getStringBuffer() {
        return this.m_StringBuffer;
    }

    private void incrementIndentLevel() {
        ++this.m_IndentLevel;
    }

    public void newLine() {
        this.append("\n");
    }

    private void openTag() {
        this.append('<');
    }

    public void quote(String string) {
        this.append('\"');
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.append("&lt;");
                    continue block7;
                }
                case '>': {
                    this.append("&gt;");
                    continue block7;
                }
                case '&': {
                    this.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    this.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    this.append("&apos;");
                    continue block7;
                }
                default: {
                    this.append(c);
                    continue block7;
                }
            }
        }
        this.append('\"');
    }

    public void setStringBuffer(StringBuffer stringBuffer) {
        this.m_StringBuffer = stringBuffer;
        this.m_StringBuffer.ensureCapacity(3000 + this.m_StringBuffer.length());
    }

    private void slash() {
        this.append('/');
    }
}

