/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.themes;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.VolatileImage;
import oracle.javatools.ui.themes.Painter;

final class VolatileImageCachingPainter
implements Painter {
    private final Painter _delegate;
    private VolatileImage _cachedImage;

    public VolatileImageCachingPainter(Painter delegate) {
        this._delegate = delegate;
    }

    @Override
    public void paint(Graphics g, int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        do {
            GraphicsConfiguration gc = ((Graphics2D)g).getDeviceConfiguration();
            Rectangle oldBounds = null;
            if (this._cachedImage == null) {
                this.renderOffscreen(gc, true, w, h, w, h);
            } else {
                boolean needNewImage;
                int imageWidth = this._cachedImage.getWidth();
                int imageHeight = this._cachedImage.getHeight();
                if (imageWidth != w || imageHeight != h) {
                    if (imageWidth < w || imageHeight < h) {
                        this.renderOffscreen(gc, true, Math.max(w, imageWidth), Math.max(h, imageHeight), w, h);
                    } else {
                        needNewImage = this._cachedImage.validate(gc) == 2;
                        this.renderOffscreen(gc, needNewImage, imageWidth, imageHeight, w, h);
                    }
                    oldBounds = g.getClipBounds();
                    g.clipRect(x, y, w, h);
                } else {
                    needNewImage = this._cachedImage.validate(gc) == 2;
                    this.renderOffscreen(gc, needNewImage, w, h, w, h);
                }
            }
            g.drawImage(this._cachedImage, x, y, null);
            if (oldBounds == null) continue;
            g.setClip(oldBounds);
        } while (this._cachedImage.contentsLost());
    }

    private void renderOffscreen(GraphicsConfiguration gc, boolean create, int imageWidth, int imageHeight, int paintWidth, int paintHeight) {
        if (create) {
            if (this._cachedImage != null) {
                this._cachedImage.flush();
                this._cachedImage = null;
            }
            this._cachedImage = gc.createCompatibleVolatileImage(imageWidth, imageHeight, 3);
        }
        Graphics2D g = this._cachedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, paintWidth, paintHeight);
        this._delegate.paint(g, 0, 0, paintWidth, paintHeight);
        g.dispose();
    }
}

