/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.javatools.ui.overview.OverviewComponent;
import oracle.javatools.ui.overview.OverviewHoverable;
import oracle.javatools.ui.overview.OverviewListener;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewStatus;
import oracle.javatools.ui.overview.OverviewTipProvider;

public class Overview<T extends Number, M extends OverviewMark<T>> {
    private final JComponent gui;
    private final OverviewComponent<T, M> overviewComponent;
    private Set<OverviewListener<M>> listeners = new CopyOnWriteArraySet<OverviewListener<M>>();
    private OverviewStatus status;
    private final Orientation orientation;
    private Map<Float, Set<M>> priorityToMarks = new HashMap<Float, Set<M>>();
    private Map<Object, Set<M>> groupsOfMarks = new HashMap<Object, Set<M>>();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private T start;
    private T end;
    private final OverviewHoverable overviewHoverable;
    public static final String PROPERTY_END = "overviewEND";
    public static final String PROPERTY_START = "overviewSTART";
    public static final String PROPERTY_STATUS = "overviewStatus";

    OverviewComponent<T, M> getOverviewComponent() {
        return this.overviewComponent;
    }

    public Overview(T start, T end) {
        this(Orientation.VERTICAL, start, end);
    }

    public Overview(Orientation orientation, T start, T end) {
        this.gui = new JPanel(new BorderLayout(0, 0));
        this.gui.setBackground(OverviewComponent.DEFAULT_COLOR);
        this.gui.setOpaque(true);
        this.orientation = orientation;
        this.start = start;
        this.end = end;
        this.overviewComponent = new OverviewComponent(this);
        this.gui.add(this.overviewComponent, "Center");
        this.overviewComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                    return;
                }
                Object mark = Overview.this.overviewComponent.markAtPoint(e.getPoint());
                if (mark == null) {
                    float location = Overview.this.overviewComponent.pointToRelativeLocation(e.getPoint());
                    for (OverviewListener l : Overview.this.listeners) {
                        l.overviewClicked(location);
                    }
                } else {
                    for (OverviewListener l : Overview.this.listeners) {
                        l.markClicked(mark);
                    }
                }
            }

            private void showPopup(MouseEvent me) {
                float location = Overview.this.overviewComponent.pointToRelativeLocation(me.getPoint());
                for (OverviewListener l : Overview.this.listeners) {
                    l.overviewPopup(location, me);
                }
            }
        });
        this.overviewHoverable = new OverviewHoverable<T, M>(this.overviewComponent);
    }

    public JComponent getGUI() {
        return this.gui;
    }

    public void setThin(boolean thin) {
        this.overviewComponent.setThin(thin);
    }

    public void rebuild() {
        this.overviewComponent.buildMarkRects();
    }

    public void addMark(M mark) {
        assert (mark != null) : "mark == null";
        Set<M> marks = this.priorityToMarks.get(Float.valueOf(mark.getPriority()));
        if (marks == null) {
            marks = new TreeSet<M>();
            this.priorityToMarks.put(Float.valueOf(mark.getPriority()), marks);
        }
        marks.add(mark);
        for (OverviewListener<M> l : this.listeners) {
            l.markAdded(mark);
        }
    }

    public void addMark(M mark, Object group) {
        this.addMark(mark);
        Set<M> markGroup = this.groupsOfMarks.get(group);
        if (markGroup == null) {
            markGroup = new HashSet<M>();
            this.groupsOfMarks.put(group, markGroup);
        }
        markGroup.add(mark);
    }

    public void removeMark(M mark) {
        for (Float f : this.priorityToMarks.keySet()) {
            Collection marks = this.priorityToMarks.get(f);
            boolean removed = marks.remove(mark);
            if (!removed || !marks.isEmpty()) continue;
            this.priorityToMarks.remove(f);
            break;
        }
        for (OverviewListener overviewListener : this.listeners) {
            overviewListener.markRemoved(mark);
        }
    }

    public Collection<M> removeMarks(Object group) {
        Set<M> marks = this.groupsOfMarks.get(group);
        if (marks == null) {
            return Collections.emptySet();
        }
        for (OverviewMark overviewMark : marks) {
            this.removeMark(overviewMark);
        }
        this.groupsOfMarks.remove(group);
        for (OverviewListener overviewListener : this.listeners) {
            for (OverviewMark mark : marks) {
                overviewListener.markRemoved(mark);
            }
        }
        return marks;
    }

    public T getStart() {
        return this.start;
    }

    public void setStart(T start) {
        T oldStart = this.start;
        this.start = start;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_START, oldStart, start);
    }

    public T getEnd() {
        return this.end;
    }

    public void setEnd(T end) {
        T oldEnd = this.end;
        this.end = end;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_END, oldEnd, end);
    }

    Collection<M> getMarks(Float priority) {
        assert (priority != null);
        Set<M> marks = this.priorityToMarks.get(priority);
        if (marks == null) {
            return Collections.emptySet();
        }
        return new ArrayList<M>(marks);
    }

    List<Float> getPriorities() {
        ArrayList<Float> priorities = new ArrayList<Float>(this.priorityToMarks.keySet());
        Collections.sort(priorities);
        return priorities;
    }

    protected final Collection<M> getMarks() {
        ArrayList<M> marks = new ArrayList<M>();
        for (Set<M> markSet : this.priorityToMarks.values()) {
            marks.addAll(markSet);
        }
        return marks;
    }

    public void addOverviewListener(OverviewListener<M> listener) {
        this.listeners.add(listener);
    }

    public void removeOverviewListener(OverviewListener<M> listener) {
        this.listeners.remove(listener);
    }

    public void setStatus(OverviewStatus status) {
        OverviewStatus oldStatus = this.status;
        if (oldStatus != null) {
            this.gui.remove(oldStatus.getGUI());
        }
        this.status = status;
        if (status != null) {
            this.gui.add((Component)status.getGUI(), this.orientation == Orientation.VERTICAL ? "First" : "Before");
        }
        this.propertyChangeSupport.firePropertyChange(PROPERTY_STATUS, oldStatus, status);
        this.gui.revalidate();
        this.gui.repaint();
    }

    public OverviewStatus getStatus() {
        return this.status;
    }

    Orientation getOrientation() {
        return this.orientation;
    }

    public void setInfoTipProvider(OverviewTipProvider overviewInfoTipProvider) {
        this.overviewHoverable.setProvider(overviewInfoTipProvider);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

