/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.list;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import oracle.javatools.util.CollectionEvent;
import oracle.javatools.util.CollectionListener;
import oracle.javatools.util.ListenableCollection;

public final class ListChecker<T> {
    private JList list;
    private ListenableCollection<T> checkedItems;
    private Listener l = new Listener();

    public ListChecker(JList list, ListenableCollection<T> checkedItems) {
        this.list = list;
        this.checkedItems = checkedItems;
        checkedItems.addListener((CollectionListener)this.l);
        list.addMouseListener(this.l);
        list.addKeyListener(this.l);
    }

    private class Listener
    extends MouseAdapter
    implements KeyListener,
    CollectionListener {
        private Listener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            int i = ListChecker.this.list.locationToIndex(me.getPoint());
            if (ListChecker.this.list.getCellBounds(i, i).contains(me.getPoint())) {
                Object o = ListChecker.this.list.getModel().getElementAt(i);
                if (ListChecker.this.checkedItems.contains(o)) {
                    ListChecker.this.checkedItems.remove(o);
                } else {
                    ListChecker.this.checkedItems.add(o);
                }
                ListChecker.this.list.repaint();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32) {
                for (Object o : ListChecker.this.list.getSelectedValues()) {
                    if (ListChecker.this.checkedItems.contains(o)) {
                        ListChecker.this.checkedItems.remove(o);
                        continue;
                    }
                    ListChecker.this.checkedItems.add(o);
                }
                ListChecker.this.list.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        public void collectionChanged(CollectionEvent event) {
            ListChecker.this.list.repaint();
        }
    }
}

