/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class ImageUtils {
    public static void dumpImage(RenderedImage image, String pathAndFilename, boolean appendTimestamp) {
        if (appendTimestamp) {
            pathAndFilename = pathAndFilename + "-" + System.currentTimeMillis();
        }
        pathAndFilename = pathAndFilename + ".png";
        try {
            ImageIO.write(image, "png", new File(pathAndFilename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void dumpComponent(JComponent c, String pathAndFilename, boolean appendTimestamp) {
        BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
        Graphics2D g = image.createGraphics();
        c.paint(g);
        g.dispose();
        ImageUtils.dumpImage(image, pathAndFilename, appendTimestamp);
    }
}

