/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import com.sun.java.swing.plaf.motif.MotifButtonUI;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.olaf2.OracleButtonUI;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.PropertyChangeAdapter;
import oracle.javatools.ui.plaf.IconicButtonUI;
import sun.swing.SwingUtilities2;

public class HyperlinkButton
extends AbstractButton
implements Accessible {
    private boolean m_mouseInside = false;
    private boolean m_alwaysUnderline = false;
    private PropertyChangeListener _listener;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static final ComponentUI s_windowsUI = new WindowsHyperlinkButtonUI();
    private static final ComponentUI s_metalUI = new MetalHyperlinkButtonUI();
    private static final ComponentUI s_motifUI = new MotifHyperlinkButtonUI();
    private static final ComponentUI s_oracleUI = new OracleHyperlinkButtonUI();
    private static final ButtonUI s_themedUI = new IconicButtonUI();
    private Color foregroundOnHover;

    public HyperlinkButton(String text) {
        this();
        this.setText(text);
    }

    public HyperlinkButton() {
        this.setModel(new DefaultButtonModel());
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseMotionListener());
        this.setForeground(Colors.HYPERLINK);
        this.setForegroundOnHover(Colors.HYPERLINK_HOVER);
        this.updateUI();
        this.setOpaque(false);
    }

    public HyperlinkButton(Action a) {
        this();
        String shortDesc = (String)a.getValue("ShortDescription");
        if (shortDesc != null) {
            this.setText(shortDesc);
        } else {
            this.setText((String)a.getValue("Name"));
        }
        this.setIcon((Icon)a.getValue("SmallIcon"));
        this.setEnabled(a.isEnabled());
        this._listener = new PropertyChangeAdapter(this, a);
        a.addPropertyChangeListener(this._listener);
        this.addActionListener(a);
    }

    @Override
    public void setAction(Action a) {
        if (this._listener != null && this.getAction() != null) {
            this.getAction().removePropertyChangeListener(this._listener);
        }
        if (a != null) {
            this._listener = new PropertyChangeAdapter(this, a);
            a.addPropertyChangeListener(this._listener);
        }
        super.setAction(a);
    }

    @Override
    public void updateUI() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof WindowsLookAndFeel) {
            this.setUI(s_windowsUI);
        } else if (laf instanceof MetalLookAndFeel) {
            this.setUI(s_metalUI);
        } else if (laf instanceof MotifLookAndFeel) {
            this.setUI(s_motifUI);
        } else if (laf instanceof OracleLookAndFeel) {
            this.setUI(s_oracleUI);
        } else {
            this.setUI(s_metalUI);
        }
    }

    @Override
    public void setUI(ButtonUI ui) {
        if (ui instanceof IconicButtonUI) {
            ui = s_themedUI;
        }
        super.setUI(ui);
    }

    @Override
    public String getUIClassID() {
        return "HyperlinkButtonUI";
    }

    public Color getForegroundOnHover() {
        return this.foregroundOnHover;
    }

    public void setForegroundOnHover(Color foregroundOnHover) {
        this.foregroundOnHover = foregroundOnHover;
    }

    public void setAlwaysUnderlined(boolean alwaysUnderline) {
        this.m_alwaysUnderline = alwaysUnderline;
        this.repaint();
    }

    public boolean isAlwaysUnderlined() {
        return this.m_alwaysUnderline;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleHyperlinkButton();
        }
        return this.accessibleContext;
    }

    private static void doPaint(Graphics g, JComponent jcomp, FocusPainter fp) {
        HyperlinkButton comp = (HyperlinkButton)jcomp;
        Icon icon = comp.isEnabled() ? comp.getIcon() : comp.getDisabledIcon();
        Color saveColor = g.getColor();
        Font saveFont = g.getFont();
        g.setColor(comp.getForeground());
        g.setFont(comp.getFont());
        FontMetrics metrics = g.getFontMetrics(comp.getFont());
        HyperlinkButton.paintViewR.x = 1;
        HyperlinkButton.paintViewR.y = 0;
        HyperlinkButton.paintViewR.width = comp.getWidth();
        HyperlinkButton.paintViewR.height = comp.getHeight();
        HyperlinkButton.paintIconR.height = 0;
        HyperlinkButton.paintIconR.width = 0;
        HyperlinkButton.paintIconR.y = 0;
        HyperlinkButton.paintIconR.x = 0;
        HyperlinkButton.paintTextR.height = 0;
        HyperlinkButton.paintTextR.width = 0;
        HyperlinkButton.paintTextR.y = 0;
        HyperlinkButton.paintTextR.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(comp, metrics, comp.getText(), comp.getIcon(), 0, 2, 0, 4, paintViewR, paintIconR, paintTextR, 4);
        if (icon != null) {
            icon.paintIcon(comp, g, HyperlinkButton.paintIconR.x, HyperlinkButton.paintIconR.y);
        }
        int textX = HyperlinkButton.paintTextR.x;
        int textY = HyperlinkButton.paintTextR.y + metrics.getAscent();
        int mnemIndex = comp.getDisplayedMnemonicIndex();
        if (!comp.isEnabled()) {
            Color background = comp.getBackground();
            g.setColor(background.brighter());
            GraphicUtils.drawString((Graphics)g, (String)clippedText, (int)(textX + 1), (int)(textY + 1));
            SwingUtilities2.drawStringUnderlineCharAt(comp, g, clippedText, mnemIndex, textX + 1, textY + 1);
            g.setColor(background.darker());
            GraphicUtils.drawString((Graphics)g, (String)clippedText, (int)textX, (int)textY);
            SwingUtilities2.drawStringUnderlineCharAt(comp, g, clippedText, mnemIndex, textX, textY);
        } else {
            g.setColor(comp.m_mouseInside && comp.isEnabled() ? comp.getForegroundOnHover() : comp.getForeground());
            GraphicUtils.drawString((Graphics)g, (String)clippedText, (int)textX, (int)textY);
            SwingUtilities2.drawStringUnderlineCharAt(comp, g, clippedText, mnemIndex, textX, textY);
        }
        if (comp.isAlwaysUnderlined() || comp.m_mouseInside && comp.isEnabled()) {
            int width = metrics.stringWidth(clippedText);
            int linePos = textY + 1;
            g.drawLine(textX, linePos, textX + width - 1, linePos);
        }
        if (comp.isFocusPainted() && comp.hasFocus()) {
            fp.doPaintFocus(g, comp, paintViewR, paintTextR, paintIconR);
        }
        g.setColor(saveColor);
        g.setFont(saveFont);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        PointerInfo info = MouseInfo.getPointerInfo();
        if (info != null) {
            GraphicsDevice gd = info.getDevice();
            Point location = info.getLocation();
            if (location != null && gd != null && this.getGraphicsConfiguration() != null && gd.equals(this.getGraphicsConfiguration().getDevice())) {
                SwingUtilities.convertPointFromScreen(location, this);
                this.m_mouseInside = location.x >= 0 && location.x <= width && location.y >= 0 && location.y <= height;
            }
        }
    }

    private class MouseMotionListener
    extends MouseAdapter {
        @Override
        public void mouseEntered(MouseEvent e) {
            HyperlinkButton.this.m_mouseInside = true;
            HyperlinkButton.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            HyperlinkButton.this.m_mouseInside = false;
            HyperlinkButton.this.repaint();
        }

        MouseMotionListener() {
        }
    }

    protected class AccessibleHyperlinkButton
    extends AbstractButton.AccessibleAbstractButton {
        protected AccessibleHyperlinkButton() {
            super(HyperlinkButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }

    private static interface FocusPainter {
        public void doPaintFocus(Graphics var1, AbstractButton var2, Rectangle var3, Rectangle var4, Rectangle var5);
    }

    private static class WindowsHyperlinkButtonUI
    extends WindowsButtonUI
    implements FocusPainter {
        public void paint(Graphics g, JComponent comp) {
            HyperlinkButton.doPaint(g, comp, this);
        }

        @Override
        public void doPaintFocus(Graphics g, AbstractButton but, Rectangle view, Rectangle text, Rectangle icon) {
            this.dashedRectGapX = 0;
            this.dashedRectGapWidth = 0;
            this.paintFocus(g, but, view, text, icon);
        }

        public static ComponentUI createUI(JComponent c) {
            return s_windowsUI;
        }

        WindowsHyperlinkButtonUI() {
        }
    }

    private static class MetalHyperlinkButtonUI
    extends MetalButtonUI
    implements FocusPainter {
        @Override
        public void paint(Graphics g, JComponent comp) {
            HyperlinkButton.doPaint(g, comp, this);
        }

        @Override
        public void doPaintFocus(Graphics g, AbstractButton but, Rectangle view, Rectangle text, Rectangle icon) {
            this.paintFocus(g, but, view, text, icon);
        }

        public static ComponentUI createUI(JComponent c) {
            return s_metalUI;
        }

        MetalHyperlinkButtonUI() {
        }
    }

    private static class MotifHyperlinkButtonUI
    extends MotifButtonUI
    implements FocusPainter {
        @Override
        public void paint(Graphics g, JComponent comp) {
            HyperlinkButton.doPaint(g, comp, this);
        }

        @Override
        public void doPaintFocus(Graphics g, AbstractButton but, Rectangle view, Rectangle text, Rectangle icon) {
            this.paintFocus(g, but, view, text, icon);
        }

        public static ComponentUI createUI(JComponent c) {
            return s_motifUI;
        }

        MotifHyperlinkButtonUI() {
        }
    }

    private static class ThemedHyperlinkButtonUI
    extends IconicButtonUI
    implements FocusPainter {
        @Override
        public void paint(Graphics g, JComponent comp) {
            HyperlinkButton.doPaint(g, comp, this);
        }

        @Override
        public void doPaintFocus(Graphics g, AbstractButton but, Rectangle view, Rectangle text, Rectangle icon) {
            this.paintFocus(g, but, view, text, icon);
        }

        public static ComponentUI createUI(JComponent c) {
            return s_oracleUI;
        }

        ThemedHyperlinkButtonUI() {
        }
    }

    private static class OracleHyperlinkButtonUI
    extends OracleButtonUI
    implements FocusPainter {
        public void paint(Graphics g, JComponent comp) {
            HyperlinkButton.doPaint(g, comp, this);
        }

        @Override
        public void doPaintFocus(Graphics g, AbstractButton but, Rectangle view, Rectangle text, Rectangle icon) {
            this.paintFocus(g, but, view, text, icon);
        }

        public static ComponentUI createUI(JComponent c) {
            return s_oracleUI;
        }

        OracleHyperlinkButtonUI() {
        }
    }
}

