/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderEvent;
import oracle.javatools.ui.HeaderListener;

public final class HeaderGroup {
    private final Header _header;
    private final List<Component> _components = new ArrayList<Component>();

    public HeaderGroup(Header header) {
        if (header == null) {
            throw new NullPointerException("header is null");
        }
        this._header = header;
        this._header.addHeaderListener(new HeaderListener(){

            @Override
            public void headerExpanded(HeaderEvent event) {
                HeaderGroup.this.setComponentsVisible(true);
            }

            @Override
            public void headerCollapsed(HeaderEvent event) {
                HeaderGroup.this.setComponentsVisible(false);
            }
        });
    }

    public void add(Component c) {
        c.setVisible(!this._header.isExpandable() || this._header.isExpanded());
        this._components.add(c);
    }

    private void setComponentsVisible(boolean visible) {
        for (Component c : this._components) {
            c.setVisible(visible);
            c.invalidate();
            c.validate();
        }
    }
}

