/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.lang.reflect.Array;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;

class ArrayPropertyEditorFactory
extends AbstractPropertyEditorFactory {
    private int _index;

    public ArrayPropertyEditorFactory(Object target, int index) {
        super(target);
        this._index = index;
    }

    public int getIndex() {
        return this._index;
    }

    public String getDisplayName() {
        return Integer.toString(this.getIndex());
    }

    public boolean setValue(Object newValue) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        boolean changed = this.getCachedValue() != newValue;
        Array.set(this.getTarget(), this.getIndex(), newValue);
        this.setCachedValue(newValue);
        this.setCachedDisplayValue(INVALID_PROPERTY);
        return changed;
    }

    public Object getValue(Object target) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        Object value = this.getCachedValue();
        if (value == INVALID_PROPERTY) {
            value = Array.get(target, this.getIndex());
            this.setCachedValue(value);
        }
        return value;
    }

    public boolean isReadable() {
        boolean readable = true;
        try {
            Array.get(this.getTarget(), this.getIndex());
        }
        catch (Exception e) {
            readable = false;
        }
        return readable;
    }

    public boolean isWritable() {
        return false;
    }

    public Class getType() {
        return this.getTarget().getClass().getComponentType();
    }

    protected Object createPropertyID() {
        return new Object();
    }
}

