/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ssh.core.Descriptor;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.util.Logger;
import oracle.javatools.data.HashStructure;

public final class TunnelDescriptor
extends Descriptor {
    public static final int AUTO_ASSIGN_LOCAL_PORT = -1;
    private final String mHost;
    private final int mHostPort;
    private final int mPort;
    private final Type type;
    private HostDescriptor host;

    static TunnelDescriptor createTunnelDescriptor(HashStructure hashStructure) {
        TunnelDescriptor tunnelDescriptor = null;
        String string = hashStructure.getString("name");
        if (ModelUtil.hasLength((String)string)) {
            try {
                Type type = Type.valueOf(hashStructure.getString("type"));
                Builder builder = new Builder(string, type);
                builder.host(hashStructure.getString("hostname"));
                builder.hostPort(hashStructure.getInt("hostport"));
                int n = hashStructure.getInt("port", -1);
                if (n > 0) {
                    builder.port(n);
                }
                tunnelDescriptor = builder.getDescriptor();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger.severe(TunnelDescriptor.class, (Throwable)illegalArgumentException);
            }
        }
        return tunnelDescriptor;
    }

    private TunnelDescriptor(String string, Type type, String string2, int n, int n2) {
        super(string);
        this.mHost = string2;
        this.mHostPort = n;
        this.mPort = n2;
        this.type = type;
    }

    public String getHostname() {
        return this.mHost;
    }

    public int getHostport() {
        return this.mHostPort;
    }

    public int getPort() {
        return this.mPort;
    }

    void setHost(HostDescriptor hostDescriptor) {
        this.host = hostDescriptor;
    }

    public HostDescriptor getHost() {
        return this.host;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TunnelDescriptor) {
            TunnelDescriptor tunnelDescriptor = (TunnelDescriptor)object;
            return this.equalsImpl(tunnelDescriptor);
        }
        return false;
    }

    protected boolean equalsImpl(TunnelDescriptor tunnelDescriptor) {
        return super.equalsImpl(tunnelDescriptor) && this.type == tunnelDescriptor.type && ModelUtil.areEqual((Object)this.mHost, (Object)tunnelDescriptor.mHost) && this.mHostPort == tunnelDescriptor.mHostPort && this.mPort == tunnelDescriptor.mPort;
    }

    public String toString() {
        return this.getName() + (this.mPort > 0 ? this.mPort + ":" : "") + this.mHost + ":" + this.mHostPort;
    }

    @Override
    HashStructure toHashStructure() {
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructure.putString("name", this.getName());
        hashStructure.putString("type", this.type.name());
        hashStructure.putString("hostname", this.mHost);
        hashStructure.putInt("hostport", this.mHostPort);
        if (this.mPort > 0) {
            hashStructure.putInt("port", this.mPort);
        }
        return hashStructure;
    }

    public static final class Builder {
        private final String name;
        private final Type type;
        private String mHostname = "localhost";
        private int mHostPort;
        private int mPort = -1;

        public Builder(String string, Type type) {
            this.name = string;
            this.type = type;
        }

        public Builder port(int n) {
            this.mPort = n;
            return this;
        }

        public Builder host(String string) {
            this.mHostname = string;
            return this;
        }

        public Builder hostPort(int n) {
            this.mHostPort = n;
            return this;
        }

        public TunnelDescriptor getDescriptor() {
            TunnelDescriptor tunnelDescriptor = new TunnelDescriptor(this.name, this.type, this.mHostname, this.mHostPort, this.mPort);
            return tunnelDescriptor;
        }
    }

    public static enum Type {
        LOCAL,
        REMOTE;

    }
}

