/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.util.EventObject;
import oracle.dbtools.raptor.ssh.core.Descriptor;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.Store;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;

public final class StoreEvent
extends EventObject {
    private final HostDescriptor host;
    private final TunnelDescriptor tunnel;
    private final Descriptor oldDesc;
    private final EventType type;

    public static StoreEvent createHostAddedEvent(Store store, HostDescriptor hostDescriptor) {
        return new StoreEvent(store, EventType.HOST_ADDED, hostDescriptor, null, null);
    }

    public static StoreEvent createHostRemovedEvent(Store store, HostDescriptor hostDescriptor) {
        return new StoreEvent(store, EventType.HOST_REMOVED, hostDescriptor, null, null);
    }

    public static StoreEvent createHostChangedEvent(Store store, HostDescriptor hostDescriptor, HostDescriptor hostDescriptor2) {
        return new StoreEvent(store, EventType.HOST_CHANGED, hostDescriptor, null, hostDescriptor2);
    }

    public static StoreEvent createTunnelAddedEvent(Store store, HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor) {
        return new StoreEvent(store, EventType.TUNNEL_ADDED, hostDescriptor, tunnelDescriptor, null);
    }

    public static StoreEvent createTunnelRemovedEvent(Store store, HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor) {
        return new StoreEvent(store, EventType.TUNNEL_REMOVED, hostDescriptor, tunnelDescriptor, null);
    }

    public static StoreEvent createTunnelChangedEvent(Store store, HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor, TunnelDescriptor tunnelDescriptor2) {
        return new StoreEvent(store, EventType.TUNNEL_CHANGED, hostDescriptor, tunnelDescriptor, tunnelDescriptor2);
    }

    private StoreEvent(Store store, EventType eventType, HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor, Descriptor descriptor) {
        super((Object)store);
        this.host = hostDescriptor;
        this.tunnel = tunnelDescriptor;
        this.type = eventType;
        this.oldDesc = descriptor;
    }

    public HostDescriptor getHostDescriptor() {
        return this.host;
    }

    public TunnelDescriptor getTunnelDescriptor() {
        return this.tunnel;
    }

    public Descriptor getOldDescriptor() {
        return this.oldDesc;
    }

    public EventType getType() {
        return this.type;
    }

    public static enum EventType {
        HOST_ADDED,
        HOST_REMOVED,
        HOST_CHANGED,
        TUNNEL_ADDED,
        TUNNEL_REMOVED,
        TUNNEL_CHANGED;

    }
}

