/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.StoreEvent;
import oracle.dbtools.raptor.ssh.core.StoreListener;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.util.Logger;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public final class Store
extends HashStructureAdapter {
    private static final String TUNNELS_KEY = "tunnels";
    private static final String HOSTS_KEY = "hosts";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_SSH_PORT = 22;
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"sqldeveloper-ssh");
    private static final String ROOT_NAME = "ssh-hosts";
    private final URL mStoreURL;
    private List<StoreListener> listeners = new CopyOnWriteArrayList<StoreListener>();

    static Store createStore(URL uRL) {
        HashStructure hashStructure = HashStructure.newInstance();
        Store store = new Store(hashStructure, uRL);
        try {
            store.load();
        }
        catch (IOException iOException) {
            Logger.severe(Store.class, (Throwable)iOException);
        }
        return store;
    }

    private static HashStructureIO getIO() {
        return new HashStructureIO(NAMESPACE_URI, ROOT_NAME);
    }

    private Store(HashStructure hashStructure, URL uRL) {
        super(hashStructure);
        this.mStoreURL = uRL;
    }

    void load() throws IOException {
        if (URLFileSystem.exists((URL)this.mStoreURL)) {
            HashStructureIO hashStructureIO = Store.getIO();
            hashStructureIO.open(this.mStoreURL, (Object)this.getHashStructure());
        }
    }

    void save() throws IOException {
        HashStructure hashStructure = this.getHashStructure();
        if (hashStructure.isDirty()) {
            HashStructureIO hashStructureIO = Store.getIO();
            hashStructureIO.save(this.mStoreURL, (Object)hashStructure);
            hashStructure.markDirty(false);
        }
    }

    private void doSave() {
        try {
            this.save();
        }
        catch (IOException iOException) {
            Logger.severe(Store.class, (Throwable)iOException);
        }
    }

    private HashStructure getHosts(boolean bl) {
        HashStructure hashStructure = this.getHashStructure();
        HashStructure hashStructure2 = hashStructure.getHashStructure(HOSTS_KEY);
        if (bl && hashStructure2 == null) {
            hashStructure2 = HashStructure.newInstance();
            hashStructure.putHashStructure(HOSTS_KEY, hashStructure2);
        }
        return hashStructure2;
    }

    private HashStructure getTunnels(String string, boolean bl) {
        HashStructure hashStructure;
        HashStructure hashStructure2 = null;
        HashStructure hashStructure3 = this.getHosts(false);
        if (hashStructure3 != null && (hashStructure = hashStructure3.getHashStructure(string)) != null && (hashStructure2 = hashStructure.getHashStructure(TUNNELS_KEY)) == null && bl) {
            hashStructure2 = HashStructure.newInstance();
            hashStructure.putHashStructure(TUNNELS_KEY, hashStructure2);
        }
        return hashStructure2;
    }

    public void addStoreListener(StoreListener storeListener) {
        this.listeners.add(storeListener);
    }

    public void removeStoreListener(StoreListener storeListener) {
        this.listeners.remove(storeListener);
    }

    public Collection<String> listHosts() {
        HashStructure hashStructure = this.getHosts(false);
        Set set = hashStructure != null ? hashStructure.keySet() : Collections.emptySet();
        return set;
    }

    public HostDescriptor getHostDescriptor(String string) {
        HashStructure hashStructure;
        HostDescriptor hostDescriptor = null;
        HashStructure hashStructure2 = this.getHosts(false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
            hostDescriptor = HostDescriptor.createHostDescriptor(hashStructure);
        }
        return hostDescriptor;
    }

    public Collection<String> listTunnels(String string) {
        HashStructure hashStructure = this.getTunnels(string, false);
        Set set = hashStructure != null ? hashStructure.keySet() : Collections.emptySet();
        return set;
    }

    public TunnelDescriptor getTunnelDescriptor(String string, String string2) {
        HashStructure hashStructure;
        TunnelDescriptor tunnelDescriptor = null;
        HashStructure hashStructure2 = this.getTunnels(string, false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string2)) != null) {
            tunnelDescriptor = TunnelDescriptor.createTunnelDescriptor(hashStructure);
            HostDescriptor hostDescriptor = this.getHostDescriptor(string);
            tunnelDescriptor.setHost(hostDescriptor);
        }
        return tunnelDescriptor;
    }

    public void addHost(HostDescriptor hostDescriptor) {
        HashStructure hashStructure = this.getHosts(true);
        hashStructure.putHashStructure(hostDescriptor.getName(), hostDescriptor.toHashStructure());
        this.doSave();
        this.fireHostAddedEvent(hostDescriptor);
    }

    public void removeHost(String string) {
        HashStructure hashStructure;
        HashStructure hashStructure2 = this.getHosts(false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
            HostDescriptor hostDescriptor = HostDescriptor.createHostDescriptor(hashStructure);
            hashStructure2.remove(string);
            this.doSave();
            this.fireHostRemovedEvent(hostDescriptor);
        }
    }

    public void updateHost(HostDescriptor hostDescriptor, HostDescriptor hostDescriptor2) {
        HashStructure hashStructure = this.getHosts(false);
        if (hashStructure != null && ModelUtil.areDifferent((Object)hostDescriptor, (Object)hostDescriptor2)) {
            String string = hostDescriptor.getName();
            String string2 = hostDescriptor2.getName();
            HashStructure hashStructure2 = null;
            HashStructure hashStructure3 = hashStructure.getHashStructure(string);
            if (hashStructure3 != null) {
                hashStructure2 = hashStructure3.getHashStructure(TUNNELS_KEY);
                hashStructure.remove(string);
            }
            HashStructure hashStructure4 = hostDescriptor2.toHashStructure();
            if (hashStructure2 != null) {
                hashStructure4.putHashStructure(TUNNELS_KEY, hashStructure2);
            }
            hashStructure.putHashStructure(string2, hashStructure4);
            this.doSave();
            this.fireHostChangedEvent(hostDescriptor2, hostDescriptor);
        }
    }

    public void addTunnel(HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor) {
        tunnelDescriptor.setHost(hostDescriptor);
        HashStructure hashStructure = this.getTunnels(hostDescriptor.getName(), true);
        if (hashStructure != null) {
            hashStructure.putHashStructure(tunnelDescriptor.getName(), tunnelDescriptor.toHashStructure());
            this.doSave();
            this.fireTunnelAddedEvent(hostDescriptor, tunnelDescriptor);
        }
    }

    public void removeTunnel(HostDescriptor hostDescriptor, String string) {
        HashStructure hashStructure;
        HashStructure hashStructure2 = this.getTunnels(hostDescriptor.getName(), false);
        if (hashStructure2 != null && (hashStructure = hashStructure2.getHashStructure(string)) != null) {
            TunnelDescriptor tunnelDescriptor = TunnelDescriptor.createTunnelDescriptor(hashStructure);
            tunnelDescriptor.setHost(hostDescriptor);
            hashStructure2.remove(string);
            this.doSave();
            this.fireTunnelRemovedEvent(hostDescriptor, tunnelDescriptor);
        }
    }

    public void updateTunnel(HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor, TunnelDescriptor tunnelDescriptor2) {
        HashStructure hashStructure = this.getTunnels(hostDescriptor.getName(), false);
        if (hashStructure != null) {
            String string = tunnelDescriptor2.getName();
            String string2 = tunnelDescriptor.getName();
            if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
                hashStructure.remove(string2);
            }
            hashStructure.putHashStructure(string, tunnelDescriptor2.toHashStructure());
            tunnelDescriptor2.setHost(hostDescriptor);
            this.doSave();
            this.fireTunnelChangedEvent(hostDescriptor, tunnelDescriptor2, tunnelDescriptor);
        }
    }

    private void fireHostAddedEvent(HostDescriptor hostDescriptor) {
        StoreEvent storeEvent = null;
        for (StoreListener storeListener : this.listeners) {
            if (storeEvent == null) {
                storeEvent = StoreEvent.createHostAddedEvent(this, hostDescriptor);
            }
            storeListener.hostAdded(storeEvent);
        }
    }

    private void fireHostRemovedEvent(HostDescriptor hostDescriptor) {
        StoreEvent storeEvent = null;
        for (StoreListener storeListener : this.listeners) {
            if (storeEvent == null) {
                storeEvent = StoreEvent.createHostRemovedEvent(this, hostDescriptor);
            }
            storeListener.hostRemoved(storeEvent);
        }
    }

    private void fireHostChangedEvent(HostDescriptor hostDescriptor, HostDescriptor hostDescriptor2) {
        StoreEvent storeEvent = null;
        for (StoreListener storeListener : this.listeners) {
            if (storeEvent == null) {
                storeEvent = StoreEvent.createHostChangedEvent(this, hostDescriptor, hostDescriptor2);
            }
            storeListener.hostChanged(storeEvent);
        }
    }

    private void fireTunnelAddedEvent(HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor) {
        StoreEvent storeEvent = null;
        for (StoreListener storeListener : this.listeners) {
            if (storeEvent == null) {
                storeEvent = StoreEvent.createTunnelAddedEvent(this, hostDescriptor, tunnelDescriptor);
            }
            storeListener.tunnelAdded(storeEvent);
        }
    }

    private void fireTunnelRemovedEvent(HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor) {
        StoreEvent storeEvent = null;
        for (StoreListener storeListener : this.listeners) {
            if (storeEvent == null) {
                storeEvent = StoreEvent.createTunnelRemovedEvent(this, hostDescriptor, tunnelDescriptor);
            }
            storeListener.tunnelRemoved(storeEvent);
        }
    }

    private void fireTunnelChangedEvent(HostDescriptor hostDescriptor, TunnelDescriptor tunnelDescriptor, TunnelDescriptor tunnelDescriptor2) {
        StoreEvent storeEvent = null;
        for (StoreListener storeListener : this.listeners) {
            if (storeEvent == null) {
                storeEvent = StoreEvent.createTunnelChangedEvent(this, hostDescriptor, tunnelDescriptor, tunnelDescriptor2);
            }
            storeListener.tunnelChanged(storeEvent);
        }
    }
}

