/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.net.URL;
import java.util.Properties;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.ssh.core.Descriptor;
import oracle.javatools.data.HashStructure;

public final class HostDescriptor
extends Descriptor {
    private static final String KEYFILE_KEY = "keyfile";
    private final String hostname;
    private final int port;
    private final String username;
    private final URL keyfile;
    private Properties props;

    static HostDescriptor createHostDescriptor(HashStructure hashStructure) {
        HashStructure hashStructure2;
        URL uRL;
        Object object;
        String string = hashStructure.getString("name");
        String string2 = hashStructure.getString("hostname");
        String string3 = hashStructure.getString("user");
        int n = hashStructure.getInt("port", -1);
        if (!ModelUtil.hasLength((String)string)) {
            if (!ModelUtil.hasLength((String)string2) || !ModelUtil.hasLength((String)string3)) {
                return null;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(string3).append('@');
            ((StringBuilder)object).append(string2);
            if (n > 0 && n != 22) {
                ((StringBuilder)object).append(':');
                ((StringBuilder)object).append(n);
            }
            string = ((StringBuilder)object).toString();
        }
        object = new Builder(string);
        if (string2 != null) {
            ((Builder)object).hostname(string2);
        }
        if (string3 != null) {
            ((Builder)object).username(string3);
        }
        if (n > 0) {
            ((Builder)object).port(n);
        }
        if ((uRL = hashStructure.getURL(KEYFILE_KEY)) != null) {
            ((Builder)object).keyfile(uRL);
        }
        if ((hashStructure2 = hashStructure.getHashStructure("properties")) != null) {
            for (String string4 : hashStructure2.keySet()) {
                ((Builder)object).setProperty(string4, hashStructure2.getString(string4));
            }
        }
        return ((Builder)object).getDescriptor();
    }

    private HostDescriptor(String string, String string2, int n, URL uRL, String string3) {
        super(string);
        this.hostname = string2;
        this.username = string3;
        this.port = n;
        this.keyfile = uRL;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof HostDescriptor) {
            HostDescriptor hostDescriptor = (HostDescriptor)object;
            return ModelUtil.areEqual((Object)this.getName(), (Object)hostDescriptor.getName()) && ModelUtil.areEqual((Object)this.keyfile, (Object)hostDescriptor.keyfile) && ModelUtil.areEqual((Object)this.props, (Object)hostDescriptor.props);
        }
        return false;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getProperty(String string) {
        return this.props != null ? this.props.getProperty(string) : null;
    }

    public String getUsername() {
        return this.username;
    }

    public URL getKeyfile() {
        return this.keyfile;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    private void setProperty(String string, String string2) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.put(string, string2);
    }

    @Override
    HashStructure toHashStructure() {
        HashStructure hashStructure = HashStructure.newInstance();
        hashStructure.putString("name", this.getName());
        hashStructure.putString("hostname", this.hostname);
        hashStructure.putString("user", this.username);
        if (this.port != 22) {
            hashStructure.putInt("port", this.port);
        }
        if (this.keyfile != null) {
            hashStructure.putURL(KEYFILE_KEY, this.keyfile);
        }
        if (this.props != null) {
            HashStructure hashStructure2 = HashStructure.newInstance();
            hashStructure.putHashStructure("properties", hashStructure2);
            for (String string : this.props.stringPropertyNames()) {
                hashStructure2.putString(string, this.props.getProperty(string));
            }
        }
        return hashStructure;
    }

    public static final class Builder {
        private String name;
        private String hostname;
        private String username;
        private int port = 22;
        private URL keyfile;
        private Properties props = new Properties();

        public Builder(String string) {
            this.name = string;
        }

        public Builder username(String string) {
            this.username = string;
            return this;
        }

        public Builder hostname(String string) {
            this.hostname = string;
            return this;
        }

        public Builder port(int n) {
            this.port = n;
            return this;
        }

        public Builder keyfile(URL uRL) {
            this.keyfile = uRL;
            return this;
        }

        public Builder setProperty(String string, String string2) {
            this.props.setProperty(string, string2);
            return this;
        }

        public HostDescriptor getDescriptor() {
            if (this.hostname == null) {
                throw new IllegalStateException("hostname must not be null");
            }
            if (this.username == null) {
                throw new IllegalStateException("username must not be null");
            }
            HostDescriptor hostDescriptor = new HostDescriptor(this.name, this.hostname, this.port, this.keyfile, this.username);
            if (this.props.size() > 0) {
                for (String string : this.props.stringPropertyNames()) {
                    hostDescriptor.setProperty(string, this.props.getProperty(string));
                }
            }
            return hostDescriptor;
        }
    }
}

