/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.util.ArrayList;
import oracle.dbtools.raptor.format.FormatterResources;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.javatools.util.PlatformUtils;

public class ReportAsianFonts {
    public static final String[] VENDOR_ASIAN_JAR_FILE = new String[]{"itext-asian.jar", "iTextAsian.jar"};
    public static final String VENDOR_CJK_PROPERTIES = "/com/itextpdf/text/pdf/fonts/cjkfonts.properties";
    public static final String BOLD = ",Bold";
    public static final String ITALIC = ",Italic";
    public static final String BOLDITALIC = ",BoldItalic";
    public static final String STSONG_LIGHT_FONT = "STSong-Light";
    public static final String STSONGSTD_LIGHT_FONT = "STSongStd-Light";
    public static final String MHEI_MEDIUM_FONT = "MHei-Medium";
    public static final String MSUNG_LIGHT_FONT = "MSung-Light";
    public static final String MSUNGSTD_LIGHT_FONT = "MSungStd-Light";
    public static final String HEISEIMIN_W3_FONT = "HeiseiMin-W3";
    public static final String HEISEIKAKUGO_W5_FONT = "HeiseiKakuGo-W5";
    public static final String KOZMINPRO_REGULAR_FONT = "KozMinPro-Regular";
    public static final String HYGOTHIC_MEDIUM_FONT = "HYGoThic-Medium";
    public static final String HYSMYEONGJOSTD_FONT = "HYSMyeongJoStd";
    public static final String HYSMYEONGJO_MEDIUM_FONT = "HYSMyeongJo-Medium";
    public static final String CHINESE_SIMPLIFIED_H_CMAP = "UniGB-UCS2-H";
    public static final String CHINESE_TRADITIONAL_H_CMAP = "UniCNS-UCS2-H";
    public static final String JAPANESE_H_CMAP = "UniJIS-UCS2-H";
    public static final String KOREAN_H_CMAP = "UniKS-UCS2-H";

    public static String[] getVendorAsianFonts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ASIAN_FONTS aSIAN_FONTS : ASIAN_FONTS.values()) {
            arrayList.add(aSIAN_FONTS.getNLSName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static boolean isVendorAsianFont(String string) {
        for (ASIAN_FONTS aSIAN_FONTS : ASIAN_FONTS.values()) {
            if (!aSIAN_FONTS.getFont().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVendorAsianJar(String string) {
        if (string != null) {
            for (int i = 0; i < VENDOR_ASIAN_JAR_FILE.length; ++i) {
                if (!string.contains(VENDOR_ASIAN_JAR_FILE[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String getAsianFontNLS(String string) {
        for (ASIAN_FONTS aSIAN_FONTS : ASIAN_FONTS.values()) {
            if (!aSIAN_FONTS.getFont().equals(string)) continue;
            return aSIAN_FONTS.getNLSName();
        }
        return null;
    }

    public static String getAsianFont(String string) {
        for (ASIAN_FONTS aSIAN_FONTS : ASIAN_FONTS.values()) {
            if (!aSIAN_FONTS.getNLSName().equals(string)) continue;
            return aSIAN_FONTS.getFont();
        }
        return null;
    }

    public static String getFontDirection(String string) {
        for (ASIAN_FONTS aSIAN_FONTS : ASIAN_FONTS.values()) {
            if (!aSIAN_FONTS.getFont().equals(string)) continue;
            return aSIAN_FONTS.getFontDirection();
        }
        return null;
    }

    public static String getAsianFontStyle(String string, ReportFormatOptions.FONT_STYLE fONT_STYLE) {
        String string2;
        ReportFormatOptions.FONT_STYLE fONT_STYLE2 = fONT_STYLE;
        switch (fONT_STYLE2) {
            case BOLD: {
                string2 = string.concat(BOLD);
                break;
            }
            case ITALIC: {
                string2 = string.concat(ITALIC);
                break;
            }
            case BOLDITALIC: {
                string2 = string.concat(BOLDITALIC);
                break;
            }
            default: {
                string2 = string;
            }
        }
        return string2;
    }

    public static String asianJarCopyMessage(String string) {
        String string2 = PlatformUtils.isWindows() ? FormatterResources.getString("PATCH_DIR2") : FormatterResources.getString("PATCH_DIR1");
        String string3 = FormatterResources.format("CJK_INFO", string, string2) + "\n" + FormatterResources.getString("CJK_CREATE_PATCH");
        return string3;
    }

    public static String asianJarRequiredMessage(String string) {
        String string2 = PlatformUtils.isWindows() ? FormatterResources.getString("PATCH_DIR2") : FormatterResources.getString("PATCH_DIR1");
        String string3 = FormatterResources.format("FILE_NOT_FOUND", FormatterResources.getString("ASIAN_JAR"), string2);
        return string3.concat("\n").concat(ReportAsianFonts.asianJarCopyMessage(string));
    }

    public static enum ASIAN_FONTS {
        FONT_STSONG_LIGHT("STSong-Light", "UniGB-UCS2-H", FormatterResources.getString("STSONG_LIGHT_FONT")),
        FONT_STSONGSTD_LIGHT("STSongStd-Light", "UniGB-UCS2-H", FormatterResources.getString("STSONGSTD_LIGHT_FONT")),
        FONT_MHEI_MEDIUM("MHei-Medium", "UniCNS-UCS2-H", FormatterResources.getString("MHEI_MEDIUM_FONT")),
        FONT_MSUNG_LIGHT("MSung-Light", "UniCNS-UCS2-H", FormatterResources.getString("MSUNG_LIGHT_FONT")),
        FONT_MSUNGSTD_LIGHT("MSungStd-Light", "UniCNS-UCS2-H", FormatterResources.getString("MSUNGSTD_LIGHT_FONT")),
        FONT_HEISEIMIN_W3("HeiseiMin-W3", "UniJIS-UCS2-H", FormatterResources.getString("HEISEIMIN_W3_FONT")),
        FONT_HEISEIKAKUGO_W5("HeiseiKakuGo-W5", "UniJIS-UCS2-H", FormatterResources.getString("HEISEIKAKUGO_W5_FONT")),
        FONT_KOZMINPRO_REGULAR("KozMinPro-Regular", "UniJIS-UCS2-H", FormatterResources.getString("KOZMINPRO_REGULAR_FONT")),
        FONT_HYGOTHIC_MEDIUM("HYGoThic-Medium", "UniKS-UCS2-H", FormatterResources.getString("HYGOTHIC_MEDIUM_FONT")),
        FONT_HYSMYEONGJO_MEDIUM("HYSMyeongJo-Medium", "UniKS-UCS2-H", FormatterResources.getString("HYSMYEONGJO_MEDIUM_FONT")),
        FONT_HYSMYEONGJOSTD("HYSMyeongJoStd", "UniKS-UCS2-H", FormatterResources.getString("HYSMYEONGJOSTD_FONT"));

        private String font;
        private String fontNLSName;
        private String fontDirection;

        private ASIAN_FONTS(String string2, String string3, String string4) {
            this.font = string2;
            this.fontDirection = string3;
            this.fontNLSName = string4;
        }

        public String getFont() {
            return this.font;
        }

        public String getFontDirection() {
            return this.fontDirection;
        }

        public String getNLSName() {
            return this.fontNLSName;
        }
    }
}

