/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.GridColumnSortParameter;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridHeaderContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.dbtools.raptor.controls.grid.contextmenu.SortShuttlePanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.Pair;

public class GridSorter
extends GridHeaderContextMenuItem {
    public static final String _cmdGridSorter = "_cmdGridSorter";
    public static final int _cmdIdGridSorter = Ide.findOrCreateCmdID((String)"_cmdGridSorter");
    private IdeAction _actionGridSorter;
    private JEWTDialog dlg = null;
    private static GridSorter _instance = null;
    private JMenuItem _mi = null;

    private GridSorter() {
        this.initAction();
    }

    private void initAction() {
        if (this._actionGridSorter == null) {
            this._actionGridSorter = this.createAction(_cmdIdGridSorter, Messages.getString("GridSorter.1"), null);
        }
    }

    public static GridHeaderContextMenuItem getInstance() {
        if (_instance == null) {
            _instance = new GridSorter();
        }
        return _instance;
    }

    @Override
    protected boolean canShow(ContextMenu contextMenu) {
        return this._table.isMultiColSort();
    }

    @Override
    protected void createAndShowMenu(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        contextMenu.add((Component)this._mi);
    }

    private void createJMenuItem(ContextMenu contextMenu) {
        if (this._mi == null) {
            this._mi = contextMenu.createMenuItem((ToggleAction)this._actionGridSorter);
        }
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == _cmdIdGridSorter) {
            return this.sort();
        }
        return false;
    }

    public boolean sort() {
        if (this._table != null && this._table.getGridModel() != null) {
            AbstractRaptorGridModel abstractRaptorGridModel = this._table.getGridModel();
            List<GridColumn> list = abstractRaptorGridModel.getGridColumns();
            HashMap<GridColumn, GridColumnSortParameter> hashMap = new HashMap<GridColumn, GridColumnSortParameter>();
            if (list != null) {
                for (GridColumn cloneable2 : list) {
                    hashMap.put(cloneable2, cloneable2.getSortParameter() != null ? new GridColumnSortParameter(cloneable2.getSortParameter()) : null);
                }
            }
            SortShuttlePanel sortShuttlePanel = new SortShuttlePanel(Messages.getString("GridSorter.2"), Messages.getString("GridSorter.3"), Messages.getString("GridSorter.4"), this._table);
            sortShuttlePanel.supportsOrderingNulls(abstractRaptorGridModel.supportsOrderingNulls());
            sortShuttlePanel.init(list);
            HelpSystem.getHelpSystem().registerTopic((JComponent)sortShuttlePanel, "f1_sortcolumns_html");
            Dimension dimension = sortShuttlePanel.getPreferredSize();
            dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
            this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)sortShuttlePanel, null, (String)Messages.getString("GridSorter.5"), (int)7);
            this.dlg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
                }
            });
            this.dlg.setSize(dimension);
            this.dlg.setModal(true);
            DialogSizeKeeper.attachToComponent((Component)this.dlg, (String)(Messages.getString("GridSorter.6") + ".dialogSize"));
            this.dlg.setLocationRelativeTo(null);
            this.dlg.setVisible(true);
            if (!this.dlg.isCancelled()) {
                try {
                    RaptorGridPersistedSettings.savePersistentSettings(this._table, false);
                    this._table.refresh();
                }
                catch (ExecutionException executionException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, executionException.getStackTrace()[0].toString(), executionException);
                }
            } else {
                for (GridColumn gridColumn : list) {
                    gridColumn.setSortParameter((GridColumnSortParameter)hashMap.get(gridColumn));
                }
            }
            this._table.requestFocusInWindow();
            return true;
        }
        return false;
    }

    public void setGrid(RaptorGridTable raptorGridTable) {
        this._table = raptorGridTable;
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        ideAction.setEnabled(this._table != null && this._table.canSortNow());
        return true;
    }

    @Override
    public JMenuItem[] getJMenuItems(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        return new JMenuItem[]{this._mi};
    }

    public static ArrayList<ArrayList<Pair<GridColumn, GridColumnSortParameter>>> getSorts(ArrayList<String> arrayList, List<GridColumn> list) {
        ArrayList<ArrayList<Pair<GridColumn, GridColumnSortParameter>>> arrayList2 = new ArrayList<ArrayList<Pair<GridColumn, GridColumnSortParameter>>>();
        if (arrayList == null) {
            return arrayList2;
        }
        for (String string : arrayList) {
            if (string == null || string.equals("")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
            ArrayList<Pair> arrayList3 = new ArrayList<Pair>();
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n;
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || string2.equals("")) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
                GridColumn gridColumn = null;
                GridColumnSortParameter gridColumnSortParameter = new GridColumnSortParameter(n, GridColumnSortParameter.SortDir.ASCENDING, GridColumnSortParameter.NullsOption.NONE);
                int n2 = 0;
                gridColumnSortParameter.setSortOrder(n);
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    switch (++n2) {
                        case 1: {
                            int n3 = -1;
                            try {
                                n3 = Integer.parseInt(string3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n3 <= 0) break;
                            gridColumn = list.get(n3 - 1);
                            break;
                        }
                        case 2: {
                            if (string3.equals(GridColumnSortParameter.SortDir.ASCENDING.toString())) {
                                gridColumnSortParameter.setSortDir(GridColumnSortParameter.SortDir.ASCENDING);
                                break;
                            }
                            if (!string3.equals(GridColumnSortParameter.SortDir.DESCENDING.toString())) break;
                            gridColumnSortParameter.setSortDir(GridColumnSortParameter.SortDir.DESCENDING);
                            break;
                        }
                        case 3: {
                            if (!string3.equals("NULLS")) break;
                            string3 = stringTokenizer2.nextToken();
                            if (string3.equals("FIRST")) {
                                gridColumnSortParameter.setNullsOption(GridColumnSortParameter.NullsOption.FIRST);
                                break;
                            }
                            if (!string3.equals("LAST")) break;
                            gridColumnSortParameter.setNullsOption(GridColumnSortParameter.NullsOption.LAST);
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                }
                if (gridColumn == null) continue;
                arrayList3.add(new Pair(gridColumn, (Object)gridColumnSortParameter));
            }
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }

    private static class SortColumnRenderer
    extends DefaultListCellRenderer {
        private SortColumnRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            final GridColumn gridColumn = (GridColumn)object;
            this.setText(gridColumn.getOriginal());
            JPanel jPanel = new JPanel();
            jPanel.add(component);
            JButton jButton = new JButton();
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GridColumnSortParameter gridColumnSortParameter = gridColumn.getSortParameter();
                    if (gridColumnSortParameter != null) {
                        if (gridColumnSortParameter.getSortDir() == GridColumnSortParameter.SortDir.ASCENDING) {
                            gridColumnSortParameter.setSortDir(GridColumnSortParameter.SortDir.DESCENDING);
                        } else if (gridColumnSortParameter.getSortDir() == GridColumnSortParameter.SortDir.DESCENDING) {
                            gridColumn.setSortParameter(null);
                        } else {
                            gridColumnSortParameter.setSortDir(GridColumnSortParameter.SortDir.ASCENDING);
                        }
                    }
                }
            });
            jPanel.add(jButton);
            return jPanel;
        }
    }
}

