/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.dialogs.RaptorTaskUI;
import oracle.dbtools.raptor.backgroundTask.internal.IRaptorTaskUIListener;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.backgroundTask.ui.Messages;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.ide.controls.Toolbar;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class TaskProgressViewer
extends JPanel
implements ITaskViewer {
    protected static final int DEFAULT_TASK_CLEAR_TIME = 1;
    private static TaskProgressViewer _gui = null;
    Map<Object, Long> _tableRowsToRemove;
    private JPanel _pnlTaskPanel;
    private Toolbar _toolbar;
    private Timer _taskClearerTimer;
    private TasksScavenger m_taskScavenger;
    private JScrollPane _taskScrollPanel;
    private IRaptorTaskUIListener m_taskExcpListener;

    private TaskProgressViewer() {
        this.createGUI();
        this._tableRowsToRemove = new LinkedHashMap<Object, Long>();
        this.m_taskScavenger = new TasksScavenger();
        this._taskClearerTimer = new Timer(200, this.m_taskScavenger);
        this.m_taskExcpListener = new IRaptorTaskUIListener(){

            public void taskClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
                if (raptorTaskDescriptor.getStatus() == IRaptorTaskStatus.FAILED) {
                    Throwable throwable = raptorTaskDescriptor.getThrowable();
                    if (throwable instanceof TaskException) {
                        throwable = ((TaskException)throwable).getCause();
                    } else if (throwable instanceof ExecutionException) {
                        throwable = ((ExecutionException)throwable).getCause();
                    }
                    if (throwable instanceof CancellationException) {
                        String string = Messages.getString("TaskProgressViewer.TaskCancelled") + raptorTaskDescriptor.getMessage();
                        MessageDialog.error((Component)TaskProgressViewer.this._pnlTaskPanel, (Object)string, (String)Messages.getString("TaskProgressViewer.Title"), null);
                        return;
                    }
                    if (throwable instanceof SQLException) {
                        SQLErrorDialog.showErrorDialog(null, TaskProgressViewer.this._pnlTaskPanel, Messages.getString("TaskProgressViewer.Title"), (SQLException)throwable);
                        return;
                    }
                    String string = throwable == null ? raptorTaskDescriptor.getMessage() : throwable.getMessage();
                    ExceptionDialog.showExceptionDialog((Component)TaskProgressViewer.this._pnlTaskPanel, (Throwable)throwable, (String)Messages.getString("TaskProgressViewer.Title"), (String)string, null);
                }
            }

            public void pauseClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
            }

            public void cancelClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
            }
        };
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getToolbar(), "North");
        this._pnlTaskPanel = new JPanel(new GridBagLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._pnlTaskPanel, "North");
        this._taskScrollPanel = new JScrollPane(jPanel);
        this.add((Component)this._taskScrollPanel, "Center");
    }

    public static synchronized TaskProgressViewer getInstance() {
        if (_gui == null) {
            _gui = new TaskProgressViewer();
        }
        return _gui;
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this.installToolbar();
        }
        return this._toolbar;
    }

    private void installToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._toolbar.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            JButton jButton = new JButton(OracleIcons.getIcon((String)"clear.png"));
            jButton.setToolTipText(Messages.getString("TaskProgressViewer.4"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TaskProgressViewer.this.m_taskScavenger.actionPerformed(actionEvent);
                }
            });
            jButton.setToolTipText(Messages.getString("TaskProgressViewer.5"));
            this._toolbar.add((Component)jButton);
        }
    }

    public void addTaskUI(final ITaskUI iTaskUI) {
        if (iTaskUI != null) {
            if (iTaskUI.getTaskDescriptor().getRunMode() == IRaptorTaskRunMode.MODAL_OPTIONAL) {
                this._addTaskUI(iTaskUI);
            } else {
                Timer timer = new Timer(2000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (iTaskUI.getTaskDescriptor().getStatus() != IRaptorTaskStatus.FINISHED) {
                            TaskProgressViewer.this._addTaskUI(iTaskUI);
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
                if (!this._taskClearerTimer.isRunning()) {
                    this._taskClearerTimer.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTasks(List<IRaptorTaskStatus> list, int n) {
        JPanel jPanel = this._pnlTaskPanel;
        synchronized (jPanel) {
            Object object;
            Serializable serializable;
            int n2;
            Long l = System.currentTimeMillis();
            for (n2 = this._pnlTaskPanel.getComponentCount() - 1; n2 >= 0; --n2) {
                serializable = this._pnlTaskPanel.getComponent(n2);
                if (!(serializable instanceof ITaskUI)) continue;
                object = (ITaskUI)serializable;
                IRaptorTaskStatus iRaptorTaskStatus = object.getStatus();
                if (list != null && !list.contains(iRaptorTaskStatus) || this._tableRowsToRemove.containsKey(serializable)) continue;
                this._tableRowsToRemove.put(serializable, l);
            }
            for (n2 = this._pnlTaskPanel.getComponentCount() - 1; n2 >= 0; --n2) {
                serializable = this._pnlTaskPanel.getComponent(n2);
                object = this._tableRowsToRemove.get(serializable);
                if (object == null || l - (Long)object < (long)n && l >= (Long)object) continue;
                this._pnlTaskPanel.remove((Component)serializable);
                this._tableRowsToRemove.remove(serializable);
            }
            Iterator<Long> iterator = this._tableRowsToRemove.values().iterator();
            while (iterator.hasNext()) {
                serializable = iterator.next();
                if (l - (Long)serializable < (long)(n * 2) && l >= (Long)serializable) continue;
                iterator.remove();
            }
            this._pnlTaskPanel.getParent().validate();
        }
    }

    public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        for (int i = this._pnlTaskPanel.getComponentCount() - 1; i >= 0; --i) {
            ITaskUI iTaskUI;
            Component component = this._pnlTaskPanel.getComponent(i);
            if (!(component instanceof ITaskUI) || (iTaskUI = (ITaskUI)component).getTaskDescriptor() != raptorTaskDescriptor) continue;
            return iTaskUI;
        }
        return null;
    }

    public void removeTaskUI(ITaskUI iTaskUI) {
        this._pnlTaskPanel.remove(iTaskUI.getPanel());
        this._pnlTaskPanel.invalidate();
        this._pnlTaskPanel.repaint();
    }

    public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        return new RaptorTaskUI(raptorTaskDescriptor){

            @Override
            protected JPanel createSimpleTaskUI() {
                JPanel jPanel = super.createSimpleTaskUI();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = -1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 5, 0, 0);
                JButton jButton = new JButton(OracleIcons.getIcon((String)"clear.png"));
                jButton.setBorder(null);
                jButton.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JPanel jPanel = TaskProgressViewer.this._pnlTaskPanel;
                        synchronized (jPanel) {
                            ITaskUI iTaskUI;
                            Component component;
                            Component component2;
                            for (component2 = component = (Component)actionEvent.getSource(); component2 != null && !(component2 instanceof ITaskUI); component2 = component2.getParent()) {
                            }
                            if (component2 != null && ((iTaskUI = (ITaskUI)component2).getStatus() == IRaptorTaskStatus.FAILED || iTaskUI.getStatus() == IRaptorTaskStatus.FINISHED)) {
                                TaskProgressViewer.this.removeTaskUI(iTaskUI);
                            }
                        }
                    }
                });
                jPanel.add((Component)jButton, gridBagConstraints);
                return jPanel;
            }
        };
    }

    public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
        ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
        if (iTaskUI != null) {
            iTaskUI.cancelClicked(raptorTaskDescriptor);
        }
    }

    public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
        ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
        if (iTaskUI != null) {
            iTaskUI.pauseClicked(raptorTaskDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addTaskUI(ITaskUI iTaskUI) {
        JPanel jPanel = this._pnlTaskPanel;
        synchronized (jPanel) {
            Component component = iTaskUI.getPanel();
            component.setPreferredSize(null);
            if (component instanceof JPanel) {
                ((JPanel)component).setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            component.setPreferredSize(new Dimension((int)this._taskScrollPanel.getPreferredSize().getWidth(), (int)component.getPreferredSize().getHeight()));
            iTaskUI.addListener(this.m_taskExcpListener);
            ((RaptorTaskUI)iTaskUI).refreshPauseUI(new RaptorTaskEvent(iTaskUI.getTaskDescriptor()));
            this._pnlTaskPanel.add(component, gridBagConstraints);
            this._pnlTaskPanel.revalidate();
            this._pnlTaskPanel.repaint();
            if (!this._taskClearerTimer.isRunning()) {
                this._taskClearerTimer.start();
            }
        }
    }

    private class TasksScavenger
    implements ActionListener {
        private TasksScavenger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = TaskProgressViewer.this._pnlTaskPanel;
            synchronized (jPanel) {
                ArrayList<IRaptorTaskStatus> arrayList = new ArrayList<IRaptorTaskStatus>();
                arrayList.add(IRaptorTaskStatus.FINISHED);
                if (actionEvent.getSource() instanceof JButton) {
                    arrayList.add(IRaptorTaskStatus.FAILED);
                    TaskProgressViewer.this.removeTasks(arrayList, 0);
                } else {
                    TaskProgressViewer.this.removeTasks(arrayList, 1);
                }
                TaskProgressViewer.this._pnlTaskPanel.repaint();
                if (TaskProgressViewer.this._taskClearerTimer.isRunning() && !arrayList.contains(IRaptorTaskStatus.FAILED)) {
                    boolean bl = true;
                    for (int i = TaskProgressViewer.this._pnlTaskPanel.getComponentCount() - 1; i >= 0; --i) {
                        IRaptorTaskStatus iRaptorTaskStatus;
                        Component component = TaskProgressViewer.this._pnlTaskPanel.getComponent(i);
                        if (!(component instanceof ITaskUI) || (iRaptorTaskStatus = ((ITaskUI)component).getStatus()) == IRaptorTaskStatus.FAILED) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        TaskProgressViewer.this._taskClearerTimer.stop();
                    }
                }
            }
        }
    }
}

