/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.Timer;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.dialogs.RaptorTaskUI;
import oracle.dbtools.raptor.backgroundTask.dialogs.TaskDialog;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.controls.GlassPaneUIBlocker;

public class GlassPaneTaskViewer
extends GlassPaneUIBlocker
implements ITaskViewer,
ActionListener {
    private static final long serialVersionUID = 1L;
    ITaskUI _taskUI;
    JComponent _ui;
    private static int ALPHA = 128;
    private Timer _timer;

    public void addTaskUI(ITaskUI iTaskUI) {
        Component component = iTaskUI.getPanel();
        if (component instanceof JComponent) {
            this._ui = (JComponent)component;
            this._ui.setOpaque(false);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)Box.createVerticalBox(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        this.add(component, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)Box.createVerticalBox(), gridBagConstraints);
    }

    public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        if (null == this._taskUI) {
            this._taskUI = new RaptorTaskUI(raptorTaskDescriptor){

                @Override
                public void paintComponent(Graphics graphics) {
                    Color color = this.getParent().getBackground();
                    Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), ALPHA);
                    graphics.setColor(color2);
                    Rectangle rectangle = graphics.getClipBounds();
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            };
        }
        return this._taskUI;
    }

    public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        return this.createTaskUI(raptorTaskDescriptor);
    }

    public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
        ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
        if (iTaskUI != null) {
            iTaskUI.cancelClicked(raptorTaskDescriptor);
        }
    }

    public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
        ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
        if (iTaskUI != null) {
            iTaskUI.pauseClicked(raptorTaskDescriptor);
        }
    }

    private Timer getDelayTimer() {
        if (null == this._timer) {
            this._timer = new Timer(TaskDialog.DELAY_MS, actionEvent -> {
                this.uiSetVisible(true);
                this._timer.stop();
            });
        }
        return this._timer;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.uiSetVisible(false);
            this.getDelayTimer().start();
        }
        super.setVisible(bl);
    }

    private void uiSetVisible(boolean bl) {
        if (this._ui != null) {
            this._ui.setVisible(bl);
        }
    }

    public void removeTaskUI(ITaskUI iTaskUI) {
    }
}

