/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Component;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.preferences.ClassificationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.preferences.PreferencesLrb;
import oracle.ide.config.Preferences;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;

public class TestLiftProfitDialogPanel
extends DialogDisplayer {
    private ClassificationModelBuildPreferencesPanelSettings _settings = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private ButtonGroup buttonGroupHighLow;
    private JSpinner jFrequencySpinner;
    private JLabel jLabelTargetValueCount;
    private JRadioButton jRadioHighest;
    private JRadioButton jRadioLowest;

    public TestLiftProfitDialogPanel() {
        this.initComponents();
        this.initUI();
        this.initRes();
    }

    private void initComponents() {
        this.buttonGroupHighLow = new ButtonGroup();
        this.jLabelTargetValueCount = new JLabel();
        this.jRadioLowest = new JRadioButton();
        this.jRadioHighest = new JRadioButton();
        this.jFrequencySpinner = new JSpinner();
        this.jLabelTargetValueCount.setText("Frequency Count:");
        this.jRadioLowest.setText("Use Lowest Occuring");
        this.jRadioLowest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioLowest.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioHighest.setText("Use Highest Occuring");
        this.jRadioHighest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioHighest.setMargin(new Insets(0, 0, 0, 0));
        this.jFrequencySpinner.setModel(new SpinnerNumberModel(5, 1, 100, 1));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRadioLowest, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioHighest, -2, 149, -2))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelTargetValueCount, -2, 159, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFrequencySpinner, -2, 88, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTargetValueCount).addComponent(this.jFrequencySpinner, -2, -1, -2)).addGap(7, 7, 7).addComponent(this.jRadioLowest).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioHighest).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(PreferencesLrb.get("TEST_LOWEST"), this.jRadioLowest);
        hashMap.put(PreferencesLrb.get("TEST_HIGHEST"), this.jRadioHighest);
        this.buttonGroupHighLow.add(this.jRadioLowest);
        this.buttonGroupHighLow.add(this.jRadioHighest);
        UIResourceHelper.setComponentText(hashMap);
        ResourceUtils.resLabel((JLabel)this.jLabelTargetValueCount, (Component)this.jFrequencySpinner, (String)PreferencesLrb.get("TEST_TARGET_COUNT"));
    }

    @Override
    public void initUI() {
        this.jFrequencySpinner.setModel(new SpinnerNumberModel(this._settings.getNTarget(), 1, 100, 1));
        this.jRadioHighest.setSelected(this._settings.isTOPN());
        this.jRadioLowest.setSelected(!this._settings.isTOPN());
    }

    @Override
    public boolean doWork() {
        this._settings.setTOPN(this.jRadioHighest.isSelected());
        this._settings.setNTarget(Integer.parseInt(this.jFrequencySpinner.getValue().toString()));
        return true;
    }

    @Override
    protected String getDialogTitle() {
        return PreferencesLrb.get("TEST_LIFT_PROFITSETTINGS_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }

    @Override
    protected int getDialogButtonMask() {
        return 3;
    }
}

