/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.preferences.PreferencesLrb;
import oracle.dmt.dataminer.workflow.preferences.RegressionModelBuildPreferencesPanelSettings;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public class RegressionModelBuildPreferencesPanel
extends DefaultTraversablePanel
implements DataminerGUIPanel {
    private ButtonGroup buttonGroup;
    private JCheckBox jAccuracyMetricsCheckBox;
    private JCheckBox jChkGLM;
    private JCheckBox jChkParallel;
    private JCheckBox jChkSVM;
    private JLabel jCreateSplitAsLabel;
    private JLabel jLabel;
    private JRadioButton jRadioAllData;
    private JRadioButton jRadioSplit;
    private JRadioButton jRadioTest;
    private JCheckBox jResidualsCheckBox;
    private JComboBox jSplitTableViewComboBox;
    private JLabel jSplitTestPercentLabel;
    private JLabel jTestDataLabel;
    private JSpinner jTestDataPercentSpinner;
    private JLabel jTestResultsLabel;

    public RegressionModelBuildPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLabel = new JLabel();
        this.jChkGLM = new JCheckBox();
        this.jChkSVM = new JCheckBox();
        this.jTestResultsLabel = new JLabel();
        this.jAccuracyMetricsCheckBox = new JCheckBox();
        this.jResidualsCheckBox = new JCheckBox();
        this.jTestDataLabel = new JLabel();
        this.jRadioAllData = new JRadioButton();
        this.jRadioSplit = new JRadioButton();
        this.jSplitTestPercentLabel = new JLabel();
        this.jCreateSplitAsLabel = new JLabel();
        this.jTestDataPercentSpinner = new JSpinner();
        this.jSplitTableViewComboBox = new JComboBox();
        this.jChkParallel = new JCheckBox();
        this.jRadioTest = new JRadioButton();
        this.jLabel.setText("Automatic Model Generation");
        this.jChkGLM.setText("GLM");
        this.jChkSVM.setText("SVM");
        this.jTestResultsLabel.setText("Test Results");
        this.jAccuracyMetricsCheckBox.setText("Accuracy Metrics");
        this.jAccuracyMetricsCheckBox.setOpaque(false);
        this.jResidualsCheckBox.setText("Residuals");
        this.jResidualsCheckBox.setOpaque(false);
        this.jTestDataLabel.setText("Test Data");
        this.buttonGroup.add(this.jRadioAllData);
        this.jRadioAllData.setText("Use All Mining Build Data for Testing");
        this.jRadioAllData.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAllData.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioAllData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegressionModelBuildPreferencesPanel.this.jRadioAllDataActionPerformed(actionEvent);
            }
        });
        this.buttonGroup.add(this.jRadioSplit);
        this.jRadioSplit.setText("Use Split Build Data for Testing");
        this.jRadioSplit.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioSplit.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegressionModelBuildPreferencesPanel.this.jRadioSplitActionPerformed(actionEvent);
            }
        });
        this.jSplitTestPercentLabel.setText("Split for Test (%):");
        this.jCreateSplitAsLabel.setText("Create Split as:");
        this.jTestDataPercentSpinner.setModel(new SpinnerNumberModel(40, 0, 100, 10));
        this.jSplitTableViewComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Table", "View"}));
        this.jSplitTableViewComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegressionModelBuildPreferencesPanel.this.jSplitTableViewComboBoxActionPerformed(actionEvent);
            }
        });
        this.jChkParallel.setText("Parallel");
        this.buttonGroup.add(this.jRadioTest);
        this.jRadioTest.setText("Use Test Data Source for Testing");
        this.jRadioTest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioTest.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RegressionModelBuildPreferencesPanel.this.jRadioTestActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTestDataLabel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCreateSplitAsLabel, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSplitTableViewComboBox, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSplitTestPercentLabel, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTestDataPercentSpinner, -2, 47, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkParallel, -2, 104, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jRadioAllData, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioSplit, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioTest, -1, -1, Short.MAX_VALUE))))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTestResultsLabel, -2, 140, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jResidualsCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jAccuracyMetricsCheckBox, -1, -1, Short.MAX_VALUE))))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChkSVM, -2, 205, -2).addComponent(this.jChkGLM, -2, 205, -2)).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        groupLayout.linkSize(0, this.jChkGLM, this.jChkSVM);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel).addGap(7, 7, 7).addComponent(this.jChkGLM).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkSVM).addGap(15, 15, 15).addComponent(this.jTestResultsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAccuracyMetricsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jResidualsCheckBox).addGap(18, 18, 18).addComponent(this.jTestDataLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioAllData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioSplit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSplitTestPercentLabel).addComponent(this.jTestDataPercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCreateSplitAsLabel).addComponent(this.jSplitTableViewComboBox, -2, -1, -2).addComponent(this.jChkParallel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioTest).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jChkGLM, this.jChkSVM);
    }

    private void jRadioAllDataActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jRadioSplitActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jRadioTestActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jSplitTableViewComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    @Override
    public void initUI() {
        this.jLabel.setOpaque(true);
        this.enableControls();
    }

    @Override
    public void initRes() {
        this.jChkGLM.setText(PreferencesLrb.get("GENERAL_LINEAR_CHECK"));
        this.jChkSVM.setText(PreferencesLrb.get("SUPPORT_VECTOR_CHECK"));
        this.jLabel.setText(PreferencesLrb.get("AUTO_MODEL_GENERATION"));
        this.jTestResultsLabel.setText(PreferencesLrb.get("TEST_RESULTS"));
        this.jAccuracyMetricsCheckBox.setText(PreferencesLrb.get("TEST_ACCURACY_METRICS"));
        this.jResidualsCheckBox.setText(PreferencesLrb.get("TEST_RESIDUALS"));
        this.jTestDataLabel.setText(PreferencesLrb.get("TEST_DATA"));
        this.jRadioAllData.setText(PreferencesLrb.get("TEST_ALL_BUILD_DATA"));
        this.jRadioSplit.setText(PreferencesLrb.get("TEST_SPLIT_BUILD_DATA"));
        this.jRadioTest.setText(PreferencesLrb.get("TEST_TEST_DATA"));
        this.jChkParallel.setText(PreferencesLrb.get("SPLIT_DATA_TABLE_PARALLEL_OPTION"));
        ResourceUtils.resSpinner((JLabel)this.jSplitTestPercentLabel, (JSpinner)this.jTestDataPercentSpinner, (String)PreferencesLrb.get("SPLIT_TEST_DATA_PERCENT"));
        ResourceUtils.resLabel((JLabel)this.jCreateSplitAsLabel, (Component)this.jSplitTableViewComboBox, (String)PreferencesLrb.get("CREATE_SPLIT_AS_TABLE_VIEW"));
        this.setHelpID("preferences_build_regression");
    }

    private void enableControls() {
        boolean bl = this.jRadioSplit.isSelected();
        this.jTestDataPercentSpinner.setEnabled(bl);
        this.jSplitTableViewComboBox.setEnabled(bl);
        String string = (String)this.jSplitTableViewComboBox.getSelectedItem();
        this.jChkParallel.setEnabled(bl && ServerConstants.SplitDataFormat.isTable(ServerConstants.SplitDataFormat.toSchema(string)));
    }

    public void onEntry(TraversableContext traversableContext) {
        RegressionModelBuildPreferencesPanelSettings regressionModelBuildPreferencesPanelSettings = RegressionModelBuildPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this.jChkGLM.setSelected(regressionModelBuildPreferencesPanelSettings.isGlm());
        this.jChkSVM.setSelected(regressionModelBuildPreferencesPanelSettings.isSvm());
        this.jAccuracyMetricsCheckBox.setSelected(regressionModelBuildPreferencesPanelSettings.isAccuracyMetrics());
        this.jResidualsCheckBox.setSelected(regressionModelBuildPreferencesPanelSettings.isResiduals());
        this.jRadioAllData.setSelected(regressionModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_ALL"));
        this.jRadioSplit.setSelected(regressionModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_SPLIT"));
        this.jRadioTest.setSelected(regressionModelBuildPreferencesPanelSettings.getTestDataOption().equals("TEST_DATA_OPTION_TEST"));
        this.jTestDataPercentSpinner.setValue(regressionModelBuildPreferencesPanelSettings.getTestSplitPercent());
        this.jSplitTableViewComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.SplitDataFormat.toHuman("Table"), ServerConstants.SplitDataFormat.toHuman("View")}));
        this.jSplitTableViewComboBox.setSelectedItem(ServerConstants.SplitDataFormat.toHuman(regressionModelBuildPreferencesPanelSettings.createSplitAsTable() ? "Table" : "View"));
        this.jChkParallel.setSelected(regressionModelBuildPreferencesPanelSettings.isParallelTable());
    }

    public void onExit(TraversableContext traversableContext) {
        RegressionModelBuildPreferencesPanelSettings regressionModelBuildPreferencesPanelSettings = RegressionModelBuildPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        regressionModelBuildPreferencesPanelSettings.setGlm(this.jChkGLM.isSelected());
        regressionModelBuildPreferencesPanelSettings.setSvm(this.jChkSVM.isSelected());
        regressionModelBuildPreferencesPanelSettings.setAccuracyMetrics(this.jAccuracyMetricsCheckBox.isSelected());
        regressionModelBuildPreferencesPanelSettings.setResiduals(this.jResidualsCheckBox.isSelected());
        regressionModelBuildPreferencesPanelSettings.setTestDataOption(this.jRadioAllData.isSelected() ? "TEST_DATA_OPTION_ALL" : (this.jRadioSplit.isSelected() ? "TEST_DATA_OPTION_SPLIT" : "TEST_DATA_OPTION_TEST"));
        regressionModelBuildPreferencesPanelSettings.setTestSplitPercent((Integer)this.jTestDataPercentSpinner.getValue());
        String string = (String)this.jSplitTableViewComboBox.getSelectedItem();
        regressionModelBuildPreferencesPanelSettings.setCreateSplitAsTable(ServerConstants.SplitDataFormat.isTable(ServerConstants.SplitDataFormat.toSchema(string)));
        regressionModelBuildPreferencesPanelSettings.setParallelTable(this.jChkParallel.isSelected());
    }

    private static RegressionModelBuildPreferencesPanelSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return RegressionModelBuildPreferencesPanelSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

