/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.DBVersions;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RelationalAttributesType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public final class JSONQueryNode
extends AbstractTransformNode
implements DataConsumer,
ApplyChainNode,
DataGuideProvider {
    private static final Logger theLogger = Logger.getLogger(JSONQueryNode.class.getName());
    public static final String JSON_ATTRIBUTES = "jsonAttributes";
    public static final String RELATIONAL_ATTRIBUTES = "relationalAttributes";
    public static final String AGGREGATION_ELEMENTS = "aggregationElements";
    public static final String GROUPING_ELEMENT = "groupingElement";

    public JSONQueryNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        JSONAttributesType jSONAttributesType = new JSONAttributesType();
        RelationalAttributesType relationalAttributesType = new RelationalAttributesType();
        AggregationElementsExType aggregationElementsExType = new AggregationElementsExType();
        GroupingElementExType groupingElementExType = new GroupingElementExType();
        jSONQueryNodeType.setJSONAttributes(jSONAttributesType);
        jSONQueryNodeType.setRelationalAttributes(relationalAttributesType);
        jSONQueryNodeType.setAggregationElements(aggregationElementsExType);
        jSONQueryNodeType.setGroupingElement(groupingElementExType);
        jSONQueryNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_JSON_QUERY_NODE_NAME");
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes;
        block12: {
            Object object;
            JSONQueryNodeType jSONQueryNodeType;
            block13: {
                attributes = new Attributes();
                jSONQueryNodeType = (JSONQueryNodeType)this.getData();
                ArrayList<JSONAttributeType> arrayList = new ArrayList<JSONAttributeType>();
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getJSONAttributes().getJSONAttribute()) {
                    if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") != 0 || !Boolean.FALSE.equals(jSONAttributeType.isUnnest())) continue;
                    arrayList.add(jSONAttributeType);
                }
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getJSONAttributes().getJSONAttribute()) {
                    boolean bl = true;
                    for (JSONAttributeType jSONAttributeType2 : arrayList) {
                        if (jSONAttributeType.getPath().compareTo(jSONAttributeType2.getPath()) == 0 || jSONAttributeType.getPath().indexOf(jSONAttributeType2.getPath()) != 0) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                        String string2;
                        object = jSONAttributeType;
                        if (Boolean.FALSE.equals(jSONAttributeType.isUnnest())) {
                            AttributeType attributeType = new AttributeType();
                            string2 = object.getDBName();
                            attributeType.setName(string2);
                            attributeType.setAlias(null);
                            attributeType.setDataType(object.getDBDataType());
                            attributeType.setDataTypeQualifier("JSON");
                            attributeType.setStatus(object.getStatus());
                            attributes.getAttribute().add(attributeType);
                            continue;
                        }
                        bl = true;
                        for (String string2 : jSONQueryNodeType.getJSONAttributes().getJSONAttribute()) {
                            if (jSONAttributeType.getPath().compareTo(string2.getPath()) == 0 || string2.getPath().indexOf(jSONAttributeType.getPath()) != 0) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        AttributeType attributeType = new AttributeType();
                        string2 = object.getDBName();
                        attributeType.setName(string2);
                        attributeType.setAlias(null);
                        attributeType.setDataType("VARCHAR2");
                        attributeType.setStatus(object.getStatus());
                        attributes.getAttribute().add(attributeType);
                        continue;
                    }
                    if (jSONAttributeType.getDataType().compareToIgnoreCase("OBJECT") == 0) continue;
                    object = new AttributeType();
                    String string = jSONAttributeType.getDBName();
                    object.setName(string);
                    object.setAlias(null);
                    object.setDataType(jSONAttributeType.getDBDataType());
                    object.setStatus(jSONAttributeType.getStatus());
                    attributes.getAttribute().add(object);
                }
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getRelationalAttributes().getAttribute()) {
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName(jSONAttributeType.getAlias() != null && !jSONAttributeType.getAlias().trim().isEmpty() ? jSONAttributeType.getAlias() : jSONAttributeType.getName());
                    attributeType.setAlias(null);
                    attributeType.setDataType(jSONAttributeType.getNewDataType() != null ? jSONAttributeType.getNewDataType() : jSONAttributeType.getDataType());
                    attributeType.setStatus(jSONAttributeType.getStatus());
                    attributes.getAttribute().add(attributeType);
                }
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getAggregationElements().getAggregationElement()) {
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName(jSONAttributeType.getOutput().getName());
                    attributeType.setAlias(null);
                    attributeType.setDataType(jSONAttributeType.getOutput().getDataType());
                    attributeType.setStatus(jSONAttributeType.getOutput().getStatus());
                    attributes.getAttribute().add(attributeType);
                }
                if (jSONQueryNodeType.getGroupingElement() == null || jSONQueryNodeType.getGroupingElement().getAttributes() == null) break block12;
                if (jSONQueryNodeType.getGroupingElement().getAttributes().getAttribute().isEmpty()) break block13;
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getGroupingElement().getAttributes().getAttribute()) {
                    boolean bl = false;
                    object = jSONAttributeType.getAlias() != null ? jSONAttributeType.getAlias() : jSONAttributeType.getName();
                    for (String string2 : attributes.getAttribute()) {
                        String string = string2.getAlias() != null ? string2.getAlias() : string2.getName();
                        if (((String)object).compareTo(string) != 0) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName((String)object);
                    attributeType.setAlias(null);
                    attributeType.setDataType(jSONAttributeType.getDataType());
                    attributeType.setStatus(jSONAttributeType.getStatus());
                    attributes.getAttribute().add(attributeType);
                }
                break block12;
            }
            if (jSONQueryNodeType.getGroupingElement().getAttributes().getJSONAttribute().isEmpty()) break block12;
            for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getGroupingElement().getAttributes().getJSONAttribute()) {
                boolean bl = false;
                object = jSONAttributeType.getDBName();
                for (String string2 : attributes.getAttribute()) {
                    String string = string2.getAlias() != null ? string2.getAlias() : string2.getName();
                    if (((String)object).compareTo(string) != 0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                AttributeType attributeType = new AttributeType();
                attributeType.setName((String)object);
                attributeType.setAlias(null);
                attributeType.setDataType(jSONAttributeType.getDataType());
                attributeType.setStatus(jSONAttributeType.getStatus());
                attributes.getAttribute().add(attributeType);
            }
        }
        return attributes;
    }

    public List<AbstractNode> findSourceNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        Object object2;
        Object object32;
        Attributes attributes3;
        AggregationElementsExType.AggregationElement.SubGroupBy.Attributes attributes2;
        Object object4;
        Object object52;
        DataGuideProvider dataGuideProvider;
        boolean bl2 = super.validate(bl);
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (jSONQueryNodeType.getJSONAttributes().getSource() != null) {
            DataGuideType dataGuideType;
            AttributeType attributeType = new AttributeType();
            attributeType.setName(jSONQueryNodeType.getJSONAttributes().getSource());
            attributeType.setDataType(jSONQueryNodeType.getJSONAttributes().getDataType());
            Integer n = null;
            dataGuideProvider = (DataGuideProvider)((Object)this.findParentNode());
            if (dataGuideProvider != null && (dataGuideType = dataGuideProvider.getJSONAttrDataGuide(attributeType, n)) != null) {
                for (Object object6 : dataGuideType.getItem()) {
                    hashMap.put(object6.getPath(), object6.getType().trim());
                }
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        dataGuideProvider = null;
        if (jSONQueryNodeType.getJSONAttributes().getJSONAttribute() != null && !jSONQueryNodeType.getJSONAttributes().getJSONAttribute().isEmpty()) {
            dataGuideProvider = (JSONAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getJSONAttributes());
            for (Object object52 : dataGuideProvider.getJSONAttribute()) {
                Object object6;
                object6 = (String)hashMap.get(object52.getPath());
                if (object6 == null && object52.getDBName().equals(JSONElement.JSON_ROOT_ARRAY_SYMBOL)) {
                    object6 = "ARRAY";
                }
                if (object6 != null) {
                    if (object52.getDataType().compareToIgnoreCase((String)object6) != 0) {
                        object52.setStatus(AttributeStatus.INVALID);
                        if (!bl4) {
                            this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl4 = true;
                            bl2 = false;
                        }
                        bl3 = true;
                        continue;
                    }
                    object52.setStatus(AttributeStatus.VALID);
                    bl3 = true;
                    continue;
                }
                object52.setStatus(AttributeStatus.MISSING);
                if (!bl4) {
                    this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                    bl4 = true;
                    bl2 = false;
                }
                bl3 = true;
            }
        }
        boolean bl5 = false;
        object52 = null;
        if (jSONQueryNodeType.getAggregationElements().getAggregationElement() != null && !jSONQueryNodeType.getAggregationElements().getAggregationElement().isEmpty()) {
            object52 = (AggregationElementsExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getAggregationElements());
            for (AggregationElementsExType.AggregationElement aggregationElement : object52.getAggregationElement()) {
                object4 = (String)hashMap.get(aggregationElement.getJSONAttribute().getPath());
                if (object4 != null) {
                    if (aggregationElement.getJSONAttribute().getDataType().compareToIgnoreCase((String)object4) != 0) {
                        aggregationElement.getJSONAttribute().setStatus(AttributeStatus.INVALID);
                        aggregationElement.getOutput().setStatus(AttributeStatus.INVALID);
                        if (!bl4) {
                            this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl4 = true;
                            bl2 = false;
                        }
                        bl5 = true;
                    } else {
                        aggregationElement.getJSONAttribute().setStatus(AttributeStatus.VALID);
                        aggregationElement.getOutput().setStatus(AttributeStatus.VALID);
                        bl5 = true;
                    }
                } else {
                    aggregationElement.getJSONAttribute().setStatus(AttributeStatus.MISSING);
                    aggregationElement.getOutput().setStatus(AttributeStatus.MISSING);
                    if (!bl4) {
                        this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                        bl4 = true;
                        bl2 = false;
                    }
                    bl5 = true;
                }
                if ((attributes2 = aggregationElement.getSubGroupBy().getAttributes()) == null) continue;
                for (Object object7 : attributes2.getJSONAttribute()) {
                    object4 = (String)hashMap.get(object7.getPath());
                    if (object4 != null) {
                        if (object7.getDataType().compareToIgnoreCase((String)object4) != 0) {
                            object7.setStatus(AttributeStatus.INVALID);
                            if (!bl4) {
                                this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                                bl4 = true;
                                bl2 = false;
                            }
                            bl5 = true;
                            continue;
                        }
                        object7.setStatus(AttributeStatus.VALID);
                        bl5 = true;
                        continue;
                    }
                    object7.setStatus(AttributeStatus.MISSING);
                    if (!bl4) {
                        this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                        bl4 = true;
                        bl2 = false;
                    }
                    bl5 = true;
                }
            }
        }
        boolean bl6 = false;
        boolean bl7 = false;
        object4 = new HashMap();
        attributes2 = this.findSourceNodes();
        if (attributes2 != null) {
            for (Object object7 : attributes2) {
                if (!(object7 instanceof DataProvider)) continue;
                attributes3 = ((DataProvider)object7).getAttributes();
                for (Object object32 : attributes3.getAttribute()) {
                    object4.put(object32.getName(), object32.getDataType());
                }
            }
        }
        Object object8 = null;
        if (jSONQueryNodeType.getRelationalAttributes().getAttribute() != null && !jSONQueryNodeType.getRelationalAttributes().getAttribute().isEmpty()) {
            object8 = (RelationalAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getRelationalAttributes());
            for (Attributes attributes3 : object8.getAttribute()) {
                object2 = (String)object4.get(attributes3.getName());
                if (object2 != null) {
                    if (attributes3.getDataType().compareToIgnoreCase((String)object2) != 0) {
                        attributes3.setStatus(AttributeStatus.INVALID);
                        if (!bl7) {
                            this.addMessage("JSON_QUERY_REL_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl7 = true;
                            bl2 = false;
                        }
                        bl6 = true;
                        continue;
                    }
                    attributes3.setStatus(AttributeStatus.VALID);
                    bl6 = true;
                    continue;
                }
                attributes3.setStatus(AttributeStatus.MISSING);
                if (!bl7) {
                    this.addMessage("JSON_QUERY_REL_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                    bl7 = true;
                    bl2 = false;
                }
                bl6 = true;
            }
        }
        boolean bl8 = false;
        attributes3 = null;
        if (!(jSONQueryNodeType.getGroupingElement().getAttributes() == null || jSONQueryNodeType.getGroupingElement().getAttributes().getJSONAttribute().isEmpty() && jSONQueryNodeType.getGroupingElement().getAttributes().getAttribute().isEmpty())) {
            attributes3 = (GroupingElementExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getGroupingElement());
            for (Object object32 : attributes3.getAttributes().getJSONAttribute()) {
                object = (String)hashMap.get(object32.getPath());
                if (object != null) {
                    if (object32.getDataType().compareToIgnoreCase((String)object) != 0) {
                        object32.setStatus(AttributeStatus.INVALID);
                        if (!bl4) {
                            this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl4 = true;
                            bl2 = false;
                        }
                        bl8 = true;
                        continue;
                    }
                    object32.setStatus(AttributeStatus.VALID);
                    bl8 = true;
                    continue;
                }
                object32.setStatus(AttributeStatus.MISSING);
                if (!bl4) {
                    this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                    bl4 = true;
                    bl2 = false;
                }
                bl8 = true;
            }
            for (Object object32 : attributes3.getAttributes().getAttribute()) {
                object = (String)object4.get(object32.getName());
                if (object != null) {
                    if (object32.getDataType().compareToIgnoreCase((String)object) != 0) {
                        object32.setStatus(AttributeStatus.INVALID);
                        if (!bl7) {
                            this.addMessage("JSON_QUERY_REL_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl7 = true;
                            bl2 = false;
                        }
                        bl8 = true;
                        continue;
                    }
                    object32.setStatus(AttributeStatus.VALID);
                    bl8 = true;
                    continue;
                }
                object32.setStatus(AttributeStatus.MISSING);
                if (!bl7) {
                    this.addMessage("JSON_QUERY_REL_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                    bl7 = true;
                    bl2 = false;
                }
                bl8 = true;
            }
        }
        object2 = new ArrayList();
        if (bl3) {
            object32 = (JSONAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getJSONAttributes());
            object = new ComplexProperty(JSON_ATTRIBUTES, dataGuideProvider);
            ((ComplexProperty)object).setOldData(object32);
            object2.add(object);
        }
        if (bl5) {
            object32 = (AggregationElementsExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getAggregationElements());
            object = new ComplexProperty(AGGREGATION_ELEMENTS, object52);
            ((ComplexProperty)object).setOldData(object32);
            object2.add((ComplexProperty)object);
        }
        if (bl6) {
            object32 = (RelationalAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getRelationalAttributes());
            object = new ComplexProperty(RELATIONAL_ATTRIBUTES, object8);
            ((ComplexProperty)object).setOldData(object32);
            object2.add((ComplexProperty)object);
        }
        if (bl8) {
            object32 = (GroupingElementExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getGroupingElement());
            object = new ComplexProperty(GROUPING_ELEMENT, attributes3);
            ((ComplexProperty)object).setOldData(object32);
            object2.add((ComplexProperty)object);
        }
        object32 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        ((ComplexProperty)object32).setOldData(this.getSQLExpression());
        object2.add((Object)object32);
        object = (OdmrSDMUndoFilter)this.getUndoFilter();
        ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this, this.getContext(), (List<ComplexProperty>)object2);
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        if (jSONQueryNodeType.getSQLExpression() == null || jSONQueryNodeType.getSQLExpression().isEmpty()) {
            this.addMessage("JSON_QUERY_NO_OUTPUT", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return false;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        List<AbstractNode> list = this.findParentNodes();
        boolean bl = true;
        if (!this.allowMoreThanOneInputNode()) {
            bl = list.isEmpty();
        }
        if (bl) {
            bl = node instanceof DataProvider;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(node, true);
    }

    public boolean validateNodeRemoval(Node node, boolean bl) {
        return this.validate(bl);
    }

    @Override
    public String generateSQLExpression() {
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        return this.generateJSONQuery(false, jSONQueryNodeType.getJSONAttributes(), jSONQueryNodeType.getRelationalAttributes(), jSONQueryNodeType.getAggregationElements(), jSONQueryNodeType.getGroupingElement(), false);
    }

    public String getJSONDataSQLExpression(String string) {
        AbstractNode abstractNode;
        StringBuffer stringBuffer = new StringBuffer();
        List<AbstractNode> list = this.findSourceNodes();
        if (list.size() > 0 && (abstractNode = list.get(0)) instanceof DataProvider) {
            AbstractDataNode abstractDataNode = (AbstractDataNode)abstractNode;
            String string2 = abstractDataNode.getInputSQL(true, false);
            stringBuffer.append(string2 + "\n");
            stringBuffer.append("SELECT " + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(string)) + " FROM " + abstractNode.getNodeNameForSQLExpression(true));
            stringBuffer.insert(0, "WITH ");
        }
        return stringBuffer.toString();
    }

    @Override
    public void setProperty(String string, Object object) {
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        if (string.equals(JSON_ATTRIBUTES)) {
            JSONAttributesType jSONAttributesType = (JSONAttributesType)object;
            jSONQueryNodeType.setJSONAttributes(jSONAttributesType);
        } else if (string.equals(RELATIONAL_ATTRIBUTES)) {
            RelationalAttributesType relationalAttributesType = (RelationalAttributesType)object;
            jSONQueryNodeType.setRelationalAttributes(relationalAttributesType);
        } else if (string.equals(AGGREGATION_ELEMENTS)) {
            AggregationElementsExType aggregationElementsExType = (AggregationElementsExType)object;
            jSONQueryNodeType.setAggregationElements(aggregationElementsExType);
        } else if (string.equals(GROUPING_ELEMENT)) {
            GroupingElementExType groupingElementExType = (GroupingElementExType)object;
            jSONQueryNodeType.setGroupingElement(groupingElementExType);
        } else if (string.equals("SQL_EXPRESSION")) {
            if ("SQL_EXPRESSION_GENERATE".equals(object)) {
                jSONQueryNodeType.setSQLExpression(this.generateSQLExpression());
            } else {
                jSONQueryNodeType.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(JSON_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(RELATIONAL_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(AGGREGATION_ELEMENTS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(GROUPING_ELEMENT)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        if (string.equals(JSON_ATTRIBUTES)) {
            return jSONQueryNodeType.getJSONAttributes();
        }
        if (string.equals(RELATIONAL_ATTRIBUTES)) {
            return jSONQueryNodeType.getRelationalAttributes();
        }
        if (string.equals(AGGREGATION_ELEMENTS)) {
            return jSONQueryNodeType.getAggregationElements();
        }
        if (string.equals(GROUPING_ELEMENT)) {
            return jSONQueryNodeType.getGroupingElement();
        }
        if (string.equals("SQL_EXPRESSION")) {
            return jSONQueryNodeType.getSQLExpression();
        }
        return super.getProperty(string);
    }

    @Override
    public String getHelpTopic() {
        return "jsonquery_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_JSON_QUERY_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_JSON_QUERY_ICON"));
    }

    @Override
    public void refactorForApply() throws Exception {
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        super.refactor(node, bl);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        RelationalAttributesType relationalAttributesType = jSONQueryNodeType.getRelationalAttributes();
        RelationalAttributesType relationalAttributesType2 = (RelationalAttributesType)MetaDataHelper.copyMetadataObject(relationalAttributesType);
        List list = relationalAttributesType2.getAttribute();
        for (AttributeExType attributeExType : list) {
            AttributeType attributeType = map.get(attributeExType.getName());
            if (attributeType == null || attributeExType.getName().equals(attributeType.getName()) && attributeExType.getDataType().equals(attributeType.getDataType())) continue;
            String string = attributeExType.getName();
            AttributeExType attributeExType2 = null;
            if (attributeExType.getAlias() != null && !attributeExType.getAlias().trim().isEmpty()) {
                attributeExType2 = new AttributeType();
                attributeExType2.setName(attributeExType.getAlias());
                attributeExType2.setAlias(null);
                attributeExType2.setDataType(attributeType.getDataType());
                attributeExType2.setStatus(AttributeStatus.VALID);
                string = attributeExType.getAlias();
            } else {
                attributeExType2 = attributeExType;
            }
            attributeExType.setName(attributeType.getName());
            attributeExType.setDataType(attributeType.getDataType());
            hashMap.put(string, (AttributeType)attributeExType2);
        }
        if (!hashMap.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), RELATIONAL_ATTRIBUTES, relationalAttributesType2);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        if (!super.isVersionSupported(context, stringBuffer)) {
            return false;
        }
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        if (!ConfigUtils.isDatabaseVersion(DBVersions.V12_1_0_2, version, true)) {
            String string = MessageFormat.format(CodeGenLrb.get("VALIDATE_NODE_TYPE_NOT_SUPPORTED"), this.getDefaultName());
            stringBuffer.append(string);
            return false;
        }
        return true;
    }

    private DataGuideType subsetGuide(DataGuideType dataGuideType, String string) {
        DataGuideType dataGuideType2 = new DataGuideType();
        for (DataGuideType.Item item : dataGuideType.getItem()) {
            if (item.getPath().indexOf(string) != 0) continue;
            int n = string.indexOf(46);
            int n2 = string.lastIndexOf(46);
            if (n > 0 && n2 > 0) {
                String string2 = item.getPath().substring(0, n + 1);
                string2 = string2 + item.getPath().substring(n2 + 1, item.getPath().length());
                item.setPath(string2);
            }
            dataGuideType2.getItem().add(item);
        }
        return dataGuideType2;
    }

    @Override
    public DataGuideType getJSONAttrDataGuide(AttributeType attributeType, Integer n) {
        JSONAttributeType jSONAttributeType;
        DataGuideType dataGuideType = null;
        String string = null;
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        Object object = jSONQueryNodeType.getJSONAttributes().getJSONAttribute().iterator();
        while (object.hasNext()) {
            jSONAttributeType = (JSONAttributeType)object.next();
            if (!jSONAttributeType.getDataType().equalsIgnoreCase("ARRAY") && !jSONAttributeType.getDataType().equalsIgnoreCase("OBJECT") || !Boolean.FALSE.equals(jSONAttributeType.isUnnest()) || !jSONAttributeType.getDBName().equals(attributeType.getName())) continue;
            string = jSONAttributeType.getPath();
        }
        if (string != null && (object = (DataGuideProvider)((Object)this.findParentNode())) != null) {
            jSONAttributeType = new AttributeType();
            jSONAttributeType.setName(jSONQueryNodeType.getJSONAttributes().getSource());
            jSONAttributeType.setDataType(jSONQueryNodeType.getJSONAttributes().getDataType());
            dataGuideType = object.getJSONAttrDataGuide((AttributeType)jSONAttributeType, n);
            if (dataGuideType != null) {
                dataGuideType = this.subsetGuide(dataGuideType, string);
            }
        }
        return dataGuideType;
    }

    private List<JSONAttributeType> getJSONStructure(DataGuideType dataGuideType, List<JSONAttributeType> list) {
        ArrayList<JSONAttributeType> arrayList = new ArrayList<JSONAttributeType>();
        HashMap<String, JSONAttributeType> hashMap = new HashMap<String, JSONAttributeType>();
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        if (dataGuideType != null) {
            for (JSONAttributeType jSONAttributeType : list) {
                if (!hashMap.containsKey(jSONAttributeType.getPath())) {
                    hashMap.put(jSONAttributeType.getPath(), jSONAttributeType);
                    int n = jSONAttributeType.getPath().lastIndexOf(46);
                    String string = jSONAttributeType.getPath().substring(0, n);
                    if (hashMap2.containsKey(string)) continue;
                    for (DataGuideType.Item item : dataGuideType.getItem()) {
                        if (jSONAttributeType.getPath().indexOf(item.getPath()) != 0) continue;
                        if (!hashMap.containsKey(item.getPath())) {
                            JSONAttributeType jSONAttributeType2 = new JSONAttributeType();
                            jSONAttributeType2.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType(item.getType()));
                            jSONAttributeType2.setDBName(null);
                            jSONAttributeType2.setDataType(item.getType());
                            jSONAttributeType2.setPath(item.getPath());
                            jSONAttributeType2.setStatus(AttributeStatus.VALID);
                            jSONAttributeType2.setUnnest(Boolean.TRUE);
                            hashMap.put(item.getPath(), jSONAttributeType2);
                        }
                        if (hashMap2.containsKey(item.getPath())) continue;
                        hashMap2.put(item.getPath(), Boolean.TRUE);
                    }
                    continue;
                }
                hashMap.put(jSONAttributeType.getPath(), jSONAttributeType);
            }
        }
        arrayList.addAll(hashMap.values());
        return arrayList;
    }

    private JSONElement loadJSONModel(List<JSONAttributeType> list) {
        HashMap<String, JSONAttributeType> hashMap = new HashMap<String, JSONAttributeType>();
        HashMap<String, JSONElement> hashMap2 = new HashMap<String, JSONElement>();
        int n = 1;
        int n2 = 0;
        JSONElement jSONElement = JSONElement.createRootNode();
        hashMap2.put(JSONElement.JSON_ROOT_OBJECT_SYMBOL, jSONElement);
        for (JSONAttributeType object : list) {
            String string = object.getPath();
            hashMap.put(string, object);
        }
        Object object = jSONElement;
        for (JSONAttributeType jSONAttributeType : list) {
            Object object2;
            int n3;
            String string = jSONAttributeType.getPath();
            String string2 = jSONAttributeType.getDataType();
            JSONElement jSONElement2 = (JSONElement)((Object)hashMap2.get(string));
            if (jSONElement2 != null) {
                jSONElement2.setDataType(string2);
                continue;
            }
            String[] stringArray = DatabaseMetadataUtils.getJSONPathElements(string);
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = -1;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (n3 > 0) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(stringArray[n3]);
                object2 = (JSONElement)((Object)hashMap2.get(stringBuilder.toString()));
                if (object2 == null) {
                    n4 = n3;
                    break;
                }
                object = object2;
            }
            if (-1 == n4) continue;
            stringBuilder = new StringBuilder();
            for (n3 = 0; n3 < n4; ++n3) {
                object2 = stringArray[n3];
                if (n3 > 0) {
                    stringBuilder.append(".");
                }
                stringBuilder.append((String)object2);
            }
            for (n3 = n4; n3 < stringArray.length; ++n3) {
                object2 = stringArray[n3];
                stringBuilder.append("." + (String)object2);
                JSONElement jSONElement3 = new JSONElement(object2, ++n2);
                object.add((MutableTreeNode)((Object)jSONElement3));
                hashMap2.put(stringBuilder.toString(), jSONElement3);
                JSONAttributeType jSONAttributeType2 = (JSONAttributeType)hashMap.get(stringBuilder.toString());
                if (jSONAttributeType2 == null && ((String)object2).compareTo(JSONElement.JSON_ROOT_ARRAY_SYMBOL) == 0) {
                    jSONElement3.setDataType("ARRAY");
                    jSONElement3.setDBDataType("NotApplicable");
                    jSONElement3.setDBName(JSONElement.JSON_ROOT_ARRAY_SYMBOL);
                    jSONElement3.setUnnested(true);
                } else {
                    jSONElement3.setDataType(jSONAttributeType2.getDataType());
                    jSONElement3.setDBDataType(jSONAttributeType2.getDBDataType());
                    jSONElement3.setDBName(jSONAttributeType2.getDBName());
                    if (jSONAttributeType2.isUnnest() != null) {
                        jSONElement3.setUnnested(jSONAttributeType2.isUnnest());
                    }
                }
                object = jSONElement3;
                ++n;
            }
        }
        return jSONElement;
    }

    public String getStackSQLExpression(JSONAttributesType jSONAttributesType, RelationalAttributesType relationalAttributesType, AggregationElementsExType aggregationElementsExType, GroupingElementExType groupingElementExType) {
        return this.generateJSONQuery(true, jSONAttributesType, relationalAttributesType, aggregationElementsExType, groupingElementExType, false);
    }

    private String generateSourceQuery(String string, DataGuideType dataGuideType, String string2, List<JSONAttributeType> list, List<AttributeExType> list2, List<String> list3) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        String string3 = null;
        boolean bl = false;
        if (list != null && !list.isEmpty()) {
            Object object2;
            List<JSONAttributeType> list4 = this.getJSONStructure(dataGuideType, list);
            JSONElement jSONElement = this.loadJSONModel(list4);
            for (int i = 0; i < jSONElement.getChildCount(); ++i) {
                object2 = (JSONElement)((Object)jSONElement.getChildAt(i));
                String string4 = (String)object2.getValue(JSONElement.JSON_DB_ATTRIBUTE_COLUMN);
                if (string4.compareTo(JSONElement.JSON_ROOT_ARRAY_SYMBOL) != 0) continue;
                bl = true;
                break;
            }
            object = new HashMap<Integer, Integer>();
            object2 = new HashMap();
            this.generateJSONQueryHelper(2, (Map<Integer, Integer>)object, jSONElement, null, stringBuffer4, (Map<String, String>)object2);
            for (String string5 : object2.keySet()) {
                String string6;
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", \n");
                }
                if ((string6 = (String)object2.get(string5)) != null) {
                    stringBuffer2.append("'{'||'" + string6 + ":'||" + "t1." + string5 + "||'}' " + string5);
                } else {
                    stringBuffer2.append("t1." + string5);
                }
                list3.add(StringUtils.trimDoubleQuotes(string5));
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            for (AttributeExType attributeExType : list2) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", \n");
                }
                stringBuffer2.append("t0." + StringUtils.addDoubleQuotes(attributeExType.getName()));
                if (attributeExType.getAlias() != null) {
                    stringBuffer2.append(" " + StringUtils.addDoubleQuotes(attributeExType.getAlias()));
                }
                object = attributeExType.getAlias() == null ? attributeExType.getName() : attributeExType.getAlias();
                list3.add((String)object);
            }
        }
        stringBuffer.append("SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "\n");
        stringBuffer.append(stringBuffer2 + "\n");
        stringBuffer.append("FROM\n");
        stringBuffer3.append(string);
        stringBuffer3.append(" t0");
        if (stringBuffer4.length() > 0) {
            stringBuffer3.append(", \nJSON_TABLE (" + StringUtils.addDoubleQuotes(string2) + ", " + (bl ? "'$[*]'" : "'$'") + " COLUMNS");
            stringBuffer3.append(stringBuffer4);
            stringBuffer3.append("\n");
            stringBuffer3.append(") t1");
        }
        stringBuffer3.append("\n");
        stringBuffer.append(stringBuffer3);
        string3 = stringBuffer.toString();
        return string3;
    }

    private String getNodeNameForSQLExpressionWithSuffix(int n, boolean bl) {
        return this.getNodeNameForSQLExpressionInternal(bl, this.getMetadataId() + "_" + n);
    }

    /*
     * WARNING - void declaration
     */
    private String generateJSONQuery(boolean bl, JSONAttributesType jSONAttributesType, RelationalAttributesType relationalAttributesType, AggregationElementsExType aggregationElementsExType, GroupingElementExType groupingElementExType, boolean bl2) {
        Object object;
        Object object2;
        CharSequence charSequence22;
        AttributeExType attributeExType;
        String string;
        Object object322;
        Object object4;
        Object object522;
        DataGuideType dataGuideType;
        if (!(jSONAttributesType != null && !jSONAttributesType.getJSONAttribute().isEmpty() || relationalAttributesType != null && !relationalAttributesType.getAttribute().isEmpty() || aggregationElementsExType != null && !aggregationElementsExType.getAggregationElement().isEmpty())) {
            return null;
        }
        DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)this.findParentNode());
        if (dataGuideProvider == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "{INPUT_SOURCE}";
        String string3 = "\"N$RefNodeId\"";
        String string4 = null;
        if (bl) {
            dataGuideType = this.findSourceNodes();
            for (Object object522 : dataGuideType) {
                if (!(object522 instanceof AbstractDataNode)) continue;
                object4 = (AbstractDataNode)object522;
                string3 = StringUtils.getReplacedString(string3, "RefNodeId", ((AbstractNode)object522).getMetadataId());
                string4 = ((AbstractDataNode)object4).getInputSQL(true, false);
            }
        }
        stringBuffer.setLength(0);
        if (bl) {
            stringBuffer.append("WITH ");
            stringBuffer.append(string4);
        }
        dataGuideType = null;
        if (jSONAttributesType != null && jSONAttributesType.getSource() != null) {
            AttributeType attributeType = new AttributeType();
            attributeType.setName(jSONAttributesType.getSource());
            attributeType.setDataType(jSONAttributesType.getDataType());
            object522 = null;
            dataGuideType = dataGuideProvider.getJSONAttrDataGuide(attributeType, (Integer)object522);
        }
        int n = 0;
        object522 = new ArrayList();
        object4 = new ArrayList();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<JSONAttributeType> arrayList3 = new ArrayList<JSONAttributeType>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (relationalAttributesType != null && !relationalAttributesType.getAttribute().isEmpty()) {
            object4.addAll(relationalAttributesType.getAttribute());
        }
        if (jSONAttributesType != null && !jSONAttributesType.getJSONAttribute().isEmpty()) {
            object522.addAll(jSONAttributesType.getJSONAttribute());
        }
        if (!(groupingElementExType == null || groupingElementExType.getAttributes() == null || groupingElementExType.getAttributes().getJSONAttribute().isEmpty() && groupingElementExType.getAttributes().getAttribute().isEmpty())) {
            arrayList.addAll(groupingElementExType.getAttributes().getJSONAttribute());
            arrayList2.addAll(groupingElementExType.getAttributes().getAttribute());
            arrayList3.addAll(groupingElementExType.getAttributes().getJSONAttribute());
        }
        if (groupingElementExType != null && groupingElementExType.getAttributes() != null) {
            boolean bl3;
            if (!groupingElementExType.getAttributes().getAttribute().isEmpty()) {
                for (Object object322 : groupingElementExType.getAttributes().getAttribute()) {
                    bl3 = false;
                    string = object322.getAlias() != null ? object322.getAlias() : object322.getName();
                    attributeExType = object4.iterator();
                    while (attributeExType.hasNext()) {
                        charSequence22 = (AttributeExType)attributeExType.next();
                        object2 = charSequence22.getAlias() != null ? charSequence22.getAlias() : charSequence22.getName();
                        if (string.compareTo((String)object2) != 0) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    attributeExType = new AttributeExType();
                    attributeExType.setName(string);
                    attributeExType.setAlias(null);
                    attributeExType.setDataType(object322.getDataType());
                    attributeExType.setNewDataType(object322.getNewDataType());
                    attributeExType.setStatus(object322.getStatus());
                    object4.add(attributeExType);
                }
            } else if (!groupingElementExType.getAttributes().getJSONAttribute().isEmpty()) {
                for (Object object322 : groupingElementExType.getAttributes().getJSONAttribute()) {
                    bl3 = false;
                    string = object322.getDBName();
                    attributeExType = object522.iterator();
                    while (attributeExType.hasNext()) {
                        charSequence22 = (JSONAttributeType)attributeExType.next();
                        object2 = charSequence22.getDBName();
                        if (string.compareTo((String)object2) != 0) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    attributeExType = new JSONAttributeType();
                    attributeExType.setDBName(string);
                    attributeExType.setPath(object322.getPath());
                    attributeExType.setDataType(object322.getDataType());
                    attributeExType.setDBDataType(object322.getDBDataType());
                    attributeExType.setStatus(object322.getStatus());
                    object522.add(attributeExType);
                }
            }
        }
        Object object6 = null;
        object322 = null;
        if (jSONAttributesType != null && !jSONAttributesType.getJSONAttribute().isEmpty() || relationalAttributesType != null && relationalAttributesType.getAttribute() != null && !relationalAttributesType.getAttribute().isEmpty()) {
            object6 = this.generateSourceQuery(bl ? string3 : string2, dataGuideType, jSONAttributesType == null ? null : jSONAttributesType.getSource(), (List<JSONAttributeType>)object522, (List<AttributeExType>)object4, arrayList4);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",\n");
            }
            object322 = this.getNodeNameForSQLExpressionWithSuffix(++n, true);
            stringBuffer.append((String)object322 + " as (" + (String)object6 + ")\n");
        }
        String string5 = null;
        string = null;
        if (aggregationElementsExType != null && !aggregationElementsExType.getAggregationElement().isEmpty()) {
            for (CharSequence charSequence22 : aggregationElementsExType.getAggregationElement()) {
                object2 = charSequence22.getOutput();
                object = charSequence22.getJSONAttribute();
                arrayList3.add((JSONAttributeType)object);
                if (charSequence22.getSubGroupBy().getAttributes() == null || charSequence22.getSubGroupBy().getAttributes().getJSONAttribute().isEmpty()) continue;
                for (Object object3 : charSequence22.getSubGroupBy().getAttributes().getJSONAttribute()) {
                    arrayList3.add((JSONAttributeType)object3);
                }
            }
            attributeExType = new ArrayList();
            charSequence22 = this.generateSourceQuery(bl ? string3 : string2, dataGuideType, jSONAttributesType == null ? null : jSONAttributesType.getSource(), arrayList3, (List<AttributeExType>)object4, (List<String>)attributeExType);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",\n");
            }
            string5 = this.getNodeNameForSQLExpressionWithSuffix(++n, true);
            stringBuffer.append(string5 + " as (" + (String)charSequence22 + ")\n");
            object6 = this.generateAggregationQuery(string5, groupingElementExType, aggregationElementsExType, string5, false);
            string = this.getNodeNameForSQLExpressionWithSuffix(++n, true);
            stringBuffer.append(",\n");
            stringBuffer.append(string + " as (" + (String)object6 + ")\n");
        }
        if (arrayList.isEmpty() && object4.isEmpty()) {
            attributeExType = new StringBuilder("SELECT * FROM ");
            if (object322 != null) {
                attributeExType.append((String)object322);
            }
            if (string != null) {
                if (object322 != null) {
                    attributeExType.append(", ");
                }
                attributeExType.append(string);
            }
            object6 = attributeExType.toString();
        } else {
            String string62;
            attributeExType = new StringBuilder();
            charSequence22 = new StringBuilder();
            object2 = new HashMap();
            for (String string7 : arrayList4) {
                if (((StringBuilder)charSequence22).length() > 0) {
                    ((StringBuilder)charSequence22).append(", ");
                }
                ((StringBuilder)charSequence22).append("t0." + StringUtils.addDoubleQuotes(string7));
                object2.put(string7, Boolean.TRUE);
            }
            object = new StringBuilder();
            if (aggregationElementsExType != null && !aggregationElementsExType.getAggregationElement().isEmpty()) {
                for (Object object3 : aggregationElementsExType.getAggregationElement()) {
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    string62 = object3.getOutput().getAlias() != null ? object3.getOutput().getAlias() : object3.getOutput().getName();
                    ((StringBuilder)object).append("t1." + StringUtils.addDoubleQuotes(string62));
                }
            }
            if (groupingElementExType != null && groupingElementExType.getAttributes() != null) {
                for (Object object3 : groupingElementExType.getAttributes().getAttribute()) {
                    string62 = object3.getAlias() != null ? object3.getAlias() : object3.getName();
                    if (object2.containsKey(string62)) continue;
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append("t1." + StringUtils.addDoubleQuotes(string62));
                    object2.put(string62, Boolean.TRUE);
                }
                for (Object object3 : groupingElementExType.getAttributes().getJSONAttribute()) {
                    string62 = object3.getDBName();
                    if (object2.containsKey(string62)) continue;
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append("t1." + StringUtils.addDoubleQuotes(string62));
                    object2.put(string62, Boolean.TRUE);
                }
            }
            attributeExType.append("  SELECT ");
            if (((StringBuilder)charSequence22).length() > 0) {
                attributeExType.append(charSequence22);
            }
            if (((StringBuilder)object).length() > 0) {
                if (((StringBuilder)charSequence22).length() > 0) {
                    attributeExType.append(", ");
                }
                attributeExType.append((CharSequence)object);
            }
            attributeExType.append("\n");
            attributeExType.append("  FROM ");
            if (object322 != null) {
                attributeExType.append((String)object322 + " t0");
            }
            if (string != null) {
                if (object322 != null) {
                    attributeExType.append(", ");
                }
                attributeExType.append(string + " t1 \n");
            } else if (string5 != null) {
                if (object322 != null) {
                    attributeExType.append(", ");
                }
                attributeExType.append(string5 + " t1 \n");
            }
            if (object322 != null && (string5 != null || string5 != null)) {
                String string8;
                attributeExType.append("  WHERE ");
                boolean bl3 = false;
                for (String string62 : arrayList2) {
                    void var28_39;
                    if (var28_39 > 0) {
                        attributeExType.append("\n  AND ");
                    }
                    string8 = string62.getAlias() != null ? string62.getAlias() : string62.getName();
                    string8 = StringUtils.addDoubleQuotes(string8);
                    attributeExType.append("t0." + string8 + " = t1." + string8);
                    ++var28_39;
                }
                if (!arrayList.isEmpty()) {
                    for (String string62 : arrayList) {
                        void var28_40;
                        if (var28_40 > 0) {
                            attributeExType.append("\n  AND ");
                        }
                        string8 = StringUtils.addDoubleQuotes(string62.getDBName());
                        attributeExType.append("t0." + string8 + " = t1." + string8);
                        ++var28_40;
                    }
                }
            }
            object6 = attributeExType.toString();
        }
        stringBuffer.append(",\n");
        stringBuffer.append(this.getNodeNameForSQLExpression(true) + " as (" + (String)object6 + ")\n");
        if (bl) {
            stringBuffer.append("SELECT * FROM " + this.getNodeNameForSQLExpression(true));
        }
        return stringBuffer.toString();
    }

    private String indentation(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private void generateJSONQueryHelper(int n, Map<Integer, Integer> map, JSONElement jSONElement, String string, StringBuffer stringBuffer, Map<String, String> map2) {
        String string2 = null;
        for (int i = 0; i < jSONElement.getChildCount(); ++i) {
            JSONElement jSONElement2 = (JSONElement)((Object)jSONElement.getChildAt(i));
            String string3 = (String)jSONElement2.getValue(JSONElement.JSON_ATTRIBUTE_COLUMN);
            string3 = StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(string3));
            String string4 = (String)jSONElement2.getValue(JSONElement.JSON_DATA_COLUMN);
            Object object = jSONElement2.getValue(JSONElement.JSON_UNNESTED_COLUMN);
            Boolean bl = object == null || "".equals(object) ? Boolean.FALSE : (Boolean)object;
            String string5 = (String)jSONElement2.getValue(JSONElement.JSON_DB_ATTRIBUTE_COLUMN);
            if (string5.compareTo(JSONElement.JSON_ROOT_ARRAY_SYMBOL) != 0) {
                Integer n2;
                string5 = StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(string5.toUpperCase()));
                String string6 = (String)jSONElement2.getValue(JSONElement.JSON_DB_DATA_COLUMN);
                if (string4.compareToIgnoreCase("BOOLEAN") == 0) {
                    string6 = string6 + " EXISTS";
                }
                if (string4.compareToIgnoreCase("ARRAY") == 0) {
                    n2 = map.get(n);
                    if (n2 == null) {
                        n2 = 0;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(",\n");
                    } else {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(this.indentation(n));
                    if (Boolean.TRUE.equals(bl)) {
                        stringBuffer.append("NESTED PATH '$." + (string != null ? string + "." + string3 : string3) + "[*]' COLUMNS (");
                        n2 = n2 + 1;
                        map.put(n, n2);
                        map.put(n += 2, 0);
                        string2 = null;
                    } else {
                        stringBuffer.append(string5 + " " + "VARCHAR2" + " FORMAT JSON WITH CONDITIONAL WRAPPER PATH '$." + (string != null ? string + "." + string3 : string3) + "'");
                        map2.put(string5, string3);
                        n2 = n2 + 1;
                        map.put(n, n2);
                    }
                } else if (string4.compareToIgnoreCase("OBJECT") == 0) {
                    string2 = string != null ? string + '.' + string3 : string3;
                } else {
                    n2 = map.get(n);
                    if (n2 == null) {
                        n2 = 0;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(",\n");
                    } else {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(this.indentation(n));
                    stringBuffer.append(string5 + " " + string6 + " PATH '$." + (string != null ? string + "." + string3 : string3) + "'");
                    map2.put(string5, null);
                    n2 = n2 + 1;
                    map.put(n, n2);
                }
                if (string4.compareToIgnoreCase("ARRAY") == 0) {
                    if (!Boolean.TRUE.equals(bl)) continue;
                    if (jSONElement2.getChildCount() > 0) {
                        this.generateJSONQueryHelper(n, map, jSONElement2, string2, stringBuffer, map2);
                    } else {
                        stringBuffer.append("\n");
                        stringBuffer.append(this.indentation(n));
                        stringBuffer.append(string5 + " " + "VARCHAR2" + " PATH '$'");
                        map2.put(string5, null);
                    }
                    stringBuffer.append("\n");
                    stringBuffer.append(this.indentation(n -= 2));
                    stringBuffer.append(")");
                    continue;
                }
                this.generateJSONQueryHelper(n, map, jSONElement2, string2, stringBuffer, map2);
                continue;
            }
            this.generateJSONQueryHelper(n, map, jSONElement2, string2, stringBuffer, map2);
        }
    }

    public static String mainGroupBytoString(GroupingElementExType groupingElementExType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementExType.getAttributes() && null != groupingElementExType.getAttributes().getAttribute()) {
            Object object2;
            List list = groupingElementExType.getAttributes().getAttribute();
            for (Object object2 : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName((AttributeType)object2));
            }
            List list2 = groupingElementExType.getAttributes().getJSONAttribute();
            object2 = list2.iterator();
            while (object2.hasNext()) {
                JSONAttributeType jSONAttributeType = (JSONAttributeType)object2.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(jSONAttributeType.getDBName()));
            }
        }
        return stringBuffer.toString();
    }

    private static String convertJSONGroupingElementTypetoSQL(AggregationElementsExType.AggregationElement.SubGroupBy subGroupBy) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != subGroupBy.getAttributes() && null != subGroupBy.getAttributes().getJSONAttribute()) {
            List list = subGroupBy.getAttributes().getJSONAttribute();
            for (JSONAttributeType jSONAttributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" || ");
                    stringBuffer.append("'");
                    stringBuffer.append(" - ");
                    stringBuffer.append("'");
                    stringBuffer.append(" || ");
                } else {
                    stringBuffer.append("(");
                }
                stringBuffer.append(jSONAttributeType.getDBName());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private static String convertJSONGroupingElementTypetoSQL(GroupingElementExType groupingElementExType, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementExType.getAttributes() && null != groupingElementExType.getAttributes().getAttribute()) {
            List list;
            if (!groupingElementExType.getAttributes().getJSONAttribute().isEmpty()) {
                list = groupingElementExType.getAttributes().getJSONAttribute();
                for (JSONAttributeType jSONAttributeType : list) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string);
                    stringBuffer.append(".");
                    stringBuffer.append(jSONAttributeType.getDBName());
                }
            }
            if (!groupingElementExType.getAttributes().getAttribute().isEmpty()) {
                list = groupingElementExType.getAttributes().getAttribute();
                for (JSONAttributeType jSONAttributeType : list) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string);
                    stringBuffer.append(".");
                    stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName((AttributeType)jSONAttributeType));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String convertAggregationElementSourcetoSQL(Context context, AggregationElementsExType.AggregationElement aggregationElement) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = aggregationElement.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
        JSONAttributeType jSONAttributeType = aggregationElement.getJSONAttribute();
        String string = aggregationElement.getAggregationFunction();
        int n = string.indexOf("()");
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
        stringBuilder.append("(");
        stringBuilder.append(jSONAttributeType.getDBName());
        if (bl) {
            String string2 = AttributeTypeHelper.getNestedCategoricalType(context, jSONAttributeType.getDBDataType());
            stringBuilder.append(") AS " + string2);
            stringBuilder.append(string.substring(n + 2, string.length()));
        } else {
            stringBuilder.append(string.substring(n + 1, string.length()));
        }
        stringBuffer.append((CharSequence)stringBuilder);
        stringBuffer.append(" ");
        stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(aggregationElement.getOutput()));
        return stringBuffer.toString();
    }

    private static String convertGroupingElementTypetoWhereClause(GroupingElementExType groupingElementExType, String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != groupingElementExType.getAttributes()) {
            StringBuilder stringBuilder2;
            List list2;
            if (!groupingElementExType.getAttributes().getAttribute().isEmpty()) {
                list2 = groupingElementExType.getAttributes().getAttribute();
                for (AttributeType attributeType : list2) {
                    stringBuilder2 = new StringBuilder();
                    for (String string2 : list) {
                        if (string2.equals(string)) continue;
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(" AND ");
                        }
                        stringBuilder2.append(string);
                        stringBuilder2.append(".");
                        stringBuilder2.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                        stringBuilder2.append(" = ");
                        stringBuilder2.append(string2);
                        stringBuilder2.append(".");
                        stringBuilder2.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                        stringBuilder2.append("(+)\n");
                    }
                    if (stringBuilder2.length() <= 0) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" AND ");
                    } else {
                        stringBuilder.append(" WHERE ");
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            }
            if (!groupingElementExType.getAttributes().getJSONAttribute().isEmpty()) {
                list2 = groupingElementExType.getAttributes().getJSONAttribute();
                for (AttributeType attributeType : list2) {
                    stringBuilder2 = new StringBuilder();
                    for (String string2 : list) {
                        if (string2.equals(string)) continue;
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(" AND ");
                        }
                        stringBuilder2.append(string);
                        stringBuilder2.append(".");
                        stringBuilder2.append(attributeType.getDBName());
                        stringBuilder2.append(" = ");
                        stringBuilder2.append(string2);
                        stringBuilder2.append(".");
                        stringBuilder2.append(attributeType.getDBName());
                        stringBuilder2.append("(+)\n");
                    }
                    if (stringBuilder2.length() <= 0) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" AND ");
                    } else {
                        stringBuilder.append(" WHERE ");
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String generateAggregationQuery(String string, GroupingElementExType groupingElementExType, AggregationElementsExType aggregationElementsExType, String string2, boolean bl) {
        String string322;
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        Object object422;
        boolean bl3 = null == groupingElementExType.getAttributes() || groupingElementExType.getAttributes().getAttribute().isEmpty() && groupingElementExType.getAttributes().getJSONAttribute().isEmpty();
        String string4 = AttributeTypeHelper.getHint(this.getContext());
        List list = aggregationElementsExType.getAggregationElement();
        String string5 = JSONQueryNode.mainGroupBytoString(groupingElementExType);
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<AggregationElementsExType.AggregationElement> arrayList2 = new ArrayList<AggregationElementsExType.AggregationElement>();
        int n = 0;
        for (Object object422 : list) {
            object3 = object422.getSubGroupBy();
            object2 = null;
            if (AttributeTypeHelper.isJSONSubGropByPresent((AggregationElementsExType.AggregationElement.SubGroupBy)object3)) {
                object = JSONQueryNode.convertJSONGroupingElementTypetoSQL((AggregationElementsExType.AggregationElement.SubGroupBy)object3);
                object2 = (AggregationJSONSQLElement)hashMap.get(object);
                if (null == object2) {
                    object2 = new AggregationJSONSQLElement((AggregationElementsExType.AggregationElement)object422);
                    hashMap.put((String)object, object2);
                    arrayList.add(object2);
                    ((AggregationJSONSQLElement)object2).sourceTable = string;
                    ((AggregationJSONSQLElement)object2).sqlSubGroupBy = (String)object;
                    ((AggregationJSONSQLElement)object2).idString = "ID" + ++n;
                    ((AggregationJSONSQLElement)object2).tableAlias = " t" + String.valueOf(n - 1);
                    ((AggregationJSONSQLElement)object2).sb.append("  (SELECT ");
                    ((AggregationJSONSQLElement)object2).sb.append(string5);
                } else {
                    ((AggregationJSONSQLElement)object2).addSourceAttr((AggregationElementsExType.AggregationElement)object422);
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl4 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MODE.toString());
                boolean bl5 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MAX.toString());
                bl2 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MIN.toString());
                boolean bl6 = null != object422.getAggregationFunction() && (object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT.toString()) || object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT_DISTINCT.toString()));
                string322 = null;
                String string6 = null;
                if (bl4 || bl5 || bl2) {
                    JSONAttributeType jSONAttributeType = object422.getJSONAttribute();
                    if (jSONAttributeType.getDBDataType().equals("VARCHAR2") || jSONAttributeType.getDBDataType().equals("CHAR") || jSONAttributeType.getDBDataType().equals("NVARCHAR2") || jSONAttributeType.getDBDataType().equals("NCHAR")) {
                        string322 = "\n\tCAST(COLLECT(DM_NESTED_CATEGORICAL(";
                        string6 = ")) AS DM_NESTED_CATEGORICALS) ";
                    } else if (jSONAttributeType.getDBDataType().equals("NUMBER") || jSONAttributeType.getDBDataType().equals("FLOAT") || jSONAttributeType.getDBDataType().equals("BINARY_DOUBLE") || jSONAttributeType.getDBDataType().equals("BINARY_FLOAT")) {
                        string322 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                        string6 = ")) AS DM_NESTED_NUMERICALS) ";
                    }
                } else if (bl6) {
                    string322 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                    string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                } else {
                    boolean bl7;
                    boolean bl8 = bl7 = object3.getAttributes() != null && object3.getAttributes().getJSONAttribute() != null && !object3.getAttributes().getJSONAttribute().isEmpty();
                    if (bl7) {
                        String string7 = ((JSONAttributeType)object3.getAttributes().getJSONAttribute().get(0)).getDBDataType();
                        if (string7.equals("BINARY_FLOAT")) {
                            string322 = "\n\tCAST(COLLECT(DM_NESTED_BINARY_FLOAT(";
                            string6 = ")) AS DM_NESTED_BINARY_FLOATS  ) ";
                        } else if (string7.equals("BINARY_DOUBLE")) {
                            string322 = "\n\tCAST(COLLECT(DM_NESTED_BINARY_DOUBLE(";
                            string6 = ")) AS DM_NESTED_BINARY_DOUBLES  ) ";
                        } else {
                            string322 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                            string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                        }
                    } else {
                        string322 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                        string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                    }
                }
                if (string322 != null) {
                    stringBuilder.append(string322);
                }
                stringBuilder.append(((AggregationJSONSQLElement)object2).idString);
                stringBuilder.append(", ");
                stringBuilder.append(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                if (string6 != null) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(" " + AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                ((AggregationJSONSQLElement)object2).nestedElement.add(stringBuilder.toString());
                ((AggregationJSONSQLElement)object2).internalResultColumns.add(JSONQueryNode.convertAggregationElementSourcetoSQL(this.getContext(), (AggregationElementsExType.AggregationElement)object422));
                ((AggregationJSONSQLElement)object2).resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                continue;
            }
            if (!bl) {
                arrayList2.add((AggregationElementsExType.AggregationElement)object422);
                continue;
            }
            ++n;
            object2 = new AggregationJSONSQLElement((AggregationElementsExType.AggregationElement)object422);
            arrayList.add(object2);
            ((AggregationJSONSQLElement)object2).sourceTable = string;
            ((AggregationJSONSQLElement)object2).tableAlias = " t" + String.valueOf(n - 1);
            ((AggregationJSONSQLElement)object2).resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
            ((AggregationJSONSQLElement)object2).sb.append("  (SELECT ");
            ((AggregationJSONSQLElement)object2).sb.append(string4);
            ((AggregationJSONSQLElement)object2).sb.append(string5);
            if (!bl3) {
                ((AggregationJSONSQLElement)object2).sb.append(", ");
            }
            ((AggregationJSONSQLElement)object2).sb.append(JSONQueryNode.convertAggregationElementSourcetoSQL(this.getContext(), (AggregationElementsExType.AggregationElement)object422));
            if (bl) {
                ((AggregationJSONSQLElement)object2).sb.append("\n\tFROM (");
                ((AggregationJSONSQLElement)object2).sb.append(string);
                ((AggregationJSONSQLElement)object2).sb.append(") ");
            } else {
                ((AggregationJSONSQLElement)object2).sb.append("\n\tFROM " + string2 + " " + ((AggregationJSONSQLElement)object2).getSourceColumnWhereClause(true) + " ");
            }
            if (!bl3) {
                ((AggregationJSONSQLElement)object2).sb.append("\n\tGROUP BY ");
                ((AggregationJSONSQLElement)object2).sb.append(string5);
            }
            ((AggregationJSONSQLElement)object2).sb.append(")");
            ((AggregationJSONSQLElement)object2).sb.append(((AggregationJSONSQLElement)object2).tableAlias);
        }
        AggregationJSONSQLElement aggregationJSONSQLElement = JSONQueryNode.aggregateWithoutSubGroupBy(this.getContext(), arrayList2, n, string5, bl3, string2, string4);
        if (null != aggregationJSONSQLElement) {
            arrayList.add(aggregationJSONSQLElement);
        }
        object422 = new StringBuilder("SELECT ");
        object3 = new StringBuilder();
        Object object4 = object2 = arrayList.isEmpty() ? AttributeTypeHelper.getMaintable_alias() : ((AggregationJSONSQLElement)arrayList.get(0)).tableAlias;
        if (!arrayList.isEmpty()) {
            ((StringBuilder)object422).append(JSONQueryNode.convertJSONGroupingElementTypetoSQL(groupingElementExType, (String)object2));
        } else {
            ((StringBuilder)object422).append(JSONQueryNode.mainGroupBytoString(groupingElementExType));
        }
        object = new ArrayList();
        boolean bl9 = !bl3 && !arrayList.isEmpty();
        for (AggregationJSONSQLElement aggregationJSONSQLElement2 : arrayList) {
            for (Iterator iterator : aggregationJSONSQLElement2.resultColumns) {
                if (bl9) {
                    ((StringBuilder)object422).append(", ");
                }
                ((StringBuilder)object422).append("\n");
                ((StringBuilder)object422).append(aggregationJSONSQLElement2.tableAlias);
                ((StringBuilder)object422).append(".");
                ((StringBuilder)object422).append((String)((Object)iterator));
                if (bl9) continue;
                bl9 = true;
            }
            if (((StringBuilder)object3).length() > 0) {
                ((StringBuilder)object3).append(",\n");
            }
            ((StringBuilder)object3).append((CharSequence)aggregationJSONSQLElement2.sb);
            boolean bl10 = bl2 = !bl3 && !aggregationJSONSQLElement2.nestedElement.isEmpty();
            if (!aggregationJSONSQLElement2.nestedElement.isEmpty()) {
                Iterator iterator;
                for (String string322 : aggregationJSONSQLElement2.nestedElement) {
                    if (bl2) {
                        ((StringBuilder)object3).append(", ");
                    }
                    ((StringBuilder)object3).append(string322);
                    if (bl2) continue;
                    bl2 = true;
                }
                ((StringBuilder)object3).append("\n\tFROM\n");
                ((StringBuilder)object3).append("\t\t(SELECT ");
                ((StringBuilder)object3).append(string4);
                ((StringBuilder)object3).append(" ");
                ((StringBuilder)object3).append(string5);
                if (!bl3) {
                    ((StringBuilder)object3).append(",");
                }
                ((StringBuilder)object3).append("\n\t\t");
                ((StringBuilder)object3).append(aggregationJSONSQLElement2.sqlSubGroupBy + " ");
                ((StringBuilder)object3).append(aggregationJSONSQLElement2.idString);
                iterator = aggregationJSONSQLElement2.internalResultColumns.iterator();
                while (iterator.hasNext()) {
                    string322 = (String)iterator.next();
                    ((StringBuilder)object3).append(",\n\t\t");
                    ((StringBuilder)object3).append(string322);
                }
                if (bl) {
                    ((StringBuilder)object3).append("\n\t\tFROM (");
                    ((StringBuilder)object3).append(aggregationJSONSQLElement2.sourceTable);
                    ((StringBuilder)object3).append(") ");
                } else {
                    ((StringBuilder)object3).append("\n\t\tFROM " + string2 + " " + aggregationJSONSQLElement2.getSourceColumnWhereClause(true) + " ");
                }
                ((StringBuilder)object3).append("\n\t\tGROUP BY ");
                ((StringBuilder)object3).append(string5);
                if (!bl3) {
                    ((StringBuilder)object3).append(", ");
                }
                ((StringBuilder)object3).append("(");
                ((StringBuilder)object3).append(aggregationJSONSQLElement2.sqlSubGroupBy);
                ((StringBuilder)object3).append(") ");
                ((StringBuilder)object3).append(")");
                ((StringBuilder)object3).append("\n\t ");
                if (!bl3) {
                    ((StringBuilder)object3).append("GROUP BY ");
                }
                ((StringBuilder)object3).append(string5);
                ((StringBuilder)object3).append(") ");
                ((StringBuilder)object3).append(aggregationJSONSQLElement2.tableAlias);
            }
            object.add(aggregationJSONSQLElement2.tableAlias);
        }
        if (arrayList.isEmpty()) {
            if (bl) {
                ((StringBuilder)object3).append(" (");
                ((StringBuilder)object3).append(string);
                ((StringBuilder)object3).append(") ");
            } else {
                ((StringBuilder)object3).append(string2 + " ");
            }
            ((StringBuilder)object3).append("\nGROUP BY ");
            ((StringBuilder)object3).append(string5);
        }
        ((StringBuilder)object422).append("\nFROM\n");
        ((StringBuilder)object422).append((CharSequence)object3);
        ((StringBuilder)object422).append("\n");
        String string8 = object.isEmpty() ? AttributeTypeHelper.getMaintable_alias() : (String)object.get(0);
        ((StringBuilder)object422).append(JSONQueryNode.convertGroupingElementTypetoWhereClause(groupingElementExType, string8, (List<String>)object));
        return ((StringBuilder)object422).toString();
    }

    private static AggregationJSONSQLElement aggregateWithoutSubGroupBy(Context context, List<AggregationElementsExType.AggregationElement> list, int n, String string, boolean bl, String string2, String string3) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        AggregationJSONSQLElement aggregationJSONSQLElement = new AggregationJSONSQLElement();
        aggregationJSONSQLElement.tableAlias = " t" + String.valueOf(n);
        aggregationJSONSQLElement.sb = new StringBuilder("  (SELECT ");
        aggregationJSONSQLElement.sb.append(string3);
        aggregationJSONSQLElement.sb.append(string);
        if (!bl) {
            aggregationJSONSQLElement.sb.append(", ");
        }
        StringBuilder stringBuilder = null;
        int n2 = 0;
        for (AggregationElementsExType.AggregationElement aggregationElement : list) {
            AggregationJSONSQLElement aggregationJSONSQLElement2 = new AggregationJSONSQLElement(aggregationElement);
            aggregationJSONSQLElement.sb.append("\n    ");
            if (n2 > 0) {
                aggregationJSONSQLElement.sb.append(",");
            }
            aggregationJSONSQLElement.resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(aggregationElement.getOutput().getName()));
            aggregationJSONSQLElement.sb.append(JSONQueryNode.convertAggregationElementSourcetoSQL(context, aggregationElement));
            ++n2;
            String string4 = aggregationJSONSQLElement2.getSourceColumnWhereClause(false);
            if (string4 == null || string4.isEmpty()) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder("WHERE ");
            } else {
                stringBuilder.append("\n    AND ");
            }
            stringBuilder.append(string4 + " ");
        }
        Object object = "";
        if (stringBuilder != null) {
            object = stringBuilder.toString();
        }
        aggregationJSONSQLElement.sb.append("\n  FROM " + string2 + "\n  " + (String)object + " ");
        if (!bl) {
            aggregationJSONSQLElement.sb.append("\n  GROUP BY ");
            aggregationJSONSQLElement.sb.append(string);
        }
        aggregationJSONSQLElement.sb.append(")");
        aggregationJSONSQLElement.sb.append(aggregationJSONSQLElement.tableAlias);
        return aggregationJSONSQLElement;
    }

    private static class AggregationJSONSQLElement {
        private List<JSONAttributeType> sourceAttrs;
        private String sqlSubGroupBy;
        private StringBuilder sb = new StringBuilder();
        private List<String> nestedElement = new ArrayList<String>();
        private String tableAlias;
        private List<String> resultColumns = new ArrayList<String>();
        private List<String> internalResultColumns = new ArrayList<String>();
        private String idString;
        private String sourceTable;

        AggregationJSONSQLElement() {
        }

        AggregationJSONSQLElement(AggregationElementsExType.AggregationElement aggregationElement) {
            this.sourceAttrs = new ArrayList<JSONAttributeType>();
            this.sourceAttrs.add(aggregationElement.getJSONAttribute());
        }

        void addSourceAttr(AggregationElementsExType.AggregationElement aggregationElement) {
            if (this.sourceAttrs == null) {
                this.sourceAttrs = new ArrayList<JSONAttributeType>();
            }
            this.sourceAttrs.add(aggregationElement.getJSONAttribute());
        }

        String getSourceColumnWhereClause(boolean bl) {
            return "";
        }
    }

    public static class ColumnNameGenerator {
        private HashMap<String, String> _columnNames = new HashMap();
        private int MAX_COLUMN_LEN = 30;

        public ColumnNameGenerator(JSONAttributesType jSONAttributesType, RelationalAttributesType relationalAttributesType, AggregationElementsExType aggregationElementsExType, GroupingElementExType groupingElementExType) {
            String string;
            String string2;
            if (jSONAttributesType != null) {
                for (JSONAttributeType jSONAttributeType : jSONAttributesType.getJSONAttribute()) {
                    string2 = jSONAttributeType.getDBName();
                    string = jSONAttributeType.getPath();
                    this._columnNames.put(string2, string);
                }
            }
            if (relationalAttributesType != null) {
                for (JSONAttributeType jSONAttributeType : relationalAttributesType.getAttribute()) {
                    string2 = jSONAttributeType.getAlias() == null ? jSONAttributeType.getName() : jSONAttributeType.getAlias();
                    string = jSONAttributeType.getName();
                    this._columnNames.put(string2, string);
                }
            }
            if (aggregationElementsExType != null) {
                for (JSONAttributeType jSONAttributeType : aggregationElementsExType.getAggregationElement()) {
                    string2 = jSONAttributeType.getOutput().getName();
                    string = jSONAttributeType.getJSONAttribute().getPath() + ":" + jSONAttributeType.getAggregationFunction();
                    this._columnNames.put(string2, string);
                }
            }
            if (groupingElementExType != null && groupingElementExType.getAttributes() != null) {
                for (JSONAttributeType jSONAttributeType : groupingElementExType.getAttributes().getJSONAttribute()) {
                    string2 = jSONAttributeType.getDBName();
                    string = jSONAttributeType.getPath();
                    this._columnNames.put(string2, string);
                }
                for (JSONAttributeType jSONAttributeType : groupingElementExType.getAttributes().getAttribute()) {
                    string2 = jSONAttributeType.getAlias() == null ? jSONAttributeType.getName() : jSONAttributeType.getAlias();
                    string = jSONAttributeType.getName();
                    this._columnNames.put(string2, string);
                }
            }
        }

        private String getUniqueName(String string, String string2) {
            int n = 0;
            String string3 = null;
            String string4 = string;
            String string5 = null;
            for (Map.Entry<String, String> entry : this._columnNames.entrySet()) {
                if (!string2.equals(entry.getValue())) continue;
                string5 = entry.getKey();
                break;
            }
            if (string5 != null) {
                return string5;
            }
            string3 = this._columnNames.get(string);
            if (string3 == null) {
                this._columnNames.put(string, string2);
                return string;
            }
            while (this._columnNames.containsKey(string4)) {
                string4 = string + ++n;
                int n2 = string4.length();
                if (n2 <= this.MAX_COLUMN_LEN) continue;
                int n3 = n2 - this.MAX_COLUMN_LEN;
                string4 = string.substring(0, string.length() - n3) + n;
            }
            this._columnNames.put(string4, string2);
            return string4;
        }

        public String GenerateName(String string, String string2, String string3) {
            return this.GenerateName(string, string2 + ":" + string3);
        }

        public String GenerateName(String string, String string2) {
            String string3 = string;
            if (string.length() > this.MAX_COLUMN_LEN) {
                string3 = string.substring(0, this.MAX_COLUMN_LEN);
            }
            return this.getUniqueName(string3, string2);
        }

        public void rename(String string, String string2) {
            String string3 = this._columnNames.get(string);
            if (string3 != null) {
                this._columnNames.remove(string);
                this._columnNames.put(string2, string3);
            }
        }

        public void removeAll() {
            this._columnNames.clear();
        }
    }
}

