/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.HistogramPreferences;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.DatabaseObjectType;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.codegen.SourceDefinition;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.model.SampleSettingsProperties;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileInputType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public final class DataProfileNode
extends AbstractDataNode
implements SampleSettingsProperties,
DataConsumer {
    private static final Logger theLogger = Logger.getLogger(DataProfileNode.class.getName());
    private static final String REFACTOR_INPUT_COLUMNS = "refactorInputProfileColumns";
    private HistogramPreferences histogramPreferences = HistogramPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
    public static final String DATAPROFILE_SETTINGS = NodeMessagesLrb.get("DATAPROFILE_SETTINGS");
    public static final String DATAPROFILE_NULL_LABEL = NodeMessagesLrb.get("DATAPROFILE_NULL_LABEL");
    public static final String DATAPROFILE_OTHER_LABEL = NodeMessagesLrb.get("DATAPROFILE_OTHER_LABEL");
    public static final String DATAPROFILE_INPUT = NodeMessagesLrb.get("DATAPROFILE_INPUT");
    public static final String DATAPROFILE_OUTPUT = NodeMessagesLrb.get("DATAPROFILE_OUTPUT");
    public static final String AUTO_SPEC = "autoSpec";
    public static final String TABLE_NAME = "tableName";
    public static final String STATS_SELECTION = NodeMessagesLrb.get("STATS_SELECTION");
    public static final String ATTR = "ATTR";
    public static final String DATA_TYPE = "DATA_TYPE";
    public static final String NULL_PERCENT = "NULL_PERCENT";
    public static final String DISTINCT_CNT = "DISTINCT_CNT";
    public static final String DISTINCT_PERCENT = "DISTINCT_PERCENT";
    public static final String MODE_VALUE = "MODE_VALUE";
    public static final String AVG = "AVG";
    public static final String AVG_DATE = "AVG_DATE";
    public static final String AVG_TS_TZ = "AVG_TS_TZ";
    public static final String MEDIAN_VAL = "MEDIAN_VAL";
    public static final String MEDIAN_DATE = "MEDIAN_DATE";
    public static final String MEDIAN_TS_TZ = "MEDIAN_TS_TZ";
    public static final String MIN = "MIN";
    public static final String MAX = "MAX";
    public static final String STD = "STD";
    public static final String VAR = "VAR";
    public static final String SKEWNESS = "SKEWNESS";
    public static final String KURTOSIS = "KURTOSIS";
    public static final String HISTOGRAMS = "HISTOGRAMS";

    public DataProfileNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (!bl) {
            return bl;
        }
        List<AbstractNode> list = this.findParentNodes();
        bl = list.isEmpty();
        if (!bl) {
            return bl;
        }
        if (node instanceof BuildTextNodeRef) {
            return false;
        }
        bl = node instanceof DataProvider;
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        List list;
        super.handleNewConnectionFrom(node);
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        Attributes attributes = dataProfileInputType.getAttributes();
        if (null == attributes) {
            attributes = new Attributes();
            dataProfileInputType.setAttributes(attributes);
        }
        if ((list = attributes.getAttribute()).isEmpty() && node instanceof DataProvider) {
            Attributes attributes2 = ((DataProvider)((Object)node)).getAttributes();
            List list2 = attributes2.getAttribute();
            this.copyAttributes(list, list2);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(DATAPROFILE_INPUT, null, dataProfileInputType, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(this, this.getContext(), arrayList);
        }
        this.validate(false);
    }

    private void copyAttributes(List<AttributeType> list, List<AttributeType> list2) {
        for (AttributeType attributeType : list2) {
            AttributeType attributeType2 = new AttributeType();
            attributeType2.setName(attributeType.getName());
            attributeType2.setAlias(attributeType.getAlias());
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            attributeType2.setStatus(attributeType.getStatus());
            attributeType2.setAnnotation(attributeType.getAnnotation());
            list.add(attributeType2);
        }
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public Attributes getAttributes() {
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        return dataProfileNodeType.getDataProfileOutput().getAttributes();
    }

    public Attributes getSourceAttributes() {
        Attributes attributes = new Attributes();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        if (null == dataProfileNodeType.getDataProfileInput() || null == dataProfileNodeType.getDataProfileInput().getAttributes()) {
            return attributes;
        }
        List list = dataProfileNodeType.getDataProfileInput().getAttributes().getAttribute();
        if (list != null && list.size() > 0) {
            for (AttributeType attributeType : list) {
                AttributeType attributeType2 = new AttributeType();
                attributeType2.setName(attributeType.getAlias() != null && !attributeType.getAlias().trim().isEmpty() ? attributeType.getAlias() : attributeType.getName());
                attributeType2.setAlias(attributeType.getAlias());
                attributeType2.setDataType(attributeType.getDataType());
                attributeType2.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                attributeType2.setStatus(attributeType.getStatus());
                attributeType2.setAnnotation(attributeType.getAnnotation());
                attributes.getAttribute().add(attributeType2);
            }
        }
        return attributes;
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_DATAPROFILE_NODE_NAME");
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        SampleSettings sampleSettings = new SampleSettings();
        sampleSettings.setNumberOfRows(Long.valueOf(2000L));
        SampleSettings.Method method = new SampleSettings.Method();
        SampleSettings.Method.Random random = new SampleSettings.Method.Random();
        random.setSeed(BigInteger.valueOf(12345L));
        method.setRandom(random);
        sampleSettings.setMethod(method);
        sampleSettings.setUseFullData(false);
        sampleSettings.setGenerateCache(Boolean.valueOf(true));
        dataProfileNodeType.setSampleSettings(sampleSettings);
        DataProfileInputType dataProfileInputType = new DataProfileInputType();
        Attributes attributes = new Attributes();
        attributes.getAttribute();
        dataProfileInputType.setAttributes(attributes);
        dataProfileNodeType.setDataProfileInput(dataProfileInputType);
        DataProfileSettingsType dataProfileSettingsType = new DataProfileSettingsType();
        dataProfileSettingsType.setCategoricalBins(this.histogramPreferences.getNumberOfCategoricBins());
        dataProfileSettingsType.setNumericalBins(this.histogramPreferences.getNumberOfNumericBins());
        dataProfileSettingsType.setDateBins(this.histogramPreferences.getNumberOfDateBins());
        dataProfileNodeType.setDataProfileSettings(dataProfileSettingsType);
        DataProfileOutputType dataProfileOutputType = new DataProfileOutputType();
        Attributes attributes2 = new Attributes();
        AttributeType attributeType = new AttributeType();
        attributeType.setName(ATTR);
        attributeType.setDataType("VARCHAR2");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(DATA_TYPE);
        attributeType.setDataType("VARCHAR2");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(NULL_PERCENT);
        attributeType.setDataType("NUMBER");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(DISTINCT_CNT);
        attributeType.setDataType("NUMBER");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(DISTINCT_PERCENT);
        attributeType.setDataType("NUMBER");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(MODE_VALUE);
        attributeType.setDataType("NVARCHAR2");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(AVG);
        attributeType.setDataType("NUMBER");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(AVG_DATE);
        attributeType.setDataType("DATE");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(AVG_TS_TZ);
        attributeType.setDataType("TIMESTAMP WITH TIME ZONE");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(MEDIAN_VAL);
        attributeType.setDataType("NUMBER");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(MEDIAN_DATE);
        attributeType.setDataType("DATE");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(MEDIAN_TS_TZ);
        attributeType.setDataType("TIMESTAMP WITH TIME ZONE");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(MIN);
        attributeType.setDataType("NVARCHAR2");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(MAX);
        attributeType.setDataType("NVARCHAR2");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(STD);
        attributeType.setDataType("NUMBER");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(VAR);
        attributeType.setDataType("NUMBER");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(SKEWNESS);
        attributeType.setDataType("NUMBER");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(KURTOSIS);
        attributeType.setDataType("NUMBER");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        attributeType = new AttributeType();
        attributeType.setName(HISTOGRAMS);
        attributeType.setDataType(SQLHelper.isExtendedTypeEnabled(context) ? "ODMR_HISTOGRAMS_EX" : "ODMR_HISTOGRAMS");
        attributeType.setStatus(AttributeStatus.VALID);
        attributes2.getAttribute().add(attributeType);
        dataProfileOutputType.setAttributes(attributes2);
        dataProfileNodeType.setDataProfileOutput(dataProfileOutputType);
        StatsSelection statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        dataProfileNodeType.setStatsSelection(statsSelection);
        dataProfileNodeType.setStatus(NodeStatusType.INVALID);
        String string = "";
        try {
            string = WorkflowUtils.getNewOutputTableNameWfid(context);
            ResultType resultType = new ResultType();
            resultType.setName(string);
            resultType.setCreationDate(null);
            dataProfileNodeType.setStatisticTable(resultType);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        ResultType resultType;
        boolean bl2 = super.validate(bl);
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        DataProfileSettingsType dataProfileSettingsType = dataProfileNodeType.getDataProfileSettings();
        if (dataProfileSettingsType.getCategoricalBins() <= 0 || dataProfileSettingsType.getNumericalBins() <= 0 || dataProfileSettingsType.getDateBins() <= 0 || dataProfileSettingsType.getCategoricalBins() > 128 || dataProfileSettingsType.getNumericalBins() > 128 || dataProfileSettingsType.getDateBins() > 128) {
            bl2 = false;
            this.addMessage("DATAPROFILE_SETTINGS_INVALID", MessageEnumType.ERROR, new String[0]);
        }
        DataProfileInputType dataProfileInputType = new DataProfileInputType();
        Attributes attributes = new Attributes();
        dataProfileInputType.setAttributes(attributes);
        List list = attributes.getAttribute();
        if (null != dataProfileNodeType.getDataProfileInput() && null != dataProfileNodeType.getDataProfileInput().getAttributes()) {
            this.copyAttributes(list, dataProfileNodeType.getDataProfileInput().getAttributes().getAttribute());
        }
        this.validateAttributes();
        this.excecuteInputColumnsTxn(dataProfileNodeType.getDataProfileInput(), dataProfileInputType);
        if (null == dataProfileNodeType.getDataProfileInput() || null == dataProfileNodeType.getDataProfileInput().getAttributes() || null == dataProfileNodeType.getDataProfileInput().getAttributes().getAttribute() || dataProfileNodeType.getDataProfileInput().getAttributes().getAttribute().isEmpty()) {
            bl2 = false;
            this.addMessage("DATAPROFILE_SETTINGS_INCOMPLETE", MessageEnumType.INCOMPLETE, new String[0]);
        } else {
            resultType = dataProfileNodeType.getDataProfileInput().getGroupByAttribute();
            if (resultType != null && !resultType.getStatus().equals((Object)AttributeStatus.VALID)) {
                bl2 = false;
                this.addMessage("DATAPROFILE_GROUP_BY_INVALID", MessageEnumType.INCOMPLETE, new String[0]);
            }
            if (bl2) {
                object = dataProfileNodeType.getDataProfileInput().getAttributes().getAttribute();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    AttributeType attributeType = (AttributeType)iterator.next();
                    if (attributeType.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                    bl2 = false;
                    this.addMessage("DATASRC_INVALID_ATTR", MessageEnumType.WARNING, new String[0]);
                    break;
                }
            }
        }
        resultType = dataProfileNodeType.getStatisticTable();
        object = resultType.getName();
        if (!StringUtils.isDoubleQuotedString((String)object) && !StringUtils.containsNoDot((String)object)) {
            bl2 = false;
            this.addMessage("CREATE_TABLE_INVALID_OUPUT_TABLE_NAME", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (((String)object).length() > 30) {
            bl2 = false;
            this.addMessage("CREATE_TABLE_NAME_TOO_LONG", MessageEnumType.INCOMPLETE, new String[0]);
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    private void validateAttributes() {
        Attributes attributes;
        AttributeType attributeType2;
        AbstractNode abstractNode = this.findParentNode();
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        Attributes attributes2 = dataProvider != null ? dataProvider.getAttributes() : null;
        List list = attributes2 != null ? attributes2.getAttribute() : null;
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        if (list != null) {
            for (AttributeType attributeType2 : list) {
                hashMap.put(attributeType2.getName(), attributeType2);
            }
        }
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        attributeType2 = dataProfileNodeType.getDataProfileInput().getGroupByAttribute();
        boolean bl = SQLHelper.isExtendedTypeEnabled(this.getContext());
        if (attributeType2 != null) {
            DatabaseMetadataUtils.convertExtendedTypes(attributeType2, bl);
            AttributeType attributeType3 = attributes = hashMap != null ? (AttributeType)hashMap.get(attributeType2.getName()) : null;
            if (null == attributes) {
                attributeType2.setStatus(AttributeStatus.MISSING);
            } else if (!attributes.getDataType().equals(attributeType2.getDataType())) {
                attributeType2.setStatus(AttributeStatus.INVALID);
                attributeType2.setDataTypeQualifier(attributes.getDataTypeQualifier());
            } else {
                attributeType2.setStatus(attributes.getStatus());
                attributeType2.setDataTypeQualifier(attributes.getDataTypeQualifier());
            }
        }
        attributes = dataProfileNodeType.getDataProfileInput().getAttributes();
        List list2 = attributes.getAttribute();
        DatabaseMetadataUtils.convertExtendedTypes(list2, bl);
        for (Object object : list2) {
            Object object2;
            Object object3 = object2 = hashMap != null ? (AttributeType)hashMap.get(object.getName()) : null;
            if (null == object2) {
                object.setStatus(AttributeStatus.MISSING);
            } else if (!object2.getDataType().equals(object.getDataType())) {
                object.setStatus(AttributeStatus.INVALID);
                object.setDataTypeQualifier(object2.getDataTypeQualifier());
            } else {
                object.setStatus(object2.getStatus());
                object.setDataTypeQualifier(object2.getDataTypeQualifier());
            }
            if (object2 == null) continue;
            hashMap.remove(object.getName());
        }
        AutoSpecType autoSpecType = dataProfileNodeType.getAutoSpec();
        if (autoSpecType.equals((Object)AutoSpecType.YES)) {
            Object object;
            if (!hashMap.isEmpty()) {
                object = hashMap.keySet().iterator();
                while (object.hasNext()) {
                    list2.add(hashMap.get(object.next()));
                }
            }
            object = new ArrayList();
            for (AttributeType attributeType4 : list2) {
                if (!attributeType4.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                object.add(attributeType4);
            }
            attributes.getAttribute().clear();
            attributes.getAttribute().addAll(object);
        }
    }

    @Override
    public String generateSQLExpression() {
        List list;
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        Attributes attributes = dataProfileNodeType.getDataProfileOutput().getAttributes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT \n" + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */ " : ""));
        if (attributes != null && (list = attributes.getAttribute()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string = null;
                string = !StringUtils.isDoubleQuotedString(((AttributeType)list.get(i)).getName()) ? "\"" + ((AttributeType)list.get(i)).getName() + "\"" : ((AttributeType)list.get(i)).getName();
                stringBuilder.append(string);
                if (i < list.size() - 1) {
                    stringBuilder.append(",\n");
                    continue;
                }
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append(" FROM {STATS_TABLE}");
        return this.wrapExpressionInWithClause(stringBuilder.toString());
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) {
        String string2;
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        String string3 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_TABLE, true);
        String string4 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_QUERY, true);
        String string5 = this.getParallelHint(context, AbstractNode.HintType.HINT_TYPE_INSERT, true);
        String string6 = dataProfileNodeType.getStatisticTable().getName();
        String string7 = "";
        try {
            string7 = ConnectionFolder.getUserAccountName(context);
        }
        catch (Exception exception) {
            string7 = "";
        }
        parameterizedSourceDefinitions.addParameterizedSourceDefinition(this, string7, string6, DatabaseObjectType.CREATE_TABLE);
        Attributes attributes = dataProfileNodeType.getDataProfileInput().getAttributes();
        AbstractNode abstractNode = this.findParentNode();
        String string8 = " (SELECT * FROM ' ||getInputSource('" + abstractNode.getMetadataId() + "')||') ";
        String string9 = " INPUT_DATA_VIEW AS \n    " + string8;
        String string10 = parameterizedSourceDefinitions.getParmNameWithAmpersand(this, string7, string6, DatabaseObjectType.CREATE_TABLE);
        AttributeType attributeType = dataProfileNodeType.getDataProfileInput().getGroupByAttribute();
        StatsSelection statsSelection = dataProfileNodeType.getStatsSelection();
        if (statsSelection == null) {
            statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        if ((string2 = dataProfileNodeType.getNullsLabel()) == null) {
            string2 = ControlsLrb.get("DEFAULT_NULL_BIN_LABEL");
        }
        if (StringUtils.isSingleQuotedString(string2)) {
            string2 = StringUtils.trimSingleQuotes(string2);
        }
        string2 = StringUtils.escapeSingleQuotesForSQL(string2);
        string2 = StringUtils.addSingleQuotes(string2);
        string2 = StringUtils.addSingleQuotes(string2);
        string2 = StringUtils.addSingleQuotes(string2);
        String string11 = dataProfileNodeType.getOtherLabel();
        if (string11 == null) {
            string11 = XformDialogsLrb.get("CUSTOM_BINNING_PANEL_OTHER_DEFAULT");
        }
        if (StringUtils.isSingleQuotedString(string11)) {
            string11 = StringUtils.trimSingleQuotes(string11);
        }
        string11 = StringUtils.escapeSingleQuotesForSQL(string11);
        string11 = StringUtils.addSingleQuotes(string11);
        string11 = StringUtils.addSingleQuotes(string11);
        string11 = StringUtils.addSingleQuotes(string11);
        Map<String, StringBuilder> map = SQLHelper.buildStatsTableSQL2(attributes.getAttribute(), string10, attributeType != null ? attributeType.getName() : null, attributeType != null ? attributeType.getDataType() : null, dataProfileNodeType.getSampleSettings(), string2, string11, statsSelection.isModesampled(), string3, string4, string5);
        String string12 = map.get("CREATE_TEMP_INPUT_VIEW").toString();
        string12 = StringUtils.getReplacedString(string12, "<INPUT_SQL>", string9);
        String string13 = CodeTemplate.updateBodyTemplate(string, "<CREATE_TEMP_INPUT_VIEW_SQL_EXPRESSION>", string12);
        string12 = map.get("PURGE_TABLE").toString();
        string13 = CodeTemplate.updateBodyTemplate(string13, "<PURGE_SQL_EXPRESSION>", string12);
        string12 = map.get("CREATE_SAMPLE_DATA").toString();
        string13 = CodeTemplate.updateBodyTemplate(string13, "<SAMPLE_ALL_DATA_EXPRESSION>", string12);
        string12 = map.get("TEMP_SAMPLED_TABLE_NAME").toString();
        string13 = CodeTemplate.updateBodyTemplate(string13, "<DROP_SAMPLE_SQL_EXPRESSION>", string12);
        string12 = map.get("DROP_EXPLORE_NODE_TABLE_NAME").toString();
        string13 = CodeTemplate.updateBodyTemplate(string13, "<TAG_DROP_EXPLORE_DATA_TABLE>", string12);
        string12 = map.get("CREATE_SERVER_CALL").toString();
        string12 = StringUtils.getReplacedString(string12, "<PERCENT_DISTINCT>", String.valueOf(statsSelection.isPercentdistinct()));
        string12 = StringUtils.getReplacedString(string12, "<PERCENT_NULL>", String.valueOf(statsSelection.isPercentnull()));
        string12 = StringUtils.getReplacedString(string12, "<MAX_VALUE>", String.valueOf(statsSelection.isMax()));
        string12 = StringUtils.getReplacedString(string12, "<MIN_VALUE>", String.valueOf(statsSelection.isMin()));
        string12 = StringUtils.getReplacedString(string12, "<AVG_VALUE>", String.valueOf(statsSelection.isAvg()));
        string12 = StringUtils.getReplacedString(string12, "<STDDEV_VALUE>", String.valueOf(statsSelection.isStd()));
        string12 = StringUtils.getReplacedString(string12, "<VAR_VALUE>", String.valueOf(statsSelection.isVar()));
        string12 = StringUtils.getReplacedString(string12, "<KURT_VALUE>", String.valueOf(statsSelection.isKurtosis()));
        string12 = StringUtils.getReplacedString(string12, "<MEDIAN_VALUE>", String.valueOf(statsSelection.isMedian()));
        string12 = StringUtils.getReplacedString(string12, "<SKEW_VALUE>", String.valueOf(statsSelection.isSkewness()));
        string12 = StringUtils.getReplacedString(string12, "<MODE_VALUE>", String.valueOf(statsSelection.isMode()));
        string12 = StringUtils.getReplacedString(string12, "<MODE_SAMPLED>", String.valueOf(statsSelection.isModesampled()));
        string12 = StringUtils.getReplacedString(string12, "<MODE_ALL>", String.valueOf(statsSelection.isModeall()));
        string12 = StringUtils.getReplacedString(string12, "<p_parallel_table_hint>", StringUtils.addSingleQuotes(string3));
        string12 = StringUtils.getReplacedString(string12, "<p_parallel_query_hint>", StringUtils.addSingleQuotes(string4));
        string12 = StringUtils.getReplacedString(string12, "<p_parallel_insert_hint>", StringUtils.addSingleQuotes(string5));
        string13 = CodeTemplate.updateBodyTemplate(string13, "<SERVER_CALL_SQL_EXPRESSION>", string12);
        string12 = map.get("HISTOGRAM_SAMPLE").toString();
        string13 = CodeTemplate.updateBodyTemplate(string13, "<HISTOGRAM_SAMPLE_SQL_EXPRESSION>", string12);
        DataProfileSettingsType dataProfileSettingsType = dataProfileNodeType.getDataProfileSettings();
        string12 = map.get("HISTOGRAM_API").toString();
        string12 = StringUtils.getReplacedString(string12, "<INPUT_SQL>", string8);
        string12 = StringUtils.getReplacedString(string12, "<p_num_bins>", Integer.toString(dataProfileSettingsType.getNumericalBins()));
        string12 = StringUtils.getReplacedString(string12, "<p_cat_bins>", Integer.toString(dataProfileSettingsType.getCategoricalBins()));
        string12 = StringUtils.getReplacedString(string12, "<p_date_bins>", Integer.toString(dataProfileSettingsType.getDateBins()));
        string12 = StringUtils.getReplacedString(string12, "<p_parallel_table_hint>", StringUtils.addSingleQuotes(string3));
        string12 = StringUtils.getReplacedString(string12, "<p_parallel_query_hint>", StringUtils.addSingleQuotes(string4));
        string12 = StringUtils.getReplacedString(string12, "<p_parallel_insert_hint>", StringUtils.addSingleQuotes(string5));
        string13 = CodeTemplate.updateBodyTemplate(string13, "<HISTOGRAM_API_SQL_EXPRESSION>", string12);
        string12 = map.get("TEMP_SAMPLED_HISTOGRAM_TABLE_NAME").toString();
        string13 = CodeTemplate.updateBodyTemplate(string13, "<DROP_HISTOGRAM_SAMPLE_SQL_EXPRESSION>", string12);
        string12 = map.get("TEMP_INPUT_VIEW_NAME").toString();
        string13 = CodeTemplate.updateBodyTemplate(string13, "<DROP_TEMP_INPUT_VIEW_SQL_EXPRESSION>", string12);
        return string13;
    }

    @Override
    public Object getProperty(String string) {
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        Object object = null;
        if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            SampleSettings sampleSettings;
            object = sampleSettings = dataProfileNodeType.getSampleSettings();
        } else if (string.equals(DATAPROFILE_SETTINGS)) {
            object = dataProfileNodeType.getDataProfileSettings();
        } else if (string.equals(DATAPROFILE_NULL_LABEL)) {
            object = dataProfileNodeType.getNullsLabel();
        } else if (string.equals(DATAPROFILE_OTHER_LABEL)) {
            object = dataProfileNodeType.getOtherLabel();
        } else if (string.equals(AUTO_SPEC)) {
            object = dataProfileNodeType.getAutoSpec();
        } else if (string.equals(DATAPROFILE_INPUT)) {
            object = dataProfileNodeType.getDataProfileInput();
        } else if (string.equals(REFACTOR_INPUT_COLUMNS)) {
            object = dataProfileNodeType.getDataProfileInput();
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else if (string.equals(STATS_SELECTION)) {
            object = dataProfileNodeType.getStatsSelection();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_PERCENT) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_SEED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TARGET) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_RANDOM) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_STRATIFIED) || complexProperty.getPropertyName().equals(SAMPLE_SETTINGS_TOPN) || complexProperty.getPropertyName().equals(DATAPROFILE_SETTINGS) || complexProperty.getPropertyName().equals(DATAPROFILE_NULL_LABEL) || complexProperty.getPropertyName().equals(DATAPROFILE_OTHER_LABEL) || complexProperty.getPropertyName().equals(DATAPROFILE_INPUT) || complexProperty.getPropertyName().equals(STATS_SELECTION) || complexProperty.getPropertyName().equals(REFACTOR_INPUT_COLUMNS) || complexProperty.getPropertyName().equals(AUTO_SPEC) || complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(TABLE_NAME)) {
            DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
            return dataProfileNodeType.getStatisticTable().getName();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        if (string.equals(SAMPLE_SETTINGS_PERCENT) || string.equals(SAMPLE_SETTINGS_NUMBER_OF_ROWS) || string.equals(SAMPLE_SETTINGS_SEED) || string.equals(SAMPLE_SETTINGS_TARGET) || string.equals(SAMPLE_SETTINGS_RANDOM) || string.equals(SAMPLE_SETTINGS_STRATIFIED) || string.equals(SAMPLE_SETTINGS_TOPN)) {
            if (object instanceof SampleSettings) {
                dataProfileNodeType.setSampleSettings((SampleSettings)object);
            }
        } else if (string.equals(DATAPROFILE_SETTINGS)) {
            DataProfileSettingsType dataProfileSettingsType = (DataProfileSettingsType)object;
            dataProfileNodeType.setDataProfileSettings(dataProfileSettingsType);
        } else if (string.equals(DATAPROFILE_NULL_LABEL)) {
            dataProfileNodeType.setNullsLabel((String)object);
        } else if (string.equals(DATAPROFILE_OTHER_LABEL)) {
            dataProfileNodeType.setOtherLabel((String)object);
        } else if (string.equals(DATAPROFILE_INPUT)) {
            DataProfileInputType dataProfileInputType = (DataProfileInputType)object;
            dataProfileNodeType.setDataProfileInput(dataProfileInputType);
        } else if (string.equals(STATS_SELECTION)) {
            StatsSelection statsSelection = (StatsSelection)object;
            dataProfileNodeType.setStatsSelection(statsSelection);
        } else if (string.equals(REFACTOR_INPUT_COLUMNS)) {
            DataProfileInputType dataProfileInputType = (DataProfileInputType)object;
            dataProfileNodeType.setDataProfileInput(dataProfileInputType);
        } else if (string.equals(TABLE_NAME)) {
            dataProfileNodeType.getStatisticTable().setName((String)object);
        } else if (string.equals(AUTO_SPEC)) {
            dataProfileNodeType.setAutoSpec((AutoSpecType)object);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    private void excecuteInputColumnsTxn(DataProfileInputType dataProfileInputType, DataProfileInputType dataProfileInputType2) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ComplexProperty complexProperty = new ComplexProperty(DATAPROFILE_INPUT, dataProfileInputType);
        complexProperty.setOldData(dataProfileInputType2);
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        arrayList.add(complexProperty);
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this.getSQLExpression());
        arrayList.add(complexProperty2);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    @Override
    public String getHelpTopic() {
        return "dataprofile_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_DATA_PROFILE_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_DATA_PROFILE_ICON"));
    }

    @Override
    protected void getInternalStackedSQL(AbstractDataNode abstractDataNode, StringBuffer stringBuffer) {
    }

    @Override
    public void refactor(Node node, boolean bl) throws Exception {
        if (!bl) {
            try {
                String string = ((DataProfileNodeType)this.getData()).getStatisticTable().getName();
                String string2 = this.getRefactorTableName(string, this.getContext());
                if (!string.equals(string2)) {
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
                    odmrSDMUndoFilter.prepareUndo(this, this.getContext(), TABLE_NAME, string2);
                    this.getModel().addRefactoredTableName(string, string2);
                }
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        super.refactor(node, bl);
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        Object object;
        Object object2;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        List list = dataProfileNodeType.getDataProfileInput().getAttributes().getAttribute();
        AttributeType attributeType = dataProfileNodeType.getDataProfileInput().getGroupByAttribute();
        DataProfileInputType dataProfileInputType = new DataProfileInputType();
        Attributes attributes = new Attributes();
        dataProfileInputType.setAttributes(attributes);
        List list2 = attributes.getAttribute();
        if (attributeType != null) {
            object2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (!(attributeType2 == null || attributeType.getName().equals(attributeType2.getName()) && attributeType.getDataType().equals(attributeType2.getDataType()))) {
                object = attributeType.getName();
                object2.setName(attributeType2.getName());
                object2.setDataType(attributeType2.getDataType());
                hashMap.put(object, object2);
            }
            dataProfileInputType.setGroupByAttribute((AttributeType)object2);
        }
        for (AttributeType attributeType2 : list) {
            object = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType2);
            AttributeType attributeType3 = map.get(attributeType2.getName());
            if (!(attributeType3 == null || attributeType2.getName().equals(attributeType3.getName()) && attributeType2.getDataType().equals(attributeType3.getDataType()))) {
                String string = attributeType2.getName();
                object.setName(attributeType3.getName());
                object.setDataType(attributeType3.getDataType());
                hashMap.put(string, object);
            }
            list2.add(object);
        }
        if (!hashMap.isEmpty()) {
            object2 = (OdmrSDMUndoFilter)this.getUndoFilter();
            ((OdmrSDMUndoFilter)((Object)object2)).prepareUndo(this, this.getContext(), REFACTOR_INPUT_COLUMNS, dataProfileInputType);
        }
    }

    @Override
    public ArrayList<SourceDefinition> getLineageSources() throws Exception {
        ArrayList<SourceDefinition> arrayList = new ArrayList<SourceDefinition>();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)this.getData();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.getContext());
        SourceDefinition sourceDefinition = new SourceDefinition(this, connectionFolder.getUserAccountName(), dataProfileNodeType.getStatisticTable().getName(), DatabaseObjectType.TABLE_OR_VIEW);
        arrayList.add(sourceDefinition);
        return arrayList;
    }

    @Override
    protected boolean canGenerateLineageSQL() {
        boolean bl;
        boolean bl2 = bl = this.getData().getStatus() == NodeStatusType.COMPLETE || this.getData().getStatus() == NodeStatusType.WARNING;
        return bl;
    }
}

