/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingODMType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingsODM;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.ide.Context;
import oracle.javatools.util.Pair;

public abstract class AbstractModelNode
extends AbstractNode
implements ModelProvider {
    private static final Logger theLogger = Logger.getLogger(AbstractModelNode.class.getName());
    public static final String MINING_FUNCTION_TYPE = "miningFunctionType";
    public static final String TARGET_ATTRIBUTE = "targetAttribute";
    public static final String MODELS = "modelsGroup";
    public static final String TARGET_VALUES = "targetValues";
    public static final String ALL_EDIT_DATA = "allEditData";
    public static final String MODEL_USE_FOR_OUTPUT = "modelUseForOutput";

    public AbstractModelNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        ModelNodeType.Models models = new ModelNodeType.Models();
        TargetValues targetValues = new TargetValues();
        ModelSettingsODM modelSettingsODM = new ModelSettingsODM();
        modelNodeType.setMiningFunction(null);
        modelNodeType.setTargetAttribute(null);
        modelNodeType.setModels(models);
        modelNodeType.setTargetValues(targetValues);
    }

    public boolean validateInProgress(boolean bl) {
        boolean bl2 = false;
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        MiningFunctionType miningFunctionType = modelNodeType.getMiningFunction();
        AttributeType attributeType = modelNodeType.getTargetAttribute();
        List list = modelNodeType.getModels().getModel();
        bl2 = list.size() > 0;
        if (bl2) {
            bl2 = miningFunctionType != null;
        }
        if (bl2 && this.requiresTarget(miningFunctionType)) {
            bl2 = attributeType != null;
        }
        this.setState(bl2);
        return bl2;
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        MiningFunctionType miningFunctionType = modelNodeType.getMiningFunction();
        AttributeType attributeType = modelNodeType.getTargetAttribute();
        List list = modelNodeType.getModels().getModel();
        if (list.size() > 0) {
            bl2 = true;
        } else {
            bl2 = false;
            this.addMessage("MODEL_NO_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (bl2) {
            for (ModelNodeType.Models.Model model : list) {
                if (model.getStatus().equals((Object)RefModelStatusType.VALID)) continue;
                bl2 = false;
                this.addMessage("MODEL_INCOMPLETE_MODELS", MessageEnumType.INCOMPLETE, new String[0]);
                break;
            }
        }
        if (bl2) {
            if (miningFunctionType == null) {
                bl2 = false;
                this.addMessage("MODEL_NO_MINING_FUNCTION", MessageEnumType.INCOMPLETE, new String[0]);
            } else {
                bl2 = true;
            }
        }
        if (bl2 && this.requiresTarget(miningFunctionType)) {
            if (attributeType == null) {
                bl2 = false;
                this.addMessage("MODEL_NO_TARGET", MessageEnumType.INCOMPLETE, new String[0]);
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean requiresTarget(MiningFunctionType miningFunctionType) {
        boolean bl = false;
        if (miningFunctionType == MiningFunctionType.CLASSIFICATION || miningFunctionType == MiningFunctionType.REGRESSION) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void setProperty(String string, Object object) {
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        if (string.equals(MINING_FUNCTION_TYPE)) {
            MiningFunctionType miningFunctionType = (MiningFunctionType)object;
            modelNodeType.setMiningFunction(miningFunctionType);
        } else if (string.equals(TARGET_ATTRIBUTE)) {
            AttributeType attributeType = (AttributeType)object;
            modelNodeType.setTargetAttribute(attributeType);
        } else if (string.equals(MODELS)) {
            ModelNodeType.Models models = (ModelNodeType.Models)object;
            modelNodeType.setModels(models);
            this.setNavigatorRefreshPending();
        } else if (string.equals(TARGET_VALUES)) {
            TargetValues targetValues = (TargetValues)object;
            modelNodeType.setTargetValues(targetValues);
        } else if (string.equals(ALL_EDIT_DATA)) {
            List list = (List)object;
            if (list.isEmpty()) {
                return;
            }
            for (Property property : list) {
                if (property.getDescription().equals(MINING_FUNCTION_TYPE)) {
                    modelNodeType.setMiningFunction((MiningFunctionType)property.getValue());
                    continue;
                }
                if (property.getDescription().equals(TARGET_ATTRIBUTE)) {
                    modelNodeType.setTargetAttribute((AttributeType)property.getValue());
                    continue;
                }
                if (property.getDescription().equals(TARGET_VALUES)) {
                    modelNodeType.setTargetValues((TargetValues)property.getValue());
                    continue;
                }
                if (!property.getDescription().equals(MODELS)) continue;
                modelNodeType.setModels((ModelNodeType.Models)property.getValue());
                this.setNavigatorRefreshPending();
            }
        } else if (string.equals(MODEL_USE_FOR_OUTPUT)) {
            if (object == null || !(object instanceof ArrayList)) {
                return;
            }
            List list = (List)object;
            for (Pair pair : list) {
                pair.getFirst();
                ModelNodeType.Models.Model model = MetaDataHelper.findModelByName(modelNodeType, (String)pair.getFirst());
                if (model != null) {
                    model.setUseForOutput(((Boolean)pair.getSecond()).booleanValue());
                    continue;
                }
                theLogger.log(Level.FINEST, "Unable to find Model to perform update");
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(MODEL_USE_FOR_OUTPUT)) {
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            List list = (List)complexProperty.getData();
            for (Pair pair : list) {
                String string = (String)pair.getFirst();
                ModelNodeType modelNodeType = (ModelNodeType)this.getData();
                ModelNodeType.Models.Model model = MetaDataHelper.findModelByName(modelNodeType, string);
                boolean bl = model.isUseForOutput();
                Pair pair2 = new Pair((Object)(model.getSchema() + "." + model.getName()), (Object)bl);
                arrayList.add(pair2);
            }
            return arrayList;
        }
        return this.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        if (string.equals(MINING_FUNCTION_TYPE)) {
            MiningFunctionType miningFunctionType = modelNodeType.getMiningFunction();
            return miningFunctionType;
        }
        if (string.equals(TARGET_ATTRIBUTE)) {
            AttributeType attributeType = modelNodeType.getTargetAttribute();
            return attributeType;
        }
        if (string.equals(MODELS)) {
            ModelNodeType.Models models = modelNodeType.getModels();
            return models;
        }
        if (string.equals(TARGET_VALUES)) {
            TargetValues targetValues = modelNodeType.getTargetValues();
            return targetValues;
        }
        if (string.equals(ALL_EDIT_DATA)) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(MINING_FUNCTION_TYPE, null, modelNodeType.getMiningFunction(), MINING_FUNCTION_TYPE, null));
            arrayList.add(new Property(TARGET_ATTRIBUTE, null, modelNodeType.getTargetAttribute(), TARGET_ATTRIBUTE, null));
            arrayList.add(new Property(MODELS, null, modelNodeType.getModels(), MODELS, null));
            return arrayList;
        }
        return super.getProperty(string);
    }

    @Override
    public List<RefModelType> getOutputModels() {
        return this.getOutputModels(true);
    }

    public List<RefModelType> getOutputModels(boolean bl) {
        ModelNodeType.Models models;
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        if (modelNodeType != null && (models = modelNodeType.getModels()) != null) {
            List list = models.getModel();
            for (ModelNodeType.Models.Model model : list) {
                if ((!model.isUseForOutput() || !bl) && bl) continue;
                RefModelType refModelType = new RefModelType();
                refModelType.setMiningFunction(model.getMiningFunction());
                refModelType.setMiningAlgorithm(model.getMiningAlgorithm());
                refModelType.setModelId(model.getModelId());
                refModelType.setNodeId(modelNodeType.getId());
                refModelType.setName(model.getName());
                refModelType.setSchema(model.getSchema());
                refModelType.setStatus(model.getStatus());
                refModelType.setUseForOutput(model.isUseForOutput());
                if (model.getStatus().equals((Object)RefModelStatusType.VALID)) {
                    refModelType.setIsModelBuilt(true);
                } else {
                    refModelType.setIsModelBuilt(false);
                }
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    private boolean isSVMLinearModel(ModelNodeType.Models.Model model) {
        boolean bl = false;
        for (ModelSettingODMType modelSettingODMType : model.getModelSettingsODM().getModelSettingODM()) {
            if (modelSettingODMType.getName().compareTo("SVMS_KERNEL_FUNCTION") != 0 || modelSettingODMType.getValue().compareTo("SVMS_LINEAR") != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public List<RefModelType> getSVMLinearModels() {
        ModelNodeType.Models models;
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        if (modelNodeType != null && (models = modelNodeType.getModels()) != null) {
            List list = models.getModel();
            for (ModelNodeType.Models.Model model : list) {
                if (!this.isSVMLinearModel(model)) continue;
                RefModelType refModelType = new RefModelType();
                refModelType.setMiningFunction(model.getMiningFunction());
                refModelType.setMiningAlgorithm(model.getMiningAlgorithm());
                refModelType.setModelId(model.getModelId());
                refModelType.setNodeId(modelNodeType.getId());
                refModelType.setName(model.getName());
                refModelType.setSchema(model.getSchema());
                refModelType.setStatus(model.getStatus());
                refModelType.setUseForOutput(model.isUseForOutput());
                if (model.getStatus().equals((Object)RefModelStatusType.VALID)) {
                    refModelType.setIsModelBuilt(true);
                } else {
                    refModelType.setIsModelBuilt(false);
                }
                arrayList.add(refModelType);
            }
        }
        return arrayList;
    }

    @Override
    public List<RefModelType> getGLMRowDiagnosticModels() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        return arrayList;
    }

    @Override
    public List<RefModelType> getModelsContainingCostMatrix() throws Exception {
        ArrayList<RefModelType> arrayList = new ArrayList<RefModelType>();
        return arrayList;
    }

    @Override
    public MiningFunctionType getMiningFunctionTypeSupported() {
        MiningFunctionType miningFunctionType = null;
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        if (modelNodeType != null) {
            miningFunctionType = modelNodeType.getMiningFunction();
        }
        return miningFunctionType;
    }

    @Override
    public AttributeType getTargetAttribute() {
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        return modelNodeType.getTargetAttribute();
    }

    @Override
    public List<PartitionExpressionType> getPartitionAttributes(RefModelType refModelType) {
        List<Object> list = new ArrayList<PartitionExpressionType>();
        ModelNodeType modelNodeType = (ModelNodeType)this.getData();
        for (ModelNodeType.Models.Model model : modelNodeType.getModels().getModel()) {
            if (!model.getModelId().equals(refModelType.getModelId())) continue;
            PartitionExpressions partitionExpressions = model.getPartitionExpressions();
            if (partitionExpressions == null) break;
            list = partitionExpressions.getPartitionExpression();
            break;
        }
        return list;
    }
}

