/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.dynamic;

import java.util.List;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.dynamic.DynamicLrb;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.model.Element;

public abstract class DynamicNodePropertyModel
extends AbstractNodePropertyModel {
    public static final PropertyGroupImpl PARTITION_GROUP = new PropertyGroupImpl(PreferencesLrb.get("PI_DYNAMIC_PREDICT_NODE_GROUP_PARTITION"));
    public static final PropertyGroupImpl OUTPUT_GROUP = new PropertyGroupImpl(PreferencesLrb.get("PI_DYNAMIC_PREDICT_NODE_GROUP_OUTPUT"));

    public DynamicNodePropertyModel(Context context) {
        super(context);
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 1) {
            return;
        }
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        List<Property> list = this.getRows();
        this.addNodeSpecificProperties(list, nodeType);
        Property property = new Property("PARTITIONS_EXPRESSIONS", DynamicLrb.get("PI_PARTITIONS_COLUMNS_GROUP_DATA"), nodeType.getName(), DynamicLrb.get("PI_PARTITIONS_COLUMNS_GROUP_DATA_DESCRIPTION"), PARTITION_GROUP);
        list.add(this.getPARTITIONS_EXPRESSIONS(), property);
        property = new Property("PARTITIONS_EXPRESSION_EDIT", DynamicLrb.get("PI_PARTITIONS_COLUMNS_GROUP_DATA"), nodeType.getName(), DynamicLrb.get("PI_PARTITIONS_COLUMNS_GROUP_DATA_DESCRIPTION"), PARTITION_GROUP);
        list.add(this.getPARTITIONS_EXPRESSION_EDIT(), property);
        property = new Property("OUTPUT_SUPPLEMENTAL", DynamicLrb.get("PI_SUPPLEMENTAL_COLUMNS_GROUP_DATA"), nodeType.getName(), DynamicLrb.get("PI_SUPPLEMENTAL_COLUMNS_GROUP_DATA_DESCRIPTION"), OUTPUT_GROUP);
        list.add(this.getOUTPUT_SUPPLEMENTAL(), property);
        property = new Property("CASE_ATTRIBUTE", DynamicLrb.get("PI_SUPPLEMENTAL_COLUMNS_GROUP_DATA"), nodeType.getName(), DynamicLrb.get("PI_SUPPLEMENTAL_COLUMNS_GROUP_DATA_DESCRIPTION"), OUTPUT_GROUP);
        list.add(this.getCASE_ATTRIBUTE(), property);
        property = new Property("SQL_EXPRESSION", PropertyLrb.get("PI_SQL_EXPRESSION"), nodeType.getName(), PropertyLrb.get("PI_SQL_EXPRESSION_DESCRIPTION"), OUTPUT_GROUP);
        list.add(this.getSQL_EXPRESSION(), property);
        property = new Property("CACHE_SETTINGS", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CACHE_SETTINGS"), nodeType.getName(), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CACHE_SETTINGS_DESCRIPTION"), OUTPUT_GROUP);
        list.add(this.getCACHE_SETTINGS(), property);
    }

    protected abstract void addNodeSpecificProperties(List<Property> var1, NodeType var2);

    @Override
    public Object getValueAt(int n, int n2) {
        Property property = this.getRows().get(n);
        Object[] objectArray = this.getColumnMapping();
        Object object = null;
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= objectArray.length) {
            return PropertyModel.DOES_NOT_EXIST;
        }
        Object object2 = objectArray[n2];
        object = PropertyModel.COLUMN_ID.equals(object2) ? property.getId() : (PropertyModel.COLUMN_GROUP.equals(object2) ? property.getGroup() : (PropertyModel.COLUMN_DISPLAY_NAME.equals(object2) ? property.getDisplayName() : (PropertyModel.COLUMN_DISPLAY_VALUE.equals(object2) ? property.getValue() : (PropertyModel.COLUMN_DESCRIPTION.equals(object2) ? property.getDescription() : (PropertyModel.COLUMN_NAME.equals(object2) ? property.getId() : (PropertyModel.COLUMN_VALUE.equals(object2) ? property.getValue() : (PropertyModel.COLUMN_IS_WRITABLE.equals(object2) ? Boolean.valueOf(this.isCellEditable(n, n2)) : (PropertyModel.COLUMN_IS_HIDDEN.equals(object2) ? Boolean.valueOf(false) : (IdePropertyModel.COLUMN_HELP.equals(object2) ? this.getHelpTopic() : PropertyModel.DOES_NOT_EXIST)))))))));
        return object;
    }

    public abstract String getHelpTopic();

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = this.getColumnMapping();
        Object object2 = objectArray[n2];
        List<Property> list = this.getRows();
        if (PropertyModel.COLUMN_ID.equals(object2)) {
            WorkflowNodeInspectorElement workflowNodeInspectorElement = this._workflowNodeInspectorElement;
            if (n == this.getCASE_ATTRIBUTE() || n == this.getPARTITIONS_EXPRESSIONS() || n == this.getPARTITIONS_EXPRESSION_EDIT() || n == this.getOUTPUT_SUPPLEMENTAL() || n == this.getSQL_EXPRESSION() || n == this.getCACHE_SETTINGS()) {
                ComplexProperty complexProperty = (ComplexProperty)object;
                list.get(n).setValue(complexProperty.getData());
                workflowNodeInspectorElement.updateNode(complexProperty);
            } else {
                super.setValueAt(object, n, n2);
            }
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    public abstract int getPARTITIONS_EXPRESSIONS();

    public abstract int getPARTITIONS_EXPRESSION_EDIT();

    public abstract int getOUTPUT_SUPPLEMENTAL();

    public abstract int getCASE_ATTRIBUTE();

    public abstract int getSQL_EXPRESSION();

    public abstract int getCACHE_SETTINGS();
}

