/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.clustering;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CommentTextFieldEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputCellRenderer;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.utils.comparator.BooleanComparator;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditDialog;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelNameCellEditor;
import oracle.dmt.dataminer.workflow.dialog.build.NewModelPanel;
import oracle.dmt.dataminer.workflow.inspect.AbstractButtonState;
import oracle.dmt.dataminer.workflow.inspect.GeneralBuildPIPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.clustering.ClusteringBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.clustering.ClusteringBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.clustering.ClusteringBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Pair;

public class ClusteringBuildPIComponentBuildPanel
extends GeneralBuildPIPanel
implements ClusteringBuildPIComponentGUI {
    private JButton _viewModelBtn;
    private JButton _removeBtn;
    private JButton _addBtn;
    private DataMinerTablePanel dataMinerTablePanel;

    public ClusteringBuildPIComponentBuildPanel(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return ClusteringBuildPIComponentHelper.getContext(propertyModel);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return ClusteringBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public void updateCell(int n, int n2) {
        GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)this.getTable().getModel();
        genericBaseTableModel.fireTableCellUpdated(n, n2);
    }

    @Override
    protected int getModelNameIdFromPropertyModel() {
        return ClusteringBuildNodePropertyModel.RowIndex.MODEL_NAME;
    }

    @Override
    protected int getModelsRerunIdFromPropertyModel() {
        return ClusteringBuildNodePropertyModel.RowIndex.MODELS_RERUN;
    }

    @Override
    protected int getTestsRerunIdFromPropertyModel() {
        return -1;
    }

    @Override
    public boolean getClearState() {
        return this._clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this._clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.dataMinerTablePanel, -1, 500, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.dataMinerTablePanel, -1, 201, Short.MAX_VALUE)));
    }

    public void initRes() {
    }

    @Override
    public void initUI(PropertyModel propertyModel) {
        super.initUI(propertyModel);
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        ModelsTableModel modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        modelsTableModel.setWritable(this.isWritable());
        this.dataMinerTablePanel.setup((TableModel)((Object)modelsTableModel), BuildEditorLrb.get("BUILD_MODEL_SETTINGS_LBL"), new String[]{modelsTableModel.COLUMN_NAMES[0], modelsTableModel.COLUMN_NAMES[3]}, 0);
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    XMLGregorianCalendar xMLGregorianCalendar;
                    boolean bl = false;
                    ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ClusteringBuildPIComponentBuildPanel.this.getTable().getModel());
                    if (modelsTableModel.getDataVector().isEmpty()) {
                        return;
                    }
                    int[] nArray = ClusteringBuildPIComponentBuildPanel.this.getTable().getSelectedRowsInModel();
                    if (nArray.length == 0) {
                        return;
                    }
                    ModelType modelType = modelsTableModel.getDataVector().get(nArray[0]);
                    if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                        bl = true;
                    } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                        bl = true;
                    }
                    if (bl) {
                        ClusteringBuildPIComponentBuildPanel.this.viewModel();
                    }
                }
            }
        });
        this._viewModelBtn = new JButton(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this._viewModelBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_VIEW"));
        this._viewModelBtn.setDisabledIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_DIS));
        this._viewModelBtn.setEnabled(false);
        this._viewModelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusteringBuildPIComponentBuildPanel.this.viewModel();
            }
        });
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_REMOVE"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = BuildEditDialog.getModelsDeleteMessage((JTable)((Object)ClusteringBuildPIComponentBuildPanel.this.getTable()));
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)BuildEditorLrb.get("REMOVE_MODELS_TITLE"), null, (boolean)true)) {
                    return;
                }
                int[] nArray = ClusteringBuildPIComponentBuildPanel.this.getTable().getSelectedRowsInModel();
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)ClusteringBuildPIComponentBuildPanel.this.getTable().getModel());
                ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                for (int i = 0; i < nArray.length; ++i) {
                    ModelType modelType = modelsTableModel.getDataVector().get(nArray[i]);
                    arrayList.add(modelType);
                }
                ClusteringBuildPIComponentBuildPanel.this.setValue(arrayList, "modelRemoved", "modelAdded");
            }
        });
        this._removeBtn.setEnabled(false);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADD"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelType modelType;
                AbstractBuildNode abstractBuildNode = ClusteringBuildPIComponentBuildPanel.this.getTargetNode((PropertyModel)ClusteringBuildPIComponentBuildPanel.this._model);
                if (abstractBuildNode instanceof ClusteringBuildNode && (modelType = NewModelPanel.addNewModel(ClusteringBuildPIComponentBuildPanel.this, (BuildNodeType)abstractBuildNode.getData(), ClusteringBuildPIComponentBuildPanel.this.getContext((PropertyModel)ClusteringBuildPIComponentBuildPanel.this._model), abstractBuildNode)) != null) {
                    ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                    arrayList.add(modelType);
                    ClusteringBuildPIComponentBuildPanel.this.setValue(arrayList, "modelAdded", "modelRemoved");
                }
            }
        });
        this._addBtn.setEnabled(this.isWritable());
        this.dataMinerTablePanel.addControlBarComponents(this._addBtn, this._removeBtn, this._duplicateBtn, this._viewModelBtn);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClusteringBuildPIComponentBuildPanel.this.handleModelSelectionChanged();
            }
        });
        this.getTable().setFillsViewportHeight(true);
    }

    @Override
    protected DataMinerTable getTable() {
        return this.dataMinerTablePanel.getTable();
    }

    public void reloadUI(PropertyModel propertyModel) {
        ModelType modelType;
        ModelsTableModel modelsTableModel;
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        int[] nArray = this.getTable().getSelectedRowsInModel();
        ArrayList<ModelType> arrayList = null;
        if (nArray != null && nArray.length > 0 && (modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel())).getDataVector().isEmpty()) {
            arrayList = new ArrayList<ModelType>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                modelType = modelsTableModel.getDataVector().get(nArray[i]);
                arrayList.add(modelType);
            }
        }
        modelsTableModel = new ModelsTableModel(this._models);
        this.setupModelsTable(modelsTableModel);
        if (arrayList != null) {
            Object object;
            Vector<Integer> vector = new Vector<Integer>();
            modelType = modelsTableModel.getDataVector();
            for (int i = 0; i < modelType.size(); ++i) {
                object = modelType.get(i);
                if (!arrayList.contains(object)) continue;
                vector.add(i);
            }
            if (!vector.isEmpty()) {
                Integer[] integerArray = vector.toArray(new Integer[vector.size()]);
                object = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object[i] = (ModelType)integerArray[i];
                }
                this.getTable().setSelectedRowsInModel((int[])object);
            }
        }
    }

    private void setupModelsTable(ModelsTableModel modelsTableModel) {
        this.getTable().setModel((TableModel)((Object)modelsTableModel));
        this.getTable().setSorted(true);
        this.getTable().setUpdateSelectionOnSort(true);
        this.getTable().getTableHeader().setReorderingAllowed(false);
        this.getTable().sizeTableToContents();
        this.getTable().setAutoResizeMode(4);
        if (modelsTableModel.getRowCount() == 0) {
            return;
        }
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)jTable.getModel());
                int n3 = jTable.convertRowIndexToModel(n);
                if (modelsTableModel.getDataVector().isEmpty()) {
                    return null;
                }
                ModelType modelType = modelsTableModel.getDataVector().get(n3);
                return IconCellRenderer.getIconForPIStatus(modelType.getStatus());
            }
        });
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(iconCellRenderer);
        TableColumn tableColumn2 = this.getTable().getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(new OutputCellEditor());
        tableColumn2.setCellRenderer(new OutputCellRenderer());
        TableColumn tableColumn3 = this.getTable().getColumnModel().getColumn(4);
        tableColumn3.setCellEditor(new CommentTextFieldEditor(this.getContext((PropertyModel)this._model)));
        tableColumn3.setMaxWidth(200);
        TableColumn tableColumn4 = this.getTable().getColumnModel().getColumn(0);
        tableColumn4.setMinWidth(100);
        tableColumn4.setCellEditor(new ModelNameCellEditor(this.getContext((PropertyModel)this._model), this.getWorkflowModel(), (BuildNodeType)this.getTargetNode((PropertyModel)this._model).getData()));
    }

    @Override
    protected ModelType getModelType(int n) {
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
        ModelType modelType = modelsTableModel.getDataVector().get(this.getTable().convertRowIndexToModel(n));
        return modelType;
    }

    @Override
    public boolean isWritable() {
        return ClusteringBuildPIComponentHelper.isWritable((PropertyModel)this._model);
    }

    private void setEnabled(AbstractButton[] abstractButtonArray, boolean[] blArray) {
        boolean bl = this.isWritable();
        AbstractButtonState abstractButtonState = new AbstractButtonState(abstractButtonArray, blArray);
        abstractButtonState.setState(bl);
    }

    private void setValue(ModelType modelType, Object object) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (object != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(modelType.getId(), (String)object);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ClusteringBuildNodePropertyModel.RowIndex.MODEL_ANNOTATION), null, new ComplexProperty("modelAnnotation", hashMap), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(List<Pair<String, Boolean>> list) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property(String.valueOf(ClusteringBuildNodePropertyModel.RowIndex.MODEL_USEFOROUTPUT), null, new ComplexProperty("modelUseForOutput", list), null, null));
        this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), abstractBuildNode, arrayList);
        this.updateWorkFlow();
    }

    @Override
    protected void setValue(List<ModelType> list, String string, String string2) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        if (abstractBuildNode == null) {
            return;
        }
        if (list != null && !list.isEmpty()) {
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ADDED_REMOVED"), this.getTargetNode((PropertyModel)this._model), new ComplexProperty(string, string2, list), ClusteringBuildNodePropertyModel.RowIndex.MODEL_ADDED_REMOVED);
            this.updateWorkFlow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClusteringBuildPIComponentBuildPanel.this.resetModelSettingsTable((PropertyModel)ClusteringBuildPIComponentBuildPanel.this._model);
                }
            });
        }
    }

    protected void updateWorkFlow() {
        this.updateWorkFlowInternal();
    }

    private void handleModelSelectionChanged() {
        Object[] objectArray;
        AbstractButton[] abstractButtonArray;
        boolean bl;
        boolean bl2 = false;
        int n = this.getTable().getSelectedRowCount();
        boolean bl3 = bl = n == 1;
        if (n > 0) {
            XMLGregorianCalendar xMLGregorianCalendar;
            abstractButtonArray = (AbstractButton[])this.getTable().getModel();
            if (abstractButtonArray.getDataVector().isEmpty()) {
                return;
            }
            objectArray = this.getTable().getSelectedRowsInModel();
            ModelType modelType = abstractButtonArray.getDataVector().get(objectArray[0]);
            if (modelType.getStatus() == ModelStatusType.COMPLETE) {
                bl2 = true;
            } else if (modelType.getStatus() == ModelStatusType.READY && (xMLGregorianCalendar = modelType.getCreationDate()) != null) {
                bl2 = true;
            }
        }
        this._viewModelBtn.setEnabled(bl2 && bl);
        abstractButtonArray = new AbstractButton[]{this._removeBtn, this._addBtn, this._duplicateBtn};
        objectArray = new boolean[]{n > 0, n != -1, true};
        this.setEnabled(abstractButtonArray, (boolean[])objectArray);
    }

    private void viewModel() {
        int[] nArray = this.getTable().getSelectedRowsInModel();
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this.getTable().getModel());
        if (modelsTableModel.getDataVector().isEmpty()) {
            return;
        }
        ModelType modelType = modelsTableModel.getDataVector().get(nArray[0]);
        Context context = this.getContext((PropertyModel)this._model);
        String string = modelType.getName();
        String string2 = this.getTargetNode((PropertyModel)this._model).getData().getName();
        WorkflowNode workflowNode = (WorkflowNode)context.getNode();
        BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string2, string);
        EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
    }

    public void resetModelSettingsTable(PropertyModel propertyModel) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode(propertyModel);
        if (abstractBuildNode == null) {
            return;
        }
        this._models.clear();
        this._models = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        this.reloadUI(propertyModel);
    }

    class ModelsTableModel
    extends GenericBaseTableModel
    implements BuildNodeTableModel {
        private final String[] COLUMN_NAMES = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_NAME"), PropertyLrb.get("PI_ATTRIBUTES_MODEL_USE_FOR_OUTPUT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_COMMENT")};
        private static final int MODEL_NAME = 0;
        private static final int OUTPUT = 1;
        private static final int BUILD = 2;
        private static final int ALGORITHM = 3;
        private static final int COMMENT = 4;
        private Vector<ModelType> _srcData;
        private Map<String, ModelType> _srcMap;
        private boolean _writable = true;

        public ModelsTableModel(List<ModelType> list) {
            this._srcData = new Vector(list.size());
            this._srcData.addAll(list);
            this._srcMap = new HashMap<String, ModelType>();
            for (ModelType modelType : list) {
                this._srcMap.put(modelType.getName(), modelType);
            }
            this.setColumnIdentifiers(this.COLUMN_NAMES);
            this.setRowCount(this._srcData.size());
            this.setColumnCount(this.COLUMN_NAMES.length);
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 1: {
                    return BooleanComparator.getComparator();
                }
            }
            return super.getColumnSortComparator(n);
        }

        @Override
        public List<ModelType> getDataList() {
            return new ArrayList<ModelType>(this._srcData);
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public void setWritable(boolean bl) {
            this._writable = bl;
        }

        public Vector<ModelType> getDataVector() {
            return this._srcData;
        }

        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return String.class;
        }

        public Pair<String, Boolean> getValueAtCheckBoxColumn(int n) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ModelType modelType = this._srcData.get(n);
            Pair pair = new Pair((Object)modelType.getName(), (Object)modelType.isUseForOutput());
            return pair;
        }

        public Object getValueAt(int n, int n2) {
            if (this._srcData.isEmpty()) {
                return null;
            }
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ModelType modelType = this._srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = modelType.getName();
                    break;
                }
                case 3: {
                    object = MetaDataHelper.getAlgorithmName(modelType);
                    break;
                }
                case 2: {
                    XMLGregorianCalendar xMLGregorianCalendar = modelType.getCreationDate();
                    if (xMLGregorianCalendar != null) {
                        object = TimeUtils.formatDate(xMLGregorianCalendar);
                        break;
                    }
                    object = _NOT_BUILT;
                    break;
                }
                case 4: {
                    String string = modelType.getAnnotation();
                    object = string != null ? string : "";
                    break;
                }
                case 1: {
                    object = modelType.isUseForOutput();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 4 || n2 == 0 || n2 == 1) {
                return this._writable;
            }
            return false;
        }

        @Override
        public String getOriginalModelName(int n) {
            ModelType modelType = this._srcData.get(n);
            return modelType.getName();
        }

        public void setValueAt(Object object, int n, int n2) {
            StringUtils.displayOverLayPanel(ClusteringBuildPIComponentBuildPanel.this.getContext((PropertyModel)ClusteringBuildPIComponentBuildPanel.this._model));
            if (n2 == 4) {
                ModelType modelType = this._srcData.get(n);
                ClusteringBuildPIComponentBuildPanel.this.setValue(modelType, object);
                this.fireTableCellUpdated(n, n2);
            } else if (n2 == 0) {
                ClusteringBuildPIComponentBuildPanel.this.renameModel(this._srcData, object, n, n2);
            } else if (n2 == 1) {
                ModelType modelType = this._srcData.get(n);
                Boolean bl = (Boolean)object;
                ArrayList<Pair> arrayList = new ArrayList<Pair>();
                arrayList.add(new Pair((Object)modelType.getId(), (Object)bl));
                ClusteringBuildPIComponentBuildPanel.this.setValue(arrayList);
            }
            StringUtils.hideOverLayPanel(ClusteringBuildPIComponentBuildPanel.this.getContext((PropertyModel)ClusteringBuildPIComponentBuildPanel.this._model));
        }
    }
}

