/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowDocumentInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowDocumentPropertyProxyModel;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.inspector.PropertyLabel;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;

public class WorkflowPIComponentPanel
extends PIComponentPanel {
    private static final int MAXIMUM_COMMENT_LENGTH = 4000;
    private PropertyModel _model;
    private boolean _listenersAdded = false;
    private PropertyLabel jCommentLabel;
    private JTextArea jCommentValue;
    private JScrollPane jScrollPane1;

    public WorkflowPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jCommentLabel = new PropertyLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jCommentValue = new JTextArea();
        this.setPreferredSize(new Dimension(492, 200));
        this.jCommentLabel.setText("Comment:");
        this.jCommentValue.setColumns(20);
        this.jCommentValue.setRows(5);
        this.jScrollPane1.setViewportView(this.jCommentValue);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.jCommentLabel, -2, 90, -2).addGap(0, 382, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent((Component)this.jCommentLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 176, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jCommentLabel, (Component)this.jCommentValue, (String)(PropertyLrb.get("PI_WORKFLOW_COMMENT") + ":"));
        this.jCommentLabel.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_WORKFLOW_COMMENT_ADA"));
        this.jCommentValue.setText("");
        this.jCommentValue.setLineWrap(true);
        this.jCommentValue.setWrapStyleWord(true);
        this.jCommentValue.setDocument(new TextFieldLimit(4000));
    }

    public void reloadUI(PropertyModel propertyModel) {
        this.initUI(propertyModel);
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = propertyModel;
        WorkflowProcess workflowProcess = this.getWorkflowProcess(propertyModel);
        if (workflowProcess == null) {
            this.jCommentValue.setText("");
            return;
        }
        String string = workflowProcess.getComment();
        if (string != null) {
            this.jCommentValue.setText(string);
            this.jCommentValue.setCaretPosition(this.jCommentValue.getDocument().getLength());
            this.jCommentValue.moveCaretPosition(0);
        } else {
            this.jCommentValue.setText("");
        }
        this.jCommentValue.setEnabled(this.isWritable());
        if (!this._listenersAdded) {
            this.jCommentValue.addFocusListener(new FocusListener(){
                Context _context;
                String origComment;
                {
                    this._context = WorkflowPIComponentPanel.this.getContext(WorkflowPIComponentPanel.this._model);
                    this.origComment = "";
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    this.origComment = WorkflowPIComponentPanel.this.jCommentValue.getText();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void focusLost(FocusEvent focusEvent) {
                    String string = WorkflowPIComponentPanel.this.jCommentValue.getText();
                    boolean bl = true;
                    if (StringUtils.checkDataLossWithMsg(this._context, string, DialogsLrb.get("ERROR_TITLE"), true)) {
                        string = "";
                        bl = false;
                        WorkflowPIComponentPanel.this.jCommentValue.setText(this.origComment);
                    }
                    if (this.origComment.compareTo(string) != 0 && bl) {
                        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
                        if (!Workflow.validateWorkflowComment(connectionFolder, string)) {
                            bl = false;
                            WorkflowPIComponentPanel.this.jCommentValue.setText(this.origComment);
                        }
                        if (bl) {
                            BaseTreeNode baseTreeNode = (BaseTreeNode)this._context.getNode();
                            if (baseTreeNode != null) {
                                baseTreeNode.markDirty(true);
                            }
                            CommandProcessor.getInstance().beginTrans("Edit Workflow Comment");
                            try {
                                WorkflowPIComponentPanel.this._model.setValueAt((Object)WorkflowPIComponentPanel.this.jCommentValue.getText().trim(), 0, 0);
                            }
                            catch (Exception exception) {
                                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)"Workflow Document Edit Error", (String)"Unable to update comment.", null);
                            }
                            finally {
                                CommandProcessor.getInstance().endTrans();
                            }
                        }
                    }
                }
            });
            this._listenersAdded = true;
        }
    }

    protected WorkflowProcess getWorkflowProcess(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowDocumentPropertyProxyModel)) {
            return null;
        }
        WorkflowDocumentPropertyProxyModel workflowDocumentPropertyProxyModel = (WorkflowDocumentPropertyProxyModel)propertyModel;
        Context context = workflowDocumentPropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowDocumentInspectorElement workflowDocumentInspectorElement = (WorkflowDocumentInspectorElement)((Object)elementArray[0].getData());
        return workflowDocumentInspectorElement.getWorkflowProcess();
    }
}

