/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.javatools.icons.OracleIcons;

public abstract class GeneralBuildPIPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(GeneralBuildPIPanel.class.getName());
    protected static final String _NOT_BUILT = BuildEditorLrb.get("BUILD_MODEL_NOT_BUILT");
    protected JButton _duplicateBtn;
    protected WorkflowNodePropertyProxyModel _model;
    protected List<ModelType> _models;
    protected boolean _clearSearchState = true;

    public GeneralBuildPIPanel() {
    }

    public GeneralBuildPIPanel(boolean bl) {
        super(bl);
    }

    public GeneralBuildPIPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public GeneralBuildPIPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public abstract Context getContext(PropertyModel var1);

    protected abstract ModelType getModelType(int var1);

    protected abstract void setValue(List<ModelType> var1, String var2, String var3);

    public void initUI(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowNodePropertyProxyModel)propertyModel;
        this.addAncestorListener(new PIAncestorListener(this));
        this._duplicateBtn = new JButton(OracleIcons.getIcon((String)"duplicate.png"));
        this._duplicateBtn.setToolTipText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_DUPLICATE"));
        this._duplicateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    Object object2;
                    Context context = GeneralBuildPIPanel.this.getContext((PropertyModel)GeneralBuildPIPanel.this._model);
                    Element[] elementArray = context.getSelection();
                    WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
                    BuildNodeType buildNodeType = (BuildNodeType)workflowNodeInspectorElement.getNode().getData();
                    WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)context.getNode());
                    int[] nArray = GeneralBuildPIPanel.this.getTable().getSelectedRows();
                    ArrayList<ModelType> arrayList = new ArrayList<ModelType>();
                    for (int i = 0; i < nArray.length; ++i) {
                        object2 = GeneralBuildPIPanel.this.getModelType(nArray[i]);
                        object = (ModelType)MetaDataHelper.copyMetadataObject(object2);
                        object.setUseForOutput(true);
                        arrayList.add((ModelType)object);
                    }
                    List<RefModelType> list = MetaDataHelper.getModelsCollection(buildNodeType, arrayList, context);
                    object2 = MetaDataHelper.getModelsCollection(buildNodeType);
                    object = WorkflowUtils.refactorModels(context, list, (List<ModelType>)object2, workflowModel, false);
                    AbstractBuildNode.applyRefactoredModels((Map<String, RefModelType>)object, arrayList);
                    GeneralBuildPIPanel.this.setValue(arrayList, "modelAdded", "modelRemoved");
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        });
        this._duplicateBtn.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameModel(Vector<ModelType> vector, Object object, int n, int n2) {
        String string;
        if (!(object instanceof String)) {
            return;
        }
        ModelType modelType = vector.get(n);
        String string2 = modelType.getName();
        if (string2.equals(string = (String)object)) {
            return;
        }
        CommandProcessor.getInstance().beginTrans(PropertyLrb.get("PI_MODEL_RENAME_TXN"));
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this._model);
        Context context = this.getContext((PropertyModel)this._model);
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(modelType.getId(), string);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            Property property = new Property(String.valueOf(this.getModelNameIdFromPropertyModel()), null, new ComplexProperty("modelName", hashMap), null, null);
            this._model.setModelNameProperty(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), property);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put(modelType.getId(), null);
            ArrayList<Property> arrayList2 = new ArrayList<Property>();
            arrayList2.add(new Property(String.valueOf(this.getModelNameIdFromPropertyModel()), null, new ComplexProperty("modelBuildDates", hashMap2), null, null));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_REMOVE"), abstractBuildNode, arrayList2);
            RefModelType refModelType = MetaDataHelper.getModelRefFromId((BuildNodeType)abstractBuildNode.getData(), modelType.getId(), context);
            HashMap<String, RefModelType> hashMap3 = new HashMap<String, RefModelType>();
            if (refModelType != null) {
                refModelType.setName(string);
                hashMap3.put(string2, refModelType);
            }
            abstractBuildNode.refactorChildModelReferences(hashMap3);
            arrayList = new ArrayList();
            ArrayList<ModelType> arrayList3 = new ArrayList<ModelType>();
            arrayList3.add(modelType);
            arrayList.addAll(this.prepareStatusReady(arrayList3));
            this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), abstractBuildNode, arrayList);
            this.updateCell(n, n2);
            this.updateWorkFlowInternal();
        }
        catch (Exception exception) {
            CommandProcessor.getInstance().abortTrans();
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    public abstract AbstractBuildNode getTargetNode(PropertyModel var1);

    public abstract void updateCell(int var1, int var2);

    protected abstract int getModelNameIdFromPropertyModel();

    protected abstract int getModelsRerunIdFromPropertyModel();

    protected abstract int getTestsRerunIdFromPropertyModel();

    protected abstract DataMinerTable getTable();

    protected WorkflowModel getWorkflowModel() {
        WorkflowModel workflowModel = null;
        try {
            workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext((PropertyModel)this._model).getNode());
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return workflowModel;
    }

    private List<Property> prepareStatusReady(List<ModelType> list) {
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType modelType : list) {
            hashMap.put(modelType.getId(), ModelStatusType.READY);
        }
        ArrayList arrayList = new ArrayList();
        if (list != null && !list.isEmpty()) {
            arrayList.add(new Property(String.valueOf(this.getModelsRerunIdFromPropertyModel()), null, new ComplexProperty("modelsRerun", hashMap), null, null));
            if (-1 != this.getTestsRerunIdFromPropertyModel()) {
                arrayList.add(new Property(String.valueOf(this.getTestsRerunIdFromPropertyModel()), null, new ComplexProperty("testsRerun", hashMap), null, null));
            }
        }
        return arrayList;
    }

    protected void updateWorkFlowInternal() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            Node node = workflowEditor.getSelectedDiagramNode();
            if (node != null) {
                workflowEditor.setSelected(workflowNode.getEngine(), node);
            }
        }
    }
}

