/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractNodePropertyModel
extends PropertyModel {
    private static final Logger theLogger = Logger.getLogger(AbstractNodePropertyModel.class.getName());
    private static int PROPERTY_START_INDEX = 0;
    private Context context;
    protected WorkflowNodeInspectorElement _workflowNodeInspectorElement = null;
    protected static final Object[] COLUMNS = new Object[]{PropertyModel.COLUMN_ID, PropertyModel.COLUMN_VALUE, PropertyModel.COLUMN_VALUE_CLASS, PropertyModel.COLUMN_GROUP, PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_NAME, PropertyModel.COLUMN_DESCRIPTION, PropertyModel.COLUMN_EDITOR_FACTORY, PropertyModel.COLUMN_EDITOR_FACTORY_2, PropertyModel.COLUMN_IS_READABLE, PropertyModel.COLUMN_IS_WRITABLE, PropertyModel.COLUMN_DISPLAY_VALUE, PropertyModel.COLUMN_ACTIONS, PropertyModel.COLUMN_IS_HIDDEN, IdePropertyModel.COLUMN_HELP};
    private final List<Property> ROWS = new ArrayList<Property>();

    protected static int getInitialIndex() {
        return PROPERTY_START_INDEX;
    }

    public AbstractNodePropertyModel(Context context) {
        this.context = context;
        this.setInspector();
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 1) {
            return;
        }
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        List<Property> list = this.getRows();
        this.addCommonProperties(nodeType, list);
    }

    public void setContext(Context context) {
        this.context = context;
        this.setInspector();
    }

    private void setInspector() {
        Element[] elementArray = this.getContext().getSelection();
        this._workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
    }

    protected void addCommonProperties(NodeType nodeType, List<Property> list) {
        Property property = new Property(this.propertyId("name"), PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME"), nodeType.getName(), PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_DESCRIPTION"), Groups.COMMON);
        list.add(RowIndex.NAME, property);
        Property property2 = new Property(this.propertyId("comment"), PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT"), nodeType.getAnnotation(), PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_DESCRIPTION"), Groups.COMMON);
        list.add(RowIndex.COMMENT, property2);
    }

    public boolean isCellEditable(int n, int n2) {
        Node node = EditorManager.getEditorManager().getCurrentEditor().getContext().getNode();
        if (!(node instanceof WorkflowNode)) {
            return false;
        }
        WorkflowNode workflowNode = (WorkflowNode)node;
        boolean bl = !workflowNode.isReadOnly();
        return bl;
    }

    public void invalidateValueData() {
    }

    public Context getContext() {
        return this.context;
    }

    public Object[] getColumnMapping() {
        return COLUMNS;
    }

    public List<Property> getRows() {
        return this.ROWS;
    }

    public String getTargetDisplayName() {
        Element element = this.context.getElement();
        String string = element.getShortLabel();
        return string;
    }

    public int getRowCount() {
        return this.ROWS.size();
    }

    protected String propertyId(String string) {
        return ((Object)((Object)this)).getClass().getName() + "." + string;
    }

    public abstract Object getValueAt(int var1, int var2);

    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = this.getColumnMapping();
        Object object2 = objectArray[n2];
        List<Property> list = this.getRows();
        if (PropertyModel.COLUMN_VALUE.equals(object2)) {
            Object object3 = list.get((int)n).value;
            String string = object3 != null ? object3.toString() : "";
            String string2 = object != null ? object.toString() : "";
            String string3 = null;
            if (n == RowIndex.NAME) {
                string3 = "name";
            } else if (n == RowIndex.COMMENT) {
                string3 = "comment";
            }
            if (string3 != null && !string.equals(string2)) {
                ProcessTextWorker processTextWorker = new ProcessTextWorker(n, string3, string2, this.context);
                processTextWorker.execute();
            }
        }
    }

    static /* synthetic */ int access$008() {
        return PROPERTY_START_INDEX++;
    }

    private class ProcessTextWorker
    extends SwingWorker<String, Void> {
        private int propIndex;
        private String propName;
        private String text;
        private Context context;

        public ProcessTextWorker(int n, String string, String string2, Context context) {
            this.text = string2;
            this.propName = string;
            this.context = context;
            this.propIndex = n;
            StringUtils.displayOverLayPanel(context);
        }

        @Override
        protected String doInBackground() throws Exception {
            return StringUtils.checkDataLossWithNoMsg(this.context, this.text, false);
        }

        @Override
        protected void done() {
            try {
                String string = (String)this.get();
                if ("".equals(string)) {
                    this.text = this.processText(this.text);
                    AbstractNodePropertyModel.this.getRows().get((int)this.propIndex).value = this.text;
                    AbstractNodePropertyModel.this._workflowNodeInspectorElement.updateNode(this.propName, this.text);
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                }
            }
            catch (IllegalArgumentException | InterruptedException | ExecutionException exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
            }
            finally {
                StringUtils.hideOverLayPanel(this.context);
            }
        }

        public String processText(String string) throws IllegalArgumentException {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.context);
            if (this.propIndex == RowIndex.NAME) {
                String string2;
                String string3 = string;
                if (string3.trim().length() == 0) {
                    throw new IllegalArgumentException(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_SPACES"));
                }
                if (string3.length() > 30) {
                    string3 = string3.substring(0, 30);
                    string2 = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_TOO_LONG"), 30);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                }
                if (this.containsForwardSlash(string3)) {
                    throw new IllegalArgumentException(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_SLASH"));
                }
                if (this.containsAmpersand(string3)) {
                    throw new IllegalArgumentException(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_AMPERSAND"));
                }
                if (this.isDuplicateName(string3)) {
                    throw new IllegalArgumentException(WorkflowEditorLrb.get("NODE_NAME_NOT_UNIQUE_MSG"));
                }
                if (!StringUtils.checkStringDBLengthMax(string3, connectionFolder, 30)) {
                    string2 = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_NAME_TOO_LONG"), 30);
                    throw new IllegalArgumentException(string2);
                }
                return string3;
            }
            if (this.propIndex == RowIndex.COMMENT) {
                CharSequence charSequence;
                String string4 = string;
                StringBuffer stringBuffer = new StringBuffer();
                if (string4.length() > 4000) {
                    string4 = string4.substring(0, 4000);
                    charSequence = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_TOO_LONG"), 4000);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)charSequence, (String)PropertyLrb.get("PI_COMMON_GROUP_NODE_SETTING_ERROR_TITLE"), null);
                }
                if (!StringUtils.checkStringDBLengthMaxLong(string4, connectionFolder, 4000)) {
                    charSequence = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_MAX_BYTES"), 4000);
                    throw new IllegalArgumentException((String)charSequence);
                }
                if (StringUtils.checkDataLoss(connectionFolder, string4, stringBuffer)) {
                    charSequence = new StringBuffer();
                    for (int i = 0; i < stringBuffer.length(); ++i) {
                        if (((StringBuffer)charSequence).length() > 0) {
                            ((StringBuffer)charSequence).append(" ");
                        }
                        ((StringBuffer)charSequence).append(stringBuffer.charAt(i));
                    }
                    String string5 = MessageFormat.format(PropertyLrb.get("PI_COMMON_GROUP_NODE_COMMENT_DATA_LOSS"), charSequence);
                    throw new IllegalArgumentException(string5);
                }
                return string4;
            }
            return string;
        }

        private boolean isDuplicateName(String string) {
            boolean bl = false;
            Editor editor = EditorManager.getEditorManager().getCurrentEditor();
            if (editor instanceof WorkflowEditor) {
                WorkflowEditor workflowEditor = (WorkflowEditor)editor;
                bl = workflowEditor.doesNodeNameAlreadyExist(string);
            }
            return bl;
        }

        private boolean containsForwardSlash(String string) {
            return string.indexOf("/") >= 0;
        }

        private boolean containsAmpersand(String string) {
            return string.indexOf("&") >= 0;
        }
    }

    protected static class Groups {
        public static final PropertyGroupImpl COMMON = new PropertyGroupImpl(PreferencesLrb.get("PI_COMMON_GROUP_TITLE"));

        protected Groups() {
        }
    }

    public static interface RowIndex {
        public static final int NAME = AbstractNodePropertyModel.access$008();
        public static final int COMMENT = AbstractNodePropertyModel.access$008();
    }
}

