/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionObject;
import oracle.dmt.dataminer.workflow.dialog.data.StatisticsSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformSettingsEditorDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesBasePanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesPanelPreRun;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.StatsSelection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;

public class TransformationNodeMainAttributesPanel
extends AbstractPanel<TransformationNode>
implements DataConsumerPanel {
    private static final String TRANSFORMATION_TAB_NAME = XformDialogsLrb.get("MAIN_TRANSFORMATION_DIALOG_TRANSFORMATION_TAB");
    private static final String DATA_EXPLORE_STATS_TAB = DataDialogsLrb.get("DATA_EXPLORE_STATS_TAB");
    private TransformationNodeAttributesBasePanel transformationPanel;
    private StatisticsSelectionPanel statsPanel;
    private TransformSettingsEditorDialog parentDlg;
    private JTabbedPane jProfileTabbedPane;

    public TransformationNodeMainAttributesPanel(TransformSettingsEditorDialog transformSettingsEditorDialog, Context context, TransformationNode transformationNode) {
        super(context, transformationNode);
        this.parentDlg = transformSettingsEditorDialog;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jProfileTabbedPane = new JTabbedPane();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProfileTabbedPane, GroupLayout.Alignment.TRAILING, -1, 513, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProfileTabbedPane, GroupLayout.Alignment.TRAILING, -1, 427, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "edit_transform_settings");
    }

    @Override
    public void initUI() {
        ResultType resultType;
        TransformationNode transformationNode = (TransformationNode)this.getData();
        TransformationNodeType transformationNodeType = (TransformationNodeType)transformationNode.getData();
        StatsSelection statsSelection = transformationNodeType.getStatsSelection();
        if (statsSelection == null) {
            statsSelection = StatisticsSelectionObject.createDefaultStatsSelection();
        }
        boolean bl = null != (resultType = transformationNodeType.getInputStatisticTable()) && null != resultType.getName();
        this.initRes();
        this.transformationPanel = bl ? new TransformationNodeAttributesPanel(this.parentDlg, this.getContext(), transformationNode) : new TransformationNodeAttributesPanelPreRun(this.parentDlg, this.getContext(), transformationNode);
        this.jProfileTabbedPane.addTab(TRANSFORMATION_TAB_NAME, this.transformationPanel);
        this.statsPanel = new StatisticsSelectionPanel(this.getContext(), statsSelection);
        this.jProfileTabbedPane.addTab(DATA_EXPLORE_STATS_TAB, this.statsPanel);
    }

    void updateResfresButtonState() {
        if (this.transformationPanel instanceof TransformationNodeAttributesPanel) {
            ((TransformationNodeAttributesPanel)this.transformationPanel).updateResfresButtonState();
        }
    }

    void updateGraph(GraphDataModel graphDataModel) {
        if (this.transformationPanel instanceof TransformationNodeAttributesPanel) {
            ((TransformationNodeAttributesPanel)this.transformationPanel).updateGraph(graphDataModel);
        }
    }

    void updateGraph(Map<String, GraphDataModel> map) {
        if (this.transformationPanel instanceof TransformationNodeAttributesPanel) {
            ((TransformationNodeAttributesPanel)this.transformationPanel).updateGraph(map);
        }
    }

    void updateGraphNoData() {
        if (this.transformationPanel instanceof TransformationNodeAttributesPanel) {
            ((TransformationNodeAttributesPanel)this.transformationPanel).updateGraphNoData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        boolean bl = this.transformationPanel.doWork();
        if (bl && (bl = this.statsPanel.doWork())) {
            TransformationNode transformationNode = (TransformationNode)this.getData();
            TransformationNodeType transformationNodeType = (TransformationNodeType)transformationNode.getData();
            TransformationNodeType transformationNodeType2 = this.transformationPanel.getCachedTransformationNodeType();
            TransformedAttributes transformedAttributes = transformationNodeType2.getTransformedAttributes();
            StatsSelection statsSelection = this.statsPanel.getResults();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(TransformationNode.STATS_SELECTION, null, statsSelection, null, null));
            CommandProcessor.getInstance().beginTrans(XformDialogsLrb.get("XFROM_NODE_PROPERTIES_TRANSACTION_NAME"));
            try {
                arrayList.add(new Property("allXfomNodeColumns", null, AttributeTypeHelper.getAllColumns(transformationNodeType2), null, null));
                arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
                OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)transformationNode.getUndoFilter();
                odmrSDMUndoFilter.prepareUndoPropertyList(transformationNode, this._context, arrayList);
                transformationNode.validate(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)XformDialogsLrb.get("XFROM_NODE_PROPERTIES_DIALOG_FAILURE_TITLE"), (String)XformDialogsLrb.get("XFROM_NODE_PROPERTIES_DIALOG_FAILURE_MSG"), null);
                bl = false;
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }
        return bl;
    }
}

