/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class DatePickerPanel
extends DialogDisplayer {
    private static final String AM = XformDialogsLrb.get("DATEPICKER_AM");
    private static final String PM = XformDialogsLrb.get("DATEPICKER_PM");
    private Calendar calendar;
    private boolean showTimezone;
    private JToggleButton jCalendarPopupButton;
    private JComboBox jComboAmApm;
    private JLabel jLabelDate;
    private JLabel jLabelTime;
    private JLabel jLabelTimeZone;
    private JSpinner jSpinnerHour;
    private JSpinner jSpinnerMin;
    private JSpinner jSpinnerSec;
    private JTextField jTextFieldDate;
    private JComboBox jTimeZoneCombo;

    public DatePickerPanel(GregorianCalendar gregorianCalendar, boolean bl) {
        this.showTimezone = bl;
        this.calendar = gregorianCalendar;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jTextFieldDate = new JTextField();
        this.jLabelDate = new JLabel();
        this.jCalendarPopupButton = new CalendarPopupButton();
        this.jLabelTime = new JLabel();
        this.jSpinnerHour = new JSpinner();
        this.jSpinnerMin = new JSpinner();
        this.jSpinnerSec = new JSpinner();
        this.jComboAmApm = new JComboBox();
        this.jLabelTimeZone = new JLabel();
        this.jTimeZoneCombo = new JComboBox();
        this.jTextFieldDate.setEditable(false);
        this.jLabelDate.setText("Date:");
        this.jLabelTime.setText("Time:");
        this.jSpinnerHour.setModel(new SpinnerNumberModel(11, 0, 11, 1));
        this.jSpinnerMin.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        this.jSpinnerSec.setModel(new SpinnerNumberModel(0, 0, 60, 1));
        this.jComboAmApm.setModel(new DefaultComboBoxModel<String>(new String[]{"AM", "PM"}));
        this.jLabelTimeZone.setText("Time Zone:");
        this.jTimeZoneCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabelTime, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelDate, -1, 62, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSpinnerHour, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerMin, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerSec, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboAmApm, 0, 0, Short.MAX_VALUE)).addComponent(this.jTextFieldDate, -2, 178, -2))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelTimeZone, -1, 62, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTimeZoneCombo, -2, 178, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCalendarPopupButton, -2, 33, -2).addContainerGap()));
        groupLayout.linkSize(0, this.jLabelDate, this.jLabelTime, this.jLabelTimeZone);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDate, -2, -1, -2).addComponent(this.jLabelDate)).addComponent(this.jCalendarPopupButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTime).addComponent(this.jSpinnerHour, -2, -1, -2).addComponent(this.jSpinnerMin, -2, -1, -2).addComponent(this.jSpinnerSec, -2, -1, -2)).addComponent(this.jComboAmApm, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTimeZone).addComponent(this.jTimeZoneCombo, -2, -1, -2)).addContainerGap(19, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelDate, (Component)this.jTextFieldDate, (String)XformDialogsLrb.get("DATEPICKER_DATE"));
        this.jLabelTime.setText(XformDialogsLrb.get("DATEPICKER_TIME"));
        this.jComboAmApm.setModel(new DefaultComboBoxModel<String>(new String[]{AM, PM}));
        if (this.showTimezone) {
            ResourceUtils.resLabel((JLabel)this.jLabelTimeZone, (Component)this.jTimeZoneCombo, (String)XformDialogsLrb.get("DATEPICKER_TIME_ZONE"));
            this.jTimeZoneCombo.setModel(new DefaultComboBoxModel<String>(TimeUtils.getTimeZoneStrings()));
        } else {
            this.jLabelTimeZone.setVisible(false);
            this.jTimeZoneCombo.setVisible(false);
        }
    }

    private String toDate(Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        StringBuilder stringBuilder = new StringBuilder();
        if (n3 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n3);
        stringBuilder.append(".");
        if (n2 + 1 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n2 + 1);
        stringBuilder.append(".");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private void setDate() {
        this.jTextFieldDate.setText(this.toDate(this.calendar));
        int n = this.calendar.get(10);
        this.jSpinnerHour.setValue(n);
        int n2 = this.calendar.get(12);
        this.jSpinnerMin.setValue(n2);
        int n3 = this.calendar.get(13);
        this.jSpinnerSec.setValue(n3);
        int n4 = this.calendar.get(9);
        if (n4 == 0) {
            this.jComboAmApm.setSelectedItem(AM);
        } else {
            this.jComboAmApm.setSelectedItem(PM);
        }
        if (this.showTimezone) {
            TimeZone timeZone = this.calendar.getTimeZone();
            String string = timeZone.getDisplayName(Locale.getDefault());
            this.jTimeZoneCombo.setSelectedItem(string);
        }
    }

    @Override
    public void initUI() {
        this.setDate();
        CalendarPanel calendarPanel = ((CalendarPopupButton)this.jCalendarPopupButton).getCalendarPanel();
        calendarPanel.setMultiSelect(false);
        calendarPanel.setShowTime(false);
        calendarPanel.setShowTimeZone(false);
        calendarPanel.setSelectedDate(this.calendar.getTime());
        calendarPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("DOUBLE_CLICK_COMMAND".equals(actionEvent.getActionCommand())) {
                    Date[] dateArray = ((CalendarPopupButton)DatePickerPanel.this.jCalendarPopupButton).getSelectedDates();
                    for (int i = 0; i < dateArray.length; ++i) {
                        Date date = dateArray[i];
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        DatePickerPanel.this.jTextFieldDate.setText(DatePickerPanel.this.toDate(calendar));
                        int n = calendar.get(1);
                        int n2 = calendar.get(2);
                        int n3 = calendar.get(5);
                        DatePickerPanel.this.calendar.set(n, n2, n3);
                    }
                }
            }
        });
        Container container = calendarPanel.getParent();
        do {
            if (container == null || !(container instanceof JDialog)) continue;
            ((JDialog)container).setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            break;
        } while ((container = container.getParent()) != null);
    }

    @Override
    public boolean doWork() {
        int n = (Integer)this.jSpinnerHour.getValue();
        this.calendar.set(10, n);
        int n2 = (Integer)this.jSpinnerMin.getValue();
        this.calendar.set(12, n2);
        int n3 = (Integer)this.jSpinnerSec.getValue();
        this.calendar.set(13, n3);
        String string = (String)this.jComboAmApm.getSelectedItem();
        int n4 = string.equals(AM) ? 0 : 1;
        this.calendar.set(9, n4);
        if (this.showTimezone) {
            String string2 = (String)this.jTimeZoneCombo.getSelectedItem();
            TimeZone timeZone = TimeUtils.toTimeZone(string2);
            this.calendar.setTimeZone(timeZone);
        }
        return true;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    protected String getDialogTitle() {
        return XformDialogsLrb.get("DATEPICKER_LABEL");
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }

    @Override
    protected int getDialogButtonMask() {
        return 3;
    }
}

