/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dmt.dataminer.expressionbuilder.DialogsLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsPanelAbstract;
import oracle.dmt.dataminer.workflow.dialog.transformations.CustomTransformationPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class AddEditCustomTransformsPanelNoStats
extends AddEditTransformsPanelAbstract {
    protected TransformationOutputAttribute _editedColumn;
    protected String newColumnName;
    protected String _customDataType;
    protected TransformationType _resultTransformationType;
    private String _selectedTransformation = TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM();
    protected boolean bEditingMode = false;
    protected int datatype = 0;
    protected AddEditTransformsPanelAbstract peer;
    private JLabel jLabelOutputColumn;
    private JPanel jPanelXformDetails;
    private JTextField jTextFieldOutput;
    protected CustomTransformationPanel customPanel;

    @Override
    public AttributeTypeHelper.ExTransformationSourceAttribute getSelectedSourceColumn() {
        return null;
    }

    @Override
    protected TransformationOutputAttribute getEditedColumn() {
        return this._editedColumn;
    }

    public void setNewColumnName(String string) {
        this.newColumnName = string;
    }

    @Override
    public String getNewColumnName() {
        return this.newColumnName;
    }

    @Override
    public String getCustomDataType() {
        return this._customDataType;
    }

    @Override
    protected TransformationType getResultTransformationType() {
        return this._resultTransformationType;
    }

    @Override
    public boolean isEditingMode() {
        return this.bEditingMode;
    }

    public AddEditCustomTransformsPanelNoStats(AddEditTransformsPanelAbstract addEditTransformsPanelAbstract, Context context, TransformationStatisticsState transformationStatisticsState, TransformationOutputAttribute transformationOutputAttribute, TransformationNodeType transformationNodeType, Map<String, TransformationSourceAttribute> map, List<TransformationSourceAttribute> list) {
        super(context, transformationStatisticsState, transformationNodeType, map, list, null);
        this.peer = addEditTransformsPanelAbstract;
        this.copyEditedColumn(transformationOutputAttribute);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public AddEditCustomTransformsPanelNoStats(Context context, TransformationStatisticsState transformationStatisticsState, TransformationOutputAttribute transformationOutputAttribute, TransformationNodeType transformationNodeType, Map<String, TransformationSourceAttribute> map, List<TransformationSourceAttribute> list) {
        super(context, transformationStatisticsState, transformationNodeType, map, list, null);
        this.copyEditedColumn(transformationOutputAttribute);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jLabelOutputColumn = new JLabel();
        this.jTextFieldOutput = new JTextField();
        this.jPanelXformDetails = new JPanel();
        this.jLabelOutputColumn.setText("Output Column:");
        this.jLabelOutputColumn.setMaximumSize(new Dimension(76, 14));
        this.jTextFieldOutput.setText("            ");
        this.jPanelXformDetails.setBorder(BorderFactory.createTitledBorder("Binning"));
        this.jPanelXformDetails.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelOutputColumn, -2, 108, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldOutput, -2, 156, -2).addContainerGap(174, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelXformDetails, -1, 432, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOutputColumn, -2, -1, -2).addComponent(this.jTextFieldOutput, -2, -1, -2)).addContainerGap(363, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.jPanelXformDetails, -1, 334, Short.MAX_VALUE).addContainerGap())));
        this.jLabelOutputColumn.getAccessibleContext().setAccessibleName("Output Column:");
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelOutputColumn, (Component)this.jTextFieldOutput, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_OUTPUT_COLUMN"));
    }

    private void copyEditedColumn(TransformationOutputAttribute transformationOutputAttribute) {
        if (null == transformationOutputAttribute) {
            return;
        }
        this._editedColumn = new TransformationOutputAttribute();
        AttributeTypeHelper.copyTransformationOutputAttribute(this._editedColumn, transformationOutputAttribute);
    }

    @Override
    public void initUI() {
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        AttributeTypeHelper.copyTransformedAttributes(transformedAttributes, this._nodeData.getTransformedAttributes());
        if (this._editedColumn != null) {
            this.bEditingMode = true;
        }
        this.customPanel = new CustomTransformationPanel(this._context, this._state, this._editedColumn, this, true);
        this.jPanelXformDetails.add(TransformationTypes.CUSTOM_PANEL, this.customPanel);
        this.showPanel();
        this.newColumnName = !this.bEditingMode ? this.generateOutputName(transformedAttributes) : this._editedColumn.getName();
        this.jTextFieldOutput.getDocument().addDocumentListener(new DocumentListener(){

            private void enable() {
                boolean bl = AddEditCustomTransformsPanelNoStats.this.customPanel.isExpressionEmpty();
                AddEditCustomTransformsPanelNoStats.this.customPanel.enableValidateBtn(!bl);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.enable();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.enable();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.enable();
            }
        });
        if (!StringUtils.isValidNonQuotedDBObjectName(this.newColumnName)) {
            this.newColumnName = StringUtils.addDoubleQuotes(this.newColumnName);
        }
        this.setOutputName(this.newColumnName);
        this.customPanel.setOutputColumnName(this.newColumnName);
        this.jTextFieldOutput.setEditable(true);
    }

    public boolean isCustomTransformation() {
        return true;
    }

    public String getCustomOutputName() {
        return this.jTextFieldOutput.getText();
    }

    private void showPanel() {
        this.jPanelXformDetails.setBorder(BorderFactory.createTitledBorder(this._selectedTransformation));
        CardLayout cardLayout = (CardLayout)this.jPanelXformDetails.getLayout();
        cardLayout.show(this.jPanelXformDetails, this._selectedTransformation);
    }

    public boolean validateAttributeName(String string) {
        String string2;
        boolean bl = true;
        String string3 = null;
        if (string == null || string.isEmpty() || string.trim().isEmpty()) {
            string3 = XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_INVALID_NAME");
        } else if (!StringUtils.checkStringLength(string, 30)) {
            string3 = XformDialogsLrb.get("TRANSFORMATION_ERROR_ATTRIBUTE_TOOLONG");
        } else if (StringUtils.containsDoubleQuote(string)) {
            string3 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_HASDBLQUOTE");
        } else if (!StringUtils.containsSingleQuote(string) && !StringUtils.checkStringLength(string2 = StringUtils.escapeSingleQuotesForSQL(string), 30)) {
            string3 = DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_TOOLONG");
        }
        if (string3 != null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean doWork() {
        boolean bl = false;
        try {
            MapTransformedSource mapTransformedSource;
            Object object2;
            this.newColumnName = this.getCustomOutputName();
            if (!StringUtils.isDoubleQuotedString(this.newColumnName)) {
                this.newColumnName = this.newColumnName.toUpperCase();
            }
            if (!AttributeNameValidator.validateAttributeName(this.newColumnName, null, this._context, true)) {
                return false;
            }
            List list = this._nodeData.getTransformationSourceAttributes().getTransformationSourceAttributeType();
            for (Object object2 : list) {
                if (!this.newColumnName.equals(object2.getName())) continue;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Not a valid attribute", (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return false;
            }
            List list2 = this._nodeData.getTransformedAttributes().getMapTransformedSourceType();
            object2 = list2.iterator();
            while (object2.hasNext()) {
                mapTransformedSource = (MapTransformedSource)object2.next();
                if (this.bEditingMode || !mapTransformedSource.getKey().getName().equals(this.newColumnName)) continue;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("EXPBLDR_ERROR_ATTRIBUTE_EXISTS_IN_SOURCE"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
                return false;
            }
            this.newColumnName = StringUtils.trimDoubleQuotes(this.newColumnName);
            this.customPanel.setOutputColumnName(this.newColumnName);
            object2 = this.customPanel.getResultsEx();
            if (object2 != null) {
                this._resultTransformationType = new TransformationType();
                this._resultTransformationType.setCustomTransformationEx((String)object2);
                this._customDataType = this.customPanel.getDataType();
                bl = true;
            } else {
                mapTransformedSource = this.customPanel.getResults();
                if (mapTransformedSource != null) {
                    this._resultTransformationType.setCustomTransformationEx(mapTransformedSource.getValue());
                    this._customDataType = this.customPanel.getDataType();
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
        }
        return bl;
    }

    private String generateOutputName(TransformedAttributes transformedAttributes) {
        String string = TransformationTypes.getXformAbbreviatedName(this._selectedTransformation);
        String string2 = AttributeTypeHelper.createUniqueTransformationOutputName(null, string, this._xformationSourceAttrList, transformedAttributes.getMapTransformedSourceType());
        return string2;
    }

    public void updateOutputName(MapTransformedSource mapTransformedSource) {
        String string;
        TransformationType transformationType = mapTransformedSource.getKey().getTransformationElementType();
        String string2 = TransformationTypes.getXformAbbreviatedName(TransformationTypes.transformationTypeToString(transformationType));
        this.newColumnName = string = AttributeTypeHelper.createUniqueTransformationOutputName(null, string2, this._xformationSourceAttrList, this._nodeData.getTransformedAttributes().getMapTransformedSourceType());
        this.setOutputName(this.newColumnName);
    }

    public void setOutputName(String string) {
        this.jTextFieldOutput.setText(this.validateColumnName(string));
    }

    private String validateColumnName(String string) {
        if (!StringUtils.isValidNonQuotedDBObjectName(string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase())) {
            string = StringUtils.addDoubleQuotes(string);
        }
        return string;
    }

    @Override
    protected void selectionChanged() {
    }

    @Override
    public MapTransformedSource getTransformedAttribute() {
        MapTransformedSource mapTransformedSource = null;
        String string = this.getCustomDataType();
        if (this.isEditingMode()) {
            TransformationType transformationType;
            TransformationType transformationType2;
            String string2;
            mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(this._nodeData.getTransformedAttributes(), (AttributeType)this.getEditedColumn());
            TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
            boolean bl = false;
            String string3 = transformationOutputAttribute.getName();
            if (0 != string3.compareTo(string2 = this.getNewColumnName())) {
                transformationOutputAttribute.setName(string2);
                bl = true;
            }
            if (!TransformationTypes.areEqual(transformationType2 = this.getResultTransformationType(), transformationType = transformationOutputAttribute.getTransformationElementType())) {
                transformationOutputAttribute.setTransformationElementType(transformationType2);
                if (!bl) {
                    bl = true;
                }
            }
            if (!transformationOutputAttribute.isModified()) {
                transformationOutputAttribute.setModified(bl);
            }
            transformationOutputAttribute.setDataType(string);
            transformationOutputAttribute.setModified(true);
        } else {
            TransformationType transformationType = this.getResultTransformationType();
            mapTransformedSource = new MapTransformedSource();
            TransformationOutputAttribute transformationOutputAttribute = new TransformationOutputAttribute();
            transformationOutputAttribute.setModified(true);
            transformationOutputAttribute.setName(this.getNewColumnName());
            transformationOutputAttribute.setDataType(string);
            transformationOutputAttribute.setIsOutput(true);
            transformationOutputAttribute.setStatus(AttributeStatus.VALID);
            transformationOutputAttribute.setTransformationElementType(transformationType);
            mapTransformedSource.setKey(transformationOutputAttribute);
            StringCollection stringCollection = new StringCollection();
            mapTransformedSource.setStringCollectionNames(stringCollection);
        }
        return mapTransformedSource;
    }
}

