/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.tests;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.tests.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.tests.TestModelPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class TestModelPickerPanel
extends DialogDisplayer<TestNode> {
    private static final Logger theLogger = Logger.getLogger(TestModelPickerPanel.class.getName());
    private static final String UNKNOWN = DialogsLrb.get("TEST_UNKNOWN");
    private List<TestModelType.Model> availModelsCache;
    private List<TestModelType.Model> selectedModelsCache;
    private TestModelPanel _parent;
    private MiningFunctionType _curMiningFunction = null;
    private AttributeType _curTarget = null;
    private boolean _dirty = false;
    private boolean _showSchema = false;
    private boolean _showPartition = false;
    private DataMinerTable jAvailAttrs;
    private JScrollPane jAvailAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JLabel jCaseIdLabel;
    private JLabel jCaseIdValue;
    private JLabel jMiningFunctionLabel;
    private JLabel jMiningFunctionValue;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTable jSelectedAttrs;
    private JScrollPane jSelectedAttrsScrollPane;
    private JLabel jSelectedLabel;
    private JLabel jTargetLabel;
    private JLabel jTargetTypeLabel;
    private JLabel jTargetTypeValue;
    private JLabel jTargetValue;

    public TestModelPickerPanel(Context context, TestModelPanel testModelPanel, TestModelType testModelType, boolean bl) {
        super(context, testModelPanel.getData());
        List<RefModelType> list;
        ModelProvider modelProvider;
        this._parent = testModelPanel;
        this._showPartition = bl;
        this.availModelsCache = new ArrayList<TestModelType.Model>();
        TestNode testNode = (TestNode)this._parent.getData();
        this._curTarget = testModelPanel.getTargetAttr();
        this._curMiningFunction = testModelPanel.getMiningFunction();
        List<AbstractNode> list2 = testNode.findTestModelNodes();
        String string = null;
        try {
            string = ConnectionFolder.getUserAccountName(this._context);
            string = StringUtils.isDoubleQuotedString(string) ? StringUtils.trimDoubleQuotes(string) : string.toUpperCase();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this._showSchema = false;
        block2: for (AbstractNode abstractNode : list2) {
            modelProvider = (ModelProvider)((Object)abstractNode);
            list = modelProvider.getOutputModels();
            for (RefModelType refModelType : list) {
                String string2 = refModelType.getSchema();
                if (string2 == null || string2.compareTo(string) == 0) continue;
                this._showSchema = true;
                continue block2;
            }
        }
        for (AbstractNode abstractNode : list2) {
            modelProvider = (ModelProvider)((Object)abstractNode);
            list = modelProvider.getOutputModels();
            for (RefModelType refModelType : list) {
                String string3;
                List<PartitionExpressionType> list3;
                String string4;
                boolean bl2 = false;
                if (!refModelType.isUseForOutput()) continue;
                if (this._curMiningFunction == null) {
                    this._curMiningFunction = refModelType.getMiningFunction();
                    this._curTarget = modelProvider.getTargetAttribute();
                    bl2 = true;
                } else {
                    String string5;
                    string4 = this._curTarget != null ? this._curTarget.getName() : "";
                    list3 = this._curTarget != null ? this._curTarget.getDataType() : "";
                    string3 = modelProvider.getTargetAttribute() != null ? modelProvider.getTargetAttribute().getName() : "";
                    String string6 = string5 = modelProvider.getTargetAttribute() != null ? modelProvider.getTargetAttribute().getDataType() : "";
                    if (modelProvider.getMiningFunctionTypeSupported().equals((Object)this._curMiningFunction) && string3.equals(string4) && string5.equals(list3)) {
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                string4 = new TestModelType.Model();
                list3 = modelProvider.getPartitionAttributes(refModelType);
                if (list3 != null && list3.size() > 0) {
                    string3 = new PartitionExpressions();
                    string3.getPartitionExpression().addAll(list3);
                    string4.setPartitionExpressions((PartitionExpressions)string3);
                }
                string4.setMiningAlgorithm(refModelType.getMiningAlgorithm());
                string4.setMiningFunction(refModelType.getMiningFunction());
                string4.setModelId(refModelType.getModelId());
                string4.setName(refModelType.getName());
                string4.setNodeId(refModelType.getNodeId());
                string4.setSchema(refModelType.getSchema());
                string4.setStatus(refModelType.getStatus());
                string4.setTestStatus(ModelStatusType.READY);
                this.availModelsCache.add((TestModelType.Model)string4);
            }
        }
        TestModelType testModelType2 = (TestModelType)MetaDataHelper.copyMetadataObject(testModelType);
        this.selectedModelsCache = testModelType2.getModel();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jMiningFunctionLabel = new JLabel();
        this.jMiningFunctionValue = new JLabel();
        this.jTargetLabel = new JLabel();
        this.jTargetValue = new JLabel();
        this.jTargetTypeLabel = new JLabel();
        this.jTargetTypeValue = new JLabel();
        this.jCaseIdLabel = new JLabel();
        this.jCaseIdValue = new JLabel();
        this.jAvailableLabel = new JLabel();
        this.jAvailAttrsScrollPane = new JScrollPane();
        this.jAvailAttrs = new DataMinerTable();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jSelectedLabel = new JLabel();
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedAttrs = new DataMinerTable();
        this.jMiningFunctionLabel.setText("Function:");
        this.jMiningFunctionLabel.setName("jMiningFunctionLabel");
        this.jMiningFunctionValue.setText("Classification");
        this.jMiningFunctionValue.setName("jMiningFunctionValue");
        this.jTargetLabel.setText("Target:");
        this.jTargetLabel.setName("jTargetLabel");
        this.jTargetValue.setText("AFFINITY_CARD");
        this.jTargetValue.setName("jTargetValue");
        this.jTargetTypeLabel.setText("Target Type:");
        this.jTargetTypeLabel.setName("jTargetTypeLabel");
        this.jTargetTypeValue.setText("DM_NESTED_CATEGORICAL");
        this.jTargetTypeValue.setName("jTargetTypeValue");
        this.jCaseIdLabel.setText("Case Id:");
        this.jCaseIdLabel.setName("jCaseIdLabel");
        this.jCaseIdValue.setText("CUST_ID");
        this.jCaseIdValue.setName("jCaseIdValue");
        this.jAvailableLabel.setText("Available Models");
        this.jAvailableLabel.setName("jAvailableLabel");
        this.jAvailAttrsScrollPane.setName("jAvailAttrsScrollPane");
        this.jAvailAttrs.setModel(new DefaultTableModel(new Object[][]{{"CLAS_SVM_1", "BuildClassificationModels", "SupportVectorMachine"}}, new String[]{"Model", "Node", "Algorithm"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jAvailAttrs.setName("jAvailAttrs");
        this.jAvailAttrsScrollPane.setViewportView((Component)((Object)this.jAvailAttrs));
        this.jSelectBtn.setText(">");
        this.jSelectBtn.setName("jSelectBtn");
        this.jSelectAllBtn.setText(">>");
        this.jSelectAllBtn.setName("jSelectAllBtn");
        this.jRemoveBtn.setText("<");
        this.jRemoveBtn.setName("jRemoveBtn");
        this.jRemoveAllBtn.setText("<<");
        this.jRemoveAllBtn.setName("jRemoveAllBtn");
        this.jSelectedLabel.setText("Selected Models");
        this.jSelectedLabel.setName("jSelectedLabel");
        this.jSelectedAttrsScrollPane.setName("jSelectedAttrsScrollPane");
        this.jSelectedAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null, null}}, new String[]{"Model", "Node", "Algorithm"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrs.setName("jSelectedAttrs");
        this.jSelectedAttrsScrollPane.setViewportView((Component)((Object)this.jSelectedAttrs));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jCaseIdLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jTargetLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -2, 54, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCaseIdValue, -2, 203, -2).addComponent(this.jTargetValue, -2, 203, -2).addComponent(this.jMiningFunctionValue, -2, 203, -2)).addGap(18, 18, 18).addComponent(this.jTargetTypeLabel, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetTypeValue, -2, 147, -2).addGap(313, 313, 313)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jAvailAttrsScrollPane, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -2, 49, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -2, 0, Short.MAX_VALUE).addComponent(this.jSelectedLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMiningFunctionLabel).addComponent(this.jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jTargetValue).addComponent(this.jTargetTypeLabel).addComponent(this.jTargetTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseIdLabel).addComponent(this.jCaseIdValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedLabel).addComponent(this.jAvailableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 281, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn)).addComponent(this.jAvailAttrsScrollPane, -1, 281, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jMiningFunctionLabel, (Component)this.jMiningFunctionValue, (String)DialogsLrb.get("TEST_MODEL_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jTargetLabel, (Component)this.jTargetValue, (String)DialogsLrb.get("TEST_MODEL_TARGET"));
        ResourceUtils.resLabel((JLabel)this.jTargetTypeLabel, (Component)this.jTargetTypeValue, (String)DialogsLrb.get("TEST_MODEL_TARGET_TYPE"));
        ResourceUtils.resLabel((JLabel)this.jCaseIdLabel, (Component)this.jCaseIdValue, (String)DialogsLrb.get("TEST_MODEL_CASE_ID"));
        ResourceUtils.resLabel((JLabel)this.jAvailableLabel, (Component)((Object)this.jAvailAttrs), (String)DialogsLrb.get("TEST_MODEL_AVAIL_MODELS"));
        ResourceUtils.resLabel((JLabel)this.jSelectedLabel, (Component)((Object)this.jSelectedAttrs), (String)DialogsLrb.get("TEST_MODEL_SELECT_MODELS"));
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    @Override
    public void initUI() {
        TestNode testNode = (TestNode)this._parent.getData();
        TestNodeType testNodeType = (TestNodeType)testNode.getData();
        this.jMiningFunctionValue.setText(this._curMiningFunction != null ? this._curMiningFunction.value() : UNKNOWN);
        this.jTargetValue.setText(this._curTarget != null ? this._curTarget.getName() : UNKNOWN);
        this.jTargetTypeValue.setText(this._curTarget != null ? this._curTarget.getDataType() : UNKNOWN);
        this.jCaseIdLabel.setVisible(testNodeType.getTestModels().getMiningFunction() != null && testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION));
        this.jCaseIdValue.setVisible(testNodeType.getTestModels().getMiningFunction() != null && testNodeType.getTestModels().getMiningFunction().equals((Object)MiningFunctionType.REGRESSION));
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        String[] stringArray = new String[]{DialogsLrb.get("TEST_MODEL_NAME"), DialogsLrb.get("TEST_MODEL_NODE"), DialogsLrb.get("TEST_MODEL_PARTITION"), DialogsLrb.get("TEST_MODEL_ALGORITHM")};
        this.removeSelectedAttrs(this.availModelsCache, this.selectedModelsCache);
        ModelTableModel modelTableModel = new ModelTableModel(this.availModelsCache, stringArray);
        this.jAvailAttrs.setModel((TableModel)((Object)modelTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        ModelNameCellRenderer modelNameCellRenderer = new ModelNameCellRenderer(this.availModelsCache, DataMinerIcons.getNullIcon(), OracleIcons.getIcon((String)"database_error.png"));
        tableColumn.setCellRenderer(modelNameCellRenderer);
        if (!this._showPartition) {
            this.jAvailAttrs.removeColumn(this.jAvailAttrs.getColumnModel().getColumn(2));
        }
        ModelTableModel modelTableModel2 = new ModelTableModel(this.selectedModelsCache, stringArray);
        this.jSelectedAttrs.setModel((TableModel)((Object)modelTableModel2));
        this.jSelectedAttrs.setSorted(true);
        tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        modelNameCellRenderer = new ModelNameCellRenderer(this.selectedModelsCache, DataMinerIcons.getNullIcon(), OracleIcons.getIcon((String)"database_error.png"));
        tableColumn.setCellRenderer(modelNameCellRenderer);
        if (!this._showPartition) {
            this.jSelectedAttrs.removeColumn(this.jSelectedAttrs.getColumnModel().getColumn(2));
        }
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPickerPanel.this.moveItems(TestModelPickerPanel.this.jAvailAttrs, TestModelPickerPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPickerPanel.this.moveItems(TestModelPickerPanel.this.jAvailAttrs, TestModelPickerPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPickerPanel.this.moveItems(TestModelPickerPanel.this.jSelectedAttrs, TestModelPickerPanel.this.jAvailAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestModelPickerPanel.this.moveItems(TestModelPickerPanel.this.jSelectedAttrs, TestModelPickerPanel.this.jAvailAttrs, true);
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List<TestModelType.Model> list = ((ModelTableModel)((Object)genericTable.getModel())).getDataList();
        ArrayList<TestModelType.Model> arrayList = new ArrayList<TestModelType.Model>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                object2 = list.get(nArray[n2]);
                arrayList.add((TestModelType.Model)object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add(list.get(n2));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List<TestModelType.Model> list2 = ((ModelTableModel)((Object)genericTable2.getModel())).getDataList();
        list2.addAll(arrayList);
        ((ModelTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((ModelTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (TestModelType.Model)n3;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
        this._dirty = true;
    }

    private void removeSelectedAttrs(List<TestModelType.Model> list, List<TestModelType.Model> list2) {
        HashMap<String, TestModelType.Model> hashMap = new HashMap<String, TestModelType.Model>();
        for (TestModelType.Model model : list2) {
            hashMap.put(model.getNodeId() + "." + model.getName(), model);
        }
        Iterator<TestModelType.Model> iterator = list.iterator();
        while (iterator.hasNext()) {
            TestModelType.Model model;
            model = iterator.next();
            TestModelType.Model model2 = (TestModelType.Model)hashMap.get(model.getNodeId() + "." + model.getName());
            if (model2 == null || !model2.getName().equals(model.getName())) continue;
            iterator.remove();
        }
    }

    public List<TestModelType.Model> getSelectedModelsCache() {
        return this.selectedModelsCache;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("TEST_MODEL_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "test_select_models";
    }

    private static class ModelNameCellRenderer
    extends DefaultTableCellRenderer {
        private Icon validIcon;
        private Icon invalidIcon;
        private List<TestModelType.Model> _cache;

        public ModelNameCellRenderer(List<TestModelType.Model> list, Icon icon, Icon icon2) {
            this._cache = list;
            this.validIcon = icon;
            this.invalidIcon = icon2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            TestModelType.Model model = this._cache.get(n);
            RefModelStatusType refModelStatusType = model.getStatus();
            if (refModelStatusType == RefModelStatusType.VALID) {
                this.setIcon(this.validIcon);
            } else {
                this.setIcon(this.invalidIcon);
            }
            return component;
        }
    }

    class ModelTableModel
    extends GenericBaseTableModel {
        private List<TestModelType.Model> _data;
        private final int TEST_MODEL_NAME = 0;
        private final int TEST_MODEL_NODE = 1;
        static final int TEST_MODEL_PARTITION = 2;
        private final int TEST_MODEL_ALGORITHM = 3;
        private final int COLUMN_COUNT = 4;

        public ModelTableModel(List<TestModelType.Model> list, String[] stringArray) {
            this._data = list;
            this.setColumnIdentifiers(stringArray);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(4);
        }

        public int getRowCount() {
            return this._data == null ? 0 : this._data.size();
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            TestModelType.Model model = this._data.get(n);
            if (0 == n2) {
                string = TestModelPickerPanel.this._showSchema ? model.getSchema() + "." + model.getName() : model.getName();
            } else if (1 == n2) {
                string = ((TestNode)TestModelPickerPanel.this._parent.getData()).getModelNodeName(model.getNodeId());
            } else if (2 == n2) {
                if (model.getPartitionExpressions() != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (PartitionExpressionType partitionExpressionType : model.getPartitionExpressions().getPartitionExpression()) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(partitionExpressionType.getPartitionAttribute().getName());
                    }
                    string = stringBuffer.toString();
                }
            } else if (3 == n2) {
                string = model.getMiningAlgorithm().value();
            }
            return string;
        }

        public List<TestModelType.Model> getDataList() {
            return this._data;
        }
    }
}

