/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.awt.Component;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.Result;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestCompareNode;
import oracle.dmt.dataminer.tviewer.lift.LiftTabState;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.dmt.dataminer.tviewer.roc.ROCTabPanelState;
import oracle.dmt.dataminer.utils.ConnectionProperties;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogState;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitTabState;
import oracle.dmt.dataminer.workflow.dialog.test.CostMatrixTabState;
import oracle.dmt.dataminer.workflow.dialog.test.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;

public class TuneState
implements AbstractPropertiesDialogState {
    private Context _context;
    private AbstractBuildNode _buildNode;
    private ClassificationBuildNodeType _nodeType;
    private Hashtable<String, Hashtable<String, TuningType>> _modifiedSettings = new Hashtable();
    private TestCompareNode _testCompareNode;
    private SharedTestEditorState _shareState;
    private ROCTabPanelState _rocState = null;
    private LiftTabState _liftState;
    private ProfitTabState _profitState;
    private CostBenefitTabState _benefitState;
    private CostMatrixTabState _costState;
    private Vector<Object> _targetValues;
    private boolean _ROCExist = false;
    private boolean _liftExist = false;
    private Hashtable<String, ModifiedObject> _data = new Hashtable();
    public static final String TUNE_OPTION_NONE = DialogsLrb.get("TUNE_OPTION_NONE");
    public static final String TUNE_METHOD_BENEFIT = DialogsLrb.get("TUNE_TAB_BENEFIT");
    public static final String TUNE_METHOD_COST = DialogsLrb.get("TUNE_TAB_COST");
    public static final String TUNE_METHOD_ROC = DialogsLrb.get("TUNE_TAB_ROC");
    public static final String TUNE_METHOD_LIFT = DialogsLrb.get("TUNE_TAB_LIFT");
    public static final String TUNE_METHOD_PROFIT = DialogsLrb.get("TUNE_TAB_PROFIT");

    public TuneState(Context context, List<ClassificationResultType> list, AbstractBuildNode abstractBuildNode, Locale locale) {
        Object object;
        this._nodeType = (ClassificationBuildNodeType)abstractBuildNode.getData();
        this._context = context;
        this._buildNode = abstractBuildNode;
        ArrayList<TestResult> arrayList = new ArrayList<TestResult>();
        for (Object object2 : list) {
            CGeneralizedLinearModelType cGeneralizedLinearModelType;
            Object object3;
            Object object42;
            object = new ClassTestResult(context, (BuildNodeType)this._nodeType, (MiningResultType)object2);
            arrayList.add((TestResult)object);
            TuningType tuningType = null;
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)abstractBuildNode.getData();
            ClassificationBuildNodeType.Models models = classificationBuildNodeType.getModels();
            List list2 = models.getNaiveBayesModel();
            for (Object object42 : list2) {
                if (object42.getId().compareTo(((Result)object).getModelId()) != 0) continue;
                tuningType = object42.getTuning();
                break;
            }
            if (tuningType == null) {
                object3 = models.getCGeneralizedLinearModel();
                object42 = object3.iterator();
                while (object42.hasNext()) {
                    cGeneralizedLinearModelType = (CGeneralizedLinearModelType)object42.next();
                    if (cGeneralizedLinearModelType.getId().compareTo(object2.getModelId()) != 0) continue;
                    tuningType = cGeneralizedLinearModelType.getTuning();
                    break;
                }
            }
            if (tuningType == null) {
                object3 = models.getDecisionTreeModel();
                object42 = object3.iterator();
                while (object42.hasNext()) {
                    cGeneralizedLinearModelType = (DecisionTreeModelType)object42.next();
                    if (cGeneralizedLinearModelType.getId().compareTo(object2.getModelId()) != 0) continue;
                    tuningType = cGeneralizedLinearModelType.getTuning();
                    break;
                }
            }
            if (tuningType == null) {
                object3 = models.getCSupportVectorMachineModel();
                object42 = object3.iterator();
                while (object42.hasNext()) {
                    cGeneralizedLinearModelType = (CSupportVectorMachineModelType)object42.next();
                    if (cGeneralizedLinearModelType.getId().compareTo(object2.getModelId()) != 0) continue;
                    tuningType = cGeneralizedLinearModelType.getTuning();
                    break;
                }
            }
            object3 = (TuningType)MetaDataHelper.copyMetadataObject(tuningType);
            this._data.put(object2.getName(), new ModifiedObject(object2.getModelId(), object3));
            if (((ClassTestResult)object).isROCResult()) {
                this._ROCExist = true;
            }
            if (!((ClassTestResult)object).isLiftProfitResult()) continue;
            this._liftExist = true;
        }
        if (this._data != null && this._data.size() > 0) {
            try {
                Object object2;
                Enumeration<String> enumeration = this._data.keys();
                object2 = (String)enumeration.nextElement();
                object = ConnectionFolder.getUserAccountName(context);
                this._targetValues = ApplyNode.getPredictionValues(context, (String)object, (String)object2);
            }
            catch (Exception exception) {
                this._targetValues = null;
            }
        }
        this._testCompareNode = new TestCompareNode();
        this._testCompareNode.setContext(this._context);
        this._testCompareNode.setTestResults(arrayList);
    }

    public void setTuningNone(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        tuningType.setNone(new TuningType.None());
        tuningType.setBenefit(null);
        tuningType.setCost(null);
        tuningType.setCustom(null);
        modifiedObject.setModified();
    }

    public boolean isTuningNone(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        return tuningType.getNone() != null;
    }

    private CostMatrixType generateDefaultTuningCost() {
        Vector<Object> vector = this.getModelTargetValues();
        CostMatrixType costMatrixType = new CostMatrixType();
        for (int i = 0; i < vector.size(); ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                CostMatrixType.Item item = new CostMatrixType.Item();
                item.setActual(vector.get(i).toString());
                item.setPredict(vector.get(j).toString());
                if (i == j) {
                    item.setCost(0.0);
                } else {
                    item.setCost(1.0);
                }
                costMatrixType.getItem().add(item);
            }
        }
        return costMatrixType;
    }

    public CostMatrixType getDefaultTuningCost() {
        CostMatrixType costMatrixType = this._nodeType.getCostSettings();
        if (costMatrixType == null) {
            costMatrixType = this.generateDefaultTuningCost();
        }
        return costMatrixType;
    }

    public void setTuningCost(String string, CostMatrixType costMatrixType) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        tuningType.setNone(null);
        tuningType.setBenefit(null);
        tuningType.setCustom(null);
        TuningType.Cost cost = new TuningType.Cost();
        cost.setCostMatrix(costMatrixType);
        tuningType.setCost(cost);
        modifiedObject.setModified();
        this._nodeType.setCostSettings(costMatrixType);
    }

    public CostMatrixType getTuningCost(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        TuningType.Cost cost = tuningType.getCost();
        return cost == null ? null : cost.getCostMatrix();
    }

    public boolean isTuningCost(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        return tuningType.getCost() != null;
    }

    public WeightsType generateDefaultTuningBenefit() {
        Vector<Object> vector = this.getModelTargetValues();
        WeightsType weightsType = new WeightsType();
        for (int i = 0; i < vector.size(); ++i) {
            WeightsType.Item item = new WeightsType.Item();
            item.setTargetValue(vector.get(i).toString());
            item.setWeight(0.0);
            weightsType.getItem().add(item);
        }
        return weightsType;
    }

    public WeightsType getDefaultTuningBenefit() {
        WeightsType weightsType = this._nodeType.getBenefitSettings();
        if (weightsType == null) {
            weightsType = this.generateDefaultTuningBenefit();
        }
        return weightsType;
    }

    public void setTuningBenefit(String string, WeightsType weightsType) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        tuningType.setNone(null);
        tuningType.setCost(null);
        tuningType.setCustom(null);
        TuningType.Benefit benefit = new TuningType.Benefit();
        benefit.setBenefitWeights(weightsType);
        tuningType.setBenefit(benefit);
        modifiedObject.setModified();
        this._nodeType.setBenefitSettings(weightsType);
    }

    public WeightsType getTuningBenefit(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        TuningType.Benefit benefit = tuningType.getBenefit();
        return benefit == null ? null : benefit.getBenefitWeights();
    }

    public boolean isTuningBenefit(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        return tuningType.getBenefit() != null;
    }

    public void setTuningCustom(String string, String string2, Object object, CostMatrixType costMatrixType) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        tuningType.setNone(null);
        tuningType.setBenefit(null);
        tuningType.setCost(null);
        TuningType.Custom custom = new TuningType.Custom();
        TuningType.Custom.Settings settings = new TuningType.Custom.Settings();
        settings.setTargetValue(string2);
        if (object instanceof TuningType.Custom.Settings.ROC) {
            settings.setROC((TuningType.Custom.Settings.ROC)object);
        } else if (object instanceof TuningType.Custom.Settings.Lift) {
            settings.setLift((TuningType.Custom.Settings.Lift)object);
        } else if (object instanceof TuningType.Custom.Settings.Profit) {
            settings.setProfit((TuningType.Custom.Settings.Profit)object);
        }
        custom.setSettings(settings);
        custom.setCostMatrix(costMatrixType);
        tuningType.setCustom(custom);
        modifiedObject.setModified();
    }

    public boolean isTuningCustom(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        return tuningType.getCustom() != null;
    }

    public boolean isTuningCustomROC(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        if (tuningType.getCustom() != null) {
            return tuningType.getCustom().getSettings().getROC() != null;
        }
        return false;
    }

    public boolean isTuningCustomLift(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        if (tuningType.getCustom() != null) {
            return tuningType.getCustom().getSettings().getLift() != null;
        }
        return false;
    }

    public boolean isTuningCustomProfit(String string) {
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        if (tuningType.getCustom() != null) {
            return tuningType.getCustom().getSettings().getProfit() != null;
        }
        return false;
    }

    public TuningCustomData getTuningCustomData(String string) {
        String string2 = null;
        TuningType.Custom.Settings.ROC rOC = null;
        CostMatrixType costMatrixType = null;
        ModifiedObject modifiedObject = this._data.get(string);
        TuningType tuningType = (TuningType)modifiedObject.getContent();
        TuningType.Custom custom = tuningType.getCustom();
        string2 = tuningType.getCustom().getSettings().getTargetValue();
        if (custom.getSettings().getROC() != null) {
            rOC = custom.getSettings().getROC();
        } else if (custom.getSettings().getLift() != null) {
            rOC = custom.getSettings().getLift();
        } else if (custom.getSettings().getProfit() != null) {
            rOC = custom.getSettings().getProfit();
        }
        costMatrixType = custom.getCostMatrix();
        TuningCustomData tuningCustomData = new TuningCustomData(string2, rOC, costMatrixType);
        return tuningCustomData;
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    @Override
    public void validate() throws ValidationException {
    }

    @Override
    public boolean isModified() throws ValidationException {
        boolean bl = true;
        return bl;
    }

    @Override
    public Object getUserObject() {
        return this._modifiedSettings;
    }

    @Override
    public void finish() throws Exception {
        Hashtable<String, TuningType> hashtable = new Hashtable<String, TuningType>();
        for (String string : this._data.keySet()) {
            ModifiedObject modifiedObject = this._data.get(string);
            if (!modifiedObject.isDirty()) continue;
            hashtable.put(modifiedObject.getId(), (TuningType)modifiedObject.getContent());
        }
        this._modifiedSettings.put("MODEL_SETTING_TUNE_OPTION", hashtable);
    }

    @Override
    public void clear() {
    }

    @Override
    public void load() throws Exception {
        this._shareState = new SharedTestEditorState((Node)this._testCompareNode);
        this._context.setProperty("TUNE_STATE", (Object)this);
        if (this._testCompareNode.isShowROC()) {
            this._rocState = new ROCTabPanelState(this._shareState, this._context);
        }
        this._liftState = new LiftTabState(this._shareState, this._context);
        this._profitState = new ProfitTabState(this._shareState, this._context);
        this._benefitState = new CostBenefitTabState(this._shareState, this._context);
        this._costState = new CostMatrixTabState(this._shareState, this._context);
    }

    @Override
    public boolean confirm(Component component) {
        String string = "TUNE_SKIPPED_WARNING";
        return MessageDialog.optionalConfirm((String)string, (Component)Ide.getMainWindow(), (Object)DialogsLrb.get("TUNE_APPLY_TUNNING_INFO"), (String)DialogsLrb.get("TUNE_DIALOG_TITLE"), null);
    }

    public SharedTestEditorState getShareState() {
        return this._shareState;
    }

    public ROCTabPanelState getRocState() {
        return this._rocState;
    }

    public LiftTabState getLiftState() {
        return this._liftState;
    }

    public ProfitTabState getProfitState() {
        return this._profitState;
    }

    public CostBenefitTabState getBenefitState() {
        return this._benefitState;
    }

    public CostMatrixTabState getCostState() {
        return this._costState;
    }

    public TestCompareNode getTestCompareNode() {
        return this._testCompareNode;
    }

    public Vector<Object> getModelTargetValues() {
        return this._targetValues;
    }

    public boolean isROCExist() {
        return this._ROCExist;
    }

    public boolean isLiftExist() {
        return this._liftExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Object> getInputDataTargetValues() {
        AbstractDataNode abstractDataNode = null;
        Vector<Object> vector = new Vector<Object>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
            WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
            ClassificationBuildNode classificationBuildNode = (ClassificationBuildNode)this._buildNode;
            abstractDataNode = classificationBuildNode.findBuildDataNode(workflowModel);
            StringBuilder stringBuilder = new StringBuilder("(");
            stringBuilder.append(abstractDataNode.getInputSQL());
            stringBuilder.append(")");
            String string = stringBuilder.toString();
            AttributeType attributeType = this._nodeType.getTargetAttribute();
            if (attributeType != null) {
                String string2 = attributeType.getName();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("select distinct \"" + string2 + "\" from " + string + " where \"" + string2 + "\" is not null");
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(stringBuffer);
                sQLHelper.conn = ConnectionFolder.getConnection(this.getContext(), ConnectionProperties.ALTER_SESSION_FIXES);
                sQLHelper.stmt = sQLHelper.conn.createStatement();
                sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer2.toString());
                while (sQLHelper.rs.next()) {
                    Object object = sQLHelper.rs.getObject(1);
                    vector.add(object);
                }
                if (this._targetValues == null || this._targetValues.size() == 0) {
                    this._targetValues = vector;
                }
            }
        }
        return vector;
    }

    public static class MatrixModel
    extends BaseCostMatrixTableModel {
        public MatrixModel(BaseCostMatrixDataProvider baseCostMatrixDataProvider) {
            super(baseCostMatrixDataProvider);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return super.getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    public static class TuneMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String _positiveTarget;
        private String _otherTarget;
        private double _truePositiveCost = 0.0;
        private double _falseNegativeCost;
        private double _falsePositiveCost = 1.0;
        private double _trueNegativeCost = 0.0;
        private NumberFormat _percentageFormat;

        TuneMatrixDataProvider(String string, String string2, CostMatrixType costMatrixType, NumberFormat numberFormat) {
            this._percentageFormat = numberFormat;
            this._positiveTarget = string;
            this._otherTarget = string2;
            List list = costMatrixType.getItem();
            for (CostMatrixType.Item item : list) {
                String string3 = item.getActual();
                String string4 = item.getPredict();
                double d = item.getCost();
                if (string3.compareTo(string) != 0 || string4.compareTo(string) == 0) continue;
                this._falseNegativeCost = d;
                break;
            }
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this._positiveTarget, this._otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == 0 && n2 == 0) {
                return this._percentageFormat.format(this._truePositiveCost);
            }
            if (n == 0 && n2 == 1) {
                return this._percentageFormat.format(this._falseNegativeCost);
            }
            if (n == 1 && n2 == 0) {
                return this._percentageFormat.format(this._falsePositiveCost);
            }
            if (n == 1 && n2 == 1) {
                return this._percentageFormat.format(this._trueNegativeCost);
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private static class ModifiedObject {
        private String _modelId;
        private Object _content;
        private boolean _modified = false;

        ModifiedObject(String string, Object object) {
            this._modelId = string;
            this._content = object;
        }

        String getId() {
            return this._modelId;
        }

        Object getContent() {
            return this._content;
        }

        boolean isDirty() {
            return this._modified;
        }

        void setModified() {
            this._modified = true;
        }
    }

    public static class TuningCustomData {
        String _targetValue;
        Object _tuneType;
        CostMatrixType _costMatrix;

        TuningCustomData(String string, Object object, CostMatrixType costMatrixType) {
            this._targetValue = string;
            this._tuneType = object;
            this._costMatrix = costMatrixType;
        }

        public String getTargetValue() {
            return this._targetValue;
        }

        public Object getTuneType() {
            return this._tuneType;
        }

        public CostMatrixType getCostMatrix() {
            return this._costMatrix;
        }
    }
}

