/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Dimension;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.utils.ConnectionManager;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;

public class EditModelNodePartitionDefPanel
extends DialogDisplayer {
    private static final Logger theLogger = Logger.getLogger(EditModelNodePartitionDefPanel.class.getName());
    private JTable jPartitionKeysTab;
    private JScrollPane jScrollPane1;

    public EditModelNodePartitionDefPanel(ConnectionManager connectionManager, String string, String string2) {
        this.initComponents();
        PartitionDefinitionTableModel partitionDefinitionTableModel = new PartitionDefinitionTableModel(string, string2);
        try {
            partitionDefinitionTableModel.loadModels(connectionManager);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.WARNING, sQLException.getMessage());
        }
        this.jPartitionKeysTab.setModel(partitionDefinitionTableModel);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPartitionKeysTab = new JTable();
        this.jPartitionKeysTab.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jPartitionKeysTab);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 278, Short.MAX_VALUE));
    }

    @Override
    public void initUI() {
    }

    @Override
    public void initRes() {
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("MODEL_NODE_PARTITION_KEYS");
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }

    @Override
    protected int getDialogButtonMask() {
        return 3;
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMaximumInitialSize(new Dimension(1200, 500));
    }

    private static class PartitionDefinitionTableModel
    extends AbstractTableModel {
        private final int NAME = 0;
        private final int DATATYPE = 1;
        private final int DATASOURCE = 2;
        private static final String PARTITION_MODEL_ATTRIBUTES = "WITH partitions as \n(select distinct owner, model_name,column_name from ALL_MINING_MODEL_PARTITIONS ) \nSELECT t1.column_name,t2.data_type, \n       NVL( (SELECT x.expression              FROM all_mining_model_xforms x              WHERE x.OWNER = t1.owner and                    x.MODEL_NAME = t1.model_name and                    x.ATTRIBUTE_NAME = t1.column_name), '') as expression FROM partitions t1, ALL_MINING_MODEL_ATTRIBUTES t2 \nWHERE t1.OWNER = ? and \n     t1.MODEL_NAME = ? and \n      t1.owner = t2.owner and \n      t1.model_name = t2.model_name and \n      t1.column_name = t2.attribute_name";
        private Vector<TableRow> _data = new Vector(16);
        private String modelName;
        private String owner;
        private String[] _columnNames = new String[]{DialogsLrb.get("MODEL_NODE_COLUMN_NAME"), DialogsLrb.get("MODEL_NODE_TARGET_DATA_TYPE"), DialogsLrb.get("MODEL_NODE_SOURCE")};

        public PartitionDefinitionTableModel(String string, String string2) {
            this.owner = string;
            this.modelName = string2;
        }

        private void loadModels(ConnectionManager connectionManager) throws SQLException {
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = connectionManager.getConnection();
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(PARTITION_MODEL_ATTRIBUTES);
                sQLHelper.pstmt.setString(1, this.owner);
                sQLHelper.pstmt.setString(2, this.modelName);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string = sQLHelper.rs.getString("expression");
                    String string2 = SettingsLrb.get("PARTITION_SOURCE_COLUMN");
                    if (string != null && !"".equals(string.trim())) {
                        string2 = SettingsLrb.get("PARTITION_EXPRESSION");
                    }
                    TableRow tableRow = new TableRow(sQLHelper.rs.getString("column_name"), sQLHelper.rs.getString("data_type"), string2);
                    this._data.add(tableRow);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TableRow tableRow = this._data.get(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = tableRow.getColumn_name();
                    break;
                }
                case 1: {
                    string = tableRow.getData_type();
                    break;
                }
                case 2: {
                    string = tableRow.getData_source();
                    break;
                }
                default: {
                    assert (false) : "Not a valid column";
                    break;
                }
            }
            return string;
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public class TableRow {
            private String column_name;
            private String data_type;
            private String data_source;

            public TableRow(String string, String string2, String string3) {
                this.column_name = string;
                this.data_type = string2;
                this.data_source = string3;
            }

            public String getColumn_name() {
                return this.column_name;
            }

            public String getData_type() {
                return this.data_type;
            }

            public String getData_source() {
                return this.data_source;
            }
        }
    }
}

