/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AdditionalOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AggregationPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.PreviewPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RelationalAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class JSONQueryEditorPanel
extends DialogDisplayer<JSONQueryNode> {
    protected Logger theLogger = Logger.getLogger(this.getClass().getName());
    private AttributeType _JSONSourceColumn = null;
    private String _relationalDataSource = null;
    private RelationalAttributesType _relationalAttributes = null;
    private Map<String, DataGuideType> _dataGuideMap = new HashMap<String, DataGuideType>();
    private Map<String, List<Object>> _cacheDataMap = new HashMap<String, List<Object>>();
    private JSONQueryNode.ColumnNameGenerator _nameGenerator = null;
    private JSONPanel _JSONPanel;
    private AdditionalOutputPanel _AdditionalOutputPanel;
    private AggregationPanel _AggregationPanel;
    private PreviewPanel _PreviewPanel;
    private boolean _JSONDirty = false;
    private boolean _relationalDirty = false;
    private boolean _aggregDirty = false;
    private boolean _previewDirty = false;
    private Date last_updated = null;
    private static int JSON_DATA_IDX = 0;
    private static int AGGREGATE_DATA_FUNC_IDX = 1;
    private static int AGGREGATE_DATA_GROUPBY_IDX = 2;
    private JTabbedPane jTabbedPane;
    private static String SOURCE_TAB = DialogsLrb.get("JSON_QUERY_SOURCE_TAB");
    private static String ADDITIONAL_TAB = DialogsLrb.get("JSON_QUERY_ADDITIONAL_TAB");
    private static String AGGREG_TAB = DialogsLrb.get("JSON_QUERY_AGGREG_TAB");
    private static String PREVIEW_TAB = DialogsLrb.get("JSON_QUERY_PREVIEW_TAB");
    public static String ERROR_OUTPUT = DialogsLrb.get("JSON_ADD_AGGREGATION_ERROR_OUTPUT");
    public static String ERROR_FUNCTION = DialogsLrb.get("JSON_ADD_AGGREGATION_ERROR_FUNCTION");
    public static String ERROR_AGGREGATIOT_TITLE = DialogsLrb.get("JSON_QUERY_AGGREGATION_EDIT_AGGREGATIONS_ERROR_TITLE");

    public JSONQueryEditorPanel(Context context, JSONQueryNode jSONQueryNode, AbstractDataNode abstractDataNode) {
        super(context, jSONQueryNode);
        assert (context != null) : "Context must not be null.";
        assert (jSONQueryNode != null) : "JSONQueryNode must not be null.";
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)jSONQueryNode.getData();
        if (jSONQueryNode.findParentNode() != null && jSONQueryNodeType.getStatus() != NodeStatusType.READY && jSONQueryNodeType.getStatus() != NodeStatusType.COMPLETE) {
            jSONQueryNode.validate(false);
        }
        JSONAttributesType jSONAttributesType = jSONQueryNodeType.getJSONAttributes();
        JSONAttributesType jSONAttributesType2 = null;
        RelationalAttributesType relationalAttributesType = null;
        AggregationElementsExType aggregationElementsExType = null;
        GroupingElementExType groupingElementExType = null;
        if (jSONAttributesType != null && jSONAttributesType.getSource() != null) {
            AttributeType attributeType = new AttributeType();
            attributeType.setName(jSONAttributesType.getSource());
            attributeType.setDataType(jSONAttributesType.getDataType());
            this.setJSONSourceColumn(attributeType);
            jSONAttributesType2 = (JSONAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getJSONAttributes());
            this.setJSONAttributes(jSONAttributesType2);
            aggregationElementsExType = (AggregationElementsExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getAggregationElements());
            this.setAggregationElements(aggregationElementsExType);
            groupingElementExType = (GroupingElementExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getGroupingElement());
            this.setGroupingElement(groupingElementExType);
        }
        if (jSONQueryNodeType.getRelationalAttributes() != null) {
            relationalAttributesType = (RelationalAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getRelationalAttributes());
            this.setRelationalAttributes(relationalAttributesType);
        }
        this._nameGenerator = new JSONQueryNode.ColumnNameGenerator(jSONAttributesType2, relationalAttributesType, aggregationElementsExType, groupingElementExType);
        if (jSONQueryNode.findSourceNodes() != null && !jSONQueryNode.findSourceNodes().isEmpty()) {
            this._relationalDataSource = jSONQueryNode.findSourceNodes().get(0).getDefaultName();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        final class Initialization
        extends ProgressRunnable {
            JSONQueryEditorPanel _parent;

            Initialization(JSONQueryEditorPanel jSONQueryEditorPanel2) {
                this._parent = jSONQueryEditorPanel2;
            }

            protected Object doWork() throws Exception {
                JSONQueryEditorPanel.this._JSONPanel = new JSONPanel(JSONQueryEditorPanel.this._context, this._parent);
                JSONQueryEditorPanel.this._AdditionalOutputPanel = new AdditionalOutputPanel(JSONQueryEditorPanel.this._context, this._parent);
                JSONQueryEditorPanel.this._AggregationPanel = new AggregationPanel(JSONQueryEditorPanel.this._context, this._parent);
                JSONQueryEditorPanel.this._PreviewPanel = new PreviewPanel(JSONQueryEditorPanel.this._context, this._parent);
                return null;
            }

            protected void finish(Object object) {
                JSONQueryEditorPanel.this.jTabbedPane.add(SOURCE_TAB, JSONQueryEditorPanel.this._JSONPanel);
                JSONQueryEditorPanel.this.jTabbedPane.add(ADDITIONAL_TAB, JSONQueryEditorPanel.this._AdditionalOutputPanel);
                JSONQueryEditorPanel.this.jTabbedPane.add(AGGREG_TAB, JSONQueryEditorPanel.this._AggregationPanel);
                JSONQueryEditorPanel.this.jTabbedPane.add(PREVIEW_TAB, JSONQueryEditorPanel.this._PreviewPanel);
                JSONQueryEditorPanel.this._PreviewPanel.addNameChangeListener(JSONQueryEditorPanel.this._JSONPanel);
                JSONQueryEditorPanel.this._PreviewPanel.addNameChangeListener(JSONQueryEditorPanel.this._AdditionalOutputPanel);
                JSONQueryEditorPanel.this._PreviewPanel.addNameChangeListener(JSONQueryEditorPanel.this._AggregationPanel);
            }
        }
        Initialization initialization = new Initialization(this);
        initialization.setTitle(DialogsLrb.get("EDIT_DIALOG_TITLE"));
        initialization.setMessage(DialogsLrb.get("JSON_QUERY_LOADING"));
        initialization.setCancelable(false);
        try {
            initialization.start(true);
        }
        catch (ProgressException progressException) {
            this.theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
    }

    public boolean isDataGuideAvailable() {
        JSONQueryNode jSONQueryNode;
        DataGuideProvider dataGuideProvider;
        DataGuideType dataGuideType = null;
        if (this._JSONSourceColumn != null && (dataGuideProvider = (DataGuideProvider)((Object)(jSONQueryNode = (JSONQueryNode)this.getData()).findParentNode())) != null) {
            Integer n = null;
            dataGuideType = dataGuideProvider.getJSONAttrDataGuide(this._JSONSourceColumn, n);
        }
        return dataGuideType != null;
    }

    public DataGuideType getDataGuide() {
        Integer n;
        JSONQueryNode jSONQueryNode;
        DataGuideProvider dataGuideProvider;
        DataGuideType dataGuideType = null;
        if (this._JSONSourceColumn != null && (dataGuideType = this._dataGuideMap.get(this._JSONSourceColumn.getName())) == null && (dataGuideProvider = (DataGuideProvider)((Object)(jSONQueryNode = (JSONQueryNode)this.getData()).findParentNode())) != null && (dataGuideType = dataGuideProvider.getJSONAttrDataGuide(this._JSONSourceColumn, n = null)) != null) {
            this._dataGuideMap.put(this._JSONSourceColumn.getName(), dataGuideType);
        }
        return dataGuideType;
    }

    public JSONQueryNode.ColumnNameGenerator getNameGenerator() {
        return this._nameGenerator;
    }

    public Date getLastUpdatedTime() {
        return this.last_updated;
    }

    public void setJSONDirty(boolean bl) {
        this._JSONDirty = bl;
        this.last_updated = new Date();
    }

    public boolean isJSONDirty() {
        return this._JSONDirty;
    }

    public void setRelationalDirty(boolean bl) {
        this._relationalDirty = bl;
        this.last_updated = new Date();
    }

    public boolean isRelationalDirty() {
        return this._relationalDirty;
    }

    public void setAggregDirty(boolean bl) {
        this._aggregDirty = bl;
        this.last_updated = new Date();
    }

    public boolean isAggregDirty() {
        return this._aggregDirty;
    }

    public void setPreviewDirty(boolean bl) {
        this._previewDirty = bl;
        this.last_updated = new Date();
    }

    public boolean isPreviewDirty() {
        return this._previewDirty;
    }

    public AttributeType getJSONSourceColumn() {
        return this._JSONSourceColumn;
    }

    public void setJSONSourceColumn(AttributeType attributeType) {
        this._JSONSourceColumn = attributeType;
        if (this._JSONSourceColumn != null) {
            this._nameGenerator = new JSONQueryNode.ColumnNameGenerator(this.getJSONAttributes(), this.getRelationalAttributes(), this.getAggregationElements(), this.getGroupingElement());
        }
    }

    public String getRelationalDataSource() {
        return this._relationalDataSource;
    }

    private List<Object> initCacheData() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        JSONAttributesType jSONAttributesType = new JSONAttributesType();
        jSONAttributesType.setSource(this._JSONSourceColumn.getName());
        jSONAttributesType.setDataType(this._JSONSourceColumn.getDataType());
        arrayList.add(JSON_DATA_IDX, jSONAttributesType);
        AggregationElementsExType aggregationElementsExType = new AggregationElementsExType();
        arrayList.add(AGGREGATE_DATA_FUNC_IDX, aggregationElementsExType);
        GroupingElementExType groupingElementExType = new GroupingElementExType();
        arrayList.add(AGGREGATE_DATA_GROUPBY_IDX, groupingElementExType);
        return arrayList;
    }

    public JSONAttributesType getJSONAttributes() {
        JSONAttributesType jSONAttributesType = null;
        if (this._JSONSourceColumn != null) {
            List<Object> list = this._cacheDataMap.get(this._JSONSourceColumn.getName());
            if (list == null) {
                list = this.initCacheData();
                this._cacheDataMap.put(this._JSONSourceColumn.getName(), list);
            }
            jSONAttributesType = (JSONAttributesType)list.get(JSON_DATA_IDX);
        }
        return jSONAttributesType;
    }

    public void setJSONAttributes(JSONAttributesType jSONAttributesType) {
        if (this._JSONSourceColumn != null) {
            List<Object> list = this._cacheDataMap.get(this._JSONSourceColumn.getName());
            if (list == null) {
                list = this.initCacheData();
                this._cacheDataMap.put(this._JSONSourceColumn.getName(), list);
            }
            list.set(JSON_DATA_IDX, jSONAttributesType);
        }
    }

    public RelationalAttributesType getRelationalAttributes() {
        return this._relationalAttributes;
    }

    public void setRelationalAttributes(RelationalAttributesType relationalAttributesType) {
        this._relationalAttributes = relationalAttributesType;
    }

    public AggregationElementsExType getAggregationElements() {
        AggregationElementsExType aggregationElementsExType = null;
        if (this._JSONSourceColumn != null) {
            List<Object> list = this._cacheDataMap.get(this._JSONSourceColumn.getName());
            if (list == null) {
                list = this.initCacheData();
                this._cacheDataMap.put(this._JSONSourceColumn.getName(), list);
            }
            aggregationElementsExType = (AggregationElementsExType)list.get(AGGREGATE_DATA_FUNC_IDX);
        }
        return aggregationElementsExType;
    }

    public void setAggregationElements(AggregationElementsExType aggregationElementsExType) {
        if (this._JSONSourceColumn != null) {
            List<Object> list = this._cacheDataMap.get(this._JSONSourceColumn.getName());
            if (list == null) {
                list = this.initCacheData();
                this._cacheDataMap.put(this._JSONSourceColumn.getName(), list);
            }
            list.set(AGGREGATE_DATA_FUNC_IDX, aggregationElementsExType);
        }
    }

    public GroupingElementExType getGroupingElement() {
        GroupingElementExType groupingElementExType = null;
        if (this._JSONSourceColumn != null) {
            List<Object> list = this._cacheDataMap.get(this._JSONSourceColumn.getName());
            if (list == null) {
                list = this.initCacheData();
                this._cacheDataMap.put(this._JSONSourceColumn.getName(), list);
            }
            groupingElementExType = (GroupingElementExType)list.get(AGGREGATE_DATA_GROUPBY_IDX);
        }
        return groupingElementExType;
    }

    public void setGroupingElement(GroupingElementExType groupingElementExType) {
        if (this._JSONSourceColumn != null) {
            List<Object> list = this._cacheDataMap.get(this._JSONSourceColumn.getName());
            if (list == null) {
                list = this.initCacheData();
                this._cacheDataMap.put(this._JSONSourceColumn.getName(), list);
            }
            list.set(AGGREGATE_DATA_GROUPBY_IDX, groupingElementExType);
        }
    }

    public List<AttributeExType> getAvailRelationalAttributes() {
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this.getData();
        DataProvider dataProvider = (DataProvider)((Object)jSONQueryNode.findParentNode());
        ArrayList<AttributeExType> arrayList = new ArrayList<AttributeExType>();
        if (dataProvider != null) {
            List list = dataProvider.getAttributes().getAttribute();
            for (AttributeType attributeType : list) {
                if (DatabaseMetadataUtils.isJSONTypeSupported(DatabaseMetadataUtils.getJSONDataType(attributeType.getDataType(), attributeType.getDataTypeQualifier()))) continue;
                AttributeExType attributeExType = new AttributeExType();
                attributeExType.setName(attributeType.getAlias() != null ? attributeType.getAlias() : attributeType.getName());
                attributeExType.setDataType(attributeType.getDataType());
                attributeExType.setNewDataType(attributeType.getDataType());
                attributeExType.setStatus(attributeType.getStatus());
                attributeExType.setAlias(null);
                arrayList.add(attributeExType);
            }
        }
        return arrayList;
    }

    public boolean isDirty() {
        return this.isJSONDirty() || this.isRelationalDirty() || this.isAggregDirty() || this.isPreviewDirty();
    }

    public String getJSONQuery() {
        return ((JSONQueryNode)this.getData()).getStackSQLExpression(this.getJSONAttributes(), this.getRelationalAttributes(), this.getAggregationElements(), this.getGroupingElement());
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.setName("jTabbedPane");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 776, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 576, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    protected void doCancel() {
        super.doCancel();
        if (this._PreviewPanel.getPreviewDataPanel() != null) {
            this._PreviewPanel.getPreviewDataPanel().getState().getResultSetModel().closeConnection();
        }
    }

    @Override
    protected void onFailure(Exception exception) {
        super.onFailure(exception);
        if (this._PreviewPanel.getPreviewDataPanel() != null) {
            this._PreviewPanel.getPreviewDataPanel().getState().getResultSetModel().closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doWork() {
        boolean bl = true;
        if (this.isDirty()) {
            Object object;
            if (this.getAggregationElements() != null) {
                object = null;
                for (Object object2 : this.getAggregationElements().getAggregationElement()) {
                    if (object2.getOutput() == null) {
                        bl = false;
                        object = ERROR_OUTPUT;
                        break;
                    }
                    if (object2.getAggregationFunction() != null) continue;
                    bl = false;
                    object = ERROR_FUNCTION;
                    break;
                }
                if (null != object) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)ERROR_AGGREGATIOT_TITLE, null);
                    return false;
                }
            }
            object = null;
            object = this.getParentWindow().getCursor();
            this.getParentWindow().setCursor(new Cursor(3));
            ArrayList arrayList = new ArrayList();
            try {
                if (this.getJSONAttributes() != null) {
                    arrayList.add(new Property("jsonAttributes", null, this.getJSONAttributes(), null, null));
                }
                if (this.getRelationalAttributes() != null) {
                    arrayList.add(new Property("relationalAttributes", null, this.getRelationalAttributes(), null, null));
                }
                if (this.getAggregationElements() != null) {
                    arrayList.add(new Property("aggregationElements", null, this.getAggregationElements(), null, null));
                }
                if (this.getGroupingElement() != null) {
                    arrayList.add(new Property("groupingElement", null, this.getGroupingElement(), null, null));
                }
                if (!arrayList.isEmpty()) {
                    Object object2;
                    object2 = (JSONQueryNode)this.getData();
                    CommandProcessor.getInstance().beginTrans(DialogsLrb.get("JSON_QUERY_EDIT_TRANSACTION_NAME"));
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((JSONQueryNode)this.getData()).getUndoFilter();
                    odmrSDMUndoFilter.prepareUndoPropertyList(object2, this.getContext(), arrayList);
                    ((JSONQueryNode)object2).validate(true);
                    CommandProcessor.getInstance().endTrans();
                }
            }
            catch (Exception exception) {
                bl = false;
                if (!arrayList.isEmpty()) {
                    CommandProcessor.getInstance().abortTrans();
                }
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("JSON_QUERY_EDIT_ERROR_MESG"), null);
            }
            finally {
                if (object != null) {
                    this.getParentWindow().setCursor((Cursor)object);
                }
            }
        }
        if (this._PreviewPanel.getPreviewDataPanel() != null) {
            this._PreviewPanel.getPreviewDataPanel().getState().getResultSetModel().closeConnection();
        }
        return bl;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("EDIT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "json_query_editor";
    }
}

