/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.TextComponentSearchSupport;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;

public class JSONDataPanel
extends AbstractPanel<JSONQueryNode> {
    private JSONQueryEditorPanel _parent;
    private JTextPane _jsonEditor = new JTextPane();
    private SearchField _jFilterCtl = new SearchField();
    private TextComponentSearchSupport _textSearchComponent;
    private boolean _previewDataLoaded = false;
    private String _column = null;
    private JPanel jDataPanel;
    private JPanel jStatusPanel;
    private JLabel locationLabel;
    private ComponentWithTitlebar<JComponent> _jComponentWithToolbar = new ComponentWithTitlebar();
    private JLabel jSampleSizeLabel = new JLabel();
    private JSpinner jSampleSizeSpinner = new JSpinner();
    private JButton jQueryBtn;

    public JSONDataPanel(Context context, JSONQueryEditorPanel jSONQueryEditorPanel) {
        super(context, null);
        assert (context != null) : "Context must not be null.";
        this._parent = jSONQueryEditorPanel;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this.jDataPanel.add((Component)this._jComponentWithToolbar);
        this._textSearchComponent = new TextComponentSearchSupport((JTextComponent)this._jsonEditor);
        JScrollPane jScrollPane = new JScrollPane(this._jsonEditor);
        this._jComponentWithToolbar.setComponent((JComponent)jScrollPane);
        this._jComponentWithToolbar.setLabel(new JLabel(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_DATA")));
        ControlBar controlBar = new ControlBar();
        this.jQueryBtn = new JButton(OracleIcons.getIcon((String)"run.png"));
        this.jQueryBtn.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_DATA_QUERY"));
        this.jQueryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSONDataPanel.this.handleQueryJSONData();
            }
        });
        ResourceUtils.resSpinner((JLabel)this.jSampleSizeLabel, (JSpinner)this.jSampleSizeSpinner, (String)DialogsLrb.get("JSON_QUERY_SOURCE_JSON_DATA_SAMPLE"));
        this.jSampleSizeSpinner.setToolTipText(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_DATA_SAMPLE_TOOLTIP"));
        this.jSampleSizeSpinner.setModel(new SpinnerNumberModel(2000, 1, 50000, 100));
        this.jSampleSizeLabel.setLabelFor(this.jSampleSizeSpinner);
        controlBar.add((Component)this.jSampleSizeLabel);
        controlBar.add((Component)new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, 0)));
        controlBar.add((Component)this.jSampleSizeSpinner);
        controlBar.add((Component)new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, 0)));
        controlBar.add((Component)this.jQueryBtn);
        controlBar.add((Component)new JSeparator(1));
        this._jFilterCtl.setPreferredSize(new Dimension(150, 20));
        controlBar.add((Component)this._jFilterCtl);
        this._jComponentWithToolbar.setControlBar(controlBar);
        this._jFilterCtl.setStyle(SearchField.Style.FIND);
        this._jFilterCtl.setPrompt(DialogsLrb.get("JSON_QUERY_SOURCE_JSON_DATA_FINDER"));
        this._jFilterCtl.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                SearchEvent.Direction direction = searchEvent.getDirection();
                String string = searchEvent.getSearchText();
                JSONDataPanel.this._textSearchComponent.search(direction, string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this._jsonEditor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                JSONDataPanel.this.setLineCol();
            }
        });
    }

    protected void setLineCol() {
        int n = this._jsonEditor.getCaretPosition();
        int n2 = 1;
        int n3 = 0;
        int n4 = -1;
        String string = this._jsonEditor.getText().replaceAll("\r", "");
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n2;
            n4 = i;
        }
        n3 = n - n4;
        String string2 = DialogsLrb.get("JSON_QUERY_SOURCE_DATA_LINE_COL");
        String string3 = MessageFormat.format(string2, n2, n3);
        this.locationLabel.setText(string3);
    }

    private void handleQueryJSONData() {
        int n = (Integer)this.jSampleSizeSpinner.getValue();
        this._textSearchComponent.search(SearchEvent.Direction.FORWARD, "");
        QueryJSONDocs queryJSONDocs = new QueryJSONDocs(n);
        queryJSONDocs.execute();
    }

    private void initComponents() {
        this.jDataPanel = new JPanel();
        this.jStatusPanel = new JPanel();
        this.locationLabel = new JLabel();
        this.jDataPanel.setName("jDataPanel");
        this.jDataPanel.setLayout(new BorderLayout());
        this.jStatusPanel.setName("jStatusPanel");
        this.jStatusPanel.setLayout(new BorderLayout());
        this.locationLabel.setText("1:1");
        this.locationLabel.setName("locationLabel");
        this.jStatusPanel.add((Component)this.locationLabel, "East");
        this.jDataPanel.add((Component)this.jStatusPanel, "South");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDataPanel, GroupLayout.Alignment.TRAILING, -1, 809, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDataPanel, GroupLayout.Alignment.TRAILING, -1, 523, Short.MAX_VALUE));
    }

    public void clear() {
        this._jsonEditor.setText("");
        this._column = null;
    }

    public void reload() {
        String string = this._parent.getJSONSourceColumn().getName();
        if (string != null && (this._column == null || string.compareTo(this._column) != 0)) {
            int n = (Integer)this.jSampleSizeSpinner.getValue();
            this._textSearchComponent.search(SearchEvent.Direction.FORWARD, "");
            QueryJSONDocs queryJSONDocs = new QueryJSONDocs(n);
            queryJSONDocs.execute();
            this._column = string;
        }
    }

    private class QueryJSONDocs
    extends SwingWorker<Boolean, Void> {
        int _size;
        StringBuffer _jsonDocs = new StringBuffer();
        Exception _ex;
        Boolean _success = false;

        public QueryJSONDocs(int n) {
            this._size = n;
            JSONDataPanel.this._previewDataLoaded = false;
            JSONDataPanel.this._jsonEditor.setText(DialogsLrb.get("JSON_QUERY_LOADING"));
        }

        private String pretty_json(String string, int n) throws SQLException {
            String string2 = "";
            SQLHelper sQLHelper = new SQLHelper();
            CLOB cLOB = null;
            CLOB cLOB2 = null;
            try {
                sQLHelper.conn = ConnectionFolder.getConnection(JSONDataPanel.this.getContext());
                cLOB = StringUtils.getTempClob(string, sQLHelper.conn);
                sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("begin ? := ODMRSYS.ODMR_UTIL.PRETTY_JSON2(?, ?); end;");
                sQLHelper.cstmt.registerOutParameter(1, 2005);
                sQLHelper.cstmt.setClob(2, (Clob)cLOB);
                sQLHelper.cstmt.setInt(3, n);
                sQLHelper.cstmt.execute();
                cLOB2 = sQLHelper.cstmt.getCLOB(1);
                string2 = cLOB2.getSubString(1L, (int)cLOB2.length());
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                try {
                    if (cLOB != null) {
                        cLOB.freeTemporary();
                    }
                }
                catch (Exception exception) {}
                sQLHelper.close();
            }
            return string2;
        }

        private void getData() throws SQLException {
            String string = ((JSONQueryNode)JSONDataPanel.this._parent.getData()).getJSONDataSQLExpression(JSONDataPanel.this._column);
            String string2 = this.pretty_json(string, this._size);
            this._jsonDocs.append(string2);
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            try {
                this.getData();
                this._success = true;
            }
            catch (SQLException sQLException) {
                int n = sQLException.getLocalizedMessage().indexOf("ORA", 3);
                String string = sQLException.getLocalizedMessage();
                if (n > 0) {
                    string = sQLException.getLocalizedMessage().substring(0, n);
                }
                this._ex = new SQLException(string);
                this._success = false;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return Boolean.TRUE;
        }

        @Override
        protected void done() {
            if (this._success.booleanValue() && this._ex == null) {
                JSONDataPanel.this._jsonEditor.setEditable(true);
                JSONDataPanel.this._jsonEditor.setText(this._jsonDocs.toString());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JSONDataPanel.this._jsonEditor.setCaretPosition(JSONDataPanel.this._jsonEditor.getDocument().getLength());
                        JSONDataPanel.this._jsonEditor.moveCaretPosition(0);
                        JSONDataPanel.this._jsonEditor.select(0, 0);
                    }
                });
                JSONDataPanel.this._jsonEditor.setEditable(false);
            } else {
                JSONDataPanel.this._jsonEditor.setText(this._ex.getLocalizedMessage());
            }
        }
    }
}

