/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.GroupByAttributeSelectionRowData;
import oracle.dmt.dataminer.controls.JSONPeerObserver;
import oracle.dmt.dataminer.controls.JSONStructureGroupByPanel;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.ide.Context;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class AddGroupByColumnPanel
extends DialogDisplayer<AbstractNode>
implements JSONPeerObserver {
    protected JSONQueryEditorPanel _parent;
    protected JSONStructureGroupByPanel jsonStructurePanel;
    private GroupingElementExType originalGroupingElement;
    private static String _SELECTED_ATTRIBUTES_GRID_TITLE = ControlsLrb.get("JSON_QUERY_AGGREGATION_ADD_GTROUP_BY_SELECTED_TITLE");
    private static String loadingDataMessage = DialogsLrb.get("JSON_QUERY_AGGREGATION_LOADING_MESSAGE");
    protected static int PATH_INDEX = 0;
    protected static int DATA_TYPE_INDEX = 1;
    protected static String[] _colNames = new String[]{DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_NAME"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_TYPE")};
    protected static String[] _colNamesLoading = new String[]{DialogsLrb.get("JSON_QUERY_AGGREGATION_LOADING_STATUS")};
    protected DataMinerTablePanel dataMinerTablePanel1;
    protected JPanel jPanel1;

    public AddGroupByColumnPanel(Context context, AbstractDataNode abstractDataNode) {
        super(context, abstractDataNode);
    }

    public AddGroupByColumnPanel(Context context, AbstractDataNode abstractDataNode, JSONQueryEditorPanel jSONQueryEditorPanel, Object object) {
        super(context, abstractDataNode);
        assert (context != null) : "Context must not be null.";
        assert (object instanceof GroupingElementExType);
        this._parent = jSONQueryEditorPanel;
        this.originalGroupingElement = (GroupingElementExType)object;
        this.initUIComponents();
        this.initRes();
        this.initUI();
    }

    protected void initUIComponents() {
        this.initComponents();
    }

    private void initComponents() {
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        this.jPanel1 = new JPanel();
        this.jPanel1.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dataMinerTablePanel1, -1, 400, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPanel1, -1, 283, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataMinerTablePanel1, -1, 152, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("JSON_QUERY_AGGREGATION_ADD_GTROUP_BY_DLG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "jsqon_query_aggregation_add_group_by";
    }

    @Override
    public void initUI() {
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)jSONQueryNode.findParentNode());
        AttributeType attributeType = this._parent.getJSONSourceColumn();
        DataGuideInfoType dataGuideInfoType = dataGuideProvider.getJSONAttrDataGuideInfoType(attributeType);
        JSONColumnsType.Attribute attribute = new JSONColumnsType.Attribute();
        attribute.setName(attributeType.getName());
        attribute.setDataGuideInfo(dataGuideInfoType);
        this.jsonStructurePanel = new JSONStructureGroupByPanel(this.getContext(), (AbstractDataNode)jSONQueryNode, attributeType, attribute, (List<JSONAttributeType>)this.originalGroupingElement.getAttributes().getJSONAttribute(), this.originalGroupingElement.getAttributes().getAttribute(), true);
        this.jPanel1.add((Component)this.jsonStructurePanel, "Center");
        this.jsonStructurePanel.setEnclosingPanel(this);
        JToggleButton jToggleButton = new JToggleButton(DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_SHOW_PATH"), DataMinerIcons.get(Icons.SHOW_JSON_PATH));
        jToggleButton.setToolTipText(DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_SHOW_PATH_TOOLTIP"));
        jToggleButton.setSelected(true);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                AddGroupByColumnPanel.this.showJSONPaths(jToggleButton.isSelected());
            }
        });
        this.setupSelectedAttributesTable();
        this.dataMinerTablePanel1.addControlBarComponents(jToggleButton);
    }

    protected void showJSONPaths(boolean bl) {
        SelectedAttributesTableModel selectedAttributesTableModel = (SelectedAttributesTableModel)((Object)this.dataMinerTablePanel1.getTable().getModel());
        selectedAttributesTableModel.showFullPath(bl);
    }

    public void setupSelectedAttributesTable() {
        this.dataMinerTablePanel1.removeSearchField();
        this.dataMinerTablePanel1.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel1.getTable().setSelectionMode(0);
        this.dataMinerTablePanel1.getTable().setShowGrid(true);
        this.dataMinerTablePanel1.getTable().setShowHorizontalLines(true);
        this.dataMinerTablePanel1.getTable().setShowVerticalLines(true);
        this.dataMinerTablePanel1.getTable().setFixedColumns(0, new int[0]);
        LoadingDataModel loadingDataModel = new LoadingDataModel();
        this.dataMinerTablePanel1.getTable().setModel((TableModel)((Object)loadingDataModel));
        this.dataMinerTablePanel1.getTable().setSorted(true);
        this.dataMinerTablePanel1.getTable().setColumnSelectorAvailable(true);
        this.dataMinerTablePanel1.getTable().setAutoResizeMode(4);
        this.dataMinerTablePanel1.setTitle("");
    }

    public void loadSelectedAttributesTable() {
        Object object2;
        GroupingElementExType.Attributes attributes = this.originalGroupingElement.getAttributes();
        ArrayList<GroupByAttributeSelectionRowData> arrayList = new ArrayList<GroupByAttributeSelectionRowData>();
        if (attributes != null) {
            GroupByAttributeSelectionRowData groupByAttributeSelectionRowData;
            for (Object object2 : attributes.getJSONAttribute()) {
                groupByAttributeSelectionRowData = new GroupByAttributeSelectionRowData((JSONAttributeType)object2, true);
                arrayList.add(groupByAttributeSelectionRowData);
            }
            for (Object object2 : attributes.getAttribute()) {
                groupByAttributeSelectionRowData = new GroupByAttributeSelectionRowData((AttributeExType)object2, true);
                arrayList.add(groupByAttributeSelectionRowData);
            }
        }
        SelectedAttributesTableModel selectedAttributesTableModel = new SelectedAttributesTableModel(arrayList);
        this.dataMinerTablePanel1.getTable().setModel((TableModel)((Object)selectedAttributesTableModel));
        this.dataMinerTablePanel1.getTable().setSorted(true);
        object2 = this.dataMinerTablePanel1.getTable().getFullColumnModel();
        object2.getColumn(PATH_INDEX).setPreferredWidth(200);
        object2.getColumn(DATA_TYPE_INDEX).setPreferredWidth(90);
        this.updateTitle(selectedAttributesTableModel);
    }

    protected void updateTitle(SelectedAttributesTableModel selectedAttributesTableModel) {
        int n = selectedAttributesTableModel.getSrcData().size();
        String string = _SELECTED_ATTRIBUTES_GRID_TITLE + n;
        this.dataMinerTablePanel1.setTitle(string);
        this.jsonStructurePanel.updatePanelTitle(n);
    }

    public void reload(List<GroupByAttributeSelectionRowData> list) {
        HashMap<String, GroupByAttributeSelectionRowData> hashMap = new HashMap<String, GroupByAttributeSelectionRowData>();
        for (GroupByAttributeSelectionRowData object2 : list) {
            hashMap.put(object2.getFullPath(), object2);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<GroupByAttributeSelectionRowData> arrayList = new ArrayList<GroupByAttributeSelectionRowData>();
        SelectedAttributesTableModel selectedAttributesTableModel = (SelectedAttributesTableModel)((Object)this.dataMinerTablePanel1.getTable().getModel());
        List<GroupByAttributeSelectionRowData> list2 = selectedAttributesTableModel.getSrcData();
        for (GroupByAttributeSelectionRowData groupByAttributeSelectionRowData : list2) {
            GroupByAttributeSelectionRowData groupByAttributeSelectionRowData2 = (GroupByAttributeSelectionRowData)hashMap.get(groupByAttributeSelectionRowData.getFullPath());
            if (groupByAttributeSelectionRowData2 != null && !groupByAttributeSelectionRowData2.isSelected()) {
                hashMap.remove(groupByAttributeSelectionRowData.getFullPath());
                continue;
            }
            if (null != hashMap2.get(groupByAttributeSelectionRowData.getFullPath())) continue;
            arrayList.add(groupByAttributeSelectionRowData);
            hashMap2.put(groupByAttributeSelectionRowData.getFullPath(), groupByAttributeSelectionRowData.isSelected());
        }
        if (!hashMap.isEmpty()) {
            for (GroupByAttributeSelectionRowData groupByAttributeSelectionRowData : hashMap.values()) {
                if (!groupByAttributeSelectionRowData.isSelected() || null != hashMap2.get(groupByAttributeSelectionRowData.getFullPath())) continue;
                arrayList.add(groupByAttributeSelectionRowData);
                hashMap2.put(groupByAttributeSelectionRowData.getFullPath(), groupByAttributeSelectionRowData.isSelected());
            }
        }
        selectedAttributesTableModel.setSrcData(arrayList);
        this.updateTitle(selectedAttributesTableModel);
    }

    public JSONQueryEditorPanel getJSONQueryEditorPanel() {
        return this._parent;
    }

    @Override
    protected boolean doWork() {
        this.originalGroupingElement.setAttributes(new GroupingElementExType.Attributes());
        List list = this.originalGroupingElement.getAttributes().getAttribute();
        List list2 = this.originalGroupingElement.getAttributes().getJSONAttribute();
        SelectedAttributesTableModel selectedAttributesTableModel = (SelectedAttributesTableModel)((Object)this.dataMinerTablePanel1.getTable().getModel());
        List<GroupByAttributeSelectionRowData> list3 = selectedAttributesTableModel.getSrcData();
        for (GroupByAttributeSelectionRowData groupByAttributeSelectionRowData : list3) {
            JSONAttributeType jSONAttributeType;
            if (groupByAttributeSelectionRowData.isJSON()) {
                jSONAttributeType = groupByAttributeSelectionRowData.createJSONAttributeType();
                list2.add(jSONAttributeType);
                continue;
            }
            jSONAttributeType = groupByAttributeSelectionRowData.createAttributeExType();
            list.add(jSONAttributeType);
        }
        return true;
    }

    @Override
    public void updateJsonStructureTree() {
        this.loadSelectedAttributesTable();
    }

    class SelectedAttributesTableModel
    extends GenericBaseTableModel {
        private List<GroupByAttributeSelectionRowData> srcData;
        private boolean _showFullPath = true;

        public void setSrcData(List<GroupByAttributeSelectionRowData> list) {
            this.srcData = list;
            this.setRowCount(list.size());
            this.fireTableDataChanged();
        }

        public List<GroupByAttributeSelectionRowData> getSrcData() {
            return this.srcData;
        }

        SelectedAttributesTableModel(List<GroupByAttributeSelectionRowData> list) {
            this.srcData = list;
            this.setColumnIdentifiers(_colNames);
            this.setRowCount(list.size());
        }

        public void showFullPath(boolean bl) {
            this._showFullPath = bl;
            this.fireTableDataChanged();
        }

        public String getColumnName(int n) {
            return _colNames[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            if (this.srcData == null || this.srcData.isEmpty()) {
                return null;
            }
            GroupByAttributeSelectionRowData groupByAttributeSelectionRowData = this.srcData.get(n);
            if (n2 == PATH_INDEX) {
                if (this._showFullPath) {
                    return groupByAttributeSelectionRowData.getFullPath();
                }
                return groupByAttributeSelectionRowData.getShortPath();
            }
            return groupByAttributeSelectionRowData.getDataType();
        }
    }

    class LoadingDataModel
    extends GenericBaseTableModel {
        public LoadingDataModel() {
            this.setColumnIdentifiers(_colNamesLoading);
            this.setRowCount(1);
        }

        public String getColumnName(int n) {
            return _colNamesLoading[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            return loadingDataMessage;
        }
    }
}

