/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.prediction;

import java.util.Vector;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionLrb;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetAttributes;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class PredictionTargetsTableModel
extends GenericBaseTableModel {
    private boolean _writable = true;
    private Vector<MiningAttributeType> _srcData = new Vector();
    private static String[] _columnNames = new String[]{PredictionLrb.get("PREDICTION_TABLE_MODEL_COLUMN_NAME"), PredictionLrb.get("PREDICTION_TABLE_MODEL_COLUMN_DATA_TYPE"), DynamicNodesLrb.get("BUILD_DATA_USAGE_MINING_TYPE")};
    protected static int _COL_INDEX = 0;
    public static final int NAME = _COL_INDEX++;
    public static final int DATA_TYPE = _COL_INDEX++;
    public static final int MINING_TYPE = _COL_INDEX++;

    protected String[] getColumnNames() {
        return _columnNames;
    }

    public PredictionTargetsTableModel(TargetAttributes targetAttributes) {
        for (MiningAttributeType miningAttributeType : targetAttributes.getMiningAttribute()) {
            this._srcData.add(miningAttributeType);
        }
        this.setRowCount(this._srcData.size());
        this.setColumnIdentifiers(this.getColumnNames());
        this.setColumnCount(this.getColumnNames().length);
    }

    public void setWritable(boolean bl) {
        this._writable = bl;
    }

    public int getRowCount() {
        return this._srcData != null ? this._srcData.size() : 0;
    }

    public Vector<MiningAttributeType> getDataVector() {
        return this._srcData;
    }

    public int getRow(String string) {
        for (int i = 0; i < this._srcData.size(); ++i) {
            if (!this._srcData.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void clearRows() {
        this._srcData.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public Object getValueAt(int n, int n2) {
        if (this._srcData.isEmpty()) {
            return "";
        }
        if (n >= this._srcData.size()) {
            return "";
        }
        MiningAttributeType miningAttributeType = this._srcData.get(n);
        String string = null;
        if (n2 == NAME) {
            string = miningAttributeType.getName();
        } else if (n2 == DATA_TYPE) {
            String string2 = miningAttributeType.getDataType();
            String string3 = miningAttributeType.getDataTypeQualifier();
            string = DatabaseMetadataUtils.isACharacterOracleDataType(string2) ? DatabaseMetadataUtils.getJSONDataType(string2, string3) : string2;
        } else if (n2 == MINING_TYPE) {
            String string4 = string = miningAttributeType.getMiningType();
            string = ServerConstants.MiningType.toHuman(string4);
        } else assert (false) : "Out of bounds column when accessing items";
        return string != null ? string : "";
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == MINING_TYPE) {
            MiningAttributeType miningAttributeType = this._srcData.get(n);
            return !DatabaseMetadataUtils.isACharacterOracleDataType(miningAttributeType.getDataType()) ? this._writable : false;
        }
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == MINING_TYPE) {
            MiningAttributeType miningAttributeType = this._srcData.get(n);
            String string = (String)object;
            object = ServerConstants.MiningType.toSchema(string);
            miningAttributeType.setMiningType((String)object);
        }
    }

    public String getMaxString(int n) {
        String string = "";
        for (int i = 0; i < this._srcData.size(); ++i) {
            Object object = this.getValueAt(i, n);
            if (object == null || object.toString().length() <= string.length()) continue;
            string = object.toString();
        }
        return string;
    }
}

