/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.feature;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyOutputDialog;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodeEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.FeatureEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.FeaturePredictionLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.FeaturePredictionsTableModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.DynamicFeatureNode;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumns;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureIdType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class DynamicFeatureEditorPanel
extends DynamicEditorPanel<DynamicFeatureNode>
implements DataConsumerPanel {
    private FeatureEditorState state;
    private DynamicFeatureNodeType cachedNodeData;
    private Map<String, ModelHeuristicRules> modelRules;
    private JLabel jCaseIdLabel;
    private JComboBox jComboBoxCaseId;
    private ComponentWithTitlebar<JComponent> jComponentClusters;
    private JTextField jFeatureTextField;
    private JLabel jLabelCaseId;
    private JLabel jLabelClusters;
    private JTabbedPane jMainTabPamel;
    private JPanel jPredictionTab;
    private DataMinerTable jPredictionOutputsTable = new DataMinerTable();
    private JButton addPredOutputBtn;
    private JButton removePredOutputBtn;
    private JButton editPredOutputBtn;

    public DynamicFeatureEditorPanel(Context context, DynamicFeatureNode dynamicFeatureNode, Map<String, ModelHeuristicRules> map) {
        super(context, dynamicFeatureNode);
        this.cachedNodeData = (DynamicFeatureNodeType)MetaDataHelper.copyMetadataObject(dynamicFeatureNode.getData());
        this.state = new FeatureEditorState(context, dynamicFeatureNode, this.cachedNodeData);
        this.modelRules = map;
        this.initComponents();
        this.createPartitionTab(this.jMainTabPamel, this.state);
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jMainTabPamel = new JTabbedPane();
        this.jPredictionTab = new JPanel();
        this.jLabelCaseId = new JLabel();
        this.jComboBoxCaseId = new JComboBox();
        this.jComponentClusters = new ComponentWithTitlebar();
        this.jLabelClusters = new JLabel();
        this.jFeatureTextField = new NumberTextField();
        this.jCaseIdLabel = new JLabel();
        this.jLabelCaseId.setText("Case ID:");
        this.jComboBoxCaseId.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabelClusters.setText("Number of Features to Extract:");
        ((NumberTextField)this.jFeatureTextField).setDataType(Integer.class);
        ((NumberTextField)this.jFeatureTextField).setSigned(false);
        this.jFeatureTextField.setLocale(Locale.getDefault());
        this.jCaseIdLabel.setHorizontalAlignment(2);
        this.jCaseIdLabel.setHorizontalTextPosition(2);
        GroupLayout groupLayout = new GroupLayout(this.jPredictionTab);
        this.jPredictionTab.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabelClusters, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelCaseId, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxCaseId, -2, 121, -2))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jFeatureTextField, -2, 59, -2)).addGroup(groupLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jCaseIdLabel, -2, 23, -2))).addContainerGap(287, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jComponentClusters, -1, 538, Short.MAX_VALUE).addGap(11, 11, 11))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCaseId).addComponent(this.jComboBoxCaseId, -2, -1, -2)).addComponent(this.jCaseIdLabel, -2, 20, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelClusters).addComponent(this.jFeatureTextField, -2, -1, -2)).addContainerGap(413, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(80, 80, 80).addComponent((Component)this.jComponentClusters, -1, 391, Short.MAX_VALUE).addContainerGap())));
        this.jMainTabPamel.addTab("Cluster", this.jPredictionTab);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMainTabPamel));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMainTabPamel));
    }

    @Override
    protected String getFirstTabTitle() {
        return FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_FIRST_TAB_TITLE");
    }

    @Override
    public DynamicNodeBaseSettingsType getOriginalDynamicNodeBaseSettings() {
        return this.cachedNodeData.getDynamicNodeBaseSettings();
    }

    protected MiningAttributes getMiningAttributes() {
        return this.getOriginalDynamicNodeBaseSettings().getMiningAttributes();
    }

    @Override
    protected JComboBox getCaseIDCombo() {
        return this.jComboBoxCaseId;
    }

    @Override
    protected JLabel getCaseIDLabel() {
        return this.jCaseIdLabel;
    }

    @Override
    public DynamicNodeEditorState getState() {
        return this.state;
    }

    @Override
    public void initUI() {
        Object object2;
        ResourceUtils.resLabel((JLabel)this.jLabelCaseId, (Component)this.jComboBoxCaseId, (String)FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_CASE_ID"));
        ResourceUtils.resLabel((JLabel)this.jLabelClusters, (Component)this.jFeatureTextField, (String)FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_NUM_FEAT"));
        this.jPredictionOutputsTable.setTooltipEnable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.jPredictionOutputsTable));
        this.jComponentClusters.setComponent((JComponent)jScrollPane);
        this.jComponentClusters.setLabel(new JLabel(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_PANEL_PREDICTION_OUTPUT_TITLE")));
        ControlBar controlBar = new ControlBar();
        this.addPredOutputBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addPredOutputBtn.setToolTipText(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_TOOLTIP_ADD_PREDICTION_OUTPUT"));
        this.addPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureEditorPanel.this.hanldeAddFeaturePredictionOutput();
            }
        });
        controlBar.add((Component)this.addPredOutputBtn);
        this.removePredOutputBtn = new JButton(FeatureEditorState.getRemoveIcon());
        this.removePredOutputBtn.setToolTipText(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_TOOLTIP_REMOVE_PREDICTION_OUTPUT"));
        this.removePredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureEditorPanel.this.removeSelectedFeaturePredictionOutputs();
            }
        });
        controlBar.add((Component)this.removePredOutputBtn);
        this.editPredOutputBtn = new JButton(FeatureEditorState.getEditIcon());
        this.editPredOutputBtn.setToolTipText(FeaturePredictionLrb.get("FEATURE_PREDICTION_EDITOR_TOOLTIP_EDIT_PREDICTION_OUTPUT"));
        this.editPredOutputBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicFeatureEditorPanel.this.hanldeEditFeaturePredictionOutput();
            }
        });
        controlBar.add((Component)this.editPredOutputBtn);
        this.jComponentClusters.setControlBar(controlBar);
        this.jPredictionOutputsTable.setFillsViewportHeight(true);
        this.addPredOutputBtn.setEnabled(true);
        this.removePredOutputBtn.setEnabled(false);
        this.editPredOutputBtn.setEnabled(false);
        this.jFeatureTextField.getDocument().addDocumentListener(new DocumentListener(){

            private void setFeatureID() {
                String string = DynamicFeatureEditorPanel.this.jFeatureTextField.getText();
                int n = 10;
                try {
                    n = Integer.parseInt(string);
                    DynamicFeatureEditorPanel.this.state.setFeatureId(n);
                }
                catch (Exception exception) {
                    DynamicFeatureEditorPanel.this.state.setNullFeatureId();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setFeatureID();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setFeatureID();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.setFeatureID();
            }
        });
        Vector<String> vector = new Vector<String>();
        if (!this.getMiningAttributes().getMiningAttribute().isEmpty()) {
            for (Object object2 : this.getMiningAttributes().getMiningAttribute()) {
                if (!DatabaseMetadataUtils.isDynamicCaseIdDataTypeSupported(object2.getDataType())) continue;
                String string = object2.getAlias() != null ? object2.getAlias() : object2.getName();
                vector.add(string);
            }
            Collections.sort(vector);
        }
        vector.insertElementAt(DynamicNodeEditorState._none, 0);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        defaultComboBoxModel.setSelectedItem(this.state.getSelectedCaseAttribute() != null ? this.state.getSelectedCaseAttribute() : DynamicNodeEditorState._none);
        this.jComboBoxCaseId.setModel(defaultComboBoxModel);
        this.jComboBoxCaseId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)DynamicFeatureEditorPanel.this.jComboBoxCaseId.getSelectedItem();
                DynamicFeatureEditorPanel.this.setSelectedCaseAttribute(string);
            }
        });
        ((NumberTextField)this.jFeatureTextField).setNumber((Number)this.state.getFeatures());
        this.setupFeaturePredictionOutputTable();
        object2 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = DynamicFeatureEditorPanel.this.jPredictionOutputsTable.getSelectedRowInModel();
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    DynamicFeatureEditorPanel.this.hanldeEditFeaturePredictionOutput();
                }
            }
        };
        this.jPredictionOutputsTable.addMouseListener((MouseListener)object2);
        this.createTabs(this.state, this.jMainTabPamel, this.modelRules);
        super.initUI();
    }

    private void setupFeaturePredictionOutputTable() {
        this.jPredictionOutputsTable.setModel((TableModel)((Object)this.state.getTableModelFeatureOutputs()));
        this.jPredictionOutputsTable.setShowGrid(true);
        this.jPredictionOutputsTable.setSorted(true);
        this.jPredictionOutputsTable.setSortColumn(FeaturePredictionsTableModel.FUNCTION, true);
        this.jPredictionOutputsTable.getSelectionModel().addListSelectionListener(new PredictionOutputsSelectionHandler());
    }

    private void removeSelectedFeaturePredictionOutputs() {
        int[] nArray = this.jPredictionOutputsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        Vector<DynamicApplyOutputColumnType> vector = this.state.getTableModelFeatureOutputs().getDataVector();
        ArrayList<DynamicApplyOutputColumnType> arrayList = new ArrayList<DynamicApplyOutputColumnType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((DynamicApplyOutputColumnType)vector.get(nArray[i]));
        }
        this.state.removePredictionOutputColumnsFromList(arrayList);
        this.setupFeaturePredictionOutputTable();
    }

    private void hanldeEditFeaturePredictionOutput() {
        int[] nArray = this.jPredictionOutputsTable.getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        Vector<DynamicApplyOutputColumnType> vector = this.state.getTableModelFeatureOutputs().getDataVector();
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType = (DynamicApplyOutputColumnType)vector.get(nArray[0]);
        String string = DynamicNodesLrb.get("DYNAMIC_FEATURE_APPLY_OUTPUT_EDIT_DIALOG_TITLE");
        DynamicApplyOutputDialog dynamicApplyOutputDialog = new DynamicApplyOutputDialog(string);
        DynamicApplyOutputColumnType dynamicApplyOutputColumnType2 = (DynamicApplyOutputColumnType)MetaDataHelper.copyMetadataObject(dynamicApplyOutputColumnType);
        if (dynamicApplyOutputDialog.invoke(this.getContext(), this.state, dynamicApplyOutputColumnType2, null)) {
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType3 = dynamicApplyOutputDialog.getApplyOutputColumn();
            this.state.replacePredictionTarget(dynamicApplyOutputColumnType, dynamicApplyOutputColumnType3);
            this.setupFeaturePredictionOutputTable();
        }
    }

    private void hanldeAddFeaturePredictionOutput() {
        String string = DynamicNodesLrb.get("DYNAMIC_FEATURE_APPLY_OUTPUT_ADD_DIALOG_TITLE");
        DynamicApplyOutputDialog dynamicApplyOutputDialog = new DynamicApplyOutputDialog(string);
        if (dynamicApplyOutputDialog.invoke(this.getContext(), this.state, null)) {
            DynamicApplyOutputColumnType dynamicApplyOutputColumnType = dynamicApplyOutputDialog.getApplyOutputColumn();
            this.state.addApplyOutputColumn(dynamicApplyOutputColumnType);
            this.setupFeaturePredictionOutputTable();
        }
    }

    private void adjustOutputColumnsWithMaxFeatureNumber() {
        int n = this.state.getFeatures();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getOriginalDynamicNodeBaseSettings();
        DynamicApplyOutputColumns dynamicApplyOutputColumns = dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns();
        for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : dynamicApplyOutputColumns.getDynamicApplyOutputColumn()) {
            int n2;
            String string;
            if (null != dynamicApplyOutputColumnType.getFeatureValue()) {
                string = dynamicApplyOutputColumnType.getFeatureValue().getColumn().getFeatureId();
                if (string == null || (n2 = Integer.parseInt(string)) <= n) continue;
                dynamicApplyOutputColumnType.getFeatureValue().getColumn().setFeatureId(null);
                continue;
            }
            if (null == dynamicApplyOutputColumnType.getFeatureDetails() || (string = dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getFeatureId()) == null || (n2 = Integer.parseInt(string)) <= n) continue;
            dynamicApplyOutputColumnType.getFeatureDetails().getColumn().setFeatureId(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        Number number = ((NumberTextField)this.jFeatureTextField).getNumber();
        if (number.intValue() <= 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)FeaturePredictionLrb.get("FEATURE_NODE_PROPERTIES_DIALOG_NUUM_FEATURES"), (String)FeaturePredictionLrb.get("FEATURE_NODE_PROPERTIES_DIALOG_FAILURE_TITLE"), null);
            return false;
        }
        if (this.isInputAttributesListEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DynamicNodesLrb.get("EDITOR_PANEL_ERROR_NO_INPUTS"), (String)FeaturePredictionLrb.get("FEATURE_NODE_PROPERTIES_DIALOG_FAILURE_TITLE"), null);
            return false;
        }
        this.state.setFeatureId(number.intValue());
        this.adjustOutputColumnsWithMaxFeatureNumber();
        CommandProcessor.getInstance().beginTrans(FeaturePredictionLrb.get("FEATURE_NODE_PROPERTIES_TRANSACTION_NAME"));
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = (DynamicNodeBaseSettingsType)MetaDataHelper.copyMetadataObject(this.getOriginalDynamicNodeBaseSettings());
            hashMap.put("DynamicNodeBaseSettingsType", dynamicNodeBaseSettingsType);
            FeatureIdType featureIdType = (FeatureIdType)MetaDataHelper.copyMetadataObject(this.cachedNodeData.getFeatureId());
            hashMap.put("FeatureIdType", featureIdType);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("FEATURE_NODE_INPUT_COLUMNS", null, hashMap, null, null));
            arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
            DynamicFeatureNode dynamicFeatureNode = (DynamicFeatureNode)this.getData();
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)dynamicFeatureNode.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(dynamicFeatureNode, this._context, arrayList);
            dynamicFeatureNode.validateSimple(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)FeaturePredictionLrb.get("FEATURE_NODE_PROPERTIES_DIALOG_FAILURE_TITLE"), (String)FeaturePredictionLrb.get("FEATURE_NODE_PROPERTIES_DIALOG_FAILURE_MSG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
        return true;
    }

    class PredictionOutputsSelectionHandler
    implements ListSelectionListener {
        PredictionOutputsSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = DynamicFeatureEditorPanel.this.jPredictionOutputsTable.getSelectedRowsInModel();
            DynamicFeatureEditorPanel.this.removePredOutputBtn.setEnabled(nArray != null && nArray.length > 0);
            DynamicFeatureEditorPanel.this.editPredOutputBtn.setEnabled(nArray != null && nArray.length == 1);
        }
    }
}

